
// trans.h

#ifndef TRANS_H
#define TRANS_H

// includes

#include "util.h"

// kh 02.06.08 start Thomas Gaksch 14b5c
// constants
const int TransUpperFlag = 1 << 0;
const int TransLowerFlag = 1 << 1;

const int TransUnknown = 0;
const int TransUpper   = TransUpperFlag;
const int TransLower   = TransLowerFlag;
const int TransExact   = TransUpperFlag | TransLowerFlag;
const int TransFlags   = 3;

// macros

#define TRANS_IS_UPPER(flags) (((flags)&TransUpperFlag)!=0)
#define TRANS_IS_LOWER(flags) (((flags)&TransLowerFlag)!=0)
#define TRANS_IS_EXACT(flags) ((flags)==TransExact)
// kh 11.04.07 end Thomas Gaksch

// types

static const int DateSize = 16;

static const int ClusterSize = 4; // TODO: unsigned?

// kh 02.06.08 start Thomas Gaksch 14b5c
static const bool AlwaysWrite = true; //was true

static const bool SmartMove = true;
static const bool SmartValue = false;
static const bool SmartReplace = true;
// kh 11.04.07 end Thomas Gaksch

static const int DepthNone = -128;

// types

// kh 02.06.08 Thomas Gaksch 14b5c
struct entry_t
{
  uint64  key;
  uint16  move;
  uint8   depth;
  uint8   date_flags;
  sint16  value;

  uint16  nproc; // kh 02.06.08 not really used at the moment

// kh 21.03.07 used for debug purposes only
#if defined(DEBUG_INTENSIVE)

  int     nLockId;   // kh 21.03.07 mpi rank id
  uint8   Dummy[12]; // kh 21.03.07 make it a power of 2 again

#endif
};

typedef struct tTransLock
{
  int     nLockId;
//int     nLockEntryId;

} TransLock;

struct trans { // HACK: typedef'ed in trans.h
   entry_t*   table;
   uint32     size;
   uint32     mask;
   int        date;
   int        age[DateSize];
   uint32     used;
   sint64     read_nb;
   sint64     read_hit;
   sint64     write_nb;
   sint64     write_hit;
   sint64     write_collision;

// kh 21.03.07
   TransLock* pTransLock;
};

typedef struct trans trans_t;

// variables

extern trans_t Trans[1];
extern bool trans_endgame; // kh 10.04.07 Thomas Gaksch

// functions

extern bool trans_is_ok    (const trans_t * trans);

extern void trans_init     (trans_t * trans);
extern void trans_alloc    (trans_t * trans);
extern void trans_free     (trans_t * trans);

extern void trans_clear      (trans_t * trans);
extern void trans_inc_date   (trans_t * trans);
extern void trans_set_date   (trans_t * trans, int date);
extern void trans_update_date(trans_t * trans, int date);

// kh 02.06.08 Thomas Gaksch 14b5c
extern void trans_store    (trans_t * trans, uint64 key, int move, int depth, int flags, int value);

// kh 02.06.08 Thomas Gaksch 14b5c
extern bool trans_retrieve (trans_t * trans, entry_t ** found_entry, uint64 key, int * move, int * depth, int * flags, int * value);

extern void trans_stats    (const trans_t * trans);

#endif // !defined TRANS_H

// end of trans.h

