
// sort.h

#ifndef SORT_H
#define SORT_H

// includes

#include "attack.h"
#include "board.h"
#include "list.h"
#include "util.h"

// types

struct sort_t {
   int depth;
   int height;
   int trans_killer;
   int killer_1;
   int killer_2;

// kh 10.04.07 Thomas Gaksch 
   int killer_3;
   int killer_4;

   int gen;
   int test;
   int pos;
   int value;

// kh 04.06.08 not really used
// kh 02.06.08 Thomas Gaksch 14b5c
   int valuePV;
   int capture_nb;

   board_t * board;
   const attack_t * attack;
   list_t list[1];
   list_t bad[1];
};

// kh 19.03.08 use original history table size (12 * 64) again
//static const int HistorySize = 9*9*12*64*64; // kh 10.04.07 Thomas Gaksch
static const int HistorySize  = 12 * 64;
static const int HistoryMax   = 16384;

typedef struct tHistory
{
  int    nLockId;

  uint16 History[HistorySize];
  uint16 HistHit[HistorySize];
  uint16 HistTot[HistorySize];

} History;

extern History* gpHistory;

extern void history_alloc    (History** ppHistory);
extern void history_free     (History* pHistory);

// functions

extern void sort_init    ();

extern void sort_init    (sort_t * sort, board_t * board, const attack_t * attack, int depth, int height, int trans_killer);

// kh 02.06.08 Thomas Gaksch 14b5c
extern int  sort_next    (sort_t * sort);

extern void sort_init_qs (sort_t * sort, board_t * board, const attack_t * attack, bool check);
extern int  sort_next_qs (sort_t * sort);

extern void good_move    (int move, const board_t * board, int depth, int height);

// kh 02.06.08 Thomas Gaksch 14b5c
extern void history_good (int move, const board_t * board);
extern void history_bad  (int move, const board_t * board);

// kh 02.06.08 Thomas Gaksch 14b5c
extern void history_reset  (int move, const board_t * board); // kh 02.06.08 not really used at the moment

extern void note_moves   (list_t * list, const board_t * board, int height, int trans_killer);

// kh 02.06.08 Thomas Gaksch 14b5c
extern int history_prob(int move, const board_t * board); // kh 10.04.07 Thomas Gaksch

#endif // !defined SORT_H

// end of sort.h

