
// search_full.h

#ifndef SEARCH_FULL_H
#define SEARCH_FULL_H

// includes

#include "board.h"
#include "util.h"

extern bool egbb_is_loaded; // kh 10.04.07 Thomas Gaksch

static const int NodeAll = -1;
static const int NodePV  =  0;
static const int NodeCut = +1;

static /* const */ bool UseHistory = true;

// kh 19.03.08
// kh 10.04.07 Thomas Gaksch
static /* const */ bool UseHistoryPruning = true;
static const int HistoryDepth = 3; // was 3

// kh 03.06.08 Thomas Gaksch 14b5c
static const int HistoryPVDepth = 3; // was 3

// kh 19.03.08
static const int HistoryMoveNb = 3; // was 3

static /* const */ int HistoryValue = 9830; // 60%

// functions

extern void search_full_init (list_t * list, board_t * board);
extern int  search_full_root (list_t * list, board_t * board, int depth, int search_type);

// kh 10.04.07 Thomas Gaksch
extern int  full_new_depth(int depth, int move, board_t * board, bool single_reply, bool in_pv, int height, bool extended, bool * cap_extended); 

extern bool move_is_dangerous(int move, const board_t * board);

#endif // !defined SEARCH_FULL_H

// end of search_full.h

