
// protocol.h

#ifndef PROTOCOL_H
#define PROTOCOL_H

// includes

#include "util.h"

#include "Result.h"

#define PROGRAM_NAME    "ClusterToga"
#define PROGRAM_VERSION "1.4 beta5c"
#define PROGRAM_DETAILS "based on Fruit 2.1 UCI, cluster parallelization by Kai Himstedt and Dr. habil. Ulf Lorenz of Toga by Thomas Gaksch which is based on Fruit by Fabien Letouzey"
#define PROGRAM_AUTHOR  "Thomas Gaksch, Kai Himstedt, Fabien Letouzey, Dr. habil. Ulf Lorenz"

// functions

extern void loop  ();
extern void event ();
extern void book_parameter(); // kh 10.04.07 Thomas Gaksch

extern void get   (char string[], int size);
extern void send  (const char format[], ...);

void finalize();

void fruit_actions_for_sync_position_received(char string[]);
void fruit_actions_for_new_game_received();
void fruit_actions_for_set_option_received(char* szOptionName, char* szOptionValue);
void fruit_actions_for_remote_test_received(char string[]);
void fruit_actions_for_stop_remote_received();
void fruit_actions_for_stop_received();
void fruit_actions_for_update_search_window_received(int nAlphaImproved, int nBetaImproved);

void fruit_actions_for_remote_test_result_received(Result* pResult);

void fruit_actions_for_work_available_received(Result* pResult);

#endif // !defined PROTOCOL_H

// end of protocol.h

