#include "Stack.h"

#include <stdlib.h>
#include <string.h>

#include "value.h"

#include "YBWCManager.h"
extern YBWCManager* g_pYBWCManagerInstance;

#include "search_full.h"

Stack g_Stack;

Stack* Stack_Construct(/* Stack* pThis */)
{
  int         i;

  StackEntry* pStackEntry;

  int         nCallPositionIndex;

  g_Stack.nMaxSize = MAX_STACK_SIZE;

  for(i = 0; i < SIZE_OF_CALL_POSITIONS_TO_INDEX; i++)
  {
    g_Stack.CallPositionToIndexMap[i] = -1;
  }

  for(i = 0; i < MAX_CALL_INDICES_TO_POSITIONS; i++)
  {
    g_Stack.CallIndexToPositionMap[i] = RETURN_POSITION_UNDEFINED;
  }

  nCallPositionIndex = 0;
  g_Stack.CallPositionToIndexMap[RETURN_POSITION_UNDEFINED]           = nCallPositionIndex++;
  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FUNCTION_END]        = nCallPositionIndex++;

  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FULL_ROOT_01]        = nCallPositionIndex++;
  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FULL_ROOT_01_1]      = nCallPositionIndex++;
  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FULL_ROOT_01_2]      = nCallPositionIndex++;
  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FULL_ROOT_02]        = nCallPositionIndex++;
  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FULL_ROOT_03]        = nCallPositionIndex++;
  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FULL_ROOT_03_1]      = nCallPositionIndex++;
  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FULL_ROOT_04]        = nCallPositionIndex++;

  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FULL_SEARCH_01]      = nCallPositionIndex++;
  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FULL_SEARCH_02]      = nCallPositionIndex++;
  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FULL_SEARCH_03]      = nCallPositionIndex++;
  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FULL_SEARCH_03_1]    = nCallPositionIndex++;
  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FULL_SEARCH_04]      = nCallPositionIndex++;
  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FULL_SEARCH_05]      = nCallPositionIndex++;
  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FULL_SEARCH_06]      = nCallPositionIndex++;
  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FULL_SEARCH_07]      = nCallPositionIndex++;
  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FULL_SEARCH_08]      = nCallPositionIndex++;
  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FULL_SEARCH_09]      = nCallPositionIndex++;

  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FULL_NO_NULL_01]     = nCallPositionIndex++;

  g_Stack.CallPositionToIndexMap[RETURN_POSITION_FULL_QUIESCENCE_01]  = nCallPositionIndex++;

  for(i = 0; i < SIZE_OF_CALL_POSITIONS_TO_INDEX; i++)
  {
    if(g_Stack.CallPositionToIndexMap[i] >= 0)
    {
      g_Stack.CallIndexToPositionMap[g_Stack.CallPositionToIndexMap[i]] = i;
    }
  }

  Stack_Init(/* pThis */);

// kh 14.03.07
  for(i = 0; i < g_Stack.nMaxSize; i++)
  {
    pStackEntry = &g_Stack.stackEntry[i];

    pStackEntry->nMoveListTotalCountMax = 0;
  }

  return &g_Stack;
}

void Stack_Destruct(/* Stack* pThis */)
{
/*
  if(pThis)
  {
*/
// kh 05.05.08 memory is no longer allocated at runtime (performance)
/*
    free(pThis);
*/
/*
  }
*/
}

void Stack_Init(/* Stack* pThis */)
{
  int         i;

  StackEntry* pStackEntry;

  g_Stack.nCount   = 0; // kh 24.07.06 top element is always at position (nCount - 1)

  for(i = 0; i < g_Stack.nMaxSize; i++)
  {
    pStackEntry = &g_Stack.stackEntry[i];

    StackEntry_Init(pStackEntry);
  }

  g_Stack.nStack_UpdateSearchWindowForEntry = 0;
}

void Stack_Clear(/* Stack* pThis */)
{
  Stack_Init(/* pThis */);
}

// kh 18.10.06 support board access per level (defensive, fruit uses always a pointer to access the board)
void Stack_RestoreBoardStateForLevel(/* Stack* pThis, */ int nStackIndex) //, board_t* pBoard)
{
  int         i;
  int         nMove;

  board_t*    pBoard;
  undo_t*     pUndo;

  StackEntry* pStackEntry;

// kh 20.10.06 there are two places where messages are potentially serviced while searching
// (leading potentially to the execution here)
// a) if messages are serviced at the beginning of the pseudo recursive call then
//    for the top level (at index nCount - 1) no move was done yet
// b) when waiting for all childs to complete at the actual top level, 
//    all moves were done for the top level (at index nCount - 1)
// for both cases the top level has to be ignored in respect to unwinding the moves on the stack
  for(i = (g_Stack.nCount - 2); i >= nStackIndex; i--) 
  {
    pStackEntry = Stack_PeekAt(/* pThis, */ i);

    pBoard = StackEntry_GetBoard(pStackEntry, Stack_PeekAt(/* pThis, */ i + 1)->nReturnPosition);
    nMove  = StackEntry_GetMove (pStackEntry, Stack_PeekAt(/* pThis, */ i + 1)->nReturnPosition);
    pUndo  = StackEntry_GetUndo (pStackEntry, Stack_PeekAt(/* pThis, */ i + 1)->nReturnPosition);

    switch(nMove)
    {
    case MoveNone:
      break;

    case MoveNull:
      move_undo_null(pBoard, pUndo);
      break;

    default:
      move_undo(pBoard, nMove, pUndo);
      break;
    }
  }
}

// kh 18.10.06 support board access per level (defensive, fruit uses always a pointer to access the board)
void Stack_ResumeActualBoardStateFromLevel(/* Stack* pThis, */ int nStackIndex) //, board_t* pBoard)
{
  int         i;
  int         nMove;

  board_t*    pBoard;
  undo_t*     pUndo;

// kh 18.10.06 a dumy buffer should be sufficient, but to use the original buffers seems to be more defensive
//undo_t      UndoBufferDummy[1];

  StackEntry* pStackEntry;

// kh 20.10.06 there are two places where messages are potentially serviced while searching
// (leading potentially to the execution here)
// a) if messages are serviced at the beginning of the pseudo recursive call then
//    for the top level (at index nCount - 1) no move was done yet
// b) when waiting for all childs to complete at the actual top level, 
//    all moves were done for the top level (at index nCount - 1)
// for both cases the top level has to be ignored in respect to resume from unwinding the moves on the stack
  for(i = nStackIndex; i <= (g_Stack.nCount - 2); i++) 
  {
    pStackEntry = Stack_PeekAt(/* pThis, */ i);

    pBoard = StackEntry_GetBoard(pStackEntry, Stack_PeekAt(/* pThis, */ i + 1)->nReturnPosition);
    nMove  = StackEntry_GetMove (pStackEntry, Stack_PeekAt(/* pThis, */ i + 1)->nReturnPosition);
    pUndo  = StackEntry_GetUndo (pStackEntry, Stack_PeekAt(/* pThis, */ i + 1)->nReturnPosition);

    switch(nMove)
    {
    case MoveNone:
      break;

    case MoveNull:
//    move_do_null(pBoard, &UndoBufferDummy[0]);
      move_do_null(pBoard, pUndo);
      break;

    default:
//    move_do(pBoard, nMove, &UndoBufferDummy[0]);
      move_do(pBoard, nMove, pUndo);
      break;
    }
  }
}

int Stack_SendWorkToSLave(/* Stack*  pThis, */
                          int     nSlaveId,
                          int     nSlaveSyncPositionId,
                          int     nStackIndex,
                          int     nMoveListIndex,
                          int     nCallType, 
                          int     nReturnPosition,
                          int     nMove, 
                          int     nDepth,
                          int     nNewDepth,
                          int     nHeightLocal,
                          int     nHeight,
                          bool    bInPV,
                          int     nPlayedNb,
                          int     nHistoryValue,
                          int     nAlpha,
                          int     nBeta,
                          int     nTransDate,
                          bool    bGoodCap)
{
  int                       nResult;

  int                       i;
  int                       j;

  bool                      bSendOk;

  int                       nMoveAheadListCount;
  uint16                    MoveAheadList[MAX_MOVES];

  int                       nKillerListCount;
  uint16                    KillerList[MAX_KILLER_ENTRIES];

  sint64                    nWorkIdMemo;

  StackEntry*               pStackEntryTmp;

  ProcessorHandler*         pProcessorHandler;
  Result*                   pResult;

  int                       nReturnPositionOfNextLevel;

  nResult             = MPI_SUCCESS;

  nMoveAheadListCount = 0;

  switch(nCallType)
  {
  case CALL_TYPE_UNDEFINED:
    ASSERT(false);
    break;

  case CALL_TYPE_FULL_ROOT:
  case CALL_TYPE_FULL_SEARCH:

    ASSERT(!(nCallType == CALL_TYPE_FULL_ROOT) || g_pYBWCManagerInstance->bRootMaster);

// kh 01.11.06 do moves already ahead of the slave itself
    if(g_pYBWCManagerInstance->bSearchingSubproblem)
    {
      for(j = 0; j < g_pYBWCManagerInstance->pWorkAvailableResult->nMoveAheadListCount; j++)
      {
        MoveAheadList[nMoveAheadListCount] = g_pYBWCManagerInstance->pWorkAvailableResult->MoveAheadList[j];
        nMoveAheadListCount++;
      }
    }

// kh 11.09.06 do moves ahead 
    for(i = 0; i < nStackIndex; i++)
    {
      pStackEntryTmp = Stack_PeekAt(/* pThis, */ i);

      if(i < (g_Stack.nCount - 1))
      {
        nReturnPositionOfNextLevel = Stack_PeekAt(/* pThis, */ i + 1)->nReturnPosition;
      }
      else
      {
        nReturnPositionOfNextLevel = RETURN_POSITION_UNDEFINED;
      }

      switch(pStackEntryTmp->nCallType)
      {
      case CALL_TYPE_UNDEFINED:
        ASSERT(false);
        break;

      case CALL_TYPE_FULL_ROOT:
//      pFullRootPar          = &pStackEntryTmp->parameters.fullRootPar;
/*
        pFullRootDat          = &pStackEntryTmp->localData.fullRootDat;
*/

        MoveAheadList[nMoveAheadListCount] = pStackEntryTmp->localData.fullRootDat.move;
        nMoveAheadListCount++;
        
        break;

      case CALL_TYPE_FULL_SEARCH:
//      pFullSearchPar        = &pStackEntryTmp->parameters.fullSearchPar;
/*
        pFullSearchDat        = &pStackEntryTmp->localData.fullSearchDat;
*/

        if(nReturnPositionOfNextLevel == RETURN_POSITION_FULL_SEARCH_02) // kh 11.09.06 sufficient null move criterion
        {
          MoveAheadList[nMoveAheadListCount] = MoveNull;
        }
        else if(    (nReturnPositionOfNextLevel == RETURN_POSITION_FULL_SEARCH_01) // kh 11.09.06 sufficient move none criterion
                 || (nReturnPositionOfNextLevel == RETURN_POSITION_FULL_SEARCH_03) 
                 || (nReturnPositionOfNextLevel == RETURN_POSITION_FULL_SEARCH_03_1) 
                 || (nReturnPositionOfNextLevel == RETURN_POSITION_FULL_SEARCH_04)
                 || (nReturnPositionOfNextLevel == RETURN_POSITION_FULL_SEARCH_05))
        {
          MoveAheadList[nMoveAheadListCount] = MoveNone;
        }
        else
        {
          MoveAheadList[nMoveAheadListCount] = pStackEntryTmp->localData.fullSearchDat.move;
        }

        nMoveAheadListCount++;

        break;

      case CALL_TYPE_FULL_NO_NULL:
//      pFullNoNullPar        = &pStackEntryTmp->parameters.fullNoNullPar;
/*
        pFullNoNullDat        = &pStackEntryTmp->localData.fullNoNullDat;
*/

        MoveAheadList[nMoveAheadListCount] = pStackEntryTmp->localData.fullNoNullDat.move;
        nMoveAheadListCount++;
        
        break;

      case CALL_TYPE_FULL_QUIESCENCE:
        ASSERT(false);

//      pFullQuiescencePar    = &pStackEntryTmp->parameters.fullQuiescencePar;
/*
        pFullQuiescenceDat    = &pStackEntryTmp->localData.fullQuiescenceDat;
*/
/*
        MoveAheadList[nMoveAheadListCount] = pStackEntryTmp->localData.fullQuiescenceDat.move;
        nMoveAheadListCount++;
*/

        break;

      default:
        ASSERT(false);
        break;
      } // switch(pStackEntryTmp->nCallType)
    } // for(i = 0; i < nStackIndex; i++)

// kh 14.02.07 select killer table entries to transmit
    nKillerListCount = 0;
    if(g_pYBWCManagerInstance->pFruitConfiguration->bTransmitKillerTable)
    {
      for(i = nHeightLocal + 1; i <= SearchCurrent->max_local_depth; i++)
      {
        for(j = 0; j < KILLER_ENTRIES_PER_HEIGHT; j++)
        {
          KillerList[nKillerListCount] = Killer[i][j];
          nKillerListCount++;
        }
      }
    } // if(g_pYBWCManagerInstance->pFruitConfiguration->bTransmitKillerTable)

    
    pProcessorHandler = g_pYBWCManagerInstance->processorHandlerPool[nSlaveId];

// kh 17.10.06 update for comment from 10.10.056 below
// the reenrant case is handeld for the same stack levels only, but if e.g. the board state is restaurated 
// here (the first time) e.g. by undoing the moves ahead from this stack level to the top stack level
// (on the main and only common board structure) then trying to restaurate the board state again 
// (from an already restaurated state) for another stack level could of course lead to problems
// bEnableWorkDistribution should be set to false therefore (anyway as long as the board state is not
// direct accessible for each stack level (e.g. by copying the whole board structure on entry of each 
// pseudo recursive call)

// kh 10.10.06 early mark move as already distributed (should be sufficient to handle 
// the reentrant case) but the explicit bEnableWorkDistribution flag seems to be
// more defensive
    pStackEntryTmp = Stack_PeekAt(/* pThis, */ nStackIndex);
    pStackEntryTmp->SlaveList [nMoveListIndex] = nSlaveId;
    pStackEntryTmp->bHasAnySubWork = true; // kh 22.10.07 ignore sync step support (performance)

// kh 02.05.07 do this now for the root master only (performance)
    if(g_pYBWCManagerInstance->bRootMaster)
    {
      search_update_current(); 
      pStackEntryTmp->TimeList  [nMoveListIndex] = SearchCurrent->time;
      strcpy(pStackEntryTmp->TimeStampList[nMoveListIndex], YBWCManager_TimeStampShortAsString(g_pYBWCManagerInstance));

      pStackEntryTmp->AlphaList [nMoveListIndex] = nAlpha;
      pStackEntryTmp->BetaList  [nMoveListIndex] = nBeta;
    }

    bSendOk = false;

// kh 10.10.06 defensive, temporarily disable work distribution here to avoid reentrant problems
// ProcessorHandler_CreateResult(... potentially dispatches requests (see also comment from 13.09.06 below)
    g_pYBWCManagerInstance->bEnableWorkDistribution = FALSE;

// kh 14.03.07 $$$ important: if the message loop is openend again here, the problem of receiving a stop/cutoff while 
// creating the request has to be handled properly

// kh 13.09.06 the state/synchronization ids may potentially change while creating 
// a new result if the pending result buffer is full, because messages are serviced then
    pResult           = ProcessorHandler_CreateResult(pProcessorHandler); 

// kh 14.03.07
    if(!pStackEntryTmp->bIsAlive || pStackEntryTmp->bStopped)
    {
      if(false && g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_FORCE_OUTPUT)
      {
        YBWCManager_Printf(g_pYBWCManagerInstance, 
                           "INFO work to slave stopped before even send: nSyncPositionId = %d, nStackIndex = %d, nMoveListIndex = %d, nCallType = %d, nMove = %d, nDepth = %d, nAlpha = %d, nBeta = %d, nMoveAheadListCount = %d\n",
//                         "INFO work to slave stopped before even send: nSyncPositionId = %d, nWorkId = " F12INT64d ", nStackIndex = %d, nMoveListIndex = %d, nCallType = %d, nMove = %d, nDepth = %d, nAlpha = %d, nBeta = %d, nMoveAheadListCount = %d\n",
                           g_pYBWCManagerInstance->nSyncPositionId,
//                         nWorkIdMemo,
                           nStackIndex,
                           nMoveListIndex,
                           nCallType,
                           nMove,
                           nDepth,
                           nAlpha,
                           nBeta,
                           nMoveAheadListCount);
      }
    }

    nResult           = Result_InitMasterWorkAvailable(pResult,
                                                       nStackIndex,
                                                       nMoveListIndex,
                                                       nCallType,       // kh 11.09.06 for future expansion
                                                       nReturnPosition, // kh 17.03.07 used for statistics only 
                                                       nMove,
                                                       nDepth,
                                                       nNewDepth,       // kh 10.10.06 for future expansion
                                                       nHeight,
                                                       bInPV,
                                                       nPlayedNb,
                                                       nHistoryValue,
                                                       nAlpha,
                                                       nBeta,
                                                       nTransDate,
                                                       bGoodCap,
                                                       nMoveAheadListCount,
                                                       MoveAheadList,
                                                       nKillerListCount,
                                                       KillerList);

    if(nResult == MPI_SUCCESS)
    {

// kh 20.09.06 the match of the master and slave sync position ids is double-checked here
// this is defensive only, because any sync position request (received in between) by this
// potential master would be delayed dispatched and can not have changed the nSyncPositionId
      if(g_pYBWCManagerInstance->nSyncPositionId == nSlaveSyncPositionId)
      {
        nWorkIdMemo = pResult->nWorkId;

        pStackEntryTmp->WorkIdList[nMoveListIndex] = nWorkIdMemo; 
        nResult = Result_Send(pResult);

        if(!pStackEntryTmp->bIsAlive || pStackEntryTmp->bStopped)
        {
          if(false && g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_FORCE_OUTPUT)
          {
            YBWCManager_Printf(g_pYBWCManagerInstance, 
                               "INFO work to slave stopped immediately after send: nSyncPositionId = %d, nStackIndex = %d, nMoveListIndex = %d, nCallType = %d, nMove = %d, nDepth = %d, nAlpha = %d, nBeta = %d, nMoveAheadListCount = %d\n",
//                             "INFO work to slave stopped before even send: nSyncPositionId = %d, nWorkId = " F12INT64d ", nStackIndex = %d, nMoveListIndex = %d, nCallType = %d, nMove = %d, nDepth = %d, nAlpha = %d, nBeta = %d, nMoveAheadListCount = %d\n",
                               g_pYBWCManagerInstance->nSyncPositionId,
//                             nWorkIdMemo,
                               nStackIndex,
                               nMoveListIndex,
                               nCallType,
                               nMove,
                               nDepth,
                               nAlpha,
                               nBeta,
                               nMoveAheadListCount);
          }
        }

        if(nResult == MPI_SUCCESS)
        {
// kh 20.09.06 lines moved up
/*
          pStackEntryTmp = Stack_PeekAt(pThis, nStackIndex);
          pStackEntryTmp->SlaveList [nMoveListIndex] = nSlaveId;
*/

// kh 14.12.06 triple-checked
          if(g_pYBWCManagerInstance->nSyncPositionId == nSlaveSyncPositionId)
          {

/*
// kh 15.12.06 do not access pResult members, because pResult may have been deleted already,
// because messages are serviced now in Result_Send(...

// kh 14.03.07 do this early now, because the request may have been completely handled here 
// (i.e. the result from the slave may have been processed in YBWCManager_ProcessSlaveResult(..., 
// see also comment from 15.12.06 above)
/*
// kh 20.09.06 pResult->nWorkId was set in Result_InitMasterWorkAvailable(...
            pStackEntryTmp->WorkIdList[nMoveListIndex] = nWorkIdMemo; 
*/
            bSendOk = true;
          }
          else
          {
            if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
            {
              YBWCManager_Printf(g_pYBWCManagerInstance, "ERROR YBWCManager_CheckSendRequestForWork(... unexpected (1) nSyncPositionId change (..., nSyncPositionId = %d\n", g_pYBWCManagerInstance->nSyncPositionId);
            }

// kh 18.03.07 pResult may not longer exist here
//          pResult->bSendSuppressed = TRUE;
          }
        } // if(nResult == MPI_SUCCESS)
        else
        {
          if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
          {
            YBWCManager_Printf(g_pYBWCManagerInstance, "ERROR Stack_SendWorkToSLave(... failed at Result_Send(..., errorcode = %d\n", nResult);
          }
        } // !if(nResult == MPI_SUCCESS)
      }
      else
      {
        pResult->bSendSuppressed = TRUE;
        if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
        {
          YBWCManager_Printf(g_pYBWCManagerInstance, "ERROR YBWCManager_CheckSendRequestForWork(... unexpected (2) nSyncPositionId change (..., nSyncPositionId = %d\n", g_pYBWCManagerInstance->nSyncPositionId);
        }
      }
    } // if(nResult == MPI_SUCCESS)
    else
    {
      if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
      {
        YBWCManager_Printf(g_pYBWCManagerInstance, "ERROR Stack_SendWorkToSLave(... failed at Result_InitMasterWorkAvailable(..., errorcode = %d\n", nResult);
      }
    } // !if(nResult == MPI_SUCCESS)

    if(bSendOk)
    {
    }
    else
    {

      if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
      {
        YBWCManager_Printf(g_pYBWCManagerInstance, "ERROR Stack_SendWorkToSLave(... failed\n");
      }

// kh 10.10.09 defensive, reenable the distribution of this move if there was a problem 
// (will probably not help any more...)
      ASSERT(pStackEntryTmp->SlaveList[nMoveListIndex] > 0);
      pStackEntryTmp->SlaveList[nMoveListIndex]   = -1;

//    pStackEntryTmp->bHasAnySubWork = false; // kh 22.10.07 perform a sync step anyway (defensive)

      pStackEntryTmp->AlphaList[nMoveListIndex]   = 0;
      pStackEntryTmp->BetaList [nMoveListIndex]   = 0;


//    ASSERT(pStackEntryTmp->WorkIdList[nMoveListIndex] > 0);
      pStackEntryTmp->WorkIdList[nMoveListIndex]  = -1; // kh 14.03.07
    }

// kh 10.10.06 defensive, enable work distribution here again
    g_pYBWCManagerInstance->bEnableWorkDistribution = TRUE;

    break;

  case CALL_TYPE_FULL_NO_NULL:
    ASSERT(false); // kh 11.09.06 no distribution at the moment

    break;

  case CALL_TYPE_FULL_QUIESCENCE:
    ASSERT(false); // kh 11.09.06 no distribution at the moment
    break;

  default:
    ASSERT(false);
    break;
  }

  return nResult;
}

bool Stack_HasSendWorkToSlave(/* Stack* pThis, */ int nSlaveId, int nSlaveSyncPositionId)
{
  bool                      bResult;
  int                       i;

  int                       j;

  bool                      bBreak;
  bool                      bWouldBreak;

  int                       nNewDepth;

  int                       nPlayedNbAtLeast;

  bool                      bMoveListBreak;
  bool                      bBreakAfterSortNextOnce;
  bool                      bBreakAfterRealSkipOnce;

  int                       nMoveListIndex;

  int                       nMove;
  int                       nMoveLookAhead;

  bool                      bSortNextFirst;

  int                       nMinimumBrothersFinished;

  int                       nMoveListCountLimitAdjust;

  int                       nHistoryValue;

  int                       nStep;

  bool                      bSkipMove;

  bool                      bSlaveOnSameNode;

  int                       nTmpMinimumRemoteSearchDepth;

  bool                      bTmpGoodCap;
  bool                      bSkip;

  StackEntry*               pStackEntry;

  bResult     = false;

  pStackEntry = NULL;

  if(g_pYBWCManagerInstance->processorHandlerPool[nSlaveId]->bOnSameNode)
  {
    bSlaveOnSameNode = true;
  }
  else
  {
    bSlaveOnSameNode = false;
  }

  if(g_Stack.nCount > 0)
  {
    bBreak = false;
    if(g_pYBWCManagerInstance->pFruitConfiguration->bUseMultiStepStackSearch)
    {
      nStep = 0;
    }
    else
    {
      nStep = 1;
    }

    while(nStep < 2 && !bBreak)
    {
      if(g_pYBWCManagerInstance->pFruitConfiguration->bReverseSearchStackDistributionOrder)
      {
        i = g_Stack.nCount - 1;
      }
      else
      {
        i = 0;
      }

      bWouldBreak = false; 
      while(    (    ((i < g_Stack.nCount) && !g_pYBWCManagerInstance->pFruitConfiguration->bReverseSearchStackDistributionOrder)
                  || ((i >= 0)             &&  g_pYBWCManagerInstance->pFruitConfiguration->bReverseSearchStackDistributionOrder))
            && !bBreak)
      {
        pStackEntry = &g_Stack.stackEntry[i];

        switch(pStackEntry->nCallType)
        {
        case CALL_TYPE_UNDEFINED:
          ASSERT(false);
          break;

        case CALL_TYPE_FULL_ROOT:
/*
          pFullRootPar          = &pStackEntry->parameters.fullRootPar;
          pFullRootDat          = &pStackEntry->localData.fullRootDat;
*/

          if(pStackEntry->bStopped)
          {
            if(false && g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_FORCE_OUTPUT)
            {
              YBWCManager_Printf(g_pYBWCManagerInstance, "INFO CALL_TYPE_FULL_ROOT Stack_HasSendWorkToSlave(... pStackEntry->bStopped was set in between -> there is no work available\n");
            }
          } // if(pStackEntry->bStopped)
          else
          {
            if(pStackEntry->bTryToDistribute)
            {
              ASSERT(pStackEntry->parameters.fullRootPar.search_type == SearchNormal);
              if(pStackEntry->bIsAlive)
              {
                ASSERT(pStackEntry->bMoveListFullyGenerated);

// kh 11.09.06 ignore first move at index 0 (always locally searched)
// that is the main characteristic of YBWC
                nMinimumBrothersFinished = g_pYBWCManagerInstance->pFruitConfiguration->nMinimumBrothersFinishedRoot;

// kh 04.05.07 use implication
                ASSERT(    (pStackEntry->nNetMoveListIndex == pStackEntry->nMoveListIndex)
                        || (SearchCurrent->multipv > 0));

// kh 04.05.07 use the "net" move list index, not counting the filtered moves in multipv mode (if > 0)
                if(    (    (     (nStep == 0) 
                               && (pStackEntry->nNetMoveListIndex >=
                                   g_pYBWCManagerInstance->pFruitConfiguration->nMinimumBrothersFinishedRootFirstStep))
                         || (nStep == 1))
                    && (pStackEntry->nNetMoveListIndex >= nMinimumBrothersFinished)
                  )
                {

// kh 04.05.07 use implication
                  ASSERT(    (pStackEntry->localData.fullRootDat.best_value[SearchCurrent->multipv] != ValueNone) // kh 11.04.07 Thomas Gaksch
                          || (nMinimumBrothersFinished == 0));

                  if(    (pStackEntry->localData.fullRootDat.best_value[SearchCurrent->multipv] == ValueNone) // kh 11.04.07 Thomas Gaksch
                      && (SearchCurrent->multipv == 0))                                  // kh 04.05.07 
                  {
                    if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
                    {
                      YBWCManager_Printf(g_pYBWCManagerInstance, "ERROR Stack_HasSendWorkToSlave(... root move pStackEntry->localData.fullRootDat.best_value[SearchCurrent->multipv] == ValueNone\n");
                    }
                  }

                  nMoveListCountLimitAdjust = -1;
                  if(g_pYBWCManagerInstance->pFruitConfiguration->bAllowDistributionOfLastMoveInList)
                  {
                    nMoveListCountLimitAdjust = 0;
                  }

                  bMoveListBreak = false;
                  nMoveListIndex = pStackEntry->nMoveListIndex + 1; 

                  while(!bMoveListBreak)
                  {
                    bSkipMove = false;
                    if(nMoveListIndex < (pStackEntry->nMoveListTotalCount + nMoveListCountLimitAdjust))
                    {

// kh 11.09.06 there are at least 1 or 2 next moves in the list available
                      nMove = pStackEntry->MoveList[nMoveListIndex];

                      if(SearchCurrent->multipv > 0)
                      {
                        j = 0;
		                    while((j < SearchCurrent->multipv) && !bSkipMove)
                        {
			                    if(SearchBest[j].pv[0] == nMove)
                          {
				                    bSkipMove = true;
			                    }
                          j++;
		                    } // while((j < SearchCurrent->multipv) && !bSkipMove)
                      } // if(SearchCurrent->multipv > 0)
                    }
                    else
                    {
                      bMoveListBreak = true;
                    }

                    if(bMoveListBreak)
                    {

                      // kh 11.09.06 move list access completed for all moves 
                      // all moves have been either locally searched (possibly except for the last move) or are distributed 
                      // (and the remote search may not be completed yet)

                    } // if(bMoveListBreak)
                    else
                    {
                      if(    (pStackEntry->SlaveList    [nMoveListIndex] > 0) // kh 11.09.06 a slave is searching for this move
                          ||  pStackEntry->CompletedList[nMoveListIndex]      // kh 11.09.06 a slave has already completed the search for this move 
                        )
                      {

                        // kh 11.09.06 skip

                      } // if(    (pStackEntry->SlaveList    [nMoveListIndex] > 0)...
                      else if(bSkipMove)
                      {

                        // kh 11.04.07 skip for multi pv move already searched

                      } // if(bSkipMove)
                      else
                      {

// kh 11.09.06 will be set if the result is sent back from the slave
//                      pStackEntry->CompletedList[nMoveListIndex] = true;


// kh 10.10.06 the full_new_depth(... calculation is delegated to the slave now
// a convenient side-effect is that the effort necessary to save the board state otherwise is avoided
/*
                        nNewDepth = full_new_depth(pStackEntry->parameters.fullRootPar.depth, 
                                                  nMove, 
                                                  &pStackEntry->boardMemo, 
                                                  board_is_check(&pStackEntry->boardMemo) && LIST_SIZE(pStackEntry->parameters.fullRootPar.list) == 1, 
                                                  true);
*/

// kh 10.10.06 the exact value of nNewDepth is not available here and "estimated" therefore
// that seems to be justifiable because the value is only used here to test if a distribution makes sense
// in respect to the overhead it introduces
                        nNewDepth = pStackEntry->parameters.fullRootPar.depth - 1; 

                        if(bSlaveOnSameNode)
                        {
                          nTmpMinimumRemoteSearchDepth = g_pYBWCManagerInstance->pFruitConfiguration->nMinimumRemoteSearchDepthSameNode;
                        }
                        else
                        {
                          nTmpMinimumRemoteSearchDepth = g_pYBWCManagerInstance->pFruitConfiguration->nMinimumRemoteSearchDepth;
                        }

                        if(    (nNewDepth >= nTmpMinimumRemoteSearchDepth)
                            && (    (nNewDepth <= g_pYBWCManagerInstance->pFruitConfiguration->nMaximumRemoteSearchDepth)
                                || (g_pYBWCManagerInstance->pFruitConfiguration->nMaximumRemoteSearchDepth == 0)))
                        {
                          if(    (pStackEntry->parameters.fullRootPar.height >= g_pYBWCManagerInstance->pFruitConfiguration->nMinimumRemoteSearchHeight)
                              && (    (pStackEntry->parameters.fullRootPar.height <= g_pYBWCManagerInstance->pFruitConfiguration->nMaximumRemoteSearchHeight)
                                  || (g_pYBWCManagerInstance->pFruitConfiguration->nMaximumRemoteSearchHeight == 0))
                            )
                          {

/*
                            if(true)
*/
                            {

// kh 17.03.07 a subproblem (nHeightOffset potentially > 0) will not be distributed any further 
// at the root level of the subproblem itself
                              ASSERT(SearchInfo->nHeightOffset == 0); 

                              if(pStackEntry->localData.fullRootDat.best_value[SearchCurrent->multipv] == ValueNone)
                              {
                                nPlayedNbAtLeast = 0;
                              }
                              else
                              {
                                nPlayedNbAtLeast = 1;
                              }

                              Stack_SendWorkToSLave(/* pThis, */
                                                    nSlaveId,
                                                    nSlaveSyncPositionId,
                                                    i, 
                                                    nMoveListIndex, 
                                                    pStackEntry->nCallType, 
                                                    pStackEntry->nReturnPosition, // kh 17.03.07 used for statistics only
                                                    nMove, 
                                                    pStackEntry->parameters.fullRootPar.depth,
                                                    nNewDepth,                    // kh 10.10.06 may be used as a future expansion
                                                    pStackEntry->parameters.fullRootPar.height,         // kh 26.03.07 actual local height 
                                                    pStackEntry->parameters.fullRootPar.height +        // kh 13.10.06 calculation by the slave (in do_moves_ahead(... ) seems to be to complex (due to IID, null move etc.)
                                                      SearchInfo->nHeightOffset,  // kh 17.03.07 further adjust (0 expected here always)
//                                                  pStackEntry->parameters.fullRootPar.height,         // kh 13.10.06 calculation by the slave (in do_moves_ahead(... ) seems to be to complex (due to IID, null move etc.)
                                                    TRUE,                         // kh 10.10.06 send "in PV" state to the slave for its delegated full_new_depth(... calculation
                                                    nPlayedNbAtLeast,             // kh 17.06.08 support nMinimumBrothersFinishedRoot = 0 
                                                    0,                            // kh 09.02.07 send nHistoryValue to the slave (do not care for root moves)
                                                    pStackEntry->parameters.fullRootPar.alpha,
                                                    pStackEntry->parameters.fullRootPar.beta,
                                                    Trans->date,
                                                    FALSE);                       // kh 04.06.08 send bGoodCap to the slave (do not care for root moves)

// kh 17.03.07 entry may have been immediately stopped after work send to slave 
//                            ASSERT(pStackEntry->bIsAlive); 

                              if(pStackEntry->bIsAlive)
                              {
                              }
                              else
                              {
                                if(false && g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_FORCE_OUTPUT)
                                {
                                  YBWCManager_Printf(g_pYBWCManagerInstance, "INFO Stack_HasSendWorkToSlave(... root move distributed but stack entry is no longer alive\n");
                                }
                              }

                              bMoveListBreak  = true;
                              bBreak          = true;
                              bResult         = true;
                              if(bWouldBreak)
                              {
                                if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
                                {
                                  YBWCManager_Printf(g_pYBWCManagerInstance, "ERROR Stack_HasSendWorkToSlave(... root move distributed now, but only because of defensive programming\n");
                                }
                              }
                            }
                          } // if(    (pStackEntry->parameters.fullRootPar.height >= g_pYBWCManagerInstance->pFruitConfiguration->nMinimumRemoteSearchHeight)...
                        } // if(    (nNewDepth >= nTmpMinimumRemoteSearchDepth)...
                      } // !// if(    (pStackEntry->SlaveList    [pStackEntry->nMoveListIndex] > 0), !if(bSkipMove)...
                    } // !if(bMoveListBreak)

                    nMoveListIndex++;
                  } // while(!bMoveListBreak)
                } // if(    (    (     (nStep == 0) ...
              } // if(pStackEntry->bIsAlive)
              else
              {
                if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_INFO_PRIO_1)
                {
                  YBWCManager_Printf(g_pYBWCManagerInstance, "INFO Stack_HasSendWorkToSlave(... pStackEntry is no longer alive\n");
                }
              } // if(pStackEntry->bIsAlive)
            } // if(pStackEntry->bTryToDistribute)
          } // !if(pStackEntry->bStopped)

          break;

        case CALL_TYPE_FULL_SEARCH:
/*
          pFullSearchPar        = &pStackEntry->parameters.fullSearchPar;
          pFullSearchDat        = &pStackEntry->localData.fullSearchDat;
*/

          if(pStackEntry->bStopped)
          {
/*
            if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_FORCE_OUTPUT)
            {
              YBWCManager_Printf(g_pYBWCManagerInstance, "INFO CALL_TYPE_FULL_SEARCH Stack_HasSendWorkToSlave(... pStackEntry->bStopped was set in between -> there is no work available\n");
            }
*/
          } // if(pStackEntry->bStopped)
          else
          {
            if(pStackEntry->bTryToDistribute)
            {
              if(pStackEntry->bIsAlive)
              {

// kh 20.10.06 lazy move list generation (see below) is now supported, because
// the correct board state (needed by sort_next(... )is accessible here "in the middle of the stack"

// kh 07.09.06 ignore first move at index 0 (always locally searched)
// that is the main characteristic of YBWC

// kh 17.12.06 now more fine tuned
                nMinimumBrothersFinished = g_pYBWCManagerInstance->pFruitConfiguration->nMinimumBrothersFinished;
                if(pStackEntry->parameters.fullSearchPar.node_type == NodeCut)
                {
                  nMinimumBrothersFinished += g_pYBWCManagerInstance->pFruitConfiguration->nBrothersFinishedTypeCutOffset;
                }
                else if(pStackEntry->parameters.fullSearchPar.node_type == NodeAll)
                {
                  nMinimumBrothersFinished += g_pYBWCManagerInstance->pFruitConfiguration->nBrothersFinishedTypeAllOffset;
                }
                else
                {
                  nMinimumBrothersFinished += g_pYBWCManagerInstance->pFruitConfiguration->nBrothersFinishedTypePVOffset;
                }

                if(bSlaveOnSameNode)
                {
                  nTmpMinimumRemoteSearchDepth = g_pYBWCManagerInstance->pFruitConfiguration->nMinimumRemoteSearchDepthSameNode;
                }
                else
                {
                  nTmpMinimumRemoteSearchDepth = g_pYBWCManagerInstance->pFruitConfiguration->nMinimumRemoteSearchDepth;
                }

                if(    (    (    (nStep == 0) 
                              && (pStackEntry->nMoveListIndex >= 
                                  g_pYBWCManagerInstance->pFruitConfiguration->nMinimumBrothersFinishedFirstStep))
                         || (nStep == 1))
                    && (pStackEntry->nMoveListIndex >= nMinimumBrothersFinished)

// kh 26.02.07 check this early and a little bit more restrictive to defer the lazy move list generation
                    && ((pStackEntry->parameters.fullSearchPar.depth - 1) >= nTmpMinimumRemoteSearchDepth)
                    && (    ((pStackEntry->parameters.fullSearchPar.depth - 1) <= g_pYBWCManagerInstance->pFruitConfiguration->nMaximumRemoteSearchDepth)
                        || (g_pYBWCManagerInstance->pFruitConfiguration->nMaximumRemoteSearchDepth == 0)))
                {
                  ASSERT((nMinimumBrothersFinished == 0) || (pStackEntry->localData.fullSearchDat.best_value != ValueNone));

                  if(pStackEntry->localData.fullSearchDat.best_value == ValueNone)
                  {
                    if(nMinimumBrothersFinished > 0)
                    {
                      if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
                      {
                        YBWCManager_Printf(g_pYBWCManagerInstance, "ERROR Stack_HasSendWorkToSlave(... full search move pStackEntry->localData.fullSearchDat.best_value == ValueNone\n");
                      }
                    }
                  }

                  nMoveListCountLimitAdjust = -1;
                  if(g_pYBWCManagerInstance->pFruitConfiguration->bAllowDistributionOfLastMoveInList)
                  {
                    nMoveListCountLimitAdjust = 0;
                  }

                  bMoveListBreak          = false;
                  bBreakAfterSortNextOnce = false;
                  bBreakAfterRealSkipOnce = false;
                  nMoveListIndex          = pStackEntry->nMoveListIndex + 1; 
                  bSortNextFirst          = true;

                  while(!bMoveListBreak && !bBreakAfterSortNextOnce && !bBreakAfterRealSkipOnce)
                  {
                    if(nMoveListIndex < pStackEntry->nMoveListTotalCount)
                    {

// kh 07.09.06 there is at least the next move in the list available
                      nMove = pStackEntry->MoveList[nMoveListIndex];

                      if(nMoveListIndex < (pStackEntry->nMoveListTotalCount + nMoveListCountLimitAdjust))
                      {

// kh 07.09.06 there are a least 1 or 2 next moves in the list available, try to distribute the move

                      }
                      else
                      {
                        ASSERT(nMoveListCountLimitAdjust == -1); // kh 8.02.07 reachable only if nMoveListCountLimitAdjust = -1

                        if(pStackEntry->bMoveListFullyGenerated)
                        {

// kh 11.09.06 the move list is already fully generated, so the real last move is accessed here
                          bMoveListBreak = true;
                        }
                        else
                        {
                          if(LAZY_MOVE_LIST_GENERATION_NOT_SUPPORTED)// kh 17.10.06 actual false, lazy move list generation is supported
                          {
                            if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
                            {
                              YBWCManager_Printf(g_pYBWCManagerInstance, "ERROR Stack_HasSendWorkToSlave(... failed at pStackEntry->MoveList[nMoveListIndex] access, move list was not fully generated in advance\n");
                            }
                            bMoveListBreak = true; // kh 16.10.06 defensive (will probably not help any more...)
                            ASSERT(false); 
                          }
                          else
                          {

// kh 07.09.06 "look ahead" (and buffer) one move, to be able to suppress the distribution 
// of the last move in the list
                            if(bSortNextFirst)
                            {

// kh 18.10.06 support board access per level (defensive, fruit uses always a pointer to access the board)
                              Stack_RestoreBoardStateForLevel(/* pThis, */ i); //, pStackEntry->parameters.fullSearchPar.board);
                              bSortNextFirst = false;
                            }

// kh 02.06.08 Thomas Gaksch 14b5c
                            if((nMoveLookAhead = sort_next(pStackEntry->localData.fullSearchDat.sort)) != MoveNone) // kh 11.04.07 Thomas Gaksch

                            {
                              ASSERT(nMoveListIndex == (pStackEntry->nMoveListTotalCount - 1));

                              StackEntry_AddMove(pStackEntry, nMoveLookAhead);
                              pStackEntry->SortValueList[pStackEntry->nMoveListTotalCount - 1] = pStackEntry->localData.fullSearchDat.sort->value;
                            } // if((nMoveLookAhead = sort_next(pStackEntry->localData.fullSearchDat.sort)) != MoveNone)
                            else
                            {

// kh 07.09.06 bMoveListFullyGenerated is also accessed in the main search loop 
                              pStackEntry->bMoveListFullyGenerated = true;

// kh 07.09.06 suppress the distribution of the last move in the list
                              bMoveListBreak                       = true;
                            } // !if((nMoveLookAhead = sort_next(pStackEntry->localData.fullSearchDat.sort)) != MoveNone)
                          }
                        }
                      }
                    } // if(nMoveListIndex < pStackEntry->nMoveListTotalCount)
                    else if(pStackEntry->bMoveListFullyGenerated) // kh 07.09.06 bMoveListFullyGenerated may have been already set while searching the stack for work in the meantime
                    {
                      bMoveListBreak = true;
                    }
                    else if(LAZY_MOVE_LIST_GENERATION_NOT_SUPPORTED)// kh 17.10.06 actual false, lazy move list generation is supported
                    {
                      if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
                      {
                        YBWCManager_Printf(g_pYBWCManagerInstance, "ERROR Stack_HasSendWorkToSlave(... failed at pStackEntry->MoveList[nMoveListIndex] access, move list was not fully generated in advance\n");
                      }
                      ASSERT(false); 
                      bMoveListBreak = true; // kh 16.10.06 defensive (will probably not help any more...)
                    }
                    else 
                    {
                      if(bSortNextFirst)
                      {

// kh 18.10.06 support board access per level (defensive, fruit uses always a pointer to access the board)
                        Stack_RestoreBoardStateForLevel(/* pThis, */ i); //, pStackEntry->parameters.fullSearchPar.board);
                        bSortNextFirst = false;
                      }

// kh 02.06.08 Thomas Gaksch 14b5c
                      if((nMove = sort_next(pStackEntry->localData.fullSearchDat.sort)) != MoveNone) // kh 11.04.07 Thomas Gaksch
                      {
                        ASSERT(nMoveListIndex == pStackEntry->nMoveListTotalCount);

                        StackEntry_AddMove(pStackEntry, nMove);
                        pStackEntry->SortValueList[pStackEntry->nMoveListTotalCount - 1] = pStackEntry->localData.fullSearchDat.sort->value;

// kh 07.09.06 force a break for the outer loop after getting first new move once via sort_next(... 
// may be used to terminate the generation of another next move, because it is very unlikely that another next move
// can be send to a slave if this move can not be send to a slave (but nNewDepth is potentially "move dependent" and 
// may vary)
                        bBreakAfterSortNextOnce = true;

// kh 07.09.06 "look ahead" (and buffer) one move, to be able to suppress the distribution of the last move in the list
                        ASSERT(!bSortNextFirst) // kh 17.10.06 already done above
                        if(bSortNextFirst)
                        {

// kh 18.10.06 support board access per level (defensive, fruit uses always a pointer to access the board)
                          Stack_RestoreBoardStateForLevel(/* pThis, */ i); //, pStackEntry->parameters.fullSearchPar.board);
                          bSortNextFirst = false;
                        }

                        if(g_pYBWCManagerInstance->pFruitConfiguration->bAllowDistributionOfLastMoveInList)
                        {

// kh 08.02.07 no look ahead is needed if the distribution of the last move is allowed

                        }
                        else
                        {

// kh 02.06.08 Thomas Gaksch 14b5c
                          if((nMoveLookAhead = sort_next(pStackEntry->localData.fullSearchDat.sort)) != MoveNone) // kh 11.04.07 Thomas Gaksch
                          {

// kh 18.10.06 one move was already inserted by the sort_next(... above
                            ASSERT(nMoveListIndex == pStackEntry->nMoveListTotalCount - 1); 

                            StackEntry_AddMove(pStackEntry, nMoveLookAhead);
                            pStackEntry->SortValueList[pStackEntry->nMoveListTotalCount - 1] = pStackEntry->localData.fullSearchDat.sort->value;
                          } // if((nMoveLookAhead = sort_next(pStackEntry->localData.fullSearchDat.sort)) != MoveNone)
                          else
                          {

// kh 07.09.06 bMoveListFullyGenerated is also accessed in the main search loop 
                            pStackEntry->bMoveListFullyGenerated = true;

// kh 07.09.06 suppress the distribution of the last move in the list
                            bMoveListBreak                       = true;
                          } // !if((nMoveLookAhead = sort_next(pStackEntry->localData.fullSearchDat.sort)) != MoveNone)
                        }
                      } // if((nMove = sort_next(pStackEntry->localData.fullSearchDat.sort)) != MoveNone)
                      else
                      {

// kh 07.09.06 bMoveListFullyGenerated is also accessed in the main search loop 
                        pStackEntry->bMoveListFullyGenerated = true;
                        bMoveListBreak                       = true;
                      } // !if((nMove = sort_next(pStackEntry->localData.fullSearchDat.sort)) != MoveNone)
                    }

                    if(bMoveListBreak)
                    {

                      // kh 07.09.06 move list access completed for all moves 
                      // all moves have been either locally searched (possibly except for the last move) or are distributed 
                      // (and the remote search may not be completed yet)

                    } // if(bMoveListBreak)
                    else
                    {
                      if(    (pStackEntry->SlaveList    [nMoveListIndex] > 0) // kh 07.09.06 a slave is searching for this move
                          ||  pStackEntry->CompletedList[nMoveListIndex]      // kh 07.09.06 a slave has already completed the search for this move 
                        )
                      {

                        // kh 07.09.06 skip

                      } // if(    (pStackEntry->SlaveList    [nMoveListIndex] > 0)...
                      else
                      {

                        ASSERT(nMove == pStackEntry->MoveList[nMoveListIndex]);

                        if(nMoveListIndex < ((pStackEntry->nMoveListTotalCount + nMoveListCountLimitAdjust) - 1))
                        {
                        }
                        else
                        {
                          bBreakAfterRealSkipOnce = true;
                        }

// kh 07.09.06 will be set if the result is sent back from the slave
//                      pStackEntry->CompletedList[nMoveListIndex] = true;

// kh 10.10.06 the full_new_depth(... calculation is delegated to the slave now
// a convenient side-effect is that the effort necessary to save the board state otherwise is avoided
/*
                        nNewDepth = full_new_depth(pStackEntry->parameters.fullSearchPar.depth, 
                                                   nMove, 
                                                   pStackEntry->parameters.fullSearchPar.board, 
                                                   pStackEntry->localData.fullSearchDat.single_reply, 
                                                   pStackEntry->parameters.fullSearchPar.node_type == NodePV);
*/

// kh 10.10.06 the exact value of nNewDepth is not available here and "estimated" therefore
// that seems to be justifiable because the value is only used here to test if a distribution makes sense
// in respect to the overhead it introduces
                        nNewDepth = pStackEntry->parameters.fullSearchPar.depth - 1; 
                        
                        if(bSlaveOnSameNode)
                        {
                          nTmpMinimumRemoteSearchDepth = g_pYBWCManagerInstance->pFruitConfiguration->nMinimumRemoteSearchDepthSameNode;
                        }
                        else
                        {
                          nTmpMinimumRemoteSearchDepth = g_pYBWCManagerInstance->pFruitConfiguration->nMinimumRemoteSearchDepth;
                        }

                        if(    (nNewDepth >= nTmpMinimumRemoteSearchDepth)
                            && (    (nNewDepth <= g_pYBWCManagerInstance->pFruitConfiguration->nMaximumRemoteSearchDepth)
                                || (g_pYBWCManagerInstance->pFruitConfiguration->nMaximumRemoteSearchDepth == 0)))
                        {
                          if(    (pStackEntry->parameters.fullSearchPar.height >= g_pYBWCManagerInstance->pFruitConfiguration->nMinimumRemoteSearchHeight)
                              && (    (pStackEntry->parameters.fullSearchPar.height <= g_pYBWCManagerInstance->pFruitConfiguration->nMaximumRemoteSearchHeight)
                                  || (g_pYBWCManagerInstance->pFruitConfiguration->nMaximumRemoteSearchHeight == 0))
                            )
                          {
                            if(    false                                                          // kh 17.03.07 for easier editing the next lines
//                              || pStackEntry->nReturnPosition == RETURN_POSITION_UNDEFINED
                                || pStackEntry->nReturnPosition == RETURN_POSITION_FUNCTION_END

                                || pStackEntry->nReturnPosition == RETURN_POSITION_FULL_ROOT_01
                                || pStackEntry->nReturnPosition == RETURN_POSITION_FULL_ROOT_01_1
                                || pStackEntry->nReturnPosition == RETURN_POSITION_FULL_ROOT_01_2

//                              || pStackEntry->nReturnPosition == RETURN_POSITION_FULL_ROOT_02
//                              || pStackEntry->nReturnPosition == RETURN_POSITION_FULL_ROOT_03
                                || pStackEntry->nReturnPosition == RETURN_POSITION_FULL_ROOT_03_1
                                || pStackEntry->nReturnPosition == RETURN_POSITION_FULL_ROOT_04

                                || pStackEntry->nReturnPosition == RETURN_POSITION_FULL_SEARCH_01
                                || pStackEntry->nReturnPosition == RETURN_POSITION_FULL_SEARCH_02
                                || pStackEntry->nReturnPosition == RETURN_POSITION_FULL_SEARCH_03
                                || pStackEntry->nReturnPosition == RETURN_POSITION_FULL_SEARCH_03_1
                                || pStackEntry->nReturnPosition == RETURN_POSITION_FULL_SEARCH_04
                                || pStackEntry->nReturnPosition == RETURN_POSITION_FULL_SEARCH_05
                                || pStackEntry->nReturnPosition == RETURN_POSITION_FULL_SEARCH_06 
//                              || pStackEntry->nReturnPosition == RETURN_POSITION_FULL_SEARCH_07
                                || pStackEntry->nReturnPosition == RETURN_POSITION_FULL_SEARCH_08
                                || pStackEntry->nReturnPosition == RETURN_POSITION_FULL_SEARCH_09

                                || pStackEntry->nReturnPosition == RETURN_POSITION_FULL_NO_NULL_01

                                || pStackEntry->nReturnPosition == RETURN_POSITION_FULL_QUIESCENCE_01
                              )
                            {

                              nHistoryValue = pStackEntry->SortValueList[nMoveListIndex];

// kh 23.02.07 try it a little bit more dynamic? ok, do it, if the move has an initial sort value an update is allowed
                              if(nHistoryValue < 16384)
                              {

// kh 23.02.07 board access is required on demand
                                if(bSortNextFirst) 
                                {

// kh 18.10.06 support board access per level (defensive, fruit uses always a pointer to access the board)
                                  Stack_RestoreBoardStateForLevel(/* pThis, */ i); //, pStackEntry->parameters.fullSearchPar.board);
                                  bSortNextFirst = false;
                                }

// kh 02.06.08 Thomas Gaksch 14b5c
                                nHistoryValue = history_prob(nMove, pStackEntry->parameters.fullSearchPar.board); // kh 11.04.07 Thomas Gaksch

                                if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_INFO_PRIO_1)
                                {
                                  if(nHistoryValue < pStackEntry->SortValueList[nMoveListIndex])
                                  {
                                    YBWCManager_Printf(g_pYBWCManagerInstance, 
                                                       "INFO \"good\" update of history prob from %d to %d\n",
                                                       pStackEntry->SortValueList[nMoveListIndex],
                                                       nHistoryValue);
                                  }
                                  else if(nHistoryValue > pStackEntry->SortValueList[nMoveListIndex])
                                  {
                                    YBWCManager_Printf(g_pYBWCManagerInstance, 
                                                       "INFO \"bad\" update of history prob from %d to %d\n",
                                                       pStackEntry->SortValueList[nMoveListIndex],
                                                       nHistoryValue);
                                  }
                                  else
                                  {
/*
                                    YBWCManager_Printf(g_pYBWCManagerInstance, 
                                                       "INFO \"no real\" update of history prob from %d to %d\n",
                                                       pStackEntry->SortValueList[nMoveListIndex],
                                                       nHistoryValue);
*/
                                  }
                                }

                              } // if(nHistoryValue < 16384)

                              bSkip = false;

// kh 04.06.08 Thomas Gaksch 14b5c
// kh 19.03.08 check history pruning in advance to suppress an immediate termination of a sub job at the root level
// (see also comment from 19.03.08 for fullSearch(... in search_full.cpp)
                              if(    UseHistoryPruning
                                  && !pStackEntry->localData.fullSearchDat.in_check 
                                  && pStackEntry->parameters.fullSearchPar.depth      <= 6 /*SearchCurrent->act_iteration / 2*/ 
			                            && pStackEntry->parameters.fullSearchPar.node_type  != NodePV 

//                                && pStackEntry->localData.fullSearchDat.new_depth   <  pStackEntry->parameters.fullSearchPar.depth 
                                  && nNewDepth                                        <  pStackEntry->parameters.fullSearchPar.depth 

                                  && pStackEntry->localData.fullSearchDat.value       <  HistoryValue / (pStackEntry->parameters.fullSearchPar.depth / 3 + 1) /*2*/

// kh 25.03.08 ignore eventually the pStackEntry->localData.fullSearchDat.played_nb check here to avoid problems if HistoryMoveNb > nMinimumBrothersFinished
// and sending potentially several moves "at once" to slaves which are potentially history pruned with a sequential search
// behavior

// kh 16.05.08 use + 1 offset to check played_nb >= ... to avoid sub job distribution (if pStackEntry->bHasAnySubWork is still false) if the master 
// searches already on the move that will increment played_nb when finished
//		                            && (    (pStackEntry->localData.fullSearchDat.played_nb + 1 >= 1+ /*sort->capture_nb*/+pStackEntry->parameters.fullSearchPar.depth)
//                                     || pStackEntry->bHasAnySubWork)

    	                            && !move_is_dangerous(pStackEntry->localData.fullSearchDat.move, 
                                                        pStackEntry->parameters.fullSearchPar.board) 
                                )
                              {
                                // kh 19.03.08 skip

                                bSkip = true;

                                if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_INFO_PRIO_1)
                                {
                							    YBWCManager_Printf(g_pYBWCManagerInstance, "INFO Stack_HasSendWorkToSlave(... history pruning expected -> Stack_SendWorkToSLave(... suppressed\n");
                                }
                              }

                              if(bSkip)
                              {
                              } // if(bSkip)
                              else
                              {

// kh 08.06.08 check history pruning part b in advance to handle search reductions for sub jobs
                                if(false && UseHistory)
                                {

// kh 03.06.08 start Thomas Gaksch 14b5c
                                  if(    !pStackEntry->localData.fullSearchDat.in_check 
                                      && pStackEntry->localData.fullSearchDat.new_depth < pStackEntry->parameters.fullSearchPar.depth

// kh 08.06.08 played_nb is potentially not really known if moves are still searched in parallel
// use defensive checks
//                                    && pStackEntry->localData.fullSearchDat.played_nb >= HistoryMoveNb 

				                              && pStackEntry->parameters.fullSearchPar.depth    >= HistoryDepth 
                                      && !move_is_dangerous(pStackEntry->localData.fullSearchDat.move, pStackEntry->parameters.fullSearchPar.board)
                                    )
                                  {
                                    bTmpGoodCap = pStackEntry->localData.fullSearchDat.good_cap;
					                          if(    pStackEntry->localData.fullSearchDat.good_cap 
                                        && !move_is_tactical(pStackEntry->localData.fullSearchDat.move, pStackEntry->parameters.fullSearchPar.board))
                                    {
						                          bTmpGoodCap = false;
					                          }

					                          if(!bTmpGoodCap)
                                    {
						                          if(pStackEntry->parameters.fullSearchPar.node_type != NodePV)
                                      {
                                        if(pStackEntry->localData.fullSearchDat.played_nb >= HistoryMoveNb)
                                        {
/*
							                            pStackEntry->localData.fullSearchDat.new_depth--;
							                            pStackEntry->localData.fullSearchDat.reduced = true;
*/
                                          if((nNewDepth - 1) >= nTmpMinimumRemoteSearchDepth)
                                          {
                                          }
                                          else
                                          {
                                            bSkip = true; // kh 08.06.08 late nTmpMinimumRemoteSearch check
                                          }
                                        }
                                        else
                                        {

// kh 08.06.08 use + 1 offset to check played_nb >= ... to avoid sub job distribution (if pStackEntry->bHasAnySubWork is still false) if the master 
// searches already on the move that will increment played_nb when finished
			                                    if( true ||    (pStackEntry->localData.fullSearchDat.played_nb + 1 >= HistoryMoveNb)
                                              || pStackEntry->bHasAnySubWork)
                                          {
                                            bSkip = true; // kh 08.06.08 played_nb is "unknown" 
                                          }
                                          else
                                          {
                                            // kh 08.06.08 played_nb is "unknown" but one additional parallel move search is at least allowed
                                            // (even if the master finished its search, the threshold aboce to set reduce to true can not be reached)
                                          }
                                        }
						                          } // if(pStackEntry->parameters.fullSearchPar.node_type != NodePV)
						                          else
                                      {
							                          if(pStackEntry->localData.fullSearchDat.played_nb >= HistoryMoveNb + 3)
                                        {
/*
							                            pStackEntry->localData.fullSearchDat.new_depth--;
							                            pStackEntry->localData.fullSearchDat.reduced = true;
*/
                                          if((nNewDepth - 1) >= nTmpMinimumRemoteSearchDepth)
                                          {
                                          }
                                          else
                                          {
                                            bSkip = true; // kh 08.06.08 late nTmpMinimumRemoteSearch check
                                          }
							                          }
                                        else
                                        {

// kh 08.06.08 use + 1 offset to check played_nb >= ... to avoid sub job distribution (if pStackEntry->bHasAnySubWork is still false) if the master 
// searches already on the move that will increment played_nb when finished
			                                    if( true || (pStackEntry->localData.fullSearchDat.played_nb + 1 >= HistoryMoveNb + 3)
                                              || pStackEntry->bHasAnySubWork)
                                          {
                                            bSkip = true; // kh 08.06.08 played_nb is "unknown"
                                          }
                                          else
                                          {
                                            // kh 08.06.08 played_nb is "unknown" but one additional parallel move search is at least allowed 
                                            // (even if the master finished its search, the threshold to set reduce to true can not be reached)
                                          }
                                        }
						                          } // !if(pStackEntry->parameters.fullSearchPar.node_type != NodePV)
			                              } // if(!pStackEntry->localData.fullSearchDat.good_cap)
                                  } // if(    !pStackEntry->localData.fullSearchDat.in_check...
                                } // if(UseHistory)
                              } // !if(bSkip)

                              if(bSkip)
                              {
                              } // if(bSkip)
                              else
                              {
                                Stack_SendWorkToSLave(/* pThis, */
                                                      nSlaveId, 
                                                      nSlaveSyncPositionId,
                                                      i, 
                                                      nMoveListIndex, 
                                                      pStackEntry->nCallType, 
                                                      pStackEntry->nReturnPosition,          // kh 17.03.07 used for statistics only
                                                      nMove, 
                                                      pStackEntry->parameters.fullSearchPar.depth,
                                                      nNewDepth,                              // kh 10.10.06 may be used as a future expansion
                                                      pStackEntry->parameters.fullSearchPar.height,                 // kh 26.03.07 actual local height 
                                                      pStackEntry->parameters.fullSearchPar.height +                // kh 13.10.06 calculation by the slave (in do_moves_ahead(... ) seems to be to complex (due to IID, null move etc.)
                                                        SearchInfo->nHeightOffset,            // kh 16.03.07 further adjust
//                                                    pStackEntry->parameters.fullSearchPar.height,                 // kh 13.10.06 calculation by the slave (in do_moves_ahead(... ) seems to be to complex (due to IID, null move etc.)
                                                      (pStackEntry->parameters.fullSearchPar.node_type == NodePV),  // kh 10.10.06 send "in PV" state to the slave for its delegated full_new_depth(... calculation
                                                      pStackEntry->localData.fullSearchDat.played_nb,
                                                      nHistoryValue, // pStackEntry->SortValueList[nMoveListIndex],
                                                      pStackEntry->parameters.fullSearchPar.alpha,
                                                      pStackEntry->parameters.fullSearchPar.beta,
                                                      Trans->date,
                                                      pStackEntry->localData.fullSearchDat.good_cap);

// kh 17.03.07 entry may have been immediately stopped after work send to slave 
//                              ASSERT(pStackEntry->bIsAlive); 

                                if(pStackEntry->bIsAlive)
                                {
                                }
                                else
                                {
                                  if(false && g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_FORCE_OUTPUT)
                                  {
                                    YBWCManager_Printf(g_pYBWCManagerInstance, "INFO Stack_HasSendWorkToSlave(... full search move distributed but stack entry is no longer alive\n");
                                  }
                                }

                                bMoveListBreak = true;
                                bBreak         = true;
                                bResult        = true;
                                if(bWouldBreak)
                                {
                                  if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
                                  {
                                    YBWCManager_Printf(g_pYBWCManagerInstance, "ERROR Stack_HasSendWorkToSlave(... full search move distributed now, but only because of defensive programming\n");
                                  }
                                } // if(bWouldBreak)
                              } // !if(bSkip) 
                            } // if(    false // kh 17.03.07 for easier editing the next lines...
                            else
                            {
                            } // !if(    false // kh 17.03.07 for easier editing the next lines
                          } // if(    (pStackEntry->parameters.fullSearchPar.height >= g_pYBWCManagerInstance->pFruitConfiguration->nMinimumRemoteSearchHeight)...
                          else
                          {
/*
                            if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_FORCE_OUTPUT)
                            {
                              YBWCManager_Printf(g_pYBWCManagerInstance, "INFO Stack_HasSendWorkToSlave(... height criterion not meet\n");
                            }
*/
                          } // if(    (pStackEntry->parameters.fullSearchPar.height >= g_pYBWCManagerInstance->pFruitConfiguration->nMinimumRemoteSearchHeight)...
                        } // if(nNewDepth >= MINIMUM_REMOTE_SEARCH_DEPTH)
                      } // !// if(    (pStackEntry->SlaveList    [pStackEntry->nMoveListIndex] > 0)...
                    } // !if(bMoveListBreak)

                    nMoveListIndex++;
                  } // while(!bMoveListBreak && !bBreakAfterSortNextOnce && !bBreakAfterRealSkipOnce)

                  if(bSortNextFirst)
                  {
                    // kh 17.10.06 sort_next(... was never called above
                  }
                  else
                  {

// kh 18.10.06 support board access per level (defensive, fruit uses always a pointer to access the board)
                    Stack_ResumeActualBoardStateFromLevel(/* pThis, */ i); //, pStackEntry->parameters.fullSearchPar.board);
                  }
                } // if(    (    (    (nStep == 0) ...
              } // if(pStackEntry->bIsAlive)
              else
              {
                if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_INFO_PRIO_1)
                {
                  YBWCManager_Printf(g_pYBWCManagerInstance, "INFO Stack_HasSendWorkToSlave(... pStackEntry is no longer alive\n");
                }
              } // if(pStackEntry->bIsAlive)
            } // if(pStackEntry->bTryToDistribute)
          } // !if(pStackEntry->bStopped)

          break;

        case CALL_TYPE_FULL_NO_NULL:
/*
          pFullNoNullPar        = &pStackEntry->parameters.fullNoNullPar;
          pFullNoNullDat        = &pStackEntry->localData.fullNoNullDat;
*/

          // kh 11.09.06 no distribution at the moment

          if(g_pYBWCManagerInstance->pFruitConfiguration->bReverseSearchStackDistributionOrder)
          {
          }
          else
          {
            //bBreak = true; // kh 22.12.06 for a test only
          }

          break;

        case CALL_TYPE_FULL_QUIESCENCE:
/*
          pFullQuiescencePar    = &pStackEntry->parameters.fullQuiescencePar;
          pFullQuiescenceDat    = &pStackEntry->localData.fullQuiescenceDat;
*/

          if(g_pYBWCManagerInstance->pFruitConfiguration->bReverseSearchStackDistributionOrder)
          {
          }
          else
          {

// kh 15.12.06 do not break (defensive)
//          bBreak      = true; // kh 09.10.06 break on first appearance of quiescence search level
            bWouldBreak = true; // kh 15.10.06 remember this behavior for error logging
          }
          break;

        default:
          ASSERT(false);
          break;
        }

        if(g_pYBWCManagerInstance->pFruitConfiguration->bReverseSearchStackDistributionOrder)
        {
          i--;
        }
        else
        {
          i++;
        }
      } // while(    (     ((i < g_Stack.nCount) && !g_pYBWCManagerInstance->pFruitConfiguration->bReverseSearchStackDistributionOrder) ...

      nStep++;
    } // while(nStep < 2 && !bBreak)
  } // if(g_Stack.nCount > 0)
  else
  {

    ASSERT(false);

  } // !if(g_Stack.nCount > 0)

  return bResult;
}

int Stack_StopEntry(/* Stack* pThis, */ StackEntry* pStackEntry)
{
  int                       nResult;
  int                       nResultTmp;

  bool                      bBreak;

  int                       nMoveListIndex;

  ProcessorHandler*         pProcessorHandler;
  Request*                  pRequest;

#if DEBUG
  int                       nMemoMoveListTotalCount;
#endif

  bool                      bTmpBreak;
  int                       nTmpIndex;

  int                       nTmpIndex2;
  bool                      bTmpFirst;

  char                      sTmpMoveString[256];

  int                       nDepth;

/*
  ParametersFullRoot*       pFullRootPar;
*/
//LocalDataFullRoot*        pFullRootDat;

/*
  ParametersFullSearch*     pFullSearchPar;
*/
//LocalDataFullSearch*      pFullSearchDat;

#if DEBUG
  nMemoMoveListTotalCount = pStackEntry->nMoveListTotalCount; // kh 15.03.07 for debug purposes only
#endif

  nResult     = MPI_SUCCESS;
  nResultTmp  = MPI_SUCCESS;

  if(pStackEntry->bStopped)
  {
    if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
    {
      YBWCManager_Printf(g_pYBWCManagerInstance, "ERROR Stack_StopEntry(... entry already stopped");
    }
  }

// kh 20.12.06
  pStackEntry->bStopped = true;

  switch(pStackEntry->nCallType)
  {
  case CALL_TYPE_UNDEFINED:
    ASSERT(false);
    break;

  case CALL_TYPE_FULL_ROOT:
  case CALL_TYPE_FULL_SEARCH:
    if(pStackEntry->bHasAnySubWork) // kh 22.10.07 quick check for potential subwork (performance)
    {
      bBreak         = false;
      nMoveListIndex = 0; 

      while((nMoveListIndex < pStackEntry->nMoveListTotalCount) && !bBreak)
      {
        if(    (pStackEntry->SlaveList    [nMoveListIndex] > 0) // kh 11.09.06 a slave is searching for this move
            && !pStackEntry->CompletedList[nMoveListIndex])     // kh 11.09.06 a slave has not completed the search for this move
        {
          ASSERT(pStackEntry->bTryToDistribute);

          pProcessorHandler = g_pYBWCManagerInstance->processorHandlerPool[pStackEntry->SlaveList[nMoveListIndex]];
          pRequest          = ProcessorHandler_CreateRequest(pProcessorHandler);
          nResult           = Request_InitMasterStop(pRequest,
                                                     pStackEntry->WorkIdList[nMoveListIndex]);

          if(nResult == MPI_SUCCESS)
          {
            g_pYBWCManagerInstance->nTotalWorkAbortSendCount++;

            nResult = Request_Send(pRequest); // kh 27.02.07 77777

            if(nResult == MPI_SUCCESS)
            {
            }
            else
            {
              if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
              {
                YBWCManager_Printf(g_pYBWCManagerInstance, "ERROR Stack_StopEntry(... failed at Request_Send(..., errorcode = %d\n", nResult);
              }

// kh 20.09.06 save first error only
              if(nResultTmp == MPI_SUCCESS)
              {
                nResultTmp = nResult;
              }

// kh 20.09.06 defensive (will probably not help any more...)
//            bBreak = TRUE;  
            }
          }
          else
          {
            if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
            {
              YBWCManager_Printf(g_pYBWCManagerInstance, "ERROR Stack_StopEntry(... failed at Request_InitMasterStop(..., errorcode = %d\n", nResult);
            }

// kh 20.09.06 save first error only
            if(nResultTmp == MPI_SUCCESS)
            {
              nResultTmp = nResult;
            }

// kh 20.09.06 defensive (will probably not help any more...)
//          bBreak = TRUE; 
          }
        }

        nMoveListIndex++;
      } // while((nMoveListIndex < pStackEntry->nMoveListTotalCount) && !bBreak)

// kh 18.03.07 for debug purposes, do it synchronous

      if(g_pYBWCManagerInstance->pFruitConfiguration->bUseSynchronizedStackStopEntry)
      {
        bTmpBreak = false;
        bTmpFirst = true;
        if(g_pYBWCManagerInstance->pFruitConfiguration->nDebugWaitForSlaveRate > 0)
        {
          CountdownTimer_Restart(g_pYBWCManagerInstance->pCountdownTimerDebugWaitForSlave);
        }

#if DEBUG
        pStackEntry->nMemoMoveListTotalCount = pStackEntry->nMoveListTotalCount; // kh 18.03.07 for debug purposes only
#endif

        while(!bTmpBreak) 
        {
          nTmpIndex = 0;
          while((nTmpIndex < pStackEntry->nMoveListTotalCount) && !bTmpBreak) 
          {
//          YBWCManager_ServiceMessages(g_pYBWCManagerInstance); // kh 18.03.07 tuning 

            if(    (pStackEntry->SlaveList    [nTmpIndex] > 0) // kh 18.03.07 a slave is searching for this move
                && !pStackEntry->CompletedList[nTmpIndex])     // kh 18.03.07 a slave has not completed the search for this move
            {
              bTmpBreak = true;
            }

            nTmpIndex++;
          } // while((nTmpIndex < pStackEntry->nMoveListTotalCount) && !bTmpBreak)

          if(bTmpBreak)
          {
            bTmpBreak = false;

// kh 17.03.07 waiting for at least one slave result is required
            if(false && g_pYBWCManagerInstance->pFruitConfiguration->nDebugWaitForSlaveRate > 0) // kh 18.03.07 tuning
            {
              if(CountdownTimer_IsRunning(g_pYBWCManagerInstance->pCountdownTimerDebugWaitForSlave))
              {
              } // if(CountdownTimer_IsRunning(g_pYBWCManagerInstance->pCountdownTimerDebugWaitForSlave))
              else
              {
                if(bTmpFirst)
                {
                  g_pYBWCManagerInstance->nDebugWaitId++;
                  bTmpFirst = false;
                } // if(bTmpFirst)

                for(nTmpIndex2 = 0; nTmpIndex2 < pStackEntry->nMoveListTotalCount; nTmpIndex2++) 
                {
                  if(    (pStackEntry->SlaveList    [nTmpIndex2] > 0) // kh 18.03.07 a slave is searching for this move
                      && !pStackEntry->CompletedList[nTmpIndex2])     // kh 18.03.07 a slave has not completed the search for this move
                  {
                    if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_FORCE_OUTPUT)
                    {
                      nDepth = -1;
                      switch(pStackEntry->nCallType)
                      {
                      case CALL_TYPE_UNDEFINED:
                        ASSERT(false);
                        break;

                      case CALL_TYPE_FULL_ROOT:
/*
                        pFullRootPar = &pStackEntry->parameters.fullRootPar;
*/
                        nDepth = pStackEntry->parameters.fullRootPar.depth;
                        break;

                      case CALL_TYPE_FULL_SEARCH:
/*
                        pFullSearchPar = &pStackEntry->parameters.fullSearchPar;
*/
                        nDepth = pStackEntry->parameters.fullSearchPar.depth;
                        break;

                      case CALL_TYPE_FULL_NO_NULL:
                        ASSERT(false);
                        break;

                      case CALL_TYPE_FULL_QUIESCENCE:
                        ASSERT(false);
                        break;

                      default:
                        ASSERT(false);
                        break;
                      }

                      move_to_string(pStackEntry->MoveList[nTmpIndex2], sTmpMoveString, 256);
                      YBWCManager_Printf(g_pYBWCManagerInstance, 
//                                       "sync waiting (wait id "S64_FORMAT") StackIndex %d MoveNumber %d/%d Move %s (%d) WorkId " S64_FORMAT " at root (search depth %d) nodes " S64_FORMAT " localnodes " S64_FORMAT " on slave %d\n", 
                                         "sync waiting for %d (wait id "S64_FORMAT") StackIndex %d Move %d/%d %s (%d) WorkId " S64_FORMAT " at (search depth %d) nodes " S64_FORMAT " local " S64_FORMAT "\n", 
                                         pStackEntry->SlaveList[nTmpIndex2],
                                         g_pYBWCManagerInstance->nDebugWaitId,
                                         g_pYBWCManagerInstance->pStack->nCount - 1,
                                         nTmpIndex2 + 1,
                                         pStackEntry->nMoveListTotalCount,
                                         sTmpMoveString,
                                         pStackEntry->MoveList[nTmpIndex2],
                                         pStackEntry->WorkIdList[nTmpIndex2],
                                         nDepth,
                                         SearchCurrent->node_nb,
                                         SearchCurrent->node_local_nb);
                    } // if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
                  } // if(    (pStackEntry->SlaveList    [nMoveListIndex] > 0)...
                } // for(nTmpIndex2 = 0; nTmpIndex2 < pStackEntry->nMoveListTotalCount; nTmpIndex2++) 

                CountdownTimer_Restart(g_pYBWCManagerInstance->pCountdownTimerDebugWaitForSlave);

              } // !if(CountdownTimer_IsRunning(g_pYBWCManagerInstance->pCountdownTimerDebugWaitForSlave))
            } // if(g_pYBWCManagerInstance->pFruitConfiguration->nDebugWaitForSlaveRate > 0)

            YBWCManager_ServiceMessages(g_pYBWCManagerInstance);

#if DEBUG
            if(pStackEntry->nMemoMoveListTotalCount == pStackEntry->nMoveListTotalCount)
            {
            }
            else
            {
              if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
              {
                YBWCManager_Printf(g_pYBWCManagerInstance, 
                                  "ERROR Stack_StopEntry(... (at synchronous wait) nMoveListTotalCount changed from %d to %d\n",
                                  pStackEntry->nMemoMoveListTotalCount,
                                  pStackEntry->nMoveListTotalCount);
              }
            }
#endif
          } // if(bTmpBreak)
          else
          {
            bTmpBreak = true;
          } // !if(bTmpBreak)
        } // while(!bTmpBreak) 
      } // if(g_pYBWCManagerInstance->pFruitConfiguration->bUseSynchronizedStackStopEntry)
    } // if(pStackEntry->bHasAnySubWork)
    else
    {
      // kh 22.10.07 no actions are required if there is not any potential subwork (performance)
    } // !if(pStackEntry->bHasAnySubWork)

    break;

  case CALL_TYPE_FULL_NO_NULL:
    ASSERT(!pStackEntry->bTryToDistribute); // kh 20.09.06 no distribution at the moment

    break;

  case CALL_TYPE_FULL_QUIESCENCE:
    ASSERT(!pStackEntry->bTryToDistribute); // kh 20.09.06 no distribution at the moment

    break;

  default:
    ASSERT(false);
    break;
  }

#if DEBUG
  if(nMemoMoveListTotalCount == pStackEntry->nMoveListTotalCount)
  {
  }
  else
  {
    if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
    {
      YBWCManager_Printf(g_pYBWCManagerInstance, 
                         "ERROR Stack_StopEntry(... nMoveListTotalCount changed from %d to %d\n",
                         nMemoMoveListTotalCount,
                         pStackEntry->nMoveListTotalCount);
    }
  }
#endif

  nResult = nResultTmp;

  return nResult;
}

int Stack_UpdateSearchWindowForEntry(/*Stack* pThis, */ StackEntry* pStackEntry, int nAlpha, int nBeta)
{
  int                       nResult;
  int                       nResultTmp;

  bool                      bBreak;

  int                       nMoveListIndex;

  ProcessorHandler*         pProcessorHandler;
  Request*                  pRequest;

#if DEBUG
  int                       nMemoMoveListTotalCount;
#endif

  if(pStackEntry->bHasAnySubWork) // kh 22.10.07 quick check for potential subwork (performance)
  {
    g_Stack.nStack_UpdateSearchWindowForEntry++;

    if(g_Stack.nStack_UpdateSearchWindowForEntry > 1)
    {
      if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_WARNING_PRIO_1)
      {
        YBWCManager_Printf(g_pYBWCManagerInstance, 
                           "WARNING Stack_UpdateSearchWindowForEntry(... potential reentrant problem, recursion level = %d\n", 
                           g_Stack.nStack_UpdateSearchWindowForEntry);
      }
    }

#if DEBUG
    nMemoMoveListTotalCount = pStackEntry->nMoveListTotalCount; // kh 15.03.07 for debug purposes only
#endif

    nResult     = MPI_SUCCESS;
    nResultTmp  = MPI_SUCCESS;

    switch(pStackEntry->nCallType)
    {
    case CALL_TYPE_UNDEFINED:
      ASSERT(false);
      break;

    case CALL_TYPE_FULL_ROOT:
    case CALL_TYPE_FULL_SEARCH:
      if(pStackEntry->bStopped)
      {
        if(false && g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_FORCE_OUTPUT)
        {
          YBWCManager_Printf(g_pYBWCManagerInstance, "INFO late slave window update suppressed for already stopped stack entry\n");
        }
      } // if(pStackEntry->bStopped)
      else if(!pStackEntry->bIsAlive)
      {
        if(false && g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_FORCE_OUTPUT)
        {
          YBWCManager_Printf(g_pYBWCManagerInstance, "INFO late slave window update suppressed for stack entry no longer alive\n");
        }
      } // if(!pStackEntry->bIsAlive)
      else
      {
        bBreak         = false;
        nMoveListIndex = 0; 

        while(    (nMoveListIndex < pStackEntry->nMoveListTotalCount) 
              && pStackEntry->bIsAlive
              && !bBreak)
        {
          if(    (pStackEntry->SlaveList    [nMoveListIndex] > 0) // kh 11.09.06 a slave is searching for this move
              && !pStackEntry->CompletedList[nMoveListIndex])     // kh 11.09.06 a slave has not completed the search for this move
          {
            ASSERT(pStackEntry->bTryToDistribute);

            pProcessorHandler = g_pYBWCManagerInstance->processorHandlerPool[pStackEntry->SlaveList[nMoveListIndex]];
            pRequest          = ProcessorHandler_CreateRequest(pProcessorHandler);
            nResult           = Request_InitMasterUpdateSearchWindow(pRequest,
                                                                    pStackEntry->WorkIdList[nMoveListIndex],
                                                                    nAlpha,
                                                                    nBeta);

            if(nResult == MPI_SUCCESS)
            {
              g_pYBWCManagerInstance->nTotalUpdateSearchWindowSendCount++;

              nResult = Request_Send(pRequest); // kh 27.02.07 77777 stack valid?

              if(nResult == MPI_SUCCESS)
              {
              }
              else
              {
                if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
                {
                  YBWCManager_Printf(g_pYBWCManagerInstance, "ERROR Stack_UpdateSearchWindowForEntry(... failed at Request_Send(..., errorcode = %d\n", nResult);
                }

    // kh 20.09.06 save first error only
                if(nResultTmp == MPI_SUCCESS)
                {
                  nResultTmp = nResult;
                }

    // kh 20.09.06 defensive (will probably not help any more...)
    //          bBreak = TRUE;  
              }
            }
            else
            {
              if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
              {
                YBWCManager_Printf(g_pYBWCManagerInstance, "ERROR Stack_UpdateSearchWindowForEntry(... failed at Request_InitMasterUpdateSearchWindow(..., errorcode = %d\n", nResult);
              }

    // kh 20.09.06 save first error only
              if(nResultTmp == MPI_SUCCESS)
              {
                nResultTmp = nResult;
              }

    // kh 20.09.06 defensive (will probably not help any more...)
    //        bBreak = TRUE; 
            }
          }

          nMoveListIndex++;
        } // while((nMoveListIndex < pStackEntry->nMoveListTotalCount) && !bBreak)
      } // !if(pStackEntry->bStopped)

      if(pStackEntry->bIsAlive)
      {
      }
      else
      {
        if(false && g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_FORCE_OUTPUT)
        {
          YBWCManager_Printf(g_pYBWCManagerInstance, "INFO window update suddenly breaked for stack entry no longer alive\n");
        }
      }

      break;

    case CALL_TYPE_FULL_NO_NULL:
      ASSERT(!pStackEntry->bTryToDistribute); // kh 20.09.06 no distribution at the moment

      break;

    case CALL_TYPE_FULL_QUIESCENCE:
      ASSERT(!pStackEntry->bTryToDistribute); // kh 20.09.06 no distribution at the moment

      break;

    default:
      ASSERT(false);
      break;
    }

#if DEBUG
    if(nMemoMoveListTotalCount == pStackEntry->nMoveListTotalCount)
    {
    }
    else
    {
      if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
      {
        YBWCManager_Printf(g_pYBWCManagerInstance, 
                          "ERROR Stack_UpdateSearchWindowForEntry(... nMoveListTotalCount changed from %d to %d\n",
                          nMemoMoveListTotalCount,
                          pStackEntry->nMoveListTotalCount);
      }
    }
#endif

    g_Stack.nStack_UpdateSearchWindowForEntry--;

    nResult = nResultTmp;
  }
  else
  {
    nResult = MPI_SUCCESS;
  }

  return nResult;
}

void Stack_UpdateSearchWindow(/* Stack* pThis, */ StackEntry* pStackEntryPrev, int nIndex)
{
  StackEntry* pStackEntry;

  bool        bBreak;
  int         nTmpBetaLimit;

  int         nTmpUpdateSearchWindowResult;

  StackEntry* pStackEntryAbort;
  int         i;
  bool        bIsAlive;

  if(g_Stack.nCount > 0)
  {
    bIsAlive  = true;
    bBreak    = false;
    while((nIndex < g_Stack.nCount) && !bBreak)
    {
      bBreak = true;
      pStackEntry = &g_Stack.stackEntry[nIndex];

      switch(pStackEntry->nReturnPosition)
      {
      case RETURN_POSITION_UNDEFINED:
        ASSERT(false);
        break;



      case RETURN_POSITION_FUNCTION_END:
        ASSERT(false)
        break;



      case RETURN_POSITION_FULL_ROOT_01:
        if(-pStackEntryPrev->parameters.fullRootPar.beta > pStackEntry->parameters.fullSearchPar.alpha) // kh 21.05.08 defensive, fullRootPar.beta is never modified by a window update
        {
          pStackEntry->parameters.fullSearchPar.alpha     = -pStackEntryPrev->parameters.fullRootPar.beta;
          pStackEntry->localData.fullSearchDat.old_alpha  = pStackEntry->parameters.fullSearchPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.alpha >= pStackEntry->parameters.fullSearchPar.beta) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.beta = pStackEntry->parameters.fullSearchPar.alpha + 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }

        if(-pStackEntryPrev->parameters.fullRootPar.alpha < pStackEntry->parameters.fullSearchPar.beta)
        {
          pStackEntry->parameters.fullSearchPar.beta = -pStackEntryPrev->parameters.fullRootPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.beta <= pStackEntry->parameters.fullSearchPar.alpha) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.alpha = pStackEntry->parameters.fullSearchPar.beta - 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }
        break;

      case RETURN_POSITION_FULL_ROOT_01_1:
        if(-pStackEntryPrev->parameters.fullRootPar.beta > pStackEntry->parameters.fullSearchPar.alpha) // kh 21.05.08 defensive, fullRootPar.beta is never modified by a window update
        {
          pStackEntry->parameters.fullSearchPar.alpha     = -pStackEntryPrev->parameters.fullRootPar.beta;
          pStackEntry->localData.fullSearchDat.old_alpha  = pStackEntry->parameters.fullSearchPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.alpha >= pStackEntry->parameters.fullSearchPar.beta) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.beta = pStackEntry->parameters.fullSearchPar.alpha + 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }

/*
        if(ValueInf < pStackEntry->parameters.fullSearchPar.beta)
        {
          pStackEntry->parameters.fullSearchPar.beta = ValueInf;

          if(pStackEntry->parameters.fullSearchPar.beta <= pStackEntry->parameters.fullSearchPar.alpha) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.alpha = pStackEntry->parameters.fullSearchPar.beta - 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }
*/

        break;

      case RETURN_POSITION_FULL_ROOT_01_2:

/*
        if(-ValueInf > pStackEntry->parameters.fullSearchPar.alpha) // kh 21.05.08 defensive, fullRootPar.beta is never modified by a window update
        {
          pStackEntry->parameters.fullSearchPar.alpha     = -ValueInf;
          pStackEntry->localData.fullSearchDat.old_alpha  = pStackEntry->parameters.fullSearchPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.alpha >= pStackEntry->parameters.fullSearchPar.beta) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.beta = pStackEntry->parameters.fullSearchPar.alpha + 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }
*/

        if(-pStackEntryPrev->parameters.fullRootPar.alpha < pStackEntry->parameters.fullSearchPar.beta)
        {
          pStackEntry->parameters.fullSearchPar.beta = -pStackEntryPrev->parameters.fullRootPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.beta <= pStackEntry->parameters.fullSearchPar.alpha) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.alpha = pStackEntry->parameters.fullSearchPar.beta - 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }
        break;

      case RETURN_POSITION_FULL_ROOT_02:
        if(-pStackEntryPrev->parameters.fullRootPar.alpha - 1 > pStackEntry->parameters.fullSearchPar.alpha) // kh 21.05.08 defensive, fullRootPar.beta is never modified by a window update
        {
          pStackEntry->parameters.fullSearchPar.alpha     = -pStackEntryPrev->parameters.fullRootPar.alpha - 1;
          pStackEntry->localData.fullSearchDat.old_alpha  = pStackEntry->parameters.fullSearchPar.alpha;

          pStackEntry->parameters.fullSearchPar.beta      = -pStackEntryPrev->parameters.fullRootPar.alpha; // kh 22.05.08 beta depends on alpha
          bIsAlive = false; 
          bBreak = false;
        }

        if(-pStackEntryPrev->parameters.fullRootPar.alpha < pStackEntry->parameters.fullSearchPar.beta)
        {
          pStackEntry->parameters.fullSearchPar.beta  = -pStackEntryPrev->parameters.fullRootPar.alpha;

          pStackEntry->parameters.fullSearchPar.alpha = -pStackEntryPrev->parameters.fullRootPar.alpha - 1; // kh 22.05.08 alpha depends on beta
          bIsAlive = false; 
          bBreak = false;
        }
        break;

      case RETURN_POSITION_FULL_ROOT_03:
        if(g_pYBWCManagerInstance->bSearchingSubproblem && (g_pYBWCManagerInstance->pWorkAvailableResult->nCallType == CALL_TYPE_FULL_SEARCH))
        {

// kh 21.05.08 standard full_search(... fruit/toga behavior for non root (implicates master) subproblems
          nTmpBetaLimit = -pStackEntryPrev->parameters.fullRootPar.beta;

        } // if(g_pYBWCManagerInstance->bSearchingSubproblem && (g_pYBWCManagerInstance->pWorkAvailableResult->nCallType == CALL_TYPE_FULL_SEARCH))
        else
        {

          nTmpBetaLimit = -pStackEntryPrev->parameters.fullRootPar.beta - 50; // kh 21.05.08 for a standard toga root move 
        } // !if(g_pYBWCManagerInstance->bSearchingSubproblem && (g_pYBWCManagerInstance->pWorkAvailableResult->nCallType == CALL_TYPE_FULL_SEARCH))

        if(nTmpBetaLimit > pStackEntry->parameters.fullSearchPar.alpha) // kh 21.05.08 defensive, fullRootPar.beta is never modified by a window update
        {
          pStackEntry->parameters.fullSearchPar.alpha     = nTmpBetaLimit;
          pStackEntry->localData.fullSearchDat.old_alpha  = pStackEntry->parameters.fullSearchPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.alpha >= pStackEntry->parameters.fullSearchPar.beta) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.beta = pStackEntry->parameters.fullSearchPar.alpha + 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }

        if(-pStackEntryPrev->parameters.fullRootPar.alpha < pStackEntry->parameters.fullSearchPar.beta)
        {
          pStackEntry->parameters.fullSearchPar.beta = -pStackEntryPrev->parameters.fullRootPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.beta <= pStackEntry->parameters.fullSearchPar.alpha) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.alpha = pStackEntry->parameters.fullSearchPar.beta - 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }
        break;

      case RETURN_POSITION_FULL_ROOT_03_1:

/*
        if(-ValueInf > pStackEntry->parameters.fullSearchPar.alpha) // kh 21.05.08 defensive, fullRootPar.beta is never modified by a window update
        {
          pStackEntry->parameters.fullSearchPar.alpha     = -ValueInf;
          pStackEntry->localData.fullSearchDat.old_alpha  = pStackEntry->parameters.fullSearchPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.alpha >= pStackEntry->parameters.fullSearchPar.beta) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.beta = pStackEntry->parameters.fullSearchPar.alpha + 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }
*/

        if(-pStackEntryPrev->parameters.fullRootPar.alpha < pStackEntry->parameters.fullSearchPar.beta)
        {
          pStackEntry->parameters.fullSearchPar.beta = -pStackEntryPrev->parameters.fullRootPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.beta <= pStackEntry->parameters.fullSearchPar.alpha) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.alpha = pStackEntry->parameters.fullSearchPar.beta - 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }
        break;

      case RETURN_POSITION_FULL_ROOT_04:
        if(-pStackEntryPrev->parameters.fullRootPar.beta > pStackEntry->parameters.fullSearchPar.alpha) // kh 21.05.08 defensive, fullRootPar.beta is never modified by a window update
        {
          pStackEntry->parameters.fullSearchPar.alpha     = -pStackEntryPrev->parameters.fullRootPar.beta;
          pStackEntry->localData.fullSearchDat.old_alpha  = pStackEntry->parameters.fullSearchPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.alpha >= pStackEntry->parameters.fullSearchPar.beta) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.beta = pStackEntry->parameters.fullSearchPar.alpha + 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }

        if(-pStackEntryPrev->parameters.fullRootPar.alpha < pStackEntry->parameters.fullSearchPar.beta)
        {
          pStackEntry->parameters.fullSearchPar.beta = -pStackEntryPrev->parameters.fullRootPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.beta <= pStackEntry->parameters.fullSearchPar.alpha) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.alpha = pStackEntry->parameters.fullSearchPar.beta - 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }
        break;



      case RETURN_POSITION_FULL_SEARCH_01:
        if(pStackEntryPrev->parameters.fullSearchPar.alpha > pStackEntry->parameters.fullQuiescencePar.alpha)
        {
          pStackEntry->parameters.fullQuiescencePar.alpha     = pStackEntryPrev->parameters.fullSearchPar.alpha;
          pStackEntry->localData.fullQuiescenceDat.old_alpha  = pStackEntry->parameters.fullQuiescencePar.alpha;

          if(pStackEntry->parameters.fullQuiescencePar.alpha >= pStackEntry->parameters.fullQuiescencePar.beta) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullQuiescencePar.beta = pStackEntry->parameters.fullQuiescencePar.alpha + 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }

        if(pStackEntryPrev->parameters.fullSearchPar.beta < pStackEntry->parameters.fullQuiescencePar.beta)
        {
          pStackEntry->parameters.fullQuiescencePar.beta = pStackEntryPrev->parameters.fullSearchPar.beta;

          if(pStackEntry->parameters.fullQuiescencePar.beta <= pStackEntry->parameters.fullQuiescencePar.alpha) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullQuiescencePar.alpha = pStackEntry->parameters.fullQuiescencePar.beta - 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }
        break;

      case RETURN_POSITION_FULL_SEARCH_02:
        if(-pStackEntryPrev->parameters.fullSearchPar.beta > pStackEntry->parameters.fullSearchPar.alpha)
        {
          pStackEntry->parameters.fullSearchPar.alpha     = -pStackEntryPrev->parameters.fullSearchPar.beta;
          pStackEntry->localData.fullSearchDat.old_alpha  = pStackEntry->parameters.fullSearchPar.alpha;

          pStackEntry->parameters.fullSearchPar.beta      = -pStackEntryPrev->parameters.fullSearchPar.beta + 1; // kh 22.05.08 beta depends on alpha
          bIsAlive = false; 
          bBreak = false;
        }

        if(-pStackEntryPrev->parameters.fullSearchPar.beta + 1 < pStackEntry->parameters.fullSearchPar.beta)
        {
          pStackEntry->parameters.fullSearchPar.beta  = -pStackEntryPrev->parameters.fullSearchPar.beta + 1;

          pStackEntry->parameters.fullSearchPar.alpha = -pStackEntryPrev->parameters.fullSearchPar.beta; // kh 22.05.08 alpha depends on beta
          bIsAlive = false; 
          bBreak = false;
        }
        break;

      case RETURN_POSITION_FULL_SEARCH_03:
        if(pStackEntryPrev->parameters.fullSearchPar.alpha > pStackEntry->parameters.fullNoNullPar.alpha)
        {
          pStackEntry->parameters.fullNoNullPar.alpha     = pStackEntryPrev->parameters.fullSearchPar.alpha;

          if(pStackEntry->parameters.fullNoNullPar.alpha >= pStackEntry->parameters.fullNoNullPar.beta) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullNoNullPar.beta = pStackEntry->parameters.fullNoNullPar.alpha + 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }

        if(pStackEntryPrev->parameters.fullSearchPar.beta < pStackEntry->parameters.fullNoNullPar.beta)
        {
          pStackEntry->parameters.fullNoNullPar.beta = pStackEntryPrev->parameters.fullSearchPar.beta;

          if(pStackEntry->parameters.fullNoNullPar.beta <= pStackEntry->parameters.fullNoNullPar.alpha) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullNoNullPar.alpha = pStackEntry->parameters.fullNoNullPar.beta - 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }
        break;

      case RETURN_POSITION_FULL_SEARCH_03_1:
        if(pStackEntryPrev->parameters.fullSearchPar.alpha > pStackEntry->parameters.fullQuiescencePar.alpha)
        {
          pStackEntry->parameters.fullQuiescencePar.alpha     = pStackEntryPrev->parameters.fullSearchPar.alpha;
          pStackEntry->localData.fullQuiescenceDat.old_alpha  = pStackEntry->parameters.fullQuiescencePar.alpha;

          if(pStackEntry->parameters.fullQuiescencePar.alpha >= pStackEntry->parameters.fullQuiescencePar.beta) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullQuiescencePar.beta = pStackEntry->parameters.fullQuiescencePar.alpha + 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }

        if(pStackEntryPrev->parameters.fullSearchPar.beta < pStackEntry->parameters.fullQuiescencePar.beta)
        {
          pStackEntry->parameters.fullQuiescencePar.beta = pStackEntryPrev->parameters.fullSearchPar.beta;

          if(pStackEntry->parameters.fullQuiescencePar.beta <= pStackEntry->parameters.fullQuiescencePar.alpha) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullQuiescencePar.alpha = pStackEntry->parameters.fullQuiescencePar.beta - 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }
        break;

      case RETURN_POSITION_FULL_SEARCH_04:
        if(pStackEntryPrev->parameters.fullSearchPar.alpha > pStackEntry->parameters.fullSearchPar.alpha)
        {
          pStackEntry->parameters.fullSearchPar.alpha     = pStackEntryPrev->parameters.fullSearchPar.alpha;
          pStackEntry->localData.fullSearchDat.old_alpha  = pStackEntry->parameters.fullQuiescencePar.alpha;

          if(pStackEntry->parameters.fullSearchPar.alpha >= pStackEntry->parameters.fullSearchPar.beta) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.beta = pStackEntry->parameters.fullSearchPar.alpha + 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }

        if(pStackEntryPrev->parameters.fullSearchPar.beta < pStackEntry->parameters.fullSearchPar.beta)
        {
          pStackEntry->parameters.fullSearchPar.beta = pStackEntryPrev->parameters.fullSearchPar.beta;

          if(pStackEntry->parameters.fullSearchPar.beta <= pStackEntry->parameters.fullSearchPar.alpha) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.alpha = pStackEntry->parameters.fullSearchPar.beta - 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }
        break;

      case RETURN_POSITION_FULL_SEARCH_05:

/*
        if(-ValueInf > pStackEntry->parameters.fullSearchPar.alpha)
        {
          pStackEntry->parameters.fullSearchPar.alpha     = -ValueInf;
          pStackEntry->localData.fullSearchDat.old_alpha  = pStackEntry->parameters.fullSearchPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.alpha >= pStackEntry->parameters.fullSearchPar.beta) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.beta = pStackEntry->parameters.fullSearchPar.alpha + 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }
*/

        if(pStackEntryPrev->parameters.fullSearchPar.beta < pStackEntry->parameters.fullSearchPar.beta)
        {
          pStackEntry->parameters.fullSearchPar.beta = pStackEntryPrev->parameters.fullSearchPar.beta;

          if(pStackEntry->parameters.fullSearchPar.beta <= pStackEntry->parameters.fullSearchPar.alpha) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.alpha = pStackEntry->parameters.fullSearchPar.beta - 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }
        break;

      case RETURN_POSITION_FULL_SEARCH_06:
        if(-pStackEntryPrev->parameters.fullSearchPar.beta > pStackEntry->parameters.fullSearchPar.alpha)
        {
          pStackEntry->parameters.fullSearchPar.alpha     = -pStackEntryPrev->parameters.fullSearchPar.beta;
          pStackEntry->localData.fullSearchDat.old_alpha  = pStackEntry->parameters.fullSearchPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.alpha >= pStackEntry->parameters.fullSearchPar.beta) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.beta = pStackEntry->parameters.fullSearchPar.alpha + 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }

        if(-pStackEntryPrev->parameters.fullSearchPar.alpha < pStackEntry->parameters.fullSearchPar.beta)
        {
          pStackEntry->parameters.fullSearchPar.beta = -pStackEntryPrev->parameters.fullSearchPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.beta <= pStackEntry->parameters.fullSearchPar.alpha) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.alpha = pStackEntry->parameters.fullSearchPar.beta - 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }
        break;

      case RETURN_POSITION_FULL_SEARCH_07:
        if(-pStackEntryPrev->parameters.fullSearchPar.alpha - 1 > pStackEntry->parameters.fullSearchPar.alpha) 
        {
          pStackEntry->parameters.fullSearchPar.alpha     = -pStackEntryPrev->parameters.fullSearchPar.alpha - 1;
          pStackEntry->localData.fullSearchDat.old_alpha  = pStackEntry->parameters.fullSearchPar.alpha;

          pStackEntry->parameters.fullSearchPar.beta      = -pStackEntryPrev->parameters.fullSearchPar.alpha; // kh 22.05.08 beta depends on alpha

          bIsAlive = false; 
          bBreak = false;
        }

        if(-pStackEntryPrev->parameters.fullSearchPar.alpha < pStackEntry->parameters.fullSearchPar.beta)
        {
          pStackEntry->parameters.fullSearchPar.beta  = -pStackEntryPrev->parameters.fullSearchPar.alpha;

          pStackEntry->parameters.fullSearchPar.alpha = -pStackEntryPrev->parameters.fullSearchPar.alpha - 1; // kh 22.05.08 alpha depends on beta

          bIsAlive = false; 
          bBreak = false;
        }
        break;

      case RETURN_POSITION_FULL_SEARCH_08:
        if(-pStackEntryPrev->parameters.fullSearchPar.beta > pStackEntry->parameters.fullSearchPar.alpha)
        {
          pStackEntry->parameters.fullSearchPar.alpha     = -pStackEntryPrev->parameters.fullSearchPar.beta;
          pStackEntry->localData.fullSearchDat.old_alpha  = pStackEntry->parameters.fullSearchPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.alpha >= pStackEntry->parameters.fullSearchPar.beta) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.beta = pStackEntry->parameters.fullSearchPar.alpha + 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }

        if(-pStackEntryPrev->parameters.fullSearchPar.alpha < pStackEntry->parameters.fullSearchPar.beta)
        {
          pStackEntry->parameters.fullSearchPar.beta = -pStackEntryPrev->parameters.fullSearchPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.beta <= pStackEntry->parameters.fullSearchPar.alpha) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.alpha = pStackEntry->parameters.fullSearchPar.beta - 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }
        break;

      case RETURN_POSITION_FULL_SEARCH_09:
        if(-pStackEntryPrev->parameters.fullSearchPar.beta > pStackEntry->parameters.fullSearchPar.alpha)
        {
          pStackEntry->parameters.fullSearchPar.alpha     = -pStackEntryPrev->parameters.fullSearchPar.beta;
          pStackEntry->localData.fullSearchDat.old_alpha  = pStackEntry->parameters.fullSearchPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.alpha >= pStackEntry->parameters.fullSearchPar.beta) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.beta = pStackEntry->parameters.fullSearchPar.alpha + 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }

        if(-pStackEntryPrev->parameters.fullSearchPar.alpha < pStackEntry->parameters.fullSearchPar.beta)
        {
          pStackEntry->parameters.fullSearchPar.beta = -pStackEntryPrev->parameters.fullSearchPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.beta <= pStackEntry->parameters.fullSearchPar.alpha) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.alpha = pStackEntry->parameters.fullSearchPar.beta - 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }
        break;



      case RETURN_POSITION_FULL_NO_NULL_01:
        if(-pStackEntryPrev->parameters.fullNoNullPar.beta > pStackEntry->parameters.fullSearchPar.alpha)
        {
          pStackEntry->parameters.fullSearchPar.alpha     = -pStackEntryPrev->parameters.fullNoNullPar.beta;
          pStackEntry->localData.fullSearchDat.old_alpha  = pStackEntry->parameters.fullSearchPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.alpha >= pStackEntry->parameters.fullSearchPar.beta) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.beta = pStackEntry->parameters.fullSearchPar.alpha + 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }

        if(-pStackEntryPrev->parameters.fullNoNullPar.alpha < pStackEntry->parameters.fullSearchPar.beta)
        {
          pStackEntry->parameters.fullSearchPar.beta = -pStackEntryPrev->parameters.fullNoNullPar.alpha;

          if(pStackEntry->parameters.fullSearchPar.beta <= pStackEntry->parameters.fullSearchPar.alpha) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullSearchPar.alpha = pStackEntry->parameters.fullSearchPar.beta - 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }
        break;



      case RETURN_POSITION_FULL_QUIESCENCE_01:
        if(-pStackEntryPrev->parameters.fullQuiescencePar.beta > pStackEntry->parameters.fullQuiescencePar.alpha)
        {
          pStackEntry->parameters.fullQuiescencePar.alpha     = -pStackEntryPrev->parameters.fullQuiescencePar.beta;
          pStackEntry->localData.fullQuiescenceDat.old_alpha  = pStackEntry->parameters.fullQuiescencePar.alpha;

          if(pStackEntry->parameters.fullQuiescencePar.alpha >= pStackEntry->parameters.fullQuiescencePar.beta) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullQuiescencePar.beta = pStackEntry->parameters.fullQuiescencePar.alpha + 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }

        if(-pStackEntryPrev->parameters.fullQuiescencePar.alpha < pStackEntry->parameters.fullQuiescencePar.beta)
        {
          pStackEntry->parameters.fullQuiescencePar.beta = -pStackEntryPrev->parameters.fullQuiescencePar.alpha;

          if(pStackEntry->parameters.fullQuiescencePar.beta <= pStackEntry->parameters.fullQuiescencePar.alpha) // kh 22.05.08 potentially adjust "null window" 
          {
            pStackEntry->parameters.fullQuiescencePar.alpha = pStackEntry->parameters.fullQuiescencePar.beta - 1;
            bIsAlive = false; 
          }

          bBreak = false;
        }
        break;



      default:
        ASSERT(false);
        break;
      } // switch(pStackEntry->nReturnPosition)


      if(bIsAlive)
      {
        if(bBreak)
        {
        } // if(bBreak)
        else
        {
          switch(pStackEntry->nCallType)
          {
          case CALL_TYPE_UNDEFINED:
            ASSERT(false);
            break;

          case CALL_TYPE_FULL_ROOT:
            nTmpUpdateSearchWindowResult = Stack_UpdateSearchWindowForEntry(/* g_pYBWCManagerInstance->pStack, */
                                                                            pStackEntry,
                                                                            pStackEntry->parameters.fullRootPar.alpha,
                                                                            pStackEntry->parameters.fullRootPar.beta);
            if(nTmpUpdateSearchWindowResult == MPI_SUCCESS)
            {
            }
            else
            {
              if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
              {
                YBWCManager_Printf(g_pYBWCManagerInstance, "ERROR fruit_actions_for_update_search_window_received(... (1) failed at Stack_UpdateSearchWindowForEntry(..., errorcode = %d\n", nTmpUpdateSearchWindowResult);
              }
            }
            break;

          case CALL_TYPE_FULL_SEARCH:
            nTmpUpdateSearchWindowResult = Stack_UpdateSearchWindowForEntry(/* g_pYBWCManagerInstance->pStack, */
                                                                            pStackEntry,
                                                                            pStackEntry->parameters.fullSearchPar.alpha,
                                                                            pStackEntry->parameters.fullSearchPar.beta);
            if(nTmpUpdateSearchWindowResult == MPI_SUCCESS)
            {
            }
            else
            {
              if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
              {
                YBWCManager_Printf(g_pYBWCManagerInstance, "ERROR fruit_actions_for_update_search_window_received(... (2) failed at Stack_UpdateSearchWindowForEntry(..., errorcode = %d\n", nTmpUpdateSearchWindowResult);
              }
            }
            break;

          case CALL_TYPE_FULL_NO_NULL:
            break;

          case CALL_TYPE_FULL_QUIESCENCE:
            break;

          default:
            ASSERT(false);
            break;
          }
        } // !if(bBreak)
      } // if(bIsAlive)
      else
      {
        bBreak = true;
        for(i = nIndex; i < g_Stack.nCount; i++)
        {
          pStackEntryAbort = Stack_PeekAt(/* pThis->pStack, */ i);
          pStackEntryAbort->bIsAlive = false;
        }

      } // !if(bIsAlive)

      pStackEntryPrev = pStackEntry;
      nIndex++;
    } // while((nIndex < g_Stack.nCount) && !bBreak)
  } // if(g_Stack.nCount > 0)
}

int Stack_Stop(/* Stack* pThis */)
{
  int                       nResult;
  int                       nResultTmp;

  int                       i;
  bool                      bBreak;

  StackEntry*               pStackEntry;

  nResult     = MPI_SUCCESS;
  nResultTmp  = MPI_SUCCESS;

  pStackEntry = NULL;

  ASSERT(!g_pYBWCManagerInstance->bStackStopActive);

  g_pYBWCManagerInstance->bStackStopActive = TRUE;

  if(g_Stack.nCount > 0)
  {
    i      = 0;
    bBreak = false;
    while((i < g_Stack.nCount) && !bBreak)
    {
      pStackEntry = &g_Stack.stackEntry[i];

      nResult = Stack_StopEntry(/* pThis, */ pStackEntry);
      if(nResult == MPI_SUCCESS)
      {
      }
      else
      {
        if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
        {
          YBWCManager_Printf(g_pYBWCManagerInstance, "ERROR Stack_StopEntry(... failed at Stack_StopEntry(..., errorcode = %d\n", nResult);
        }

// kh 20.09.06 save first error only
        if(nResultTmp == MPI_SUCCESS)
        {
          nResultTmp = nResult;
        }
      }

      i++;
    } // while((i < g_Stack.nCount) && !bBreak)
  } // if(g_Stack.nCount > 0)
  else
  {
    ASSERT(false);
  } // !if(g_Stack.nCount > 0)

  g_pYBWCManagerInstance->bStackStopActive = FALSE;

  nResult = nResultTmp;

  return nResult;
}

int Stack_CallPositionToIndex(/* Stack* pThis, */ int nCallPosition)
{
  int nResult;

  nResult = g_Stack.CallPositionToIndexMap[nCallPosition];

  return nResult;
}

int Stack_CallIndexToPosition(/* Stack* pThis, */ int nCallIndex)
{
  int nResult;

  nResult = g_Stack.CallIndexToPositionMap[nCallIndex];

  return nResult;
}

void Stack_DumpAwaitedSlaveResultsForEntry(/* Stack* pThis, */ StackEntry* pStackEntry, int nIndex)
{
  bool                      bBreak;

  int                       nMoveListIndex;

#if DEBUG
  char                      sTmpMoveString[256];
#endif

/*
  ProcessorHandler*         pProcessorHandler;
  Request*                  pRequest;

  int                       nMemoMoveListTotalCount;
*/

/*
  ParametersFullRoot*       pFullRootPar;
*/
//LocalDataFullRoot*        pFullRootDat;

/*
  ParametersFullSearch*     pFullSearchPar;
*/
//LocalDataFullSearch*      pFullSearchDat;

/*
  YBWCManager_Printf(g_pYBWCManagerInstance, "Stack:\n");
  YBWCManager_Printf(g_pYBWCManagerInstance, "nCount = %d\n", g_Stack.nCount);
  YBWCManager_Printf(g_pYBWCManagerInstance, "\n");
*/

/*
  if(pStackEntry->bStopped)
  {
    if(g_pYBWCManagerInstance->pFruitConfiguration->nFruitDebugLevel >= FRUIT_DEBUG_LEVEL_ERROR_PRIO_1)
    {
      YBWCManager_Printf(g_pYBWCManagerInstance, "INFO Stack_DumpAwaitedSlaveResults(... entry already stopped");
    }
  }
*/

  switch(pStackEntry->nCallType)
  {
  case CALL_TYPE_UNDEFINED:
    ASSERT(false);
    break;

  case CALL_TYPE_FULL_ROOT:
  case CALL_TYPE_FULL_SEARCH:
    bBreak         = false;
    nMoveListIndex = 0; 

    while((nMoveListIndex < pStackEntry->nMoveListTotalCount) && !bBreak)
    {
      if(    (pStackEntry->SlaveList    [nMoveListIndex] > 0) // kh 11.09.06 a slave is searching for this move
          && !pStackEntry->CompletedList[nMoveListIndex])     // kh 11.09.06 a slave has not completed the search for this move
      {
        ASSERT(pStackEntry->bTryToDistribute);

/*
        pProcessorHandler = g_pYBWCManagerInstance->processorHandlerPool[pStackEntry->SlaveList[nMoveListIndex]];
        pRequest          = ProcessorHandler_CreateRequest(pProcessorHandler);
        nResult           = Request_InitMasterStop(pRequest,
                                                   pStackEntry->WorkIdList[nMoveListIndex]);
*/
        switch(pStackEntry->nCallType)
        {
        case CALL_TYPE_UNDEFINED:
          break;

        case CALL_TYPE_FULL_ROOT:
/*
          pFullRootPar          = &pStackEntry->parameters.fullRootPar;
*/

#if DEBUG
          move_to_string(pStackEntry->MoveList[nMoveListIndex], sTmpMoveString, 256);
          YBWCManager_Printf(g_pYBWCManagerInstance, 
                             "awaiting upcoming result from slave %d StackIndex %d Move %d/%d %s (%d) WorkId " S64_FORMAT " at root (search depth %d) initial a=%d b=%d, last a=%d b=%d, work a=%d b=%d nodes " S64_FORMAT " local " S64_FORMAT "\n", 
                             pStackEntry->SlaveList[nMoveListIndex],
                             nIndex,
                             nMoveListIndex + 1,
                             pStackEntry->nMoveListTotalCount,
                             sTmpMoveString,
                             pStackEntry->MoveList[nMoveListIndex],
                             pStackEntry->WorkIdList[nMoveListIndex],
                             pStackEntry->parameters.fullRootPar.depth,
                             pStackEntry->nAlphaParameterOnEntry,
                             pStackEntry->nBetaParameterOnEntry,
                             pStackEntry->parameters.fullRootPar.alpha,
                             pStackEntry->parameters.fullRootPar.beta,
                             pStackEntry->AlphaList[nMoveListIndex],
                             pStackEntry->BetaList[nMoveListIndex],
                             SearchCurrent->node_nb,
                             SearchCurrent->node_local_nb);
#endif
          break;

        case CALL_TYPE_FULL_SEARCH:
/*
          pFullSearchPar        = &pStackEntry->parameters.fullSearchPar;
*/

#if DEBUG
          move_to_string(pStackEntry->MoveList[nMoveListIndex], sTmpMoveString, 256);
          YBWCManager_Printf(g_pYBWCManagerInstance, 
                             "awaiting upcoming result from slave %d StackIndex %d Move %d/%d %s (%d) WorkId " S64_FORMAT " at full search height/depth %d+%d/%d initial a=%d b=%d, last a=%d b=%d, work a=%d b=%d nodes " S64_FORMAT " local " S64_FORMAT "\n", 
                             pStackEntry->SlaveList[nMoveListIndex],
                             nIndex,
                             nMoveListIndex + 1,
                             pStackEntry->nMoveListTotalCount,
                             sTmpMoveString,
                             pStackEntry->MoveList[nMoveListIndex],
                             pStackEntry->WorkIdList[nMoveListIndex],
                             SearchInfo->nHeightOffset, // kh 21.03.07 nTmpHeightOffset,
                             pStackEntry->parameters.fullSearchPar.height,
                             pStackEntry->parameters.fullSearchPar.depth,
                             pStackEntry->nAlphaParameterOnEntry,
                             pStackEntry->nBetaParameterOnEntry,
                             pStackEntry->parameters.fullSearchPar.alpha,
                             pStackEntry->parameters.fullSearchPar.beta,
                             pStackEntry->AlphaList[nMoveListIndex],
                             pStackEntry->BetaList[nMoveListIndex],
                             SearchCurrent->node_nb,
                             SearchCurrent->node_local_nb);
#endif
          break;

        case CALL_TYPE_FULL_NO_NULL:
          break;

        case CALL_TYPE_FULL_QUIESCENCE:
          break;

        default:
          break;
        }
      }

      nMoveListIndex++;
    } // while((nMoveListIndex < pStackEntry->nMoveListTotalCount) && !bBreak)
    break;

  case CALL_TYPE_FULL_NO_NULL:
    ASSERT(!pStackEntry->bTryToDistribute); // kh 20.09.06 no distribution at the moment

    break;

  case CALL_TYPE_FULL_QUIESCENCE:
    ASSERT(!pStackEntry->bTryToDistribute); // kh 20.09.06 no distribution at the moment

    break;

  default:
    ASSERT(false);
    break;
  }
}

void Stack_DumpAwaitedSlaveResults(/* Stack* pThis */)
{
  int                       nResult;
  int                       nResultTmp;

  int                       i;
  bool                      bBreak;

  StackEntry*               pStackEntry;

/*
  YBWCManager_Printf(g_pYBWCManagerInstance, "Stack:\n");
  YBWCManager_Printf(g_pYBWCManagerInstance, "nCount = %d\n", g_Stack.nCount);
  YBWCManager_Printf(g_pYBWCManagerInstance, "\n");
*/

  nResult     = MPI_SUCCESS;
  nResultTmp  = MPI_SUCCESS;

  pStackEntry = NULL;

/*
  ASSERT(!g_pYBWCManagerInstance->bStackStopActive);

  g_pYBWCManagerInstance->bStackStopActive = TRUE;
*/

  if(g_Stack.nCount > 0)
  {
    i      = 0;
    bBreak = false;
    while((i < g_Stack.nCount) && !bBreak)
    {
      pStackEntry = &g_Stack.stackEntry[i];

      Stack_DumpAwaitedSlaveResultsForEntry(/* pThis, */ pStackEntry, i);

      i++;
    } // while((i < g_Stack.nCount) && !bBreak)
  } // if(g_Stack.nCount > 0)
  else
  {
//  ASSERT(false);
  } // !if(g_Stack.nCount > 0)
}

void Stack_Dump(/* Stack* pThis */)
{
  int                       i;
  int                       j;
  char                      sPrefix[16384];

  StackEntry*               pStackEntry;

  ParametersFullRoot*       pFullRootPar;
  LocalDataFullRoot*        pFullRootDat;

  ParametersFullSearch*     pFullSearchPar;
  LocalDataFullSearch*      pFullSearchDat;

  ParametersFullNoNull*     pFullNoNullPar;
  LocalDataFullNoNull*      pFullNoNullDat;

  ParametersFullQuiescence* pFullQuiescencePar;
  LocalDataFullQuiescence*  pFullQuiescenceDat;

  YBWCManager_Printf(g_pYBWCManagerInstance, "Stack:\n");
  YBWCManager_Printf(g_pYBWCManagerInstance, "nCount = %d\n", g_Stack.nCount);
  YBWCManager_Printf(g_pYBWCManagerInstance, "\n");

  pStackEntry = NULL;

  if(g_Stack.nCount > 0)
  {
    for(i = 0; i < g_Stack.nCount; i++)
    {
      pStackEntry = &g_Stack.stackEntry[i];

      sPrefix[0] = '\0';
      for(j = 0; j < i; j++)
      {
        strcat(sPrefix, "  ");
      }

      YBWCManager_Printf(g_pYBWCManagerInstance, "%sstack entry %d:\n",               sPrefix, i);
      YBWCManager_Printf(g_pYBWCManagerInstance, "%s  nCallType       = %s\n", sPrefix, StackEntry_CallTypeToString(pStackEntry));
      YBWCManager_Printf(g_pYBWCManagerInstance, "%s  nReturnPosition = %s\n", sPrefix, StackEntry_ReturnPositionToString(pStackEntry));

      if(    (pStackEntry->nResult == STACK_ENTRY_RESULT_UNDEFINED)
          || (pStackEntry->nResult == STACK_ENTRY_RESULT_UNDEFINED_FULL_ROOT)
          || (pStackEntry->nResult == STACK_ENTRY_RESULT_UNDEFINED_FULL_SEARCH)
          || (pStackEntry->nResult == STACK_ENTRY_RESULT_UNDEFINED_FULL_NO_NULL)
          || (pStackEntry->nResult == STACK_ENTRY_RESULT_UNDEFINED_FULL_QUIESCENCE))
      {
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s  nResult         = %s\n", sPrefix, StackEntry_ResultToString(pStackEntry));
      }
      else
      {
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s  nResult         = %d\n", sPrefix, pStackEntry->nResult);
      }

      switch(pStackEntry->nCallType)
      {
      case CALL_TYPE_UNDEFINED:
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s  <undefined parameters>\n", sPrefix);
        break;

      case CALL_TYPE_FULL_ROOT:
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s  actual FULL_ROOT parameters:\n", sPrefix);
        pFullRootPar          = &pStackEntry->parameters.fullRootPar;

        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    list:\n", sPrefix);
        for(j = 0; j < pFullRootPar->list->size; j++)
        {
          YBWCManager_Printf(g_pYBWCManagerInstance, "%s      index %3d, move = %5d, value = %6d \n", sPrefix, j, pFullRootPar->list->move[j], pFullRootPar->list->value[j]);
        }
        YBWCManager_Printf(g_pYBWCManagerInstance, " \n");

        // kh 07.08.06 future expansion: board;
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    alpha       = %d\n", sPrefix, pFullRootPar->alpha);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    beta        = %d\n", sPrefix, pFullRootPar->beta);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    depth       = %d\n", sPrefix, pFullRootPar->depth);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    height      = %d\n", sPrefix, pFullRootPar->height);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    search_type = %d\n", sPrefix, pFullRootPar->search_type);
        break;

      case CALL_TYPE_FULL_SEARCH:
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s  actual FULL_SEARCH parameters:\n", sPrefix);
        pFullSearchPar        = &pStackEntry->parameters.fullSearchPar;

        // kh 07.08.06 future expansion: board;
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    alpha       = %d\n", sPrefix, pFullSearchPar->alpha);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    beta        = %d\n", sPrefix, pFullSearchPar->beta);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    depth       = %d\n", sPrefix, pFullSearchPar->depth);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    height      = %d\n", sPrefix, pFullSearchPar->height);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    *ppv        = %d\n", sPrefix, *pFullSearchPar->ppv);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    node_type   = %d\n", sPrefix, pFullSearchPar->node_type);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    extended    = %d\n", sPrefix, pFullSearchPar->extended);
        break;

      case CALL_TYPE_FULL_NO_NULL:
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s  actual FULL_NO_NULL parameters:\n", sPrefix);
        pFullNoNullPar        = &pStackEntry->parameters.fullNoNullPar;

        // kh 07.08.06 future expansion: board;
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    alpha       = %d\n", sPrefix, pFullNoNullPar->alpha);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    beta        = %d\n", sPrefix, pFullNoNullPar->beta);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    depth       = %d\n", sPrefix, pFullNoNullPar->depth);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    height      = %d\n", sPrefix, pFullNoNullPar->height);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    *ppv        = %d\n", sPrefix, *pFullNoNullPar->ppv);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    node_type   = %d\n", sPrefix, pFullNoNullPar->node_type);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    trans_move  = %d\n", sPrefix, pFullNoNullPar->trans_move);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    *pbest_move = %d\n", sPrefix, *pFullNoNullPar->pbest_move);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    extended    = %d\n", sPrefix, pFullNoNullPar->extended);
        break;

      case CALL_TYPE_FULL_QUIESCENCE:
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s  actual FULL_QUIESCENCE parameters:\n", sPrefix);
        pFullQuiescencePar    = &pStackEntry->parameters.fullQuiescencePar;

        // kh 07.08.06 future expansion: board;
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    alpha       = %d\n", sPrefix, pFullQuiescencePar->alpha);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    beta        = %d\n", sPrefix, pFullQuiescencePar->beta);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    depth       = %d\n", sPrefix, pFullQuiescencePar->depth);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    height      = %d\n", sPrefix, pFullQuiescencePar->height);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    *ppv        = %d\n", sPrefix, *pFullQuiescencePar->ppv);
        break;

      default:
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s  <undefined parameters>\n", sPrefix);
        break;
      }

      switch(pStackEntry->nCallType)
      {
      case CALL_TYPE_UNDEFINED:
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s  <undefined localData>\n", sPrefix);
        break;

      case CALL_TYPE_FULL_ROOT:
        pFullRootDat          = &pStackEntry->localData.fullRootDat;

        YBWCManager_Printf(g_pYBWCManagerInstance, "%s  actual FULL_ROOT localData:\n", sPrefix);

        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    old_alpha           = %d\n", sPrefix, pStackEntry->localData.fullRootDat.old_alpha);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    value               = %d\n", sPrefix, pStackEntry->localData.fullRootDat.value);
                                                                       
// kh 10.04.07 Thomas Gaksch future expansion: more info               
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    best_value[0]       = %d\n", sPrefix, pStackEntry->localData.fullRootDat.best_value[0]);
                                                                       
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    i                   = %d\n", sPrefix, pStackEntry->localData.fullRootDat.i);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    j                   = %d\n", sPrefix, pStackEntry->localData.fullRootDat.j); // kh 10.04.07 Thomas Gaksch
                                                                       
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    move                = %d\n", sPrefix, pStackEntry->localData.fullRootDat.move);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    new_depth           = %d\n", sPrefix, pStackEntry->localData.fullRootDat.new_depth);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    reduced             = %d\n", sPrefix, pStackEntry->localData.fullRootDat.reduced);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    found               = %d\n", sPrefix, pStackEntry->localData.fullRootDat.found);     // kh 10.04.07 Thomas Gaksch
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    cap_extended        = %d\n", sPrefix, pStackEntry->localData.fullRootDat.cap_extended); // kh 02.06.08 Thomas Gaksch 14b5c
                                                                       
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    opt_value           = %d\n", sPrefix, pStackEntry->localData.fullRootDat.opt_value); // kh 12.04.07 

        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    bIterationConfirmed = %d\n", sPrefix, pStackEntry->localData.fullRootDat.bIterationConfirmed); // kh 18.06.08

        break;

      case CALL_TYPE_FULL_SEARCH:
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s  actual FULL_SEARCH localData:\n", sPrefix);
        pFullSearchDat        = &pStackEntry->localData.fullSearchDat;

        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    in_check        = %d\n", sPrefix, pFullSearchDat->in_check);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    single_reply    = %d\n", sPrefix, pFullSearchDat->single_reply);
        
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    good_cap        = %d\n", sPrefix, pFullSearchDat->single_reply); // kh 03.06.08 Thomas Gaksch 14b5c

        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    trans_move      = %d\n", sPrefix, pFullSearchDat->trans_move);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    trans_depth     = %d\n", sPrefix, pFullSearchDat->trans_depth);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    trans_flags     = %d\n", sPrefix, pFullSearchDat->trans_flags); // kh 03.06.08 Thomas Gaksch 14b5c
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    trans_value     = %d\n", sPrefix, pFullSearchDat->trans_value); // kh 03.06.08 Thomas Gaksch 14b5c

        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    old_alpha       = %d\n", sPrefix, pFullSearchDat->old_alpha);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    value           = %d\n", sPrefix, pFullSearchDat->value);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    best_value      = %d\n", sPrefix, pFullSearchDat->best_value);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    move            = %d\n", sPrefix, pFullSearchDat->move);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    best_move       = %d\n", sPrefix, pFullSearchDat->best_move);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    new_depth       = %d\n", sPrefix, pFullSearchDat->new_depth);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    played_nb       = %d\n", sPrefix, pFullSearchDat->played_nb);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    i               = %d\n", sPrefix, pFullSearchDat->i);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    opt_value       = %d\n", sPrefix, pFullSearchDat->opt_value);

        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    cap_extended    = %d\n", sPrefix, pFullSearchDat->cap_extended); // kh 03.06.08 Thomas Gaksch 14b5c
        
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    reduced         = %d\n", sPrefix, pFullSearchDat->reduced);

        // kh 07.08.06 future expansion: attack;
        // kh 07.08.06 future expansion: sort;
        // kh 07.08.06 future expansion: undo;
        // kh 07.08.06 future expansion: new_pv;
        // kh 07.08.06 future expansion: played;

        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    FutilityMargin  = %d\n", sPrefix, pFullSearchDat->FutilityMargin); // kh 10.04.07 Thomas Gaksch

        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    probe_score     = %d\n", sPrefix, pFullSearchDat->probe_score); // kh 10.04.07 Thomas Gaksch
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    probe_depth     = %d\n", sPrefix, pFullSearchDat->probe_depth); // kh 03.06.08 Thomas Gaksch 14b5c
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    newHistoryValue = %d\n", sPrefix, pFullSearchDat->newHistoryValue); // kh 03.06.08 Thomas Gaksch 14b5c

        // kh 03.06.08 future expansion: found_entry;

        break;

      case CALL_TYPE_FULL_NO_NULL:
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s  actual FULL_NO_NULL localData:\n", sPrefix);
        pFullNoNullDat        = &pStackEntry->localData.fullNoNullDat;

        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    value           = %d\n", sPrefix, pFullNoNullDat->value);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    best_value      = %d\n", sPrefix, pFullNoNullDat->best_value);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    move            = %d\n", sPrefix, pFullNoNullDat->move);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    new_depth       = %d\n", sPrefix, pFullNoNullDat->new_depth);
        // kh 07.08.06 future expansion: attack;
        // kh 07.08.06 future expansion: sort;
        // kh 07.08.06 future expansion: undo;
        // kh 07.08.06 future expansion: new_pv;

        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    cap_extended    = %d\n", sPrefix, pFullNoNullDat->cap_extended); // kh 03.06.08 Thomas Gaksch 14b5c

        break;

      case CALL_TYPE_FULL_QUIESCENCE:
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s  actual FULL_QUIESCENCE localData:\n", sPrefix);
        pFullQuiescenceDat    = &pStackEntry->localData.fullQuiescenceDat;

        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    in_check        = %d\n", sPrefix, pFullQuiescenceDat->in_check);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    old_alpha       = %d\n", sPrefix, pFullQuiescenceDat->old_alpha);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    value           = %d\n", sPrefix, pFullQuiescenceDat->value);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    best_value      = %d\n", sPrefix, pFullQuiescenceDat->best_value);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    best_move       = %d\n", sPrefix, pFullQuiescenceDat->best_move);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    move            = %d\n", sPrefix, pFullQuiescenceDat->move);
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    opt_value       = %d\n", sPrefix, pFullQuiescenceDat->opt_value);
        // kh 07.08.06 future expansion: attack;
        // kh 07.08.06 future expansion: sort;
        // kh 07.08.06 future expansion: undo;
        // kh 07.08.06 future expansion: new_pv;

        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    probe_score     = %d\n", sPrefix, pFullQuiescenceDat->probe_score); // kh 10.04.07 Thomas Gaksch
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s    probe_depth     = %d\n", sPrefix, pFullQuiescenceDat->probe_depth); // kh 03.06.08 Thomas Gaksch 14b5c
        break;

      default:
        YBWCManager_Printf(g_pYBWCManagerInstance, "%s  <undefined localData>\n", sPrefix);
        break;
      }

      YBWCManager_Printf(g_pYBWCManagerInstance, " \n");
    }
  } // if(g_Stack.nCount > 0)
  else
  {
    YBWCManager_Printf(g_pYBWCManagerInstance, "stack is empty\n");
  } // !if(g_Stack.nCount > 0)

  YBWCManager_Printf(g_pYBWCManagerInstance, " \n");
}
