#ifndef PROCESSORHANDLER_H
#define PROCESSORHANDLER_H

#include "stdmpi.h"

/*
#include "ProxyBase.h"
*/

#include "Request.h"
#include "Result.h"

#define PROCESSOR_HANDLER_STATE_INITIALIZED               0
//#define PROCESSOR_HANDLER_STATE_LOGGED_ON                 1
//#define PROCESSOR_HANDLER_STATE_IDLE                      2
//#define PROCESSOR_HANDLER_STATE_SEARCHING                 3
//#define PROCESSOR_HANDLER_STATE_UNKNOWN                   4
//#define PROCESSOR_HANDLER_STATE_DONT_CARE                 5
#define PROCESSOR_HANDLER_STATE_STATE_NOT_USED_YET        6
#define PROCESSOR_HANDLER_STATE_SEE_YBWC_MANAGER_STATE    7
#define PROCESSOR_HANDLER_STATE_LOGGED_OFF                8
#define PROCESSOR_HANDLER_STATE_SHUTDOWN                  9

#define ALL_SENDS_COMPLETED_TIMEOUT                    10000 // kh 02.08.06 milliseconds
#define ALL_SENDS_COMPLETED_POLL_RATE                     10 // kh 02.08.06 milliseconds

#define CLEANUP_FOR_COMPLETED_SENDS_TIMEOUT             5000 // kh 02.08.06 milliseconds
#define CLEANUP_FOR_COMPLETED_SENDS_POLL_RATE              5 // kh 02.08.06 milliseconds

typedef struct
{
  int                             nId;
  int                             nState;
  BOOL                            bLoggedOn;
  BOOL                            bSyncedNewGame;
  BOOL                            bSyncedSetOption;
  BOOL                            bSyncedAfterBroadcast;

  char                            sProcessorName[MPI_MAX_PROCESSOR_NAME + 1];

  Request*                        pHeadRequest;
  Request*                        pTailRequest;
  int                             nBufferedRequestCount;
  int                             nBufferedRequestCountMax;

  Result*                         pHeadResult;
  Result*                         pTailResult;
  int                             nBufferedResultCount;
  int                             nBufferedResultCountMax;

  BOOL                            bHashTableBroadcastTarget;
  BOOL                            bHistoryTableBroadcastTarget;

  BOOL                            bOnSameNode;

  uint64                          nTransUsed;

} ProcessorHandler;

ProcessorHandler* ProcessorHandler_Construct(ProcessorHandler* pThis, int nId);

void ProcessorHandler_Destruct(ProcessorHandler* pThis);

Request* ProcessorHandler_CreateRequest(ProcessorHandler* pThis);

Result* ProcessorHandler_CreateResult(ProcessorHandler* pThis);

int ProcessorHandler_CleanupForCompletedSends(ProcessorHandler* pThis);

int ProcessorHandler_ForcedWaitForAllSendsCompleted(ProcessorHandler* pThis);

int ProcessorHandler_WaitForAllSendsCompleted(ProcessorHandler* pThis);

#endif
