#ifndef HASHTABLEBUFFER_H
#define HASHTABLEBUFFER_H

//#include "MPIWrapper.h"
#include "HashTableEntry.h"

#include "trans.h"

#include "Request.h"

// kh 15.11.06 is limited by the MAX_RESULT_PARAMETER_BUFFER_SIZE 
#define MAX_HASH_TABLE_BUFFER_SIZE                 256

typedef struct tHashTableBuffer
{
  int                   nMaxSize;
  int                   nCount;
  int                   nChunkSizeForFlush;
  HashTableEntry        hashTableEntry[MAX_HASH_TABLE_BUFFER_SIZE];

  struct tRequest*      pBroadcastRequestBuffer;

} HashTableBuffer;

HashTableBuffer* HashTableBuffer_Construct(HashTableBuffer* pThis, int nChunkSizeForFlush);

void HashTableBuffer_Destruct(HashTableBuffer* pThis);

void HashTableBuffer_Init(HashTableBuffer* pThis);

HashTableEntry* HashTableBuffer_AddEntryAndCheckBroadcast(HashTableBuffer* pThis,
                                                          uint64           nKey,
                                                          int              nMove,
                                                          int              nDepth,
                                                          int              nFlags,
                                                          int              nValue);

// kh 02.02.07 not used at the moment
/*
HashTableEntry* HashTableBuffer_AddEntry(HashTableBuffer* pThis,
                                         uint64           nKey,
                                         int              nMove,
                                         int              nDepth,
                                         int              nMinValue,
                                         int              nMaxValue);
*/

int HashTableBuffer_Broadcast(HashTableBuffer* pThis);
int HashTableBuffer_FlushWithBroadcast(HashTableBuffer* pThis);
void HashTableBuffer_Discard(HashTableBuffer* pThis);

int HashTableBuffer_FlushToTranspositionTable(HashTableBuffer* pThis, trans_t* pTranspositionTable);

#endif
