#ifndef FRUITCONFIGURATION_H
#define FRUITCONFIGURATION_H

#include "stdmpi.h"

#include "FruitBase.h"

//#define BASE_CONFIGURATION_SECTION                        "BASE_CONFIGURATION"

#define OPT_NAME_LOG_TO_COMMON_FILE                           "Log To Common File"
#define KEY_NAME_LOG_TO_COMMON_FILE                           "LOG_TO_COMMON_FILE"
#define DEFAULT_LOG_TO_COMMON_FILE                            TRUE

#define OPT_NAME_LOG_TO_FILE                                  "Log To Specific File"
#define KEY_NAME_LOG_TO_FILE                                  "LOG_TO_FILE"
#define DEFAULT_LOG_TO_FILE                                   TRUE

#define OPT_NAME_LOG_TO_STDOUT                                "Log To Stdout"
#define KEY_NAME_LOG_TO_STDOUT                                "LOG_TO_STDOUT"
#define DEFAULT_LOG_TO_STDOUT                                 TRUE

#define OPT_NAME_MAX_BUFFERED_REQUEST_COUNT                   "Max Buffered Requests"
#define KEY_NAME_MAX_BUFFERED_REQUEST_COUNT                   "MAX_BUFFERED_REQUEST_COUNT"
#define DEFAULT_MAX_BUFFERED_REQUEST_COUNT                    128

#define OPT_NAME_MAX_BUFFERED_RESULT_COUNT                    "Max Buffered Results"
#define KEY_NAME_MAX_BUFFERED_RESULT_COUNT                    "MAX_BUFFERED_RESULT_COUNT"
#define DEFAULT_MAX_BUFFERED_RESULT_COUNT                     128

#define OPT_NAME_REQUEST_FOR_WORK_WAIT_COUNTER_LIMIT          "Max Waits Before Work Request"
#define KEY_NAME_REQUEST_FOR_WORK_WAIT_COUNTER_LIMIT          "REQUEST_FOR_WORK_WAIT_COUNTER_LIMIT"
#define DEFAULT_REQUEST_FOR_WORK_WAIT_COUNTER_LIMIT           5000

#define OPT_NAME_REQUEST_FOR_WORK_WAIT_COUNTER_TO_DOUBLE      "Base Waits Before Work Request"
#define KEY_NAME_REQUEST_FOR_WORK_WAIT_COUNTER_TO_DOUBLE      "REQUEST_FOR_WORK_WAIT_COUNTER_TO_DOUBLE"
#define DEFAULT_REQUEST_FOR_WORK_WAIT_COUNTER_TO_DOUBLE       100

#define OPT_NAME_REQUEST_FOR_WORK_REPEAT_BLOCK_FACTOR         "No Work Results Before Doubling Base Waits"
#define KEY_NAME_REQUEST_FOR_WORK_REPEAT_BLOCK_FACTOR         "REQUEST_FOR_WORK_REPEAT_BLOCK_FACTOR"
#define DEFAULT_REQUEST_FOR_WORK_REPEAT_BLOCK_FACTOR          10

#define OPT_NAME_SEND_ADDITIONAL_UCI_INFO                     "Send Additional UCI Info"
#define KEY_NAME_SEND_ADDITIONAL_UCI_INFO                     "SEND_ADDITIONAL_UCI_INFO"
#define DEFAULT_SEND_ADDITIONAL_UCI_INFO                      TRUE

#define OPT_NAME_DEBUG_WAIT_FOR_SLAVE_RATE                    "Wait For Slave Dump Interval"
#define KEY_NAME_DEBUG_WAIT_FOR_SLAVE_RATE                    "DEBUG_WAIT_FOR_SLAVE_RATE"
#define DEFAULT_DEBUG_WAIT_FOR_SLAVE_RATE                     10000

#define OPT_NAME_DEBUG_WAIT_FOR_WORK_RATE                     "Wait For Work Dump Interval"
#define KEY_NAME_DEBUG_WAIT_FOR_WORK_RATE                     "DEBUG_WAIT_FOR_WORK_RATE"
#define DEFAULT_DEBUG_WAIT_FOR_WORK_RATE                      1000

#define OPT_NAME_DEBUG_AT_WORK_RATE                           "At Work Dump Interval"
#define KEY_NAME_DEBUG_AT_WORK_RATE                           "DEBUG_AT_WORK_RATE"
#define DEFAULT_DEBUG_AT_WORK_RATE                            10000

#define OPT_NAME_DEBUG_AWAITING_RESULT_RATE                   "Awaiting Result Dump Interval"
#define KEY_NAME_DEBUG_AWAITING_RESULT_RATE                   "DEBUG_AWAITING_RESULT_RATE"
#define DEFAULT_DEBUG_AWAITING_RESULT_RATE                    10000

#define OPT_NAME_FORCE_REPRODUCIBLE_EVALUATION                "Force Reproducible Evaluation"
#define KEY_NAME_FORCE_REPRODUCIBLE_EVALUATION                "FORCE_REPRODUCIBLE_EVALUATION"
#define DEFAULT_FORCE_REPRODUCIBLE_EVALUATION                 FALSE

#define OPT_NAME_ONLY_DISTRIBUTE_WORK_OF_ROOT_MASTER          "Only Distribute Work Of Root Master"
#define KEY_NAME_ONLY_DISTRIBUTE_WORK_OF_ROOT_MASTER          "ONLY_DISTRIBUTE_WORK_OF_ROOT_MASTER"
#define DEFAULT_ONLY_DISTRIBUTE_WORK_OF_ROOT_MASTER           FALSE

#define OPT_NAME_SUPPRESS_DISTRIBUTION_OF_ROOT_MOVES          "Suppress Distribution Of Root Moves"
#define KEY_NAME_SUPPRESS_DISTRIBUTION_OF_ROOT_MOVES          "SUPPRESS_DISTRIBUTION_OF_ROOT_MOVES"
#define DEFAULT_SUPPRESS_DISTRIBUTION_OF_ROOT_MOVES           FALSE

#define OPT_NAME_SUPPRESS_DISTRIBUTION_OF_FULL_SEARCH_MOVES   "Suppress Distribution Of Non Root Moves"
#define KEY_NAME_SUPPRESS_DISTRIBUTION_OF_FULL_SEARCH_MOVES   "SUPPRESS_DISTRIBUTION_OF_FULL_SEARCH_MOVES"
#define DEFAULT_SUPPRESS_DISTRIBUTION_OF_FULL_SEARCH_MOVES    FALSE

#define OPT_NAME_ALLOW_DISTRIBUTION_OF_LAST_MOVE_IN_LIST      "Allow Distribution Of Last Move"
#define KEY_NAME_ALLOW_DISTRIBUTION_OF_LAST_MOVE_IN_LIST      "ALLOW_DISTRIBUTION_OF_LAST_MOVE_IN_LIST"
#define DEFAULT_ALLOW_DISTRIBUTION_OF_LAST_MOVE_IN_LIST       FALSE

#define OPT_NAME_REVERSE_SEARCH_STACK_DISTRIBUTION_ORDER      "Reverse Stack Distribution Order"
#define KEY_NAME_REVERSE_SEARCH_STACK_DISTRIBUTION_ORDER      "REVERSE_SEARCH_STACK_DISTRIBUTION_ORDER"
#define DEFAULT_REVERSE_SEARCH_STACK_DISTRIBUTION_ORDER       FALSE

#define OPT_NAME_UPDATE_SEARCH_WINDOWS                        "Update Search Windows"
#define KEY_NAME_UPDATE_SEARCH_WINDOWS                        "UPDATE_SEARCH_WINDOWS"
#define DEFAULT_UPDATE_SEARCH_WINDOWS                         TRUE

#define OPT_NAME_DIRECT_UPDATE_SEARCH_WINDOWS                 "Direct Update Search Windows"
#define KEY_NAME_DIRECT_UPDATE_SEARCH_WINDOWS                 "DIRECT_UPDATE_SEARCH_WINDOWS"
#define DEFAULT_DIRECT_UPDATE_SEARCH_WINDOWS                  FALSE

#define OPT_NAME_MINIMUM_ALPHA_IMPROVEMENT_FOR_RERUN_SEARCH   "Min Alpha Improvement For Rerun"
#define KEY_NAME_MINIMUM_ALPHA_IMPROVEMENT_FOR_RERUN_SEARCH   "MINIMUM_ALPHA_IMPROVEMENT_FOR_RERUN_SEARCH"
#define DEFAULT_MINIMUM_ALPHA_IMPROVEMENT_FOR_RERUN_SEARCH    0

#define OPT_NAME_MAXIMUM_MOVES_COMPLETED_FOR_RERUN_SEARCH     "Max Moves Completed For Rerun"
#define KEY_NAME_MAXIMUM_MOVES_COMPLETED_FOR_RERUN_SEARCH     "MAXIMUM_MOVES_COMPLETED_FOR_RERUN_SEARCH"
#define DEFAULT_MAXIMUM_MOVES_COMPLETED_FOR_RERUN_SEARCH      0

#define OPT_NAME_MAXIMUM_PERCENT_COMPLETED_FOR_RERUN_SEARCH   "Max Percent Completed For Rerun"
#define KEY_NAME_MAXIMUM_PERCENT_COMPLETED_FOR_RERUN_SEARCH   "MAXIMUM_PERCENT_COMPLETED_FOR_RERUN_SEARCH"
#define DEFAULT_MAXIMUM_PERCENT_COMPLETED_FOR_RERUN_SEARCH    0

#define OPT_NAME_MAXIMUM_ALPHA_IMPROVEMENT_CHECK_COMPLETED    "Alpha Improvement To Force Rerun"
#define KEY_NAME_MAXIMUM_ALPHA_IMPROVEMENT_CHECK_COMPLETED    "MAXIMUM_ALPHA_IMPROVEMENT_CHECK_COMPLETED"
#define DEFAULT_MAXIMUM_ALPHA_IMPROVEMENT_CHECK_COMPLETED     0

#define OPT_NAME_BROADCAST_TRANSPOSITION_TABLE                "Broadcast Hash Table"
#define KEY_NAME_BROADCAST_TRANSPOSITION_TABLE                "BROADCAST_TRANSPOSITION_TABLE"
#define DEFAULT_BROADCAST_TRANSPOSITION_TABLE                 TRUE

#define OPT_NAME_BROADCAST_TRANSPOSITION_TABLE_CHUNK_SIZE     "Broadcast Chunk Size Of Hash Table"
#define KEY_NAME_BROADCAST_TRANSPOSITION_TABLE_CHUNK_SIZE     "BROADCAST_TRANSPOSITION_TABLE_CHUNK_SIZE"
#define DEFAULT_BROADCAST_TRANSPOSITION_TABLE_CHUNK_SIZE      64

#define OPT_NAME_MINIMUM_TRANS_DEPTH_FOR_BROADCAST            "Broadcast Min Depth of Hash Table"
#define KEY_NAME_MINIMUM_TRANS_DEPTH_FOR_BROADCAST            "MINIMUM_TRANS_DEPTH_FOR_BROADCAST"
#define DEFAULT_MINIMUM_TRANS_DEPTH_FOR_BROADCAST             0

#define OPT_NAME_USE_SHARED_MEMORY_TRANSPOSITION_TABLE        "Share Hash Table"
#define KEY_NAME_USE_SHARED_MEMORY_TRANSPOSITION_TABLE        "USE_SHARED_MEMORY_TRANSPOSITION_TABLE"
#define DEFAULT_USE_SHARED_MEMORY_TRANSPOSITION_TABLE         FALSE

#define OPT_NAME_USE_SHARED_MEMORY_HISTORY_TABLE              "Share History Table"
#define KEY_NAME_USE_SHARED_MEMORY_HISTORY_TABLE              "USE_SHARED_MEMORY_HISTORY_TABLE"
#define DEFAULT_USE_SHARED_MEMORY_HISTORY_TABLE               FALSE

#define OPT_NAME_SYNCHRONIZE_HISTORY_TABLE_ACCESS             "Synchronize History Table Access"
#define KEY_NAME_SYNCHRONIZE_HISTORY_TABLE_ACCESS             "SYNCHRONIZE_HISTORY_TABLE_ACCESS"
#define DEFAULT_SYNCHRONIZE_HISTORY_TABLE_ACCESS              FALSE

#define OPT_NAME_BROADCAST_HISTORY_TABLE                      "Broadcast History Table"
#define KEY_NAME_BROADCAST_HISTORY_TABLE                      "BROADCAST_HISTORY_TABLE"
#define DEFAULT_BROADCAST_HISTORY_TABLE                       FALSE

#define OPT_NAME_HISTORY_TABLE_UPDATES_TO_TRIGGER_BROADCAST   "History Table Chunk Size"
#define KEY_NAME_HISTORY_TABLE_UPDATES_TO_TRIGGER_BROADCAST   "HISTORY_TABLE_UPDATES_TO_TRIGGER_BROADCAST"
#define DEFAULT_HISTORY_TABLE_UPDATES_TO_TRIGGER_BROADCAST    100

#define OPT_NAME_HIST_TOT_TABLE_UPDATES_TO_TRIGGER_BROADCAST  "History HistTot Table Chunk Size"
#define KEY_NAME_HIST_TOT_TABLE_UPDATES_TO_TRIGGER_BROADCAST  "HIST_TOT_TABLE_UPDATES_TO_TRIGGER_BROADCAST"
#define DEFAULT_HIST_TOT_TABLE_UPDATES_TO_TRIGGER_BROADCAST   100

#define OPT_NAME_TRANSMIT_KILLER_TABLE                        "Transmit Killer Table"
#define KEY_NAME_TRANSMIT_KILLER_TABLE                        "TRANSMIT_KILLER_TABLE"
#define DEFAULT_TRANSMIT_KILLER_TABLE                         TRUE

#define OPT_NAME_TRANSMIT_HISTORY_TABLE                       "Transmit History Table"
#define KEY_NAME_TRANSMIT_HISTORY_TABLE                       "TRANSMIT_HISTORY_TABLE"
#define DEFAULT_TRANSMIT_HISTORY_TABLE                        TRUE

#define OPT_NAME_TRANSMIT_HIST_TOT_TABLE                      "Transmit HistTot Table"
#define KEY_NAME_TRANSMIT_HIST_TOT_TABLE                      "TRANSMIT_HIST_TOT_TABLE"
#define DEFAULT_TRANSMIT_HIST_TOT_TABLE                       TRUE

#define OPT_NAME_USE_HISTORY_PRUNING                          "Real History Pruning"
#define KEY_NAME_USE_HISTORY_PRUNING                          "USE_HISTORY_PRUNING"
#define DEFAULT_USE_HISTORY_PRUNING                           TRUE

#define OPT_NAME_USE_IID                                      "Use IID"
#define KEY_NAME_USE_IID                                      "USE_IID"
#define DEFAULT_USE_IID                                       TRUE

#define OPT_NAME_USE_TRANSPOSITION_TABLE                      "Use Hash Table"
#define KEY_NAME_USE_TRANSPOSITION_TABLE                      "USE_TRANSPOSITION_TABLE"
#define DEFAULT_USE_TRANSPOSITION_TABLE                       TRUE

#define OPT_NAME_CHECK_NB                                     "Standard Poll Interval"
#define KEY_NAME_CHECK_NB                                     "CHECK_NB"
#define DEFAULT_CHECK_NB                                      1000

#define OPT_NAME_CHECK_INC                                    "Standard Poll Increment"
#define KEY_NAME_CHECK_INC                                    "CHECK_INC"
#define DEFAULT_CHECK_INC                                     1000

#define OPT_NAME_CHECK_NB_MPI_POLL                            "MPI Poll Interval"
#define KEY_NAME_CHECK_NB_MPI_POLL                            "CHECK_NB_MPI_POLL"
#define DEFAULT_CHECK_NB_MPI_POLL                             20

#define OPT_NAME_CHECK_INC_MPI_POLL                           "MPI Poll Increment"
#define KEY_NAME_CHECK_INC_MPI_POLL                           "CHECK_INC_MPI_POLL"
#define DEFAULT_CHECK_INC_MPI_POLL                            20

#define OPT_NAME_CLEANUP_ACTIONS_INTERVAL                     "Cleanup Interval"
#define KEY_NAME_CLEANUP_ACTIONS_INTERVAL                     "CLEANUP_ACTIONS_INTERVAL"
#define DEFAULT_CLEANUP_ACTIONS_INTERVAL                      5000

#define OPT_NAME_TIMER_ACTIONS_INTERVAL_01                    "Timer 01 Interval"
#define KEY_NAME_TIMER_ACTIONS_INTERVAL_01                    "TIMER_ACTIONS_INTERVAL_01"
#define DEFAULT_TIMER_ACTIONS_INTERVAL_01                     4000

#define OPT_NAME_SEND_KEEP_ALIVE_CHARS                        "Send Keep Alive Chars"
#define KEY_NAME_SEND_KEEP_ALIVE_CHARS                        "SEND_KEEP_ALIVE_CHARS"
#define DEFAULT_SEND_KEEP_ALIVE_CHARS                         FALSE

#define OPT_NAME_SLAVE_START_IID_DEPTH                        "Remote Start IID Depth"
#define KEY_NAME_SLAVE_START_IID_DEPTH                        "SLAVE_START_IID_DEPTH"
#define DEFAULT_SLAVE_START_IID_DEPTH                         0

#define OPT_NAME_SLAVE_IID_DEPTH_SKIP_TO_MAX                  "Remote IID Depth To Skip To Max"
#define KEY_NAME_SLAVE_IID_DEPTH_SKIP_TO_MAX                  "SLAVE_IID_DEPTH_SKIP_TO_MAX"
#define DEFAULT_SLAVE_IID_DEPTH_SKIP_TO_MAX                   0

// kh 12.02.08 use standard uci options now
/*
#define KEY_NAME_HASH_TABLE_SIZE_MB                           "HASH_TABLE_SIZE_MB"
#define DEFAULT_HASH_TABLE_SIZE_MB                            16
*/

#define OPT_NAME_MINIMUM_BROTHERS_FINISHED_ROOT               "Moves Completed At Root Before Work Distribution"
#define KEY_NAME_MINIMUM_BROTHERS_FINISHED_ROOT               "MINIMUM_BROTHERS_FINISHED_ROOT"
#define DEFAULT_MINIMUM_BROTHERS_FINISHED_ROOT                1

#define OPT_NAME_MINIMUM_BROTHERS_FINISHED                    "Moves Completed Before Work Distribution"
#define KEY_NAME_MINIMUM_BROTHERS_FINISHED                    "MINIMUM_BROTHERS_FINISHED"
#define DEFAULT_MINIMUM_BROTHERS_FINISHED                     1

#define OPT_NAME_BROTHERS_FINISHED_TYPE_CUT_OFFSET            "Moves Completed Offset At Cut Node"
#define KEY_NAME_BROTHERS_FINISHED_TYPE_CUT_OFFSET            "BROTHERS_FINISHED_TYPE_CUT_OFFSET"
#define DEFAULT_BROTHERS_FINISHED_TYPE_CUT_OFFSET             0

#define OPT_NAME_BROTHERS_FINISHED_TYPE_ALL_OFFSET            "Moves Completed Offset At All Node"
#define KEY_NAME_BROTHERS_FINISHED_TYPE_ALL_OFFSET            "BROTHERS_FINISHED_TYPE_ALL_OFFSET"
#define DEFAULT_BROTHERS_FINISHED_TYPE_ALL_OFFSET             0

#define OPT_NAME_BROTHERS_FINISHED_TYPE_PV_OFFSET             "Moves Completed Offset At PV Node"
#define KEY_NAME_BROTHERS_FINISHED_TYPE_PV_OFFSET             "BROTHERS_FINISHED_TYPE_PV_OFFSET"
#define DEFAULT_BROTHERS_FINISHED_TYPE_PV_OFFSET              0

#define OPT_NAME_MINIMUM_REMOTE_SEARCH_DEPTH_SAME_NODE        "Min Remaining Search Depth Same Node"
#define KEY_NAME_MINIMUM_REMOTE_SEARCH_DEPTH_SAME_NODE        "MINIMUM_REMOTE_SEARCH_DEPTH_SAME_NODE"
#define DEFAULT_MINIMUM_REMOTE_SEARCH_DEPTH_SAME_NODE         2

#define OPT_NAME_MINIMUM_REMOTE_SEARCH_DEPTH                  "Min Remaining Search Depth"
#define KEY_NAME_MINIMUM_REMOTE_SEARCH_DEPTH                  "MINIMUM_REMOTE_SEARCH_DEPTH"
#define DEFAULT_MINIMUM_REMOTE_SEARCH_DEPTH                   3

#define OPT_NAME_MAXIMUM_REMOTE_SEARCH_DEPTH                  "Max Remaining Search Depth"
#define KEY_NAME_MAXIMUM_REMOTE_SEARCH_DEPTH                  "MAXIMUM_REMOTE_SEARCH_DEPTH"
#define DEFAULT_MAXIMUM_REMOTE_SEARCH_DEPTH                   0

#define OPT_NAME_MINIMUM_REMOTE_SEARCH_HEIGHT                 "Min Remaining Search Height"
#define KEY_NAME_MINIMUM_REMOTE_SEARCH_HEIGHT                 "MINIMUM_REMOTE_SEARCH_HEIGHT"
#define DEFAULT_MINIMUM_REMOTE_SEARCH_HEIGHT                  0

#define OPT_NAME_MAXIMUM_REMOTE_SEARCH_HEIGHT                 "Max Remaining Search Height"
#define KEY_NAME_MAXIMUM_REMOTE_SEARCH_HEIGHT                 "MAXIMUM_REMOTE_SEARCH_HEIGHT"
#define DEFAULT_MAXIMUM_REMOTE_SEARCH_HEIGHT                  0

#define OPT_NAME_USE_MULTI_STEP_STACK_SEARCH                  "Use Multi Step Stack Search For Work"
#define KEY_NAME_USE_MULTI_STEP_STACK_SEARCH                  "USE_MULTI_STEP_STACK_SEARCH"
#define DEFAULT_USE_MULTI_STEP_STACK_SEARCH                   FALSE

#define OPT_NAME_MINIMUM_BROTHERS_FINISHED_ROOT_FIRST_STEP    "Moves Completed At Root At First Step"
#define KEY_NAME_MINIMUM_BROTHERS_FINISHED_ROOT_FIRST_STEP    "MINIMUM_BROTHERS_FINISHED_ROOT_FIRST_STEP"
#define DEFAULT_MINIMUM_BROTHERS_FINISHED_ROOT_FIRST_STEP     5

#define OPT_NAME_MINIMUM_BROTHERS_FINISHED_FIRST_STEP         "Moves Completed At First Step"
#define KEY_NAME_MINIMUM_BROTHERS_FINISHED_FIRST_STEP         "MINIMUM_BROTHERS_FINISHED_FIRST_STEP"
#define DEFAULT_MINIMUM_BROTHERS_FINISHED_FIRST_STEP          5

#define OPT_NAME_USE_SYNCHRONIZED_STACK_STOP_ENTRY            "Use Synchronized Stack Stop Entry"
#define KEY_NAME_USE_SYNCHRONIZED_STACK_STOP_ENTRY            "USE_SYNCHRONIZED_STACK_STOP_ENTRY"
#define DEFAULT_USE_SYNCHRONIZED_STACK_STOP_ENTRY             FALSE

#define OPT_NAME_ADJUST_PROCESS_PRIORITY                      "Lower Process Priority To Favor GUI Updates"
#define KEY_NAME_ADJUST_PROCESS_PRIORITY                      "ADJUST_PROCESS_PRIORITY"
#define DEFAULT_ADJUST_PROCESS_PRIORITY                       FALSE

#define OPT_NAME_USE_EVENT                                    "Use Event"
#define KEY_NAME_USE_EVENT                                    "USE_EVENT"
#define DEFAULT_USE_EVENT                                     TRUE



#define FRUIT_DEBUG_LEVEL_FORCE_OUTPUT        0
#define FRUIT_DEBUG_LEVEL_ERROR_PRIO_1        1
#define FRUIT_DEBUG_LEVEL_ERROR_PRIO_2        2
#define FRUIT_DEBUG_LEVEL_ERROR_PRIO_LAST     2

#define FRUIT_DEBUG_LEVEL_WARNING_PRIO_1      3
#define FRUIT_DEBUG_LEVEL_WARNING_PRIO_2      4
#define FRUIT_DEBUG_LEVEL_WARNING_PRIO_LAST   4

#define FRUIT_DEBUG_LEVEL_INFO_PRIO_1         5
#define FRUIT_DEBUG_LEVEL_INFO_PRIO_2         6
#define FRUIT_DEBUG_LEVEL_INFO_PRIO_3         7
#define FRUIT_DEBUG_LEVEL_INFO_PRIO_999     999
#define FRUIT_DEBUG_LEVEL_INFO_PRIO_LAST    999

#define OPT_NAME_FRUIT_DEBUG_LEVEL        "Debug Level"
#define KEY_NAME_FRUIT_DEBUG_LEVEL        "FRUIT_DEBUG_LEVEL"
#define DEFAULT_FRUIT_DEBUG_LEVEL         1 // kh 21.07.06 FRUIT_DEBUG_LEVEL_ERROR_PRIO_1 (see list above)

typedef struct
{
  char                    sFileName     [MAX_FRUIT_CONFIGURATION_FILE_NAME + 1];
  char                    szBoolToString[MAX_BOOL_TO_STRING + 1];

  int                     nFruitDebugLevel;                       // kh 21.07.06 sets the debug level and thereby the amount of information displayed via printf(...
                                                                  // the rule of thumb is: the higher the level the more info will be displayed
                                                                  // this info is transmitted back to the gui (via the master) and may produce
                                                                  // communication overhead

  BOOL                    bLogToCommonFile;                       // kh 04.08.06 true to write to the log output to a file common for all processors
  BOOL                    bLogToFile;                             // kh 04.08.06 true to write to the log output to a file
  BOOL                    bLogToStdout;                           // kh 04.08.06 true to write to the log output to stdout

  int                     nMaxBufferedRequestCount;               // kh 01.02.07 maximum buffered request count, before messages are serviced 
                                                                  // additionally explicitly 
  int                     nMaxBufferedResultCount;                // kh 01.02.07 maximum buffered result count, before messages are serviced 
                                                                  // additionally explicitly 

  int                     nRequestForWorkWaitCounterLimit;        // kh 01.02.07 wait limit if there is still no work available 
                                                                  // (count of "no work available" results in a row)
  int                     nRequestForWorkWaitCounterToDouble;     // kh 01.02.07 start wait counter limit if there is still no work available
                                                                  // this value is doubled until nRequestForWorkWaitCounterLimit is reached to decrease
                                                                  // the frequency of asking for work reducing the network traffic
                                                                  // the value is duplicated after each next nRequestForWorkRepeatBlockFactor 
                                                                  // "no work available" results in a row
  int                     nRequestForWorkRepeatBlockFactor;       // kh 01.02.07 requests for work are done with decreasing frequency if there is 
                                                                  // still no work available
                                                                  // but the frequency is not decreased for n - blocked - negative answers in a row


  BOOL                    bSendAdditionalUCIInfo;                 // kh 25.01.07 true to send additional uci info (e.g. currprocessorid)

  int                     nDebugWaitForSlaveRate;                 // kh 08.02.07 log the slaves with outstanding results at the synchronization points
                                                                  // when waiting (rate is ms for values > 0, 0 disables the logging))

  int                     nDebugWaitForWorkRate;                  // kh 13.03.07 log the slaves waiting for work
                                                                  // (rate is ms for values > 0, 0 disables the logging))

  int                     nDebugAtWorkRate;                       // kh 14.03.07 log the slaves working 
                                                                  // (rate is ms for values > 0, 0 disables the logging))

  int                     nDebugAwaitingResultRate;               // kh 14.03.07 log awaited slave results
                                                                  // (rate is ms for values > 0, 0 disables the logging))

  BOOL                    bForceReproducibleEvaluation;           // kh 27.10.06 true to force a reproducible evaluation 
                                                                  // e.g. history heuristic and good_move(... marking will be suppressed
                                                                  // attention: that makes fruit much slower!
                                                                  // can be used for debug purposes

  BOOL                    bOnlyDistributeWorkOfRootMaster;        // kh 27.10.06 true to suppress further distribution of subwork from 
                                                                  // slaves
                                                                  // can be used for debug purposes

  BOOL                    bSuppressDistributionOfRootMoves;       // kh 30.10.06 true to suppress the distribution of root 
                                                                  // moves (implicitly affects the root master only)
                                                                  // can be used for debug purposes

  BOOL                    bSuppressDistributionOfFullSearchMoves; // kh 13.11.06 true to suppress the distribution of full search 
                                                                  // moves
                                                                  // can be used for debug purposes

  BOOL                    bAllowDistributionOfLastMoveInList;     // kh 08.02.07 true to allow the distribution of the last move 
                                                                  // in the move list (this may lead to a decrease in efficiency because
                                                                  // a master may potentially longer wait for the slave results but it
                                                                  // favors the speedup)

  BOOL                    bReverseSearchStackDistributionOrder;   // kh 09.03.07 true to reverse the standard order the stack is searched for sub jobs
                                                                  // with the ybwc standard order the stack is searched for work starting from the root
                                                                  // especially for fruit it seems to be a good idea to start the search for work
                                                                  // at the top of the stack (i.e. starting at the leaves)

  BOOL                    bUpdateSearchWindows;                   // kh 09.11.06 true to update also the search windows (alpha) of slaves
                                                                  // if a master gets a better value for alpha (by his local search or
                                                                  // by a slave result received) 
  BOOL                    bDirectUpdateSearchWindows;             // kh 18.06.08 true to direct update the search windows (alpha and beta) of slaves
                                                                  // if a master gets a better value for alpha or beta (by his local search or
                                                                  // by a slave result received) with appropriate stack paramter adjusts
                                                                  // false to rerun the search (using: nMinimumAlphaImprovementForRerunSearch,
                                                                  // nMaximumMovesCompletedForRerunSearch, nMaximumPercentCompletedForRerunSearch,
                                                                  // nMaximumPercentCompletedForRerunSearch, nMaximumAlphaImprovementCheckCompleted)
  int                     nMinimumAlphaImprovementForRerunSearch; // kh 15.02.07 minimum alpha improvement (see also bUpdateSearchWindows)
                                                                  // to rerun the search with the new window (alpha) after 
                                                                  // stopping the actual search

  int                     nMaximumMovesCompletedForRerunSearch;   // kh 14.03.07 maximum number of moves marked completed 
                                                                  // at level 1 (i.e. the level next to the root)
                                                                  // to rerun the search with the new window (alpha) after 
                                                                  // stopping the actual search
                                                                  // (only used for values > 0)

  int                     nMaximumPercentCompletedForRerunSearch; // kh 14.03.07 maximum percentage of search progress of the actual search
                                                                  // (estimated via the moves marked completed divided by the maximum move list count
                                                                  // ever reached on level 1 (not necessarily the number of legal moves in level 1, 
                                                                  // because there may exist cutoffs)
                                                                  // to rerun the search with the new window (alpha) after 
                                                                  // stopping the actual search
                                                                  // should only be used in combination with an IID:
                                                                  // using an appropriate IID (so at least 1 additional iteration with 
                                                                  // any search depth < final/actual search deph is performed)
                                                                  // is important to expand level 1 at least once, before in the last run
                                                                  // for the final/actual depth the nMoveListTotalCountMax of level 1 is accessed
                                                                  // if otherwise (without an IID) nMoveListTotalCountMax stays initialized to 0 the value for 
                                                                  // nMaximumPercentCompletedForRerunSearch will be ignored
                                                                  // (only used for values > 0)

  int                     nMaximumAlphaImprovementCheckCompleted; // kh 15.03.07 maximum alpha improvement allowed to potentially suppress 
                                                                  // a rerun of the search with the new window (alpha) after 
                                                                  // stopping the actual search 
                                                                  // used in combination with nMaximumMovesCompletedForRerunSearch and
                                                                  // nMaximumPercentCompletedForRerunSearch
                                                                  // (only used for values > 0)

  BOOL                    bBroadcastTranspositionTable;           // kh 13.11.06 true to broadcast the transposition table

  int                     nBroadcastTranspositionTableChunkSize;  // kh 13.11.06 chunk size (number of buffered new hash table entries) of each broadcast

  int                     nMinimumTransDepthForBroadcast;         // kh 01.02.07 minimum search depth of a transpoistion table entry 
                                                                  // to consider it for a broadcast

  BOOL                    bUseSharedMemoryTranspositionTable;     // kh 13.11.06 true to use shared memory for the transposition table

  BOOL                    bUseSharedMemoryHistoryTable;           // kh 13.11.06 true to use shared memory for the history table

  BOOL                    bSynchronizeHistoryTableAccess;         // kh 16.02.07 true to synchronize all accesses to the shared memory history table
                                                                  // (used in combination with bUseSharedMemoryHistoryTable)

  BOOL                    bBroadcastHistoryTable;                  // kh 13.11.06 true to broadcast the history and in combination the histtot and histhit tables
  int                     nHistoryTableUpdatesToTriggerBroadcast;  // kh 20.02.07 number off required updates to the history table (see good_move(...) to trigger
                                                                   // the broadcast of the history table
  int                     nHistTotTableUpdatesToTriggerBroadcast;  // kh 20.02.07 number off required updates to the histtot table (see history_good(... nd gistory_bad(...) 
                                                                   // to trigger the broadcast of the histtot and histhit tables

  BOOL                    bTransmitKillerTable;                   // kh 14.02.07 true to tranmsit the killer table from the master to the slave

  BOOL                    bTransmitHistoryTable;                  // kh 29.03.07 true to tranmsit the history table from the master to the slave
  BOOL                    bTransmitHistTotTable;                  // kh 29.03.07 true to tranmsit the histtot table from the master to the slave

  BOOL                    bUseHistoryPruning;                     // kh 11.04.07 true to use the history pruning

  BOOL                    bUseIID;                                // kh 05.01.07 true to use internal iterative deepening
  BOOL                    bUseTranspositionTable;                 // kh 05.01.07 true to use the transposition table;

  int                     nCheckNb;                               // kh 01.02.07 searched node interval for checks
  int                     nCheckInc;                              // kh 01.02.07 searched node interval for checks

  int                     nCheckNbMPIPoll;                        // kh 01.02.07 searched node interval for mpi checks
  int                     nCheckIncMPIPoll;                       // kh 01.02.07 searched node interval for mpi checks

  int                     nCleanupActionsInterval;                // kh 31.05.07 call to YBWCManager_CleanupActions(... interval to perform the real 
                                                                  // cleanup actions (was formerly handled by a countdown timer but the system calls to get
                                                                  // e.g. the "tick counts" under windows seem to be too expensive)

  int                     nTimerActionsInterval01;                // kh 10.12.07 timer actions interval to trigger YBWCManager_TimerActions01(... regularly
                                                                  // used to keep the ssh protocol alive and solve some flush buffer problems in
                                                                  // certain linux environments when plink is used in connection with the chessbase gui

  BOOL                    bSendKeepAliveChars;                    // kh 10.12.07 true to send regularly keep alive characters to the gui 
                                                                  // see also comment for nTimerActionsInterval01

  int                     nSlaveStartIIDDepth;                    // kh 01.02.07 tunes the pseudo IID start depth for slaves at the root
                                                                  //   0 means no IID at all, the start depth is the actual remaining search depth 
                                                                  //     of the sub problem
                                                                  // > 0 sets a fixed IID start depth (limited by the remaining search depth of the sub problem)
                                                                  //     so lowest search levels are skipped
                                                                  // < 0 the absolute value is subtracted as an offset from the remaining search depth 
                                                                  //     of the sub problem (limited by 1)

  int                     nSlaveIIDDepthSkipToMax;                // kh 13.02.07 tunes the pseudo IID depth for slaves at the root
                                                                  //             if the skip level is reached the final search depth is used next directly 
                                                                  //             (i.e. the IID breaks at that level and skips)
                                                                  // (only used for values > 0)

  int                     nHashTableSizeMB;                       // kh 01.02.07 hash table size in MB

  int                     nMinimumBrothersFinishedRoot;           // kh 01.02.07 minimum number of brothers sequentially finished at the root level
                                                                  // before a parallel distribution of younger brothers is allowed
                                                                  // default for the YBWC is 1

  int                     nMinimumBrothersFinished;               // kh 01.02.07 minimum number of brothers sequentially finished
                                                                  // before a parallel distribution of younger brothers is allowed
                                                                  // default for the YBWC is 1

  int                     nBrothersFinishedTypeCutOffset;         // kh 01.02.07 offset of brothers sequentially finished on a cut node
  int                     nBrothersFinishedTypeAllOffset;         // kh 01.02.07 offset of brothers sequentially finished on a all node
  int                     nBrothersFinishedTypePVOffset;          // kh 01.02.07 offset of brothers sequentially finished on a PV  node

  int                     nMinimumRemoteSearchDepthSameNode;      // kh 30.04.08 minimum remaining search depth for sub problems on the same node
  int                     nMinimumRemoteSearchDepth;              // kh 01.02.07 minimum remaining search depth for sub problems
  int                     nMaximumRemoteSearchDepth;              // kh 08.03.07 maximum remaining search depth for sub problems (0 means no limit)

  int                     nMinimumRemoteSearchHeight;             // kh 13.02.07 minimum search height for sub problems
  int                     nMaximumRemoteSearchHeight;             // kh 13.02.07 maximum search height for sub problems (0 means no limit)

  BOOL                    bUseMultiStepStackSearch;               // kh 12.03.07 true to search the stack several times (i.e. two times at the moment) for sub jobs 
  int                     nMinimumBrothersFinishedRootFirstStep;  // kh 12.03.07 minimum number of brothers sequentially finished at the root level 
                                                                  // before a parallel distribution of younger brothers is allowed
                                                                  // if the stack stack is searched for the first time and bUseMultiStepStackSearch is set to true

  int                     nMinimumBrothersFinishedFirstStep;      // kh 12.03.07 minimum number of brothers sequentially finished 
                                                                  // before a parallel distribution of younger brothers is allowed
                                                                  // if the stack stack is searched for the first time and bUseMultiStepStackSearch is set to true
  
  BOOL                    bUseSynchronizedStackStopEntry;         // kh 19.03.07 true to wait after stopping a stack entry for the slave results for the entry
                                                                  // used for debug purposes at the moment
                                                                  // (reasonably usable only in high speed interconnection networks)

  BOOL                    bAdjustProcessPriority;                 // kh 28.11.07 true to adjust the process priority (i.e. set the process 
                                                                  // priority for all non hash table of a physical machine to "below normal"
                                                                  // the ChessBase GUI has a display update problem (PV info etc.) if running 
                                                                  // on the same physical machine and all cores are used for the 
                                                                  // parallel search
                                                                  // it seems to be a good idea anyway to prioritize indirect other processes 
                                                                  // (e.g. the operating system) that way

  BOOL                    bUseEvent;                              // kh 14.02.08 true to accept uci commands during search

} FruitConfiguration;

FruitConfiguration* FruitConfiguration_Construct(FruitConfiguration* pThis);

void FruitConfiguration_Destruct(FruitConfiguration* pThis);

BOOL FruitConfiguration_ReadConfigurationFile(FruitConfiguration* pThis, char* sFileName);

void FruitConfiguration_UpdateOptions(FruitConfiguration* pThis);

char* FruitConfiguration_BoolToString(FruitConfiguration* pThis, BOOL bValue);

void FruitConfiguration_Dump(FruitConfiguration* pThis);
#endif
