#include "FruitConfiguration.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "option.h"

#include "YBWCManager.h"

FruitConfiguration* FruitConfiguration_Construct(FruitConfiguration* pThis)
{
  pThis->sFileName[0] = '\0';
  strncat(pThis->sFileName, "<UndefinedFileName>", MAX_FRUIT_CONFIGURATION_FILE_NAME);

  pThis->szBoolToString[0]                      = '\0';

  pThis->nFruitDebugLevel                       = 0;

  pThis->bLogToCommonFile                       = FALSE;
  pThis->bLogToFile                             = FALSE;
  pThis->bLogToStdout                           = FALSE;

  pThis->nMaxBufferedRequestCount               = 0;
  pThis->nMaxBufferedResultCount                = 0;

  pThis->nRequestForWorkWaitCounterLimit        = 0;
  pThis->nRequestForWorkWaitCounterToDouble     = 0;
  pThis->nRequestForWorkRepeatBlockFactor       = 1;

  pThis->bSendAdditionalUCIInfo                 = FALSE;

  pThis->nDebugWaitForSlaveRate                 = 0;
  pThis->nDebugWaitForWorkRate                  = 0;
  pThis->nDebugAtWorkRate                       = 0;
  pThis->nDebugAwaitingResultRate               = 0;

  pThis->bForceReproducibleEvaluation           = FALSE;

  pThis->bOnlyDistributeWorkOfRootMaster        = FALSE;
  pThis->bSuppressDistributionOfRootMoves       = FALSE;
  pThis->bSuppressDistributionOfFullSearchMoves = FALSE;
  pThis->bAllowDistributionOfLastMoveInList     = FALSE;

  pThis->bReverseSearchStackDistributionOrder   = FALSE;

  pThis->bUpdateSearchWindows                   = TRUE;
  pThis->bDirectUpdateSearchWindows             = FALSE;

  pThis->nMinimumAlphaImprovementForRerunSearch = 0;
  pThis->nMaximumMovesCompletedForRerunSearch   = 0;
  pThis->nMaximumPercentCompletedForRerunSearch = 0;
  pThis->nMaximumAlphaImprovementCheckCompleted = 0;

  pThis->bBroadcastTranspositionTable           = TRUE;

  pThis->nBroadcastTranspositionTableChunkSize  = 1;
  pThis->bUseSharedMemoryTranspositionTable     = TRUE;

  pThis->bUseSharedMemoryHistoryTable           = TRUE;
  pThis->bSynchronizeHistoryTableAccess         = TRUE;

  pThis->bBroadcastHistoryTable                 = TRUE;
  pThis->nHistoryTableUpdatesToTriggerBroadcast = 1;
  pThis->nHistTotTableUpdatesToTriggerBroadcast = 1;

  pThis->bTransmitKillerTable                   = TRUE;

  pThis->bTransmitHistoryTable                  = FALSE;
  pThis->bTransmitHistTotTable                  = FALSE;

  pThis->nMinimumTransDepthForBroadcast         = 0;

  pThis->bUseHistoryPruning                     = TRUE;

  pThis->bUseIID                                = TRUE;
  pThis->bUseTranspositionTable                 = TRUE;

  pThis->nCheckNb                               = 1;
  pThis->nCheckInc                              = 1;

  pThis->nCheckNbMPIPoll                        = 1;
  pThis->nCheckIncMPIPoll                       = 1;

  pThis->nCleanupActionsInterval                = 1;

  pThis->nTimerActionsInterval01                = 1;

  pThis->bSendKeepAliveChars                    = FALSE;

  pThis->nSlaveStartIIDDepth                    = 0;
  pThis->nSlaveIIDDepthSkipToMax                = 0;

  pThis->nHashTableSizeMB                       = 0;

  pThis->nMinimumBrothersFinishedRoot           = 0;
  pThis->nMinimumBrothersFinished               = 0;
  pThis->nBrothersFinishedTypeCutOffset         = 0;
  pThis->nBrothersFinishedTypeAllOffset         = 0;
  pThis->nBrothersFinishedTypePVOffset          = 0;

  pThis->nMinimumRemoteSearchDepthSameNode      = 0;
  pThis->nMinimumRemoteSearchDepth              = 0;
  pThis->nMaximumRemoteSearchDepth              = 0;

  pThis->nMinimumRemoteSearchHeight             = 0;
  pThis->nMaximumRemoteSearchHeight             = 0;
  
  pThis->bUseMultiStepStackSearch               = FALSE;
  pThis->nMinimumBrothersFinishedRootFirstStep  = 0;
  pThis->nMinimumBrothersFinishedFirstStep      = 0;

  pThis->bUseSynchronizedStackStopEntry         = FALSE;

  pThis->bAdjustProcessPriority                 = FALSE;

  pThis->bUseEvent                              = FALSE;
  
  return pThis;
}

void FruitConfiguration_Destruct(FruitConfiguration* pThis)
{
  if(pThis)
  {
    free(pThis);
  }
}

BOOL FruitConfiguration_ReadConfigurationFile(FruitConfiguration* pThis, char* sFileName)
{
  BOOL  bResult = FALSE;

  pThis->sFileName[0] = '\0';
  strncat(pThis->sFileName, sFileName, MAX_FRUIT_CONFIGURATION_FILE_NAME);

// kh 04.08.06 future expansion: read configuration from file or get it e.g. via the command line arguments
  pThis->nFruitDebugLevel                       = DEFAULT_FRUIT_DEBUG_LEVEL;

  pThis->bLogToCommonFile                       = DEFAULT_LOG_TO_COMMON_FILE;
  pThis->bLogToFile                             = DEFAULT_LOG_TO_FILE;
  pThis->bLogToStdout                           = DEFAULT_LOG_TO_STDOUT;

  pThis->nMaxBufferedRequestCount               = DEFAULT_MAX_BUFFERED_REQUEST_COUNT;
  pThis->nMaxBufferedResultCount                = DEFAULT_MAX_BUFFERED_RESULT_COUNT;

  pThis->nRequestForWorkWaitCounterLimit        = DEFAULT_REQUEST_FOR_WORK_WAIT_COUNTER_LIMIT;
  pThis->nRequestForWorkWaitCounterToDouble     = DEFAULT_REQUEST_FOR_WORK_WAIT_COUNTER_TO_DOUBLE;
  pThis->nRequestForWorkRepeatBlockFactor       = DEFAULT_REQUEST_FOR_WORK_REPEAT_BLOCK_FACTOR;

  pThis->bSendAdditionalUCIInfo                 = DEFAULT_SEND_ADDITIONAL_UCI_INFO;

  pThis->nDebugWaitForSlaveRate                 = DEFAULT_DEBUG_WAIT_FOR_SLAVE_RATE;
  pThis->nDebugWaitForWorkRate                  = DEFAULT_DEBUG_WAIT_FOR_WORK_RATE;
  pThis->nDebugAtWorkRate                       = DEFAULT_DEBUG_AT_WORK_RATE;
  pThis->nDebugAwaitingResultRate               = DEFAULT_DEBUG_AWAITING_RESULT_RATE;

  pThis->bForceReproducibleEvaluation           = DEFAULT_FORCE_REPRODUCIBLE_EVALUATION;

  pThis->bOnlyDistributeWorkOfRootMaster        = DEFAULT_ONLY_DISTRIBUTE_WORK_OF_ROOT_MASTER;
  pThis->bSuppressDistributionOfRootMoves       = DEFAULT_SUPPRESS_DISTRIBUTION_OF_ROOT_MOVES;
  pThis->bSuppressDistributionOfFullSearchMoves = DEFAULT_SUPPRESS_DISTRIBUTION_OF_FULL_SEARCH_MOVES;
  pThis->bAllowDistributionOfLastMoveInList     = DEFAULT_ALLOW_DISTRIBUTION_OF_LAST_MOVE_IN_LIST;

  pThis->bReverseSearchStackDistributionOrder   = DEFAULT_REVERSE_SEARCH_STACK_DISTRIBUTION_ORDER;

  pThis->bUpdateSearchWindows                   = DEFAULT_UPDATE_SEARCH_WINDOWS;
  pThis->bDirectUpdateSearchWindows             = DEFAULT_DIRECT_UPDATE_SEARCH_WINDOWS;

  pThis->nMinimumAlphaImprovementForRerunSearch = DEFAULT_MINIMUM_ALPHA_IMPROVEMENT_FOR_RERUN_SEARCH;
  pThis->nMaximumMovesCompletedForRerunSearch   = DEFAULT_MAXIMUM_MOVES_COMPLETED_FOR_RERUN_SEARCH;
  pThis->nMaximumPercentCompletedForRerunSearch = DEFAULT_MAXIMUM_PERCENT_COMPLETED_FOR_RERUN_SEARCH;
  pThis->nMaximumAlphaImprovementCheckCompleted = DEFAULT_MAXIMUM_ALPHA_IMPROVEMENT_CHECK_COMPLETED;

  pThis->bBroadcastTranspositionTable           = DEFAULT_BROADCAST_TRANSPOSITION_TABLE;
  pThis->nBroadcastTranspositionTableChunkSize  = DEFAULT_BROADCAST_TRANSPOSITION_TABLE_CHUNK_SIZE;
  pThis->nMinimumTransDepthForBroadcast         = DEFAULT_MINIMUM_TRANS_DEPTH_FOR_BROADCAST;

  pThis->bUseSharedMemoryTranspositionTable     = DEFAULT_USE_SHARED_MEMORY_TRANSPOSITION_TABLE;

  pThis->bUseSharedMemoryHistoryTable           = DEFAULT_USE_SHARED_MEMORY_HISTORY_TABLE;
  pThis->bSynchronizeHistoryTableAccess         = DEFAULT_SYNCHRONIZE_HISTORY_TABLE_ACCESS;

  pThis->bBroadcastHistoryTable                 = DEFAULT_BROADCAST_HISTORY_TABLE;
  pThis->nHistoryTableUpdatesToTriggerBroadcast = DEFAULT_HISTORY_TABLE_UPDATES_TO_TRIGGER_BROADCAST;
  pThis->nHistTotTableUpdatesToTriggerBroadcast = DEFAULT_HIST_TOT_TABLE_UPDATES_TO_TRIGGER_BROADCAST;

  pThis->bTransmitKillerTable                   = DEFAULT_TRANSMIT_KILLER_TABLE;

  pThis->bTransmitHistoryTable                  = DEFAULT_TRANSMIT_HISTORY_TABLE;
  pThis->bTransmitHistTotTable                  = DEFAULT_TRANSMIT_HIST_TOT_TABLE;

  pThis->bUseHistoryPruning                     = DEFAULT_USE_HISTORY_PRUNING;

  pThis->bUseIID                                = DEFAULT_USE_IID;
  pThis->bUseTranspositionTable                 = DEFAULT_USE_TRANSPOSITION_TABLE;

  pThis->nCheckNb                               = DEFAULT_CHECK_NB;
  pThis->nCheckInc                              = DEFAULT_CHECK_INC;

  pThis->nCheckNbMPIPoll                        = DEFAULT_CHECK_NB_MPI_POLL;
  pThis->nCheckIncMPIPoll                       = DEFAULT_CHECK_INC_MPI_POLL;

  pThis->nCleanupActionsInterval                = DEFAULT_CLEANUP_ACTIONS_INTERVAL;

  pThis->nTimerActionsInterval01                = DEFAULT_TIMER_ACTIONS_INTERVAL_01;

  pThis->bSendKeepAliveChars                    = DEFAULT_SEND_KEEP_ALIVE_CHARS;

  pThis->nSlaveStartIIDDepth                    = DEFAULT_SLAVE_START_IID_DEPTH;
  pThis->nSlaveIIDDepthSkipToMax                = DEFAULT_SLAVE_IID_DEPTH_SKIP_TO_MAX; 

// kh 12.02.08 use standard uci options now
/*
  pThis->nHashTableSizeMB                       = DEFAULT_HASH_TABLE_SIZE_MB;
*/

  pThis->nMinimumBrothersFinishedRoot           = DEFAULT_MINIMUM_BROTHERS_FINISHED_ROOT;
  pThis->nMinimumBrothersFinished               = DEFAULT_MINIMUM_BROTHERS_FINISHED;
  pThis->nBrothersFinishedTypeCutOffset         = DEFAULT_BROTHERS_FINISHED_TYPE_CUT_OFFSET;
  pThis->nBrothersFinishedTypeAllOffset         = DEFAULT_BROTHERS_FINISHED_TYPE_ALL_OFFSET;
  pThis->nBrothersFinishedTypePVOffset          = DEFAULT_BROTHERS_FINISHED_TYPE_PV_OFFSET;

  pThis->nMinimumRemoteSearchDepthSameNode      = DEFAULT_MINIMUM_REMOTE_SEARCH_DEPTH_SAME_NODE;
  pThis->nMinimumRemoteSearchDepth              = DEFAULT_MINIMUM_REMOTE_SEARCH_DEPTH;
  pThis->nMaximumRemoteSearchDepth              = DEFAULT_MAXIMUM_REMOTE_SEARCH_DEPTH;

  pThis->nMinimumRemoteSearchHeight             = DEFAULT_MINIMUM_REMOTE_SEARCH_HEIGHT;
  pThis->nMaximumRemoteSearchHeight             = DEFAULT_MAXIMUM_REMOTE_SEARCH_HEIGHT;

  pThis->bUseMultiStepStackSearch               = DEFAULT_USE_MULTI_STEP_STACK_SEARCH;
  pThis->nMinimumBrothersFinishedRootFirstStep  = DEFAULT_MINIMUM_BROTHERS_FINISHED_ROOT_FIRST_STEP;
  pThis->nMinimumBrothersFinishedFirstStep      = DEFAULT_MINIMUM_BROTHERS_FINISHED_FIRST_STEP;

  pThis->bUseSynchronizedStackStopEntry         = DEFAULT_USE_SYNCHRONIZED_STACK_STOP_ENTRY;

  pThis->bAdjustProcessPriority                 = DEFAULT_ADJUST_PROCESS_PRIORITY;

  pThis->bUseEvent                              = DEFAULT_USE_EVENT;

// ------------------------------ start of manual configuration override ------------------------------

// kh 14.02.08 future expansion: read configuration from file or get it e.g. via the command line arguments

//pThis->nFruitDebugLevel                       = FRUIT_DEBUG_LEVEL_INFO_PRIO_LAST;

//pThis->bLogToCommonFile                       = FALSE;
  pThis->bLogToFile                             = FALSE;
  pThis->bLogToStdout                           = FALSE;

//pThis->nMaxBufferedRequestCount               = 32;
//pThis->nMaxBufferedResultCount                = 32;

//pThis->nRequestForWorkWaitCounterLimit        = 3000;
//pThis->nRequestForWorkWaitCounterToDouble     = 50;
//pThis->nRequestForWorkRepeatBlockFactor       = 20;

//pThis->bSendAdditionalUCIInfo                 = FALSE;

//pThis->nDebugWaitForSlaveRate                 = 1000;
//pThis->nDebugWaitForWorkRate                  = 50;
//pThis->nDebugAtWorkRate                       = 5000;
//pThis->nDebugAwaitingResultRate               = 4000;
  
//pThis->bForceReproducibleEvaluation           = TRUE;

//pThis->bOnlyDistributeWorkOfRootMaster        = TRUE;
//pThis->bSuppressDistributionOfRootMoves       = TRUE;
//pThis->bSuppressDistributionOfFullSearchMoves = TRUE;
//pThis->bAllowDistributionOfLastMoveInList     = TRUE;

//pThis->bReverseSearchStackDistributionOrder   = TRUE;

//pThis->bUpdateSearchWindows                   = FALSE;
//pThis->bDirectUpdateSearchWindows             = TRUE;

//pThis->nMinimumAlphaImprovementForRerunSearch = 50;

//pThis->nMaximumMovesCompletedForRerunSearch   = 0; // kh 24.04.07 0 disables the check

//pThis->nMaximumPercentCompletedForRerunSearch = 0; // kh 27.03.07 0 disables the check

//pThis->nMaximumAlphaImprovementCheckCompleted = 0; // kh 17.03.07 0 disables the check

//pThis->bBroadcastTranspositionTable           = FALSE;
//pThis->nBroadcastTranspositionTableChunkSize  = 16;

//pThis->nMinimumTransDepthForBroadcast         = 4;

//pThis->bUseSharedMemoryTranspositionTable     = TRUE;

//pThis->bUseSharedMemoryHistoryTable           = TRUE;
//pThis->bSynchronizeHistoryTableAccess         = TRUE;

//pThis->bBroadcastHistoryTable                 = TRUE;
//pThis->nHistTotTableUpdatesToTriggerBroadcast = 75;

//pThis->bTransmitKillerTable                   = FALSE;

//pThis->bTransmitHistoryTable                  = FALSE;
//pThis->bTransmitHistTotTable                  = FALSE;

//pThis->bUseHistoryPruning                     = FALSE;

//pThis->bUseIID                                = FALSE;
//pThis->bUseTranspositionTable                 = FALSE;

//pThis->nCheckNb                               = 10000;
//pThis->nCheckInc                              = 10000;

//pThis->nCheckNbMPIPoll                        = 50;
//pThis->nCheckIncMPIPoll                       = 50;

//pThis->nCleanupActionsInterval                = 2000;

//pThis->nTimerActionsInterval01                = 3000;

//pThis->bSendKeepAliveChars                    = TRUE;

// kh 01.02.07 negative values are used as relative IID start depth for sub problems
//pThis->nSlaveStartIIDDepth                    = -2; 
//pThis->nSlaveStartIIDDepth                    = 1;

//pThis->nSlaveIIDDepthSkipToMax                = 8;

//pThis->nHashTableSizeMB                       = 1024;

//pThis->nMinimumBrothersFinishedRoot           = 8;
//pThis->nMinimumBrothersFinished               = 2;

//pThis->nBrothersFinishedTypeCutOffset         = 4;
 
//pThis->nBrothersFinishedTypeAllOffset         = -1;
//pThis->nBrothersFinishedTypePVOffset          = -1;

//pThis->nMinimumRemoteSearchDepthSameNode      = 2;
  
//pThis->nMinimumRemoteSearchDepth              = 4;

//pThis->nMaximumRemoteSearchDepth              = 12;
//pThis->nMaximumRemoteSearchDepth              = 14;

//pThis->nMinimumRemoteSearchHeight             = 0;
//pThis->nMinimumRemoteSearchHeight             = 3;

//pThis->nMaximumRemoteSearchHeight             = 1;

//pThis->bUseMultiStepStackSearch               = TRUE;
//pThis->nMinimumBrothersFinishedRootFirstStep  = 16;
//pThis->nMinimumBrothersFinishedFirstStep      = 8;

//pThis->bUseSynchronizedStackStopEntry         = TRUE;

//pThis->bAdjustProcessPriority                 = TRUE;

//pThis->bUseEvent                              = FALSE;

// ------------------------------ end of manual configuration override ------------------------------

// kh 01.02.07 check some limits
  if(pThis->nRequestForWorkRepeatBlockFactor < 1)
  {
    pThis->nRequestForWorkRepeatBlockFactor = 1;
  }

  if(pThis->nBroadcastTranspositionTableChunkSize > MAX_HASH_TABLE_BUFFER_SIZE)
  {
    pThis->nBroadcastTranspositionTableChunkSize = MAX_HASH_TABLE_BUFFER_SIZE;
  }

  bResult = TRUE; // kh 21.07.06 force to true at the moment

  return bResult;
}

void FruitConfiguration_UpdateOptions(FruitConfiguration* pThis)
{
  pThis->nFruitDebugLevel                       = option_get_int (OPT_NAME_FRUIT_DEBUG_LEVEL);

  pThis->bLogToCommonFile                       = option_get_bool(OPT_NAME_LOG_TO_COMMON_FILE);
  pThis->bLogToFile                             = option_get_bool(OPT_NAME_LOG_TO_FILE);
  pThis->bLogToStdout                           = option_get_bool(OPT_NAME_LOG_TO_STDOUT);

  pThis->nMaxBufferedRequestCount               = option_get_int (OPT_NAME_MAX_BUFFERED_REQUEST_COUNT);
  pThis->nMaxBufferedResultCount                = option_get_int (OPT_NAME_MAX_BUFFERED_RESULT_COUNT);

  pThis->nRequestForWorkWaitCounterLimit        = option_get_int (OPT_NAME_REQUEST_FOR_WORK_WAIT_COUNTER_LIMIT);
  pThis->nRequestForWorkWaitCounterToDouble     = option_get_int (OPT_NAME_REQUEST_FOR_WORK_WAIT_COUNTER_TO_DOUBLE);
  pThis->nRequestForWorkRepeatBlockFactor       = option_get_int (OPT_NAME_REQUEST_FOR_WORK_REPEAT_BLOCK_FACTOR);

  pThis->bSendAdditionalUCIInfo                 = option_get_bool(OPT_NAME_SEND_ADDITIONAL_UCI_INFO);
  pThis->nDebugWaitForSlaveRate                 = option_get_int (OPT_NAME_DEBUG_WAIT_FOR_SLAVE_RATE);
  pThis->nDebugWaitForWorkRate                  = option_get_int (OPT_NAME_DEBUG_WAIT_FOR_WORK_RATE);
  pThis->nDebugAtWorkRate                       = option_get_int (OPT_NAME_DEBUG_AT_WORK_RATE);
  pThis->nDebugAwaitingResultRate               = option_get_int (OPT_NAME_DEBUG_AWAITING_RESULT_RATE);

  pThis->bForceReproducibleEvaluation           = option_get_bool(OPT_NAME_FORCE_REPRODUCIBLE_EVALUATION);

  pThis->bOnlyDistributeWorkOfRootMaster        = option_get_bool(OPT_NAME_ONLY_DISTRIBUTE_WORK_OF_ROOT_MASTER);
  pThis->bSuppressDistributionOfRootMoves       = option_get_bool(OPT_NAME_SUPPRESS_DISTRIBUTION_OF_ROOT_MOVES);
  pThis->bSuppressDistributionOfFullSearchMoves = option_get_bool(OPT_NAME_SUPPRESS_DISTRIBUTION_OF_FULL_SEARCH_MOVES);
  pThis->bAllowDistributionOfLastMoveInList     = option_get_bool(OPT_NAME_ALLOW_DISTRIBUTION_OF_LAST_MOVE_IN_LIST);

  pThis->bReverseSearchStackDistributionOrder   = option_get_bool(OPT_NAME_REVERSE_SEARCH_STACK_DISTRIBUTION_ORDER);

  pThis->bUpdateSearchWindows                   = option_get_bool(OPT_NAME_UPDATE_SEARCH_WINDOWS);
  pThis->bDirectUpdateSearchWindows             = option_get_bool(OPT_NAME_DIRECT_UPDATE_SEARCH_WINDOWS);
  pThis->nMinimumAlphaImprovementForRerunSearch = option_get_int (OPT_NAME_MINIMUM_ALPHA_IMPROVEMENT_FOR_RERUN_SEARCH);
  pThis->nMaximumMovesCompletedForRerunSearch   = option_get_int (OPT_NAME_MAXIMUM_MOVES_COMPLETED_FOR_RERUN_SEARCH);
  pThis->nMaximumPercentCompletedForRerunSearch = option_get_int (OPT_NAME_MAXIMUM_PERCENT_COMPLETED_FOR_RERUN_SEARCH);
  pThis->nMaximumAlphaImprovementCheckCompleted = option_get_int (OPT_NAME_MAXIMUM_ALPHA_IMPROVEMENT_CHECK_COMPLETED);

  pThis->bBroadcastTranspositionTable           = option_get_bool(OPT_NAME_BROADCAST_TRANSPOSITION_TABLE);
  pThis->nBroadcastTranspositionTableChunkSize  = option_get_int (OPT_NAME_BROADCAST_TRANSPOSITION_TABLE_CHUNK_SIZE);
  pThis->nMinimumTransDepthForBroadcast         = option_get_int (OPT_NAME_MINIMUM_TRANS_DEPTH_FOR_BROADCAST);

  pThis->bUseSharedMemoryTranspositionTable     = option_get_bool(OPT_NAME_USE_SHARED_MEMORY_TRANSPOSITION_TABLE);

  pThis->bUseSharedMemoryHistoryTable           = option_get_bool(OPT_NAME_USE_SHARED_MEMORY_HISTORY_TABLE);
  pThis->bSynchronizeHistoryTableAccess         = option_get_bool(OPT_NAME_SYNCHRONIZE_HISTORY_TABLE_ACCESS);

  pThis->bBroadcastHistoryTable                 = option_get_bool(OPT_NAME_BROADCAST_HISTORY_TABLE);
  pThis->nHistoryTableUpdatesToTriggerBroadcast = option_get_int (OPT_NAME_HISTORY_TABLE_UPDATES_TO_TRIGGER_BROADCAST);
  pThis->nHistTotTableUpdatesToTriggerBroadcast = option_get_int (OPT_NAME_HIST_TOT_TABLE_UPDATES_TO_TRIGGER_BROADCAST);

  pThis->bTransmitKillerTable                   = option_get_bool(OPT_NAME_TRANSMIT_KILLER_TABLE);

  pThis->bTransmitHistoryTable                  = option_get_bool(OPT_NAME_TRANSMIT_HISTORY_TABLE);
  pThis->bTransmitHistTotTable                  = option_get_bool(OPT_NAME_TRANSMIT_HIST_TOT_TABLE);

  pThis->bUseHistoryPruning                     = option_get_bool(OPT_NAME_USE_HISTORY_PRUNING);

  pThis->bUseIID                                = option_get_bool(OPT_NAME_USE_IID);
  pThis->bUseTranspositionTable                 = option_get_bool(OPT_NAME_USE_TRANSPOSITION_TABLE);

  pThis->nCheckNb                               = option_get_int (OPT_NAME_CHECK_NB);
  pThis->nCheckInc                              = option_get_int (OPT_NAME_CHECK_INC);

  pThis->nCheckNbMPIPoll                        = option_get_int (OPT_NAME_CHECK_NB_MPI_POLL);
  pThis->nCheckIncMPIPoll                       = option_get_int (OPT_NAME_CHECK_INC_MPI_POLL);

  pThis->nCleanupActionsInterval                = option_get_int (OPT_NAME_CLEANUP_ACTIONS_INTERVAL);

  pThis->nTimerActionsInterval01                = option_get_int (OPT_NAME_TIMER_ACTIONS_INTERVAL_01);

  pThis->bSendKeepAliveChars                    = option_get_bool(OPT_NAME_SEND_KEEP_ALIVE_CHARS);

  pThis->nSlaveStartIIDDepth                    = option_get_int (OPT_NAME_SLAVE_START_IID_DEPTH);
  pThis->nSlaveIIDDepthSkipToMax                = option_get_int (OPT_NAME_SLAVE_IID_DEPTH_SKIP_TO_MAX);

// kh 12.02.08 use standard uci options now
/*
  pThis->nHashTableSizeMB                       = DEFAULT_HASH_TABLE_SIZE_MB;
*/

  pThis->nMinimumBrothersFinishedRoot           = option_get_int (OPT_NAME_MINIMUM_BROTHERS_FINISHED_ROOT);
  pThis->nMinimumBrothersFinished               = option_get_int (OPT_NAME_MINIMUM_BROTHERS_FINISHED);
  pThis->nBrothersFinishedTypeCutOffset         = option_get_int (OPT_NAME_BROTHERS_FINISHED_TYPE_CUT_OFFSET);
  pThis->nBrothersFinishedTypeAllOffset         = option_get_int (OPT_NAME_BROTHERS_FINISHED_TYPE_ALL_OFFSET);
  pThis->nBrothersFinishedTypePVOffset          = option_get_int (OPT_NAME_BROTHERS_FINISHED_TYPE_PV_OFFSET);

  pThis->nMinimumRemoteSearchDepthSameNode      = option_get_int (OPT_NAME_MINIMUM_REMOTE_SEARCH_DEPTH_SAME_NODE);
  pThis->nMinimumRemoteSearchDepth              = option_get_int (OPT_NAME_MINIMUM_REMOTE_SEARCH_DEPTH);
  pThis->nMaximumRemoteSearchDepth              = option_get_int (OPT_NAME_MAXIMUM_REMOTE_SEARCH_DEPTH);

  pThis->nMinimumRemoteSearchHeight             = option_get_int (OPT_NAME_MINIMUM_REMOTE_SEARCH_HEIGHT);
  pThis->nMaximumRemoteSearchHeight             = option_get_int (OPT_NAME_MAXIMUM_REMOTE_SEARCH_HEIGHT);

  pThis->bUseMultiStepStackSearch               = option_get_bool(OPT_NAME_USE_MULTI_STEP_STACK_SEARCH);
  pThis->nMinimumBrothersFinishedRootFirstStep  = option_get_int (OPT_NAME_MINIMUM_BROTHERS_FINISHED_ROOT_FIRST_STEP);
  pThis->nMinimumBrothersFinishedFirstStep      = option_get_int (OPT_NAME_MINIMUM_BROTHERS_FINISHED_FIRST_STEP);

  pThis->bUseSynchronizedStackStopEntry         = option_get_bool(OPT_NAME_USE_SYNCHRONIZED_STACK_STOP_ENTRY);

  pThis->bAdjustProcessPriority                 = option_get_bool(OPT_NAME_ADJUST_PROCESS_PRIORITY);

  pThis->bUseEvent                              = option_get_bool(OPT_NAME_USE_EVENT);
}

char* FruitConfiguration_BoolToString(FruitConfiguration* pThis, BOOL bValue)
{
  pThis->szBoolToString[0] = '\0';
  if(bValue)
  {
    strncat(pThis->szBoolToString, "true",  MAX_BOOL_TO_STRING);
  }
  else
  {
    strncat(pThis->szBoolToString, "false", MAX_BOOL_TO_STRING);
  }

  return pThis->szBoolToString;
}

void FruitConfiguration_Dump(FruitConfiguration* pThis)
{
  YBWCManager_Printf(YBWCManager_Instance(), "FruitConfiguration:\n");
  YBWCManager_Printf(YBWCManager_Instance(), "sFileName                              = %s\n", pThis->sFileName);

  YBWCManager_Printf(YBWCManager_Instance(), "nFruitDebugLevel                       = %d\n", pThis->nFruitDebugLevel);

  YBWCManager_Printf(YBWCManager_Instance(), "bLogToCommonFile                       = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bLogToCommonFile));
  YBWCManager_Printf(YBWCManager_Instance(), "bLogToFile                             = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bLogToFile));
  YBWCManager_Printf(YBWCManager_Instance(), "bLogToStdout                           = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bLogToStdout));

  YBWCManager_Printf(YBWCManager_Instance(), "nMaxBufferedRequestCount               = %d\n", pThis->nMaxBufferedRequestCount);
  YBWCManager_Printf(YBWCManager_Instance(), "nMaxBufferedResultCount                = %d\n", pThis->nMaxBufferedResultCount);

  YBWCManager_Printf(YBWCManager_Instance(), "nRequestForWorkWaitCounterLimit        = %d\n", pThis->nRequestForWorkWaitCounterLimit);
  YBWCManager_Printf(YBWCManager_Instance(), "nRequestForWorkWaitCounterToDouble     = %d\n", pThis->nRequestForWorkWaitCounterToDouble);
  YBWCManager_Printf(YBWCManager_Instance(), "nRequestForWorkRepeatBlockFactor       = %d\n", pThis->nRequestForWorkRepeatBlockFactor);

  YBWCManager_Printf(YBWCManager_Instance(), "bSendAdditionalUCIInfo                 = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bSendAdditionalUCIInfo));

  YBWCManager_Printf(YBWCManager_Instance(), "nDebugWaitForSlaveRate                 = %d\n", pThis->nDebugWaitForSlaveRate);
  YBWCManager_Printf(YBWCManager_Instance(), "nDebugWaitForWorkRate                  = %d\n", pThis->nDebugWaitForWorkRate);
  YBWCManager_Printf(YBWCManager_Instance(), "nDebugAtWorkRate                       = %d\n", pThis->nDebugAtWorkRate);
  YBWCManager_Printf(YBWCManager_Instance(), "nDebugAwaitingResultRate               = %d\n", pThis->nDebugAwaitingResultRate);

  YBWCManager_Printf(YBWCManager_Instance(), "bForceReproducibleEvaluation           = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bForceReproducibleEvaluation));
  YBWCManager_Printf(YBWCManager_Instance(), "bOnlyDistributeWorkOfRootMaster        = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bOnlyDistributeWorkOfRootMaster));
  YBWCManager_Printf(YBWCManager_Instance(), "bSuppressDistributionOfRootMoves       = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bSuppressDistributionOfRootMoves));
  YBWCManager_Printf(YBWCManager_Instance(), "bSuppressDistributionOfFullSearchMoves = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bSuppressDistributionOfFullSearchMoves));
  YBWCManager_Printf(YBWCManager_Instance(), "bAllowDistributionOfLastMoveInList     = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bAllowDistributionOfLastMoveInList));
  YBWCManager_Printf(YBWCManager_Instance(), "bReverseSearchStackDistributionOrder   = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bReverseSearchStackDistributionOrder));

  YBWCManager_Printf(YBWCManager_Instance(), "bUpdateSearchWindows                   = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bUpdateSearchWindows));
  YBWCManager_Printf(YBWCManager_Instance(), "bDirectUpdateSearchWindows             = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bDirectUpdateSearchWindows));
  YBWCManager_Printf(YBWCManager_Instance(), "nMinimumAlphaImprovementForRerunSearch = %d\n", pThis->nMinimumAlphaImprovementForRerunSearch);

  YBWCManager_Printf(YBWCManager_Instance(), "nMaximumMovesCompletedForRerunSearch   = %d\n", pThis->nMaximumMovesCompletedForRerunSearch);
  YBWCManager_Printf(YBWCManager_Instance(), "nMaximumPercentCompletedForRerunSearch = %d\n", pThis->nMaximumPercentCompletedForRerunSearch);
  YBWCManager_Printf(YBWCManager_Instance(), "nMaximumAlphaImprovementCheckCompleted = %d\n", pThis->nMaximumAlphaImprovementCheckCompleted);

  YBWCManager_Printf(YBWCManager_Instance(), "bBroadcastTranspositionTable           = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bBroadcastTranspositionTable));
  YBWCManager_Printf(YBWCManager_Instance(), "nBroadcastTranspositionTableChunkSize  = %d\n", pThis->nBroadcastTranspositionTableChunkSize);
  YBWCManager_Printf(YBWCManager_Instance(), "nMinimumTransDepthForBroadcast         = %d\n", pThis->nMinimumTransDepthForBroadcast);

  YBWCManager_Printf(YBWCManager_Instance(), "bUseSharedMemoryTranspositionTable     = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bUseSharedMemoryTranspositionTable));
  YBWCManager_Printf(YBWCManager_Instance(), "bUseSharedMemoryHistoryTable           = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bUseSharedMemoryHistoryTable));
  YBWCManager_Printf(YBWCManager_Instance(), "bSynchronizeHistoryTableAccess         = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bSynchronizeHistoryTableAccess));

  YBWCManager_Printf(YBWCManager_Instance(), "bBroadcastHistoryTable                 = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bBroadcastHistoryTable));
  YBWCManager_Printf(YBWCManager_Instance(), "nHistoryTableUpdatesToTriggerBroadcast = %d\n", pThis->nHistoryTableUpdatesToTriggerBroadcast);
  YBWCManager_Printf(YBWCManager_Instance(), "nHistTotTableUpdatesToTriggerBroadcast = %d\n", pThis->nHistTotTableUpdatesToTriggerBroadcast );

  YBWCManager_Printf(YBWCManager_Instance(), "bTransmitKillerTable                   = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bTransmitKillerTable));

  YBWCManager_Printf(YBWCManager_Instance(), "bTransmitHistoryTable                  = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bTransmitHistoryTable));
  YBWCManager_Printf(YBWCManager_Instance(), "bTransmitHistTotTable                  = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bTransmitHistTotTable));

  YBWCManager_Printf(YBWCManager_Instance(), "bUseHistoryPruning                     = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bUseHistoryPruning));

  YBWCManager_Printf(YBWCManager_Instance(), "bUseIID                                = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bUseIID));
  YBWCManager_Printf(YBWCManager_Instance(), "bUseTranspositionTable                 = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bUseTranspositionTable));

  YBWCManager_Printf(YBWCManager_Instance(), "nCheckNb                               = %d\n", pThis->nCheckNb);
  YBWCManager_Printf(YBWCManager_Instance(), "nCheckInc                              = %d\n", pThis->nCheckInc);

  YBWCManager_Printf(YBWCManager_Instance(), "nCheckNbMPIPoll                        = %d\n", pThis->nCheckNbMPIPoll);
  YBWCManager_Printf(YBWCManager_Instance(), "nCheckIncMPIPoll                       = %d\n", pThis->nCheckIncMPIPoll);

  YBWCManager_Printf(YBWCManager_Instance(), "nCleanupActionsInterval                = %d\n", pThis->nCleanupActionsInterval);

  YBWCManager_Printf(YBWCManager_Instance(), "nTimerActionsInterval01                = %d\n", pThis->nTimerActionsInterval01);
  YBWCManager_Printf(YBWCManager_Instance(), "bSendKeepAliveChars                    = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bSendKeepAliveChars));
  
  YBWCManager_Printf(YBWCManager_Instance(), "nSlaveStartIIDDepth                    = %d\n", pThis->nSlaveStartIIDDepth);
  YBWCManager_Printf(YBWCManager_Instance(), "nSlaveIIDDepthSkipToMax                = %d\n", pThis->nSlaveIIDDepthSkipToMax);

  YBWCManager_Printf(YBWCManager_Instance(), "nHashTableSizeMB                       = %d\n", pThis->nHashTableSizeMB);

  YBWCManager_Printf(YBWCManager_Instance(), "nMinimumBrothersFinishedRoot           = %d\n", pThis->nMinimumBrothersFinishedRoot);
  YBWCManager_Printf(YBWCManager_Instance(), "nMinimumBrothersFinished               = %d\n", pThis->nMinimumBrothersFinished);
  YBWCManager_Printf(YBWCManager_Instance(), "nBrothersFinishedTypeCutOffset         = %d\n", pThis->nBrothersFinishedTypeCutOffset);
  YBWCManager_Printf(YBWCManager_Instance(), "nBrothersFinishedTypeAllOffset         = %d\n", pThis->nBrothersFinishedTypeAllOffset);
  YBWCManager_Printf(YBWCManager_Instance(), "nBrothersFinishedTypePVOffset          = %d\n", pThis->nBrothersFinishedTypePVOffset);

  YBWCManager_Printf(YBWCManager_Instance(), "nMinimumRemoteSearchDepthSameNode      = %d\n", pThis->nMinimumRemoteSearchDepthSameNode);
  YBWCManager_Printf(YBWCManager_Instance(), "nMinimumRemoteSearchDepth              = %d\n", pThis->nMinimumRemoteSearchDepth);
  YBWCManager_Printf(YBWCManager_Instance(), "nMaximumRemoteSearchDepth              = %d\n", pThis->nMaximumRemoteSearchDepth);

  YBWCManager_Printf(YBWCManager_Instance(), "nMinimumRemoteSearchHeight             = %d\n", pThis->nMinimumRemoteSearchHeight);
  YBWCManager_Printf(YBWCManager_Instance(), "nMaximumRemoteSearchHeight             = %d\n", pThis->nMaximumRemoteSearchHeight);

  YBWCManager_Printf(YBWCManager_Instance(), "bUseMultiStepStackSearch               = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bUseMultiStepStackSearch));
  YBWCManager_Printf(YBWCManager_Instance(), "nMinimumBrothersFinishedRootFirstStep  = %d\n", pThis->nMinimumBrothersFinishedRootFirstStep);
  YBWCManager_Printf(YBWCManager_Instance(), "nMinimumBrothersFinishedFirstStep      = %d\n", pThis->nMinimumBrothersFinishedFirstStep);

  YBWCManager_Printf(YBWCManager_Instance(), "bUseSynchronizedStackStopEntry         = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bUseSynchronizedStackStopEntry));

  YBWCManager_Printf(YBWCManager_Instance(), "bAdjustProcessPriority                 = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bAdjustProcessPriority));

  YBWCManager_Printf(YBWCManager_Instance(), "bUseEvent                              = %s\n", FruitConfiguration_BoolToString(pThis, pThis->bUseEvent));

  YBWCManager_Printf(YBWCManager_Instance(), " \n");
}
