#ifndef COUNTDOWNTIMER_H
#define COUNTDOWNTIMER_H

#include "stdmpi.h" 

typedef struct 
{
  double       dStartTime;
  unsigned int nCountdownTime;  // kh 03.07.04 milliseconds
  BOOL         bRunning;
  BOOL         bAutoRestart;
} CountdownTimer;

CountdownTimer* CountdownTimer_Construct(CountdownTimer* pThis, unsigned int nCountdownTime);

void CountdownTimer_Destruct(CountdownTimer* pThis);

double CountdownTimer_GetTickCount(CountdownTimer* pThis);

void CountdownTimer_Wait(CountdownTimer* pThis);
void CountdownTimer_Restart(CountdownTimer* pThis);
void CountdownTimer_WaitAndRestart(CountdownTimer* pThis);
BOOL CountdownTimer_IsRunning(CountdownTimer* pThis);
void CountdownTimer_StopRunning(CountdownTimer* pThis);
void CountdownTimer_SetAutoRestart(CountdownTimer* pThis, BOOL bAutoRestart);

#endif
