#ifndef COMMANDLINE_H
#define COMMANDLINE_H

#include "stdmpi.h"

#include "FruitBase.h"

#include "argtable2.h"

#define ARGTABLE_SIZE 6

typedef struct
{
  int*    pargc;
  char*** pargv;

  struct  arg_int* nPosition;
  struct  arg_int* nDepth;
  struct  arg_int* nMoveTime;
  struct  arg_lit* help;
  struct  arg_lit* version;
  struct  arg_end* end;

//void*   argtable[] = {position, d, help, version, end};
  void*   argtable[ARGTABLE_SIZE];

//const char* progname = "ClusterToga";
  char*   progname;

  int     nExitCode;

  BOOL    bExitRequest;

} CommandLine;

CommandLine* CommandLine_Construct(CommandLine* pThis, int* pargc, char*** pargv);

void CommandLine_Destruct(CommandLine* pThis);

BOOL CommandLine_Parse(CommandLine* pThis);

void CommandLine_Dump(CommandLine* pThis);
#endif
