#ifndef AUTOTESTER_H
#define AUTOTESTER_H

#include "stdmpi.h"

#include "CommandLine.h"

#define MAX_UCI_STRINGS     8192

#define MAX_START_POSITIONS   33

typedef struct
{
  BOOL          bAutoTest;

  int           nUCIStringCount;
  char*         sUCIStrings[MAX_UCI_STRINGS];

  int           nUCIStringIndex;

  int           nStartPositionCount;
  char*         startpositions[MAX_START_POSITIONS];

} AutoTester;

AutoTester* AutoTester_Construct(AutoTester* pThis);

void AutoTester_Destruct(AutoTester* pThis);

BOOL AutoTester_CommandLineToTests(AutoTester* pThis, CommandLine*  pCommandLine);

void AutoTester_Dump(AutoTester* pThis);

char* AutoTester_GetNextUCIString(AutoTester* pThis);

#endif
