//    Copyright 2009 Antonio Torrecillas Gonzalez
//
//    This file is part of Rocinante.
//
//    Rocinante is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    Rocinante is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Rocinante.  If not, see <http://www.gnu.org/licenses/>
//

#include <stdio.h>
#include <stdlib.h>

#include <string.h>
#include "Ajedrez.h"
#include "Uci.h"
#define E_INVALIDARG	-1

#include "TreeNode.h"
#include "SmpManager.h"
SmpManager SmpWorkers;

CPartida Partida;

/*********************************************************************
**
Cuatro das se le pasaron en imaginar qu nombre le podra: porque, 
segn se deca l a s mismo, no era razn que caballo de caballero tan famoso, 
y tan bueno l por s, estuviese sin nombre conocido; 
y as procuraba acomodrsele, de manera que declarase quien haba sido, 
antes que fuese de caballero andante, y lo que era entonces: 
pues estaba muy puesto en razn, que mudando su seor estado, 
mudase l tambin el nombre; y le cobrase famoso y de estruendo, 
como convena a la nueva orden y al nuevo ejercicio que ya profesaba: 
y as despus de muchos nombres que form, borr y quit, aadi, 
deshizo y torn a hacer en su memoria e imaginacin, 
al fin le vino a llamar ROCINANTE, nombre a su parecer alto, 
sonoro y significativo de lo que haba sido cuando fue rocn, 
antes de lo que ahora era, que era antes y primero de todos los rocines del mundo. 
**
Four days were spent in thinking what name to give him, 
because (as he said to himself) it was not right that a horse 
belonging to a knight so famous, and one with such merits of his own,
should be without some distinctive name, 
and he strove to adapt it so as to indicate what he had been before belonging 
to a knight-errant, and what he then was; for it was only reasonable that, 
his master taking a new character, he should take a new name, 
and that it should be a distinguished and full-sounding one, 
befitting the new order and calling he was about to follow. And so, 
after having composed, struck out, rejected, added to, unmade, 
and remade a multitude of names out of his memory and fancy, 
he decided upon calling him Rocinante, a name, to his thinking, 
lofty, sonorous, and significant of his condition as a hack before 
he became what he now was, the first and foremost of all the hacks in the world. 
**
** Miguel de Cervantes.
*/

/*********************************************************************
** No Hash + Zobrist Code.
** UFO Evaluation.
** no tablebase.
** SMP. Naive Implementation for windows, not coded for Linux/Unix/Posix
** Not Optimized.
** Bitboard engine. Kinder Garten.
** Some Debugging/test code: perft,DumpTree, pgnparse, pgn2epd, epd, test, testsimetria...
**
** All non standard feature are acceded with debug prefix in UCI protocol.
**
*/

/*********************************************************************
** Lazy Cloning Guide (lazy writed)
** Add init code on main.cpp
** on JobWorker.cpp JobWorker::DoJob plug your own search engine
** you have on node->fen the position, you just need to return the evaluation
** and the optimist evaluation.
** look also JobWorker::GetOptVal and JobWorker::GetRealVal
** good luck.
*/

/**********************************************************************
** Main: inicializa, reparte el curro y procesa la entrada
*/
int main(int argc, char **argv)
{

	CUci *protocol = new CUci();	
    protocol->start();
	delete protocol;

	// Stop all things
	SmpWorkers.StopWorkers();
	while(!SmpWorkers.AllStopped())SmpWorkers.Sleep();
	return 0;
}
