//    Copyright 2009 Antonio Torrecillas Gonzalez
//
//    This file is part of Rocinante.
//
//    Rocinante is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    Rocinante is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Rocinante.  If not, see <http://www.gnu.org/licenses/>
//

#include "stdio.h"
#include "stdlib.h"
#include "memory.h"
#include "string.h"
#include <time.h>

#include "epd.h"
#include "Ajedrez.h"

#include "Oracle.h"

#include "TreeNode.h"
#include "BStar.h"


/*
*	Clase base para distintos tests
*	Esta clase se encarga de recorrer las posiciones de un archivo epd 
*   y cargando estas en el tablero.
*	Una funcin virtual TestPos se encarga de analizar la posicion alcanzada.
*/


CEpd::CEpd()
{
}
CEpd::~CEpd()
{
}

bool CEpd::AbreArchivos()
{
	fi = fo = fsi = fno = NULL;
		// abrir el archivo
	fi = fopen(epdfile,"r");
	if(fi)
	{
		fo = fopen("./testepd.txt","w+");
		fsi = fopen("./si.txt","w+");
		fno = fopen("./no.txt","w+");
		if(fo)
		{
			struct tm *newtime;
			time_t aclock;
			time( &aclock_ini);
			time( &aclock );   // Get time in seconds
			newtime = localtime( &aclock );   // Convert time to struct tm form

			fprintf(fo,"Test %s\n",epdfile);
			fprintf(fo,"Fecha %s\n",asctime(newtime));
			fflush(fo);
		}

		return true;
	}
	return false;
}
void CEpd::CierraArchivos()
{
	struct tm *newtime;
	if(!fi) return;
	time( &aclock );   // Get time in seconds
	newtime = localtime( &aclock );   // Convert time to struct tm form

	fprintf(fo,"Resumen Test %s\n",epdfile);
	fprintf(fo,"Fecha %s\n",asctime(newtime));
	fprintf(fo,"Tiempo %ld\n",aclock-aclock_ini);
	fprintf(fo,"Branch Factor %f\n",BFMedio/(test_aciertos+test_fallos));
	fflush(fo);
	if((test_aciertos+test_fallos))
		fprintf(fo,"\nTotal %d aciertos %d fallos => %2d%% \n",test_aciertos,test_fallos,(test_aciertos*100)/(test_aciertos+test_fallos));
	if((aclock-aclock_ini) == 0)
		aclock = aclock_ini+1;
	fprintf(fo,"\nNodes %d nps %ld\n",NodeCount,NodeCount /(aclock-aclock_ini));
	Print("\nNodes %d nps %d \n",NodeCount ,NodeCount /(aclock-aclock_ini));
	TestAciertos = test_aciertos;
	TestNodeCount = NodeCount;
	fclose(fsi);
	fclose(fno);
	fclose(fo);
	fclose(fi);
	extern void DumpNodesFaseDepth();
}

void CEpd::SeparaLineaEpd()
{
	int blancos;
	// buscar el ';' atras hasta un ' '
	memset(Epd,0,sizeof(Epd));
	memset(Solucion,0,sizeof(Solucion));
	blancos = 0;
	aux = Test;

	bm = strstr(aux,"bm")!= NULL;
	if(bm)
	{
		aux = strstr(Test,"bm");
		strncpy(Epd,Test,aux-Test);
	}
	else
	{
		aux = strstr(Test,"am");
		strncpy(Epd,Test,aux-Test);
	}
	aux++;
	aux++;
	aux++;
	i = 0;
	while(*aux == ' ')
		aux++;
	while(*aux != ';' && *aux != '\r' && *aux != '\n' && *aux != '\0')
	{
		if(*aux != '-')
		{
			Solucion[i++] = *aux++;
		}
		else
			aux++;
	}
	// eliminamos el \n final
	while(*aux != '\0')aux++;
	aux--;
	*aux = '\0';

	// carga y prueba del test
	Partida.Nueva();
	Partida.Taux.LoadEPD(Epd,0);
	PrintLog(Test);

	// obtener la solucion en formato algebraico.
	Partida.Taux.CalculaJugadasPosibles();
	aux = strtok(Solucion," ;");
	i = Partida.Taux.IdentificaPgn(Solucion);
	strcpy(SolucionAlg[0],Partida.Taux.JugadasPosibles[i-1].ToString());
	aux = strtok(NULL," ;");
	{
		// quitamos el + final si lo hay
		char *aux = SolucionAlg[0];
		while(*aux)
		{
			if(*aux == '+')
				*aux = '\0';
			aux++;
		}
	}
	SolucionAlg[1][0] = '\0';
	if(aux && *aux != ' ')
	{
		i = Partida.Taux.IdentificaPgn(aux);
		strcpy(SolucionAlg[1],Partida.Taux.JugadasPosibles[i-1].ToString());
		{
			// quitamos el + final si lo hay
			char *aux = SolucionAlg[1];
			while(*aux)
			{
				if(*aux == '+')
					*aux = '\0';
				aux++;
			}
		}
	}


	aux = strtok(NULL," ;");
	SolucionAlg[2][0] = '\0';
	if(aux && *aux != ' ')
	{
		i = Partida.Taux.IdentificaPgn(aux);
		strcpy(SolucionAlg[2],Partida.Taux.JugadasPosibles[i-1].ToString());
		{
			// quitamos el + final si lo hay
			char *aux = SolucionAlg[2];
			while(*aux)
			{
				if(*aux == '+')
					*aux = '\0';
				aux++;
			}
		}
	}
}

const int UseBStar = true;


bool CEpd::ProcesaTestEpd()
{
	if(UseBStar)
	{
		BStar Bt;
		if(profundidad && profundidad < 25)
			Bt.SetProbeDepth(profundidad);
		Bt.TotalExpand = 0;
	   char dest[100];
	   Partida.Taux.SaveFEN(&dest[0]);
		Bt.Run(dest);
		NodeCount += Bt.TotalExpand;
		ProbeCount += Bt.TotalProbes; 
		ExpandToSolve = Bt.LastChange;
	}
	else
	{
		if(true)
		{
			if(profundidad && profundidad < 25)
				Partida.LimiteProfundidad = profundidad;
			Partida.IterativeDeepening();
		}
		else
		{
			Partida.JugadaActual[0] = '\0';
			Delphos.Initialize(Partida.Taux);
			Partida.Taux.FullEval();
			Partida.tiempo_limite = 0;
			Partida.cancelado = false;
			Partida.ResetHistory();
			int v = Partida.RootPVS(profundidad ,-MATE,MATE);
		}
		NodeCount += Partida.NodosVisitados;
	}
	// es OK
	// quitamos el + final si lo hay
	char *aux = Partida.JugadaActual;
	if(*aux == '\0')
		return false;
	while(*aux)
	{
		if(*aux == '+')
			*aux = '\0';
		aux++;
	}
	if(bm)
	{

		return !((strcmp(SolucionAlg[0],Partida.JugadaActual)!=0 )	&& 
			(strcmp(SolucionAlg[1],Partida.JugadaActual)!=0 )		&&
			(strcmp(SolucionAlg[2],Partida.JugadaActual)!=0 ) 		);

	}
	else
	{	// avoid move
		return ((strcmp(SolucionAlg[0],Partida.JugadaActual)!=0 )	&& 
			(strcmp(SolucionAlg[1],Partida.JugadaActual)!=0 )		&&
			(strcmp(SolucionAlg[2],Partida.JugadaActual)!=0 ) 		);
	}
	return false;
}

void CEpd::Start()
{
	extern void Print(const char *fmt, ...);
	extern int UseLog;
	aclock_ini = 0;	aclock = 0;	Dm = 0; // depth media
	NodeCount = 0;	BFMedio = 0; ProbeCount = 0;
	test_aciertos = 0;	test_fallos = 0;
	DontPrintToLog = 0;UseLog = 0;

	if(!epdfile)return;

	Partida.tiempo_limite = 0; 
	Partida.LimiteProfundidad = 0;

	if(profundidad && profundidad < 25)
	{
		Partida.LimiteProfundidad = profundidad; 
	}
#ifdef _DEBUG
	UseLog = 1;
#endif
	if(tiempo)
	{
      Partida.tiempo_limite = tiempo;
    }


	score = 0;
	if(AbreArchivos())
	{
	// cada linea es un test individual
		while(fgets(Test,sizeof(Test),fi))
		{
			if(Test[0] == '\r')
				break;
			if(Test[0] == '\n')
				break;
			if(Test[0] == ';') // saltamos los comentarios
			{
				PrintLog(Test);
				continue;
			}
			// separa epd de la solucion
			SeparaLineaEpd();
			Print("PARCIAL %d - %d\n",test_aciertos,test_fallos);
			if(Test[0] == '\0')
				break;
			Print(Test);
			Print("\n");
			// analizar
			if(ProcesaTestEpd())
			{
				// test positivo
				fprintf(fsi,"%s\n",Test);
				fflush(fsi);
				test_aciertos++;
				score += 500 - ExpandToSolve;
			}
			else
			{
				// test negativo
				test_fallos++;
				fprintf(fno,"%s\n",Test);
				fflush(fno);
			}
			Test[0] = '\0';
		}
	}
	CierraArchivos();
	Print("Test Finalizado %d - %d %f score %d t=%d\n",test_aciertos,test_fallos,(test_aciertos*1.0)/(1.0*(test_aciertos+test_fallos)),score,aclock-aclock_ini);
	DontPrintToLog = 0;

}
