//
//    Bitboard with Kinder Garten approach by Gerd Isemberg.
//    See chess Programming for more details
//    http://chessprogramming.wikispaces.com/ 
//


#include "Ajedrez.h"

/*
    directions and shifts
    +-----+-----+-----+
    |<<= 7|<<= 8|<<= 9|
    +-----+-----+-----+
    |<<= 1|     |>>= 1|
    +-----+-----+-----+
    |>>= 9|>>= 8|>>= 7|
    +-----+-----+-----+

    We use this mapping of the normal board squares to bitboard bits
    +-------------------------+
    | 56 57 58 59 60 61 62 63 | 8
    | 48 49 50 51 52 53 54 55 | 7
    | 40 41 42 43 44 45 46 47 | 6
    | 32 33 34 35 36 37 38 39 | 5
    | 24 25 26 27 28 29 30 31 | 4
    | 16 17 18 19 20 21 22 23 | 3
    |  8  9 10 11 12 13 14 15 | 2
    |  0  1  2  3  4  5  6  7 | 1
    +-------------------------+
       a  b  c  d  e  f  g  h
*/

u32 MagicTable[32]=
{  31, 0, 9, 1,10,20,13, 2,
    7,11,21,23,17,14, 3,25,
   30, 8,19,12, 6,22,16,24,
   29,18, 5,15,28, 4,27,26
};

const u64 diagonalMask[64] = {
	 0x8040201008040201ull,	 0x0080402010080402ull,	 0x0000804020100804ull,	 0x0000008040201008ull,
	 0x0000000080402010ull,	 0x0000000000804020ull,	 0x0000000000008040ull,	 0x0000000000000080ull,
	 0x4020100804020100ull,	 0x8040201008040201ull,	 0x0080402010080402ull,	 0x0000804020100804ull,
	 0x0000008040201008ull,	 0x0000000080402010ull,	 0x0000000000804020ull,	 0x0000000000008040ull,
	 0x2010080402010000ull,	 0x4020100804020100ull,	 0x8040201008040201ull,	 0x0080402010080402ull,
	 0x0000804020100804ull,	 0x0000008040201008ull,	 0x0000000080402010ull,	 0x0000000000804020ull,
	 0x1008040201000000ull,	 0x2010080402010000ull,	 0x4020100804020100ull,	 0x8040201008040201ull,
	 0x0080402010080402ull,	 0x0000804020100804ull,	 0x0000008040201008ull,	 0x0000000080402010ull,
	 0x0804020100000000ull,	 0x1008040201000000ull,	 0x2010080402010000ull,	 0x4020100804020100ull,
	 0x8040201008040201ull,	 0x0080402010080402ull,	 0x0000804020100804ull,	 0x0000008040201008ull,
	 0x0402010000000000ull,	 0x0804020100000000ull,	 0x1008040201000000ull,	 0x2010080402010000ull,
	 0x4020100804020100ull,	 0x8040201008040201ull,	 0x0080402010080402ull,	 0x0000804020100804ull,
	 0x0201000000000000ull,	 0x0402010000000000ull,	 0x0804020100000000ull,	 0x1008040201000000ull,
	 0x2010080402010000ull,	 0x4020100804020100ull,	 0x8040201008040201ull,	 0x0080402010080402ull,
	 0x0100000000000000ull,	 0x0201000000000000ull,	 0x0402010000000000ull,	 0x0804020100000000ull,
	 0x1008040201000000ull,	 0x2010080402010000ull,	 0x4020100804020100ull,	 0x8040201008040201ull,
};
const u64 antidiagMask[64] = {
	 0x0000000000000001ull,	 0x0000000000000102ull,	 0x0000000000010204ull,	 0x0000000001020408ull,
	 0x0000000102040810ull,	 0x0000010204081020ull,	 0x0001020408102040ull,	 0x0102040810204080ull,
	 0x0000000000000102ull,	 0x0000000000010204ull,	 0x0000000001020408ull,	 0x0000000102040810ull,
	 0x0000010204081020ull,	 0x0001020408102040ull,	 0x0102040810204080ull,	 0x0204081020408000ull,
	 0x0000000000010204ull,	 0x0000000001020408ull,	 0x0000000102040810ull,	 0x0000010204081020ull,
	 0x0001020408102040ull,	 0x0102040810204080ull,	 0x0204081020408000ull,	 0x0408102040800000ull,
	 0x0000000001020408ull,	 0x0000000102040810ull,	 0x0000010204081020ull,	 0x0001020408102040ull,
	 0x0102040810204080ull,	 0x0204081020408000ull,	 0x0408102040800000ull,	 0x0810204080000000ull,
	 0x0000000102040810ull,	 0x0000010204081020ull,	 0x0001020408102040ull,	 0x0102040810204080ull,
	 0x0204081020408000ull,	 0x0408102040800000ull,	 0x0810204080000000ull,	 0x1020408000000000ull,
	 0x0000010204081020ull,	 0x0001020408102040ull,	 0x0102040810204080ull,	 0x0204081020408000ull,
	 0x0408102040800000ull,	 0x0810204080000000ull,	 0x1020408000000000ull,	 0x2040800000000000ull,
	 0x0001020408102040ull,	 0x0102040810204080ull,	 0x0204081020408000ull,	 0x0408102040800000ull,
	 0x0810204080000000ull,	 0x1020408000000000ull,	 0x2040800000000000ull,	 0x4080000000000000ull,
	 0x0102040810204080ull,	 0x0204081020408000ull,	 0x0408102040800000ull,	 0x0810204080000000ull,
	 0x1020408000000000ull,	 0x2040800000000000ull,	 0x4080000000000000ull,	 0x8000000000000000ull,
};

const u8 firstRankAttacks[64][8] = { // [occ64][file]
	{  // occ == 0
0xfe,0xfd,0xfb,0xf7,0xef,0xdf,0xbf,0x7f,	},
	{  // occ == 1
0x02,0xfd,0xfa,0xf6,0xee,0xde,0xbe,0x7e,	},
	{  // occ == 2
0x06,0x05,0xfb,0xf4,0xec,0xdc,0xbc,0x7c,	},
	{  // occ == 3
0x02,0x05,0xfa,0xf4,0xec,0xdc,0xbc,0x7c,	},
	{  // occ == 4
0x0e,0x0d,0x0b,0xf7,0xe8,0xd8,0xb8,0x78,	},
	{  // occ == 5
0x02,0x0d,0x0a,0xf6,0xe8,0xd8,0xb8,0x78,	},
	{  // occ == 6
0x06,0x05,0x0b,0xf4,0xe8,0xd8,0xb8,0x78,	},
	{  // occ == 7
0x02,0x05,0x0a,0xf4,0xe8,0xd8,0xb8,0x78,	},
	{  // occ == 8
0x1e,0x1d,0x1b,0x17,0xef,0xd0,0xb0,0x70,	},
	{  // occ == 9
0x02,0x1d,0x1a,0x16,0xee,0xd0,0xb0,0x70,	},
	{  // occ == 10
0x06,0x05,0x1b,0x14,0xec,0xd0,0xb0,0x70,	},
	{  // occ == 11
0x02,0x05,0x1a,0x14,0xec,0xd0,0xb0,0x70,	},
	{  // occ == 12
0x0e,0x0d,0x0b,0x17,0xe8,0xd0,0xb0,0x70,	},
	{  // occ == 13
0x02,0x0d,0x0a,0x16,0xe8,0xd0,0xb0,0x70,	},
	{  // occ == 14
0x06,0x05,0x0b,0x14,0xe8,0xd0,0xb0,0x70,	},
	{  // occ == 15
0x02,0x05,0x0a,0x14,0xe8,0xd0,0xb0,0x70,	},
	{  // occ == 16
0x3e,0x3d,0x3b,0x37,0x2f,0xdf,0xa0,0x60,	},
	{  // occ == 17
0x02,0x3d,0x3a,0x36,0x2e,0xde,0xa0,0x60,	},
	{  // occ == 18
0x06,0x05,0x3b,0x34,0x2c,0xdc,0xa0,0x60,	},
	{  // occ == 19
0x02,0x05,0x3a,0x34,0x2c,0xdc,0xa0,0x60,	},
	{  // occ == 20
0x0e,0x0d,0x0b,0x37,0x28,0xd8,0xa0,0x60,	},
	{  // occ == 21
0x02,0x0d,0x0a,0x36,0x28,0xd8,0xa0,0x60,	},
	{  // occ == 22
0x06,0x05,0x0b,0x34,0x28,0xd8,0xa0,0x60,	},
	{  // occ == 23
0x02,0x05,0x0a,0x34,0x28,0xd8,0xa0,0x60,	},
	{  // occ == 24
0x1e,0x1d,0x1b,0x17,0x2f,0xd0,0xa0,0x60,	},
	{  // occ == 25
0x02,0x1d,0x1a,0x16,0x2e,0xd0,0xa0,0x60,	},
	{  // occ == 26
0x06,0x05,0x1b,0x14,0x2c,0xd0,0xa0,0x60,	},
	{  // occ == 27
0x02,0x05,0x1a,0x14,0x2c,0xd0,0xa0,0x60,	},
	{  // occ == 28
0x0e,0x0d,0x0b,0x17,0x28,0xd0,0xa0,0x60,	},
	{  // occ == 29
0x02,0x0d,0x0a,0x16,0x28,0xd0,0xa0,0x60,	},
	{  // occ == 30
0x06,0x05,0x0b,0x14,0x28,0xd0,0xa0,0x60,	},
	{  // occ == 31
0x02,0x05,0x0a,0x14,0x28,0xd0,0xa0,0x60,	},
	{  // occ == 32
0x7e,0x7d,0x7b,0x77,0x6f,0x5f,0xbf,0x40,	},
	{  // occ == 33
0x02,0x7d,0x7a,0x76,0x6e,0x5e,0xbe,0x40,	},
	{  // occ == 34
0x06,0x05,0x7b,0x74,0x6c,0x5c,0xbc,0x40,	},
	{  // occ == 35
0x02,0x05,0x7a,0x74,0x6c,0x5c,0xbc,0x40,	},
	{  // occ == 36
0x0e,0x0d,0x0b,0x77,0x68,0x58,0xb8,0x40,	},
	{  // occ == 37
0x02,0x0d,0x0a,0x76,0x68,0x58,0xb8,0x40,	},
	{  // occ == 38
0x06,0x05,0x0b,0x74,0x68,0x58,0xb8,0x40,	},
	{  // occ == 39
0x02,0x05,0x0a,0x74,0x68,0x58,0xb8,0x40,	},
	{  // occ == 40
0x1e,0x1d,0x1b,0x17,0x6f,0x50,0xb0,0x40,	},
	{  // occ == 41
0x02,0x1d,0x1a,0x16,0x6e,0x50,0xb0,0x40,	},
	{  // occ == 42
0x06,0x05,0x1b,0x14,0x6c,0x50,0xb0,0x40,	},
	{  // occ == 43
0x02,0x05,0x1a,0x14,0x6c,0x50,0xb0,0x40,	},
	{  // occ == 44
0x0e,0x0d,0x0b,0x17,0x68,0x50,0xb0,0x40,	},
	{  // occ == 45
0x02,0x0d,0x0a,0x16,0x68,0x50,0xb0,0x40,	},
	{  // occ == 46
0x06,0x05,0x0b,0x14,0x68,0x50,0xb0,0x40,	},
	{  // occ == 47
0x02,0x05,0x0a,0x14,0x68,0x50,0xb0,0x40,	},
	{  // occ == 48
0x3e,0x3d,0x3b,0x37,0x2f,0x5f,0xa0,0x40,	},
	{  // occ == 49
0x02,0x3d,0x3a,0x36,0x2e,0x5e,0xa0,0x40,	},
	{  // occ == 50
0x06,0x05,0x3b,0x34,0x2c,0x5c,0xa0,0x40,	},
	{  // occ == 51
0x02,0x05,0x3a,0x34,0x2c,0x5c,0xa0,0x40,	},
	{  // occ == 52
0x0e,0x0d,0x0b,0x37,0x28,0x58,0xa0,0x40,	},
	{  // occ == 53
0x02,0x0d,0x0a,0x36,0x28,0x58,0xa0,0x40,	},
	{  // occ == 54
0x06,0x05,0x0b,0x34,0x28,0x58,0xa0,0x40,	},
	{  // occ == 55
0x02,0x05,0x0a,0x34,0x28,0x58,0xa0,0x40,	},
	{  // occ == 56
0x1e,0x1d,0x1b,0x17,0x2f,0x50,0xa0,0x40,	},
	{  // occ == 57
0x02,0x1d,0x1a,0x16,0x2e,0x50,0xa0,0x40,	},
	{  // occ == 58
0x06,0x05,0x1b,0x14,0x2c,0x50,0xa0,0x40,	},
	{  // occ == 59
0x02,0x05,0x1a,0x14,0x2c,0x50,0xa0,0x40,	},
	{  // occ == 60
0x0e,0x0d,0x0b,0x17,0x28,0x50,0xa0,0x40,	},
	{  // occ == 61
0x02,0x0d,0x0a,0x16,0x28,0x50,0xa0,0x40,	},
	{  // occ == 62
0x06,0x05,0x0b,0x14,0x28,0x50,0xa0,0x40,	},
	{  // occ == 63
0x02,0x05,0x0a,0x14,0x28,0x50,0xa0,0x40,	},
};
const u64 fillUpAttacks[64][8] = { // [occ64][file]
	{ 0xfefefefefefefefeull,0xfdfdfdfdfdfdfdfdull,0xfbfbfbfbfbfbfbfbull,0xf7f7f7f7f7f7f7f7ull,0xefefefefefefefefull,0xdfdfdfdfdfdfdfdfull,0xbfbfbfbfbfbfbfbfull,0x7f7f7f7f7f7f7f7full,},
	{ 0x0202020202020202ull,0xfdfdfdfdfdfdfdfdull,0xfafafafafafafafaull,0xf6f6f6f6f6f6f6f6ull,0xeeeeeeeeeeeeeeeeull,0xdedededededededeull,0xbebebebebebebebeull,0x7e7e7e7e7e7e7e7eull,},
	{ 0x0606060606060606ull,0x0505050505050505ull,0xfbfbfbfbfbfbfbfbull,0xf4f4f4f4f4f4f4f4ull,0xececececececececull,0xdcdcdcdcdcdcdcdcull,0xbcbcbcbcbcbcbcbcull,0x7c7c7c7c7c7c7c7cull,},
	{ 0x0202020202020202ull,0x0505050505050505ull,0xfafafafafafafafaull,0xf4f4f4f4f4f4f4f4ull,0xececececececececull,0xdcdcdcdcdcdcdcdcull,0xbcbcbcbcbcbcbcbcull,0x7c7c7c7c7c7c7c7cull,},
	{ 0x0e0e0e0e0e0e0e0eull,0x0d0d0d0d0d0d0d0dull,0x0b0b0b0b0b0b0b0bull,0xf7f7f7f7f7f7f7f7ull,0xe8e8e8e8e8e8e8e8ull,0xd8d8d8d8d8d8d8d8ull,0xb8b8b8b8b8b8b8b8ull,0x7878787878787878ull,},
	{ 0x0202020202020202ull,0x0d0d0d0d0d0d0d0dull,0x0a0a0a0a0a0a0a0aull,0xf6f6f6f6f6f6f6f6ull,0xe8e8e8e8e8e8e8e8ull,0xd8d8d8d8d8d8d8d8ull,0xb8b8b8b8b8b8b8b8ull,0x7878787878787878ull,},
	{ 0x0606060606060606ull,0x0505050505050505ull,0x0b0b0b0b0b0b0b0bull,0xf4f4f4f4f4f4f4f4ull,0xe8e8e8e8e8e8e8e8ull,0xd8d8d8d8d8d8d8d8ull,0xb8b8b8b8b8b8b8b8ull,0x7878787878787878ull,},
	{ 0x0202020202020202ull,0x0505050505050505ull,0x0a0a0a0a0a0a0a0aull,0xf4f4f4f4f4f4f4f4ull,0xe8e8e8e8e8e8e8e8ull,0xd8d8d8d8d8d8d8d8ull,0xb8b8b8b8b8b8b8b8ull,0x7878787878787878ull,},
	{ 0x1e1e1e1e1e1e1e1eull,0x1d1d1d1d1d1d1d1dull,0x1b1b1b1b1b1b1b1bull,0x1717171717171717ull,0xefefefefefefefefull,0xd0d0d0d0d0d0d0d0ull,0xb0b0b0b0b0b0b0b0ull,0x7070707070707070ull,},
	{ 0x0202020202020202ull,0x1d1d1d1d1d1d1d1dull,0x1a1a1a1a1a1a1a1aull,0x1616161616161616ull,0xeeeeeeeeeeeeeeeeull,0xd0d0d0d0d0d0d0d0ull,0xb0b0b0b0b0b0b0b0ull,0x7070707070707070ull,},
	{ 0x0606060606060606ull,0x0505050505050505ull,0x1b1b1b1b1b1b1b1bull,0x1414141414141414ull,0xececececececececull,0xd0d0d0d0d0d0d0d0ull,0xb0b0b0b0b0b0b0b0ull,0x7070707070707070ull,},
	{ 0x0202020202020202ull,0x0505050505050505ull,0x1a1a1a1a1a1a1a1aull,0x1414141414141414ull,0xececececececececull,0xd0d0d0d0d0d0d0d0ull,0xb0b0b0b0b0b0b0b0ull,0x7070707070707070ull,},
	{ 0x0e0e0e0e0e0e0e0eull,0x0d0d0d0d0d0d0d0dull,0x0b0b0b0b0b0b0b0bull,0x1717171717171717ull,0xe8e8e8e8e8e8e8e8ull,0xd0d0d0d0d0d0d0d0ull,0xb0b0b0b0b0b0b0b0ull,0x7070707070707070ull,},
	{ 0x0202020202020202ull,0x0d0d0d0d0d0d0d0dull,0x0a0a0a0a0a0a0a0aull,0x1616161616161616ull,0xe8e8e8e8e8e8e8e8ull,0xd0d0d0d0d0d0d0d0ull,0xb0b0b0b0b0b0b0b0ull,0x7070707070707070ull,},
	{ 0x0606060606060606ull,0x0505050505050505ull,0x0b0b0b0b0b0b0b0bull,0x1414141414141414ull,0xe8e8e8e8e8e8e8e8ull,0xd0d0d0d0d0d0d0d0ull,0xb0b0b0b0b0b0b0b0ull,0x7070707070707070ull,},
	{ 0x0202020202020202ull,0x0505050505050505ull,0x0a0a0a0a0a0a0a0aull,0x1414141414141414ull,0xe8e8e8e8e8e8e8e8ull,0xd0d0d0d0d0d0d0d0ull,0xb0b0b0b0b0b0b0b0ull,0x7070707070707070ull,},
	{ 0x3e3e3e3e3e3e3e3eull,0x3d3d3d3d3d3d3d3dull,0x3b3b3b3b3b3b3b3bull,0x3737373737373737ull,0x2f2f2f2f2f2f2f2full,0xdfdfdfdfdfdfdfdfull,0xa0a0a0a0a0a0a0a0ull,0x6060606060606060ull,},
	{ 0x0202020202020202ull,0x3d3d3d3d3d3d3d3dull,0x3a3a3a3a3a3a3a3aull,0x3636363636363636ull,0x2e2e2e2e2e2e2e2eull,0xdedededededededeull,0xa0a0a0a0a0a0a0a0ull,0x6060606060606060ull,},
	{ 0x0606060606060606ull,0x0505050505050505ull,0x3b3b3b3b3b3b3b3bull,0x3434343434343434ull,0x2c2c2c2c2c2c2c2cull,0xdcdcdcdcdcdcdcdcull,0xa0a0a0a0a0a0a0a0ull,0x6060606060606060ull,},
	{ 0x0202020202020202ull,0x0505050505050505ull,0x3a3a3a3a3a3a3a3aull,0x3434343434343434ull,0x2c2c2c2c2c2c2c2cull,0xdcdcdcdcdcdcdcdcull,0xa0a0a0a0a0a0a0a0ull,0x6060606060606060ull,},
	{ 0x0e0e0e0e0e0e0e0eull,0x0d0d0d0d0d0d0d0dull,0x0b0b0b0b0b0b0b0bull,0x3737373737373737ull,0x2828282828282828ull,0xd8d8d8d8d8d8d8d8ull,0xa0a0a0a0a0a0a0a0ull,0x6060606060606060ull,},
	{ 0x0202020202020202ull,0x0d0d0d0d0d0d0d0dull,0x0a0a0a0a0a0a0a0aull,0x3636363636363636ull,0x2828282828282828ull,0xd8d8d8d8d8d8d8d8ull,0xa0a0a0a0a0a0a0a0ull,0x6060606060606060ull,},
	{ 0x0606060606060606ull,0x0505050505050505ull,0x0b0b0b0b0b0b0b0bull,0x3434343434343434ull,0x2828282828282828ull,0xd8d8d8d8d8d8d8d8ull,0xa0a0a0a0a0a0a0a0ull,0x6060606060606060ull,},
	{ 0x0202020202020202ull,0x0505050505050505ull,0x0a0a0a0a0a0a0a0aull,0x3434343434343434ull,0x2828282828282828ull,0xd8d8d8d8d8d8d8d8ull,0xa0a0a0a0a0a0a0a0ull,0x6060606060606060ull,},
	{ 0x1e1e1e1e1e1e1e1eull,0x1d1d1d1d1d1d1d1dull,0x1b1b1b1b1b1b1b1bull,0x1717171717171717ull,0x2f2f2f2f2f2f2f2full,0xd0d0d0d0d0d0d0d0ull,0xa0a0a0a0a0a0a0a0ull,0x6060606060606060ull,},
	{ 0x0202020202020202ull,0x1d1d1d1d1d1d1d1dull,0x1a1a1a1a1a1a1a1aull,0x1616161616161616ull,0x2e2e2e2e2e2e2e2eull,0xd0d0d0d0d0d0d0d0ull,0xa0a0a0a0a0a0a0a0ull,0x6060606060606060ull,},
	{ 0x0606060606060606ull,0x0505050505050505ull,0x1b1b1b1b1b1b1b1bull,0x1414141414141414ull,0x2c2c2c2c2c2c2c2cull,0xd0d0d0d0d0d0d0d0ull,0xa0a0a0a0a0a0a0a0ull,0x6060606060606060ull,},
	{ 0x0202020202020202ull,0x0505050505050505ull,0x1a1a1a1a1a1a1a1aull,0x1414141414141414ull,0x2c2c2c2c2c2c2c2cull,0xd0d0d0d0d0d0d0d0ull,0xa0a0a0a0a0a0a0a0ull,0x6060606060606060ull,},
	{ 0x0e0e0e0e0e0e0e0eull,0x0d0d0d0d0d0d0d0dull,0x0b0b0b0b0b0b0b0bull,0x1717171717171717ull,0x2828282828282828ull,0xd0d0d0d0d0d0d0d0ull,0xa0a0a0a0a0a0a0a0ull,0x6060606060606060ull,},
	{ 0x0202020202020202ull,0x0d0d0d0d0d0d0d0dull,0x0a0a0a0a0a0a0a0aull,0x1616161616161616ull,0x2828282828282828ull,0xd0d0d0d0d0d0d0d0ull,0xa0a0a0a0a0a0a0a0ull,0x6060606060606060ull,},
	{ 0x0606060606060606ull,0x0505050505050505ull,0x0b0b0b0b0b0b0b0bull,0x1414141414141414ull,0x2828282828282828ull,0xd0d0d0d0d0d0d0d0ull,0xa0a0a0a0a0a0a0a0ull,0x6060606060606060ull,},
	{ 0x0202020202020202ull,0x0505050505050505ull,0x0a0a0a0a0a0a0a0aull,0x1414141414141414ull,0x2828282828282828ull,0xd0d0d0d0d0d0d0d0ull,0xa0a0a0a0a0a0a0a0ull,0x6060606060606060ull,},
	{ 0x7e7e7e7e7e7e7e7eull,0x7d7d7d7d7d7d7d7dull,0x7b7b7b7b7b7b7b7bull,0x7777777777777777ull,0x6f6f6f6f6f6f6f6full,0x5f5f5f5f5f5f5f5full,0xbfbfbfbfbfbfbfbfull,0x4040404040404040ull,},
	{ 0x0202020202020202ull,0x7d7d7d7d7d7d7d7dull,0x7a7a7a7a7a7a7a7aull,0x7676767676767676ull,0x6e6e6e6e6e6e6e6eull,0x5e5e5e5e5e5e5e5eull,0xbebebebebebebebeull,0x4040404040404040ull,},
	{ 0x0606060606060606ull,0x0505050505050505ull,0x7b7b7b7b7b7b7b7bull,0x7474747474747474ull,0x6c6c6c6c6c6c6c6cull,0x5c5c5c5c5c5c5c5cull,0xbcbcbcbcbcbcbcbcull,0x4040404040404040ull,},
	{ 0x0202020202020202ull,0x0505050505050505ull,0x7a7a7a7a7a7a7a7aull,0x7474747474747474ull,0x6c6c6c6c6c6c6c6cull,0x5c5c5c5c5c5c5c5cull,0xbcbcbcbcbcbcbcbcull,0x4040404040404040ull,},
	{ 0x0e0e0e0e0e0e0e0eull,0x0d0d0d0d0d0d0d0dull,0x0b0b0b0b0b0b0b0bull,0x7777777777777777ull,0x6868686868686868ull,0x5858585858585858ull,0xb8b8b8b8b8b8b8b8ull,0x4040404040404040ull,},
	{ 0x0202020202020202ull,0x0d0d0d0d0d0d0d0dull,0x0a0a0a0a0a0a0a0aull,0x7676767676767676ull,0x6868686868686868ull,0x5858585858585858ull,0xb8b8b8b8b8b8b8b8ull,0x4040404040404040ull,},
	{ 0x0606060606060606ull,0x0505050505050505ull,0x0b0b0b0b0b0b0b0bull,0x7474747474747474ull,0x6868686868686868ull,0x5858585858585858ull,0xb8b8b8b8b8b8b8b8ull,0x4040404040404040ull,},
	{ 0x0202020202020202ull,0x0505050505050505ull,0x0a0a0a0a0a0a0a0aull,0x7474747474747474ull,0x6868686868686868ull,0x5858585858585858ull,0xb8b8b8b8b8b8b8b8ull,0x4040404040404040ull,},
	{ 0x1e1e1e1e1e1e1e1eull,0x1d1d1d1d1d1d1d1dull,0x1b1b1b1b1b1b1b1bull,0x1717171717171717ull,0x6f6f6f6f6f6f6f6full,0x5050505050505050ull,0xb0b0b0b0b0b0b0b0ull,0x4040404040404040ull,},
	{ 0x0202020202020202ull,0x1d1d1d1d1d1d1d1dull,0x1a1a1a1a1a1a1a1aull,0x1616161616161616ull,0x6e6e6e6e6e6e6e6eull,0x5050505050505050ull,0xb0b0b0b0b0b0b0b0ull,0x4040404040404040ull,},
	{ 0x0606060606060606ull,0x0505050505050505ull,0x1b1b1b1b1b1b1b1bull,0x1414141414141414ull,0x6c6c6c6c6c6c6c6cull,0x5050505050505050ull,0xb0b0b0b0b0b0b0b0ull,0x4040404040404040ull,},
	{ 0x0202020202020202ull,0x0505050505050505ull,0x1a1a1a1a1a1a1a1aull,0x1414141414141414ull,0x6c6c6c6c6c6c6c6cull,0x5050505050505050ull,0xb0b0b0b0b0b0b0b0ull,0x4040404040404040ull,},
	{ 0x0e0e0e0e0e0e0e0eull,0x0d0d0d0d0d0d0d0dull,0x0b0b0b0b0b0b0b0bull,0x1717171717171717ull,0x6868686868686868ull,0x5050505050505050ull,0xb0b0b0b0b0b0b0b0ull,0x4040404040404040ull,},
	{ 0x0202020202020202ull,0x0d0d0d0d0d0d0d0dull,0x0a0a0a0a0a0a0a0aull,0x1616161616161616ull,0x6868686868686868ull,0x5050505050505050ull,0xb0b0b0b0b0b0b0b0ull,0x4040404040404040ull,},
	{ 0x0606060606060606ull,0x0505050505050505ull,0x0b0b0b0b0b0b0b0bull,0x1414141414141414ull,0x6868686868686868ull,0x5050505050505050ull,0xb0b0b0b0b0b0b0b0ull,0x4040404040404040ull,},
	{ 0x0202020202020202ull,0x0505050505050505ull,0x0a0a0a0a0a0a0a0aull,0x1414141414141414ull,0x6868686868686868ull,0x5050505050505050ull,0xb0b0b0b0b0b0b0b0ull,0x4040404040404040ull,},
	{ 0x3e3e3e3e3e3e3e3eull,0x3d3d3d3d3d3d3d3dull,0x3b3b3b3b3b3b3b3bull,0x3737373737373737ull,0x2f2f2f2f2f2f2f2full,0x5f5f5f5f5f5f5f5full,0xa0a0a0a0a0a0a0a0ull,0x4040404040404040ull,},
	{ 0x0202020202020202ull,0x3d3d3d3d3d3d3d3dull,0x3a3a3a3a3a3a3a3aull,0x3636363636363636ull,0x2e2e2e2e2e2e2e2eull,0x5e5e5e5e5e5e5e5eull,0xa0a0a0a0a0a0a0a0ull,0x4040404040404040ull,},
	{ 0x0606060606060606ull,0x0505050505050505ull,0x3b3b3b3b3b3b3b3bull,0x3434343434343434ull,0x2c2c2c2c2c2c2c2cull,0x5c5c5c5c5c5c5c5cull,0xa0a0a0a0a0a0a0a0ull,0x4040404040404040ull,},
	{ 0x0202020202020202ull,0x0505050505050505ull,0x3a3a3a3a3a3a3a3aull,0x3434343434343434ull,0x2c2c2c2c2c2c2c2cull,0x5c5c5c5c5c5c5c5cull,0xa0a0a0a0a0a0a0a0ull,0x4040404040404040ull,},
	{ 0x0e0e0e0e0e0e0e0eull,0x0d0d0d0d0d0d0d0dull,0x0b0b0b0b0b0b0b0bull,0x3737373737373737ull,0x2828282828282828ull,0x5858585858585858ull,0xa0a0a0a0a0a0a0a0ull,0x4040404040404040ull,},
	{ 0x0202020202020202ull,0x0d0d0d0d0d0d0d0dull,0x0a0a0a0a0a0a0a0aull,0x3636363636363636ull,0x2828282828282828ull,0x5858585858585858ull,0xa0a0a0a0a0a0a0a0ull,0x4040404040404040ull,},
	{ 0x0606060606060606ull,0x0505050505050505ull,0x0b0b0b0b0b0b0b0bull,0x3434343434343434ull,0x2828282828282828ull,0x5858585858585858ull,0xa0a0a0a0a0a0a0a0ull,0x4040404040404040ull,},
	{ 0x0202020202020202ull,0x0505050505050505ull,0x0a0a0a0a0a0a0a0aull,0x3434343434343434ull,0x2828282828282828ull,0x5858585858585858ull,0xa0a0a0a0a0a0a0a0ull,0x4040404040404040ull,},
	{ 0x1e1e1e1e1e1e1e1eull,0x1d1d1d1d1d1d1d1dull,0x1b1b1b1b1b1b1b1bull,0x1717171717171717ull,0x2f2f2f2f2f2f2f2full,0x5050505050505050ull,0xa0a0a0a0a0a0a0a0ull,0x4040404040404040ull,},
	{ 0x0202020202020202ull,0x1d1d1d1d1d1d1d1dull,0x1a1a1a1a1a1a1a1aull,0x1616161616161616ull,0x2e2e2e2e2e2e2e2eull,0x5050505050505050ull,0xa0a0a0a0a0a0a0a0ull,0x4040404040404040ull,},
	{ 0x0606060606060606ull,0x0505050505050505ull,0x1b1b1b1b1b1b1b1bull,0x1414141414141414ull,0x2c2c2c2c2c2c2c2cull,0x5050505050505050ull,0xa0a0a0a0a0a0a0a0ull,0x4040404040404040ull,},
	{ 0x0202020202020202ull,0x0505050505050505ull,0x1a1a1a1a1a1a1a1aull,0x1414141414141414ull,0x2c2c2c2c2c2c2c2cull,0x5050505050505050ull,0xa0a0a0a0a0a0a0a0ull,0x4040404040404040ull,},
	{ 0x0e0e0e0e0e0e0e0eull,0x0d0d0d0d0d0d0d0dull,0x0b0b0b0b0b0b0b0bull,0x1717171717171717ull,0x2828282828282828ull,0x5050505050505050ull,0xa0a0a0a0a0a0a0a0ull,0x4040404040404040ull,},
	{ 0x0202020202020202ull,0x0d0d0d0d0d0d0d0dull,0x0a0a0a0a0a0a0a0aull,0x1616161616161616ull,0x2828282828282828ull,0x5050505050505050ull,0xa0a0a0a0a0a0a0a0ull,0x4040404040404040ull,},
	{ 0x0606060606060606ull,0x0505050505050505ull,0x0b0b0b0b0b0b0b0bull,0x1414141414141414ull,0x2828282828282828ull,0x5050505050505050ull,0xa0a0a0a0a0a0a0a0ull,0x4040404040404040ull,},
	{ 0x0202020202020202ull,0x0505050505050505ull,0x0a0a0a0a0a0a0a0aull,0x1414141414141414ull,0x2828282828282828ull,0x5050505050505050ull,0xa0a0a0a0a0a0a0a0ull,0x4040404040404040ull,},
};
const u64 aFileAttacks[64][8] = { // [occ64][file]
	{ 0x0101010101010100ull,0x0101010101010001ull,0x0101010101000101ull,0x0101010100010101ull,0x0101010001010101ull,0x0101000101010101ull,0x0100010101010101ull,0x0001010101010101ull,},
	{ 0x0001010101010100ull,0x0001010101010001ull,0x0001010101000101ull,0x0001010100010101ull,0x0001010001010101ull,0x0001000101010101ull,0x0100010101010101ull,0x0001000000000000ull,},
	{ 0x0000010101010100ull,0x0000010101010001ull,0x0000010101000101ull,0x0000010100010101ull,0x0000010001010101ull,0x0101000101010101ull,0x0100010000000000ull,0x0001010000000000ull,},
	{ 0x0000010101010100ull,0x0000010101010001ull,0x0000010101000101ull,0x0000010100010101ull,0x0000010001010101ull,0x0001000101010101ull,0x0100010000000000ull,0x0001000000000000ull,},
	{ 0x0000000101010100ull,0x0000000101010001ull,0x0000000101000101ull,0x0000000100010101ull,0x0101010001010101ull,0x0101000100000000ull,0x0100010100000000ull,0x0001010100000000ull,},
	{ 0x0000000101010100ull,0x0000000101010001ull,0x0000000101000101ull,0x0000000100010101ull,0x0001010001010101ull,0x0001000100000000ull,0x0100010100000000ull,0x0001000000000000ull,},
	{ 0x0000000101010100ull,0x0000000101010001ull,0x0000000101000101ull,0x0000000100010101ull,0x0000010001010101ull,0x0101000100000000ull,0x0100010000000000ull,0x0001010000000000ull,},
	{ 0x0000000101010100ull,0x0000000101010001ull,0x0000000101000101ull,0x0000000100010101ull,0x0000010001010101ull,0x0001000100000000ull,0x0100010000000000ull,0x0001000000000000ull,},
	{ 0x0000000001010100ull,0x0000000001010001ull,0x0000000001000101ull,0x0101010100010101ull,0x0101010001000000ull,0x0101000101000000ull,0x0100010101000000ull,0x0001010101000000ull,},
	{ 0x0000000001010100ull,0x0000000001010001ull,0x0000000001000101ull,0x0001010100010101ull,0x0001010001000000ull,0x0001000101000000ull,0x0100010101000000ull,0x0001000000000000ull,},
	{ 0x0000000001010100ull,0x0000000001010001ull,0x0000000001000101ull,0x0000010100010101ull,0x0000010001000000ull,0x0101000101000000ull,0x0100010000000000ull,0x0001010000000000ull,},
	{ 0x0000000001010100ull,0x0000000001010001ull,0x0000000001000101ull,0x0000010100010101ull,0x0000010001000000ull,0x0001000101000000ull,0x0100010000000000ull,0x0001000000000000ull,},
	{ 0x0000000001010100ull,0x0000000001010001ull,0x0000000001000101ull,0x0000000100010101ull,0x0101010001000000ull,0x0101000100000000ull,0x0100010100000000ull,0x0001010100000000ull,},
	{ 0x0000000001010100ull,0x0000000001010001ull,0x0000000001000101ull,0x0000000100010101ull,0x0001010001000000ull,0x0001000100000000ull,0x0100010100000000ull,0x0001000000000000ull,},
	{ 0x0000000001010100ull,0x0000000001010001ull,0x0000000001000101ull,0x0000000100010101ull,0x0000010001000000ull,0x0101000100000000ull,0x0100010000000000ull,0x0001010000000000ull,},
	{ 0x0000000001010100ull,0x0000000001010001ull,0x0000000001000101ull,0x0000000100010101ull,0x0000010001000000ull,0x0001000100000000ull,0x0100010000000000ull,0x0001000000000000ull,},
	{ 0x0000000000010100ull,0x0000000000010001ull,0x0101010101000101ull,0x0101010100010000ull,0x0101010001010000ull,0x0101000101010000ull,0x0100010101010000ull,0x0001010101010000ull,},
	{ 0x0000000000010100ull,0x0000000000010001ull,0x0001010101000101ull,0x0001010100010000ull,0x0001010001010000ull,0x0001000101010000ull,0x0100010101010000ull,0x0001000000000000ull,},
	{ 0x0000000000010100ull,0x0000000000010001ull,0x0000010101000101ull,0x0000010100010000ull,0x0000010001010000ull,0x0101000101010000ull,0x0100010000000000ull,0x0001010000000000ull,},
	{ 0x0000000000010100ull,0x0000000000010001ull,0x0000010101000101ull,0x0000010100010000ull,0x0000010001010000ull,0x0001000101010000ull,0x0100010000000000ull,0x0001000000000000ull,},
	{ 0x0000000000010100ull,0x0000000000010001ull,0x0000000101000101ull,0x0000000100010000ull,0x0101010001010000ull,0x0101000100000000ull,0x0100010100000000ull,0x0001010100000000ull,},
	{ 0x0000000000010100ull,0x0000000000010001ull,0x0000000101000101ull,0x0000000100010000ull,0x0001010001010000ull,0x0001000100000000ull,0x0100010100000000ull,0x0001000000000000ull,},
	{ 0x0000000000010100ull,0x0000000000010001ull,0x0000000101000101ull,0x0000000100010000ull,0x0000010001010000ull,0x0101000100000000ull,0x0100010000000000ull,0x0001010000000000ull,},
	{ 0x0000000000010100ull,0x0000000000010001ull,0x0000000101000101ull,0x0000000100010000ull,0x0000010001010000ull,0x0001000100000000ull,0x0100010000000000ull,0x0001000000000000ull,},
	{ 0x0000000000010100ull,0x0000000000010001ull,0x0000000001000101ull,0x0101010100010000ull,0x0101010001000000ull,0x0101000101000000ull,0x0100010101000000ull,0x0001010101000000ull,},
	{ 0x0000000000010100ull,0x0000000000010001ull,0x0000000001000101ull,0x0001010100010000ull,0x0001010001000000ull,0x0001000101000000ull,0x0100010101000000ull,0x0001000000000000ull,},
	{ 0x0000000000010100ull,0x0000000000010001ull,0x0000000001000101ull,0x0000010100010000ull,0x0000010001000000ull,0x0101000101000000ull,0x0100010000000000ull,0x0001010000000000ull,},
	{ 0x0000000000010100ull,0x0000000000010001ull,0x0000000001000101ull,0x0000010100010000ull,0x0000010001000000ull,0x0001000101000000ull,0x0100010000000000ull,0x0001000000000000ull,},
	{ 0x0000000000010100ull,0x0000000000010001ull,0x0000000001000101ull,0x0000000100010000ull,0x0101010001000000ull,0x0101000100000000ull,0x0100010100000000ull,0x0001010100000000ull,},
	{ 0x0000000000010100ull,0x0000000000010001ull,0x0000000001000101ull,0x0000000100010000ull,0x0001010001000000ull,0x0001000100000000ull,0x0100010100000000ull,0x0001000000000000ull,},
	{ 0x0000000000010100ull,0x0000000000010001ull,0x0000000001000101ull,0x0000000100010000ull,0x0000010001000000ull,0x0101000100000000ull,0x0100010000000000ull,0x0001010000000000ull,},
	{ 0x0000000000010100ull,0x0000000000010001ull,0x0000000001000101ull,0x0000000100010000ull,0x0000010001000000ull,0x0001000100000000ull,0x0100010000000000ull,0x0001000000000000ull,},
	{ 0x0000000000000100ull,0x0101010101010001ull,0x0101010101000100ull,0x0101010100010100ull,0x0101010001010100ull,0x0101000101010100ull,0x0100010101010100ull,0x0001010101010100ull,},
	{ 0x0000000000000100ull,0x0001010101010001ull,0x0001010101000100ull,0x0001010100010100ull,0x0001010001010100ull,0x0001000101010100ull,0x0100010101010100ull,0x0001000000000000ull,},
	{ 0x0000000000000100ull,0x0000010101010001ull,0x0000010101000100ull,0x0000010100010100ull,0x0000010001010100ull,0x0101000101010100ull,0x0100010000000000ull,0x0001010000000000ull,},
	{ 0x0000000000000100ull,0x0000010101010001ull,0x0000010101000100ull,0x0000010100010100ull,0x0000010001010100ull,0x0001000101010100ull,0x0100010000000000ull,0x0001000000000000ull,},
	{ 0x0000000000000100ull,0x0000000101010001ull,0x0000000101000100ull,0x0000000100010100ull,0x0101010001010100ull,0x0101000100000000ull,0x0100010100000000ull,0x0001010100000000ull,},
	{ 0x0000000000000100ull,0x0000000101010001ull,0x0000000101000100ull,0x0000000100010100ull,0x0001010001010100ull,0x0001000100000000ull,0x0100010100000000ull,0x0001000000000000ull,},
	{ 0x0000000000000100ull,0x0000000101010001ull,0x0000000101000100ull,0x0000000100010100ull,0x0000010001010100ull,0x0101000100000000ull,0x0100010000000000ull,0x0001010000000000ull,},
	{ 0x0000000000000100ull,0x0000000101010001ull,0x0000000101000100ull,0x0000000100010100ull,0x0000010001010100ull,0x0001000100000000ull,0x0100010000000000ull,0x0001000000000000ull,},
	{ 0x0000000000000100ull,0x0000000001010001ull,0x0000000001000100ull,0x0101010100010100ull,0x0101010001000000ull,0x0101000101000000ull,0x0100010101000000ull,0x0001010101000000ull,},
	{ 0x0000000000000100ull,0x0000000001010001ull,0x0000000001000100ull,0x0001010100010100ull,0x0001010001000000ull,0x0001000101000000ull,0x0100010101000000ull,0x0001000000000000ull,},
	{ 0x0000000000000100ull,0x0000000001010001ull,0x0000000001000100ull,0x0000010100010100ull,0x0000010001000000ull,0x0101000101000000ull,0x0100010000000000ull,0x0001010000000000ull,},
	{ 0x0000000000000100ull,0x0000000001010001ull,0x0000000001000100ull,0x0000010100010100ull,0x0000010001000000ull,0x0001000101000000ull,0x0100010000000000ull,0x0001000000000000ull,},
	{ 0x0000000000000100ull,0x0000000001010001ull,0x0000000001000100ull,0x0000000100010100ull,0x0101010001000000ull,0x0101000100000000ull,0x0100010100000000ull,0x0001010100000000ull,},
	{ 0x0000000000000100ull,0x0000000001010001ull,0x0000000001000100ull,0x0000000100010100ull,0x0001010001000000ull,0x0001000100000000ull,0x0100010100000000ull,0x0001000000000000ull,},
	{ 0x0000000000000100ull,0x0000000001010001ull,0x0000000001000100ull,0x0000000100010100ull,0x0000010001000000ull,0x0101000100000000ull,0x0100010000000000ull,0x0001010000000000ull,},
	{ 0x0000000000000100ull,0x0000000001010001ull,0x0000000001000100ull,0x0000000100010100ull,0x0000010001000000ull,0x0001000100000000ull,0x0100010000000000ull,0x0001000000000000ull,},
	{ 0x0000000000000100ull,0x0000000000010001ull,0x0101010101000100ull,0x0101010100010000ull,0x0101010001010000ull,0x0101000101010000ull,0x0100010101010000ull,0x0001010101010000ull,},
	{ 0x0000000000000100ull,0x0000000000010001ull,0x0001010101000100ull,0x0001010100010000ull,0x0001010001010000ull,0x0001000101010000ull,0x0100010101010000ull,0x0001000000000000ull,},
	{ 0x0000000000000100ull,0x0000000000010001ull,0x0000010101000100ull,0x0000010100010000ull,0x0000010001010000ull,0x0101000101010000ull,0x0100010000000000ull,0x0001010000000000ull,},
	{ 0x0000000000000100ull,0x0000000000010001ull,0x0000010101000100ull,0x0000010100010000ull,0x0000010001010000ull,0x0001000101010000ull,0x0100010000000000ull,0x0001000000000000ull,},
	{ 0x0000000000000100ull,0x0000000000010001ull,0x0000000101000100ull,0x0000000100010000ull,0x0101010001010000ull,0x0101000100000000ull,0x0100010100000000ull,0x0001010100000000ull,},
	{ 0x0000000000000100ull,0x0000000000010001ull,0x0000000101000100ull,0x0000000100010000ull,0x0001010001010000ull,0x0001000100000000ull,0x0100010100000000ull,0x0001000000000000ull,},
	{ 0x0000000000000100ull,0x0000000000010001ull,0x0000000101000100ull,0x0000000100010000ull,0x0000010001010000ull,0x0101000100000000ull,0x0100010000000000ull,0x0001010000000000ull,},
	{ 0x0000000000000100ull,0x0000000000010001ull,0x0000000101000100ull,0x0000000100010000ull,0x0000010001010000ull,0x0001000100000000ull,0x0100010000000000ull,0x0001000000000000ull,},
	{ 0x0000000000000100ull,0x0000000000010001ull,0x0000000001000100ull,0x0101010100010000ull,0x0101010001000000ull,0x0101000101000000ull,0x0100010101000000ull,0x0001010101000000ull,},
	{ 0x0000000000000100ull,0x0000000000010001ull,0x0000000001000100ull,0x0001010100010000ull,0x0001010001000000ull,0x0001000101000000ull,0x0100010101000000ull,0x0001000000000000ull,},
	{ 0x0000000000000100ull,0x0000000000010001ull,0x0000000001000100ull,0x0000010100010000ull,0x0000010001000000ull,0x0101000101000000ull,0x0100010000000000ull,0x0001010000000000ull,},
	{ 0x0000000000000100ull,0x0000000000010001ull,0x0000000001000100ull,0x0000010100010000ull,0x0000010001000000ull,0x0001000101000000ull,0x0100010000000000ull,0x0001000000000000ull,},
	{ 0x0000000000000100ull,0x0000000000010001ull,0x0000000001000100ull,0x0000000100010000ull,0x0101010001000000ull,0x0101000100000000ull,0x0100010100000000ull,0x0001010100000000ull,},
	{ 0x0000000000000100ull,0x0000000000010001ull,0x0000000001000100ull,0x0000000100010000ull,0x0001010001000000ull,0x0001000100000000ull,0x0100010100000000ull,0x0001000000000000ull,},
	{ 0x0000000000000100ull,0x0000000000010001ull,0x0000000001000100ull,0x0000000100010000ull,0x0000010001000000ull,0x0101000100000000ull,0x0100010000000000ull,0x0001010000000000ull,},
	{ 0x0000000000000100ull,0x0000000000010001ull,0x0000000001000100ull,0x0000000100010000ull,0x0000010001000000ull,0x0001000100000000ull,0x0100010000000000ull,0x0001000000000000ull,},
};

const u64 bcasilla[64]= {
	0x1ull,0x2ull,0x4ull,0x8ull,
	0x10ull,0x20ull,0x40ull,0x80ull,
	0x100ull,0x200ull,0x400ull,0x800ull,
	0x1000ull,0x2000ull,0x4000ull,0x8000ull,
	0x10000ull,0x20000ull,0x40000ull,0x80000ull,
	0x100000ull,0x200000ull,0x400000ull,0x800000ull,
	0x1000000ull,0x2000000ull,0x4000000ull,0x8000000ull,
	0x10000000ull,0x20000000ull,0x40000000ull,0x80000000ull,
	0x100000000ull,0x200000000ull,0x400000000ull,0x800000000ull,
	0x1000000000ull,0x2000000000ull,0x4000000000ull,0x8000000000ull,
	0x10000000000ull,0x20000000000ull,0x40000000000ull,0x80000000000ull,
	0x100000000000ull,0x200000000000ull,0x400000000000ull,0x800000000000ull,
	0x1000000000000ull,0x2000000000000ull,0x4000000000000ull,0x8000000000000ull,
	0x10000000000000ull,0x20000000000000ull,0x40000000000000ull,0x80000000000000ull,
	0x100000000000000ull,0x200000000000000ull,0x400000000000000ull,0x800000000000000ull,
	0x1000000000000000ull,0x2000000000000000ull,0x4000000000000000ull,0x8000000000000000ull,
};

const u64 ncasilla[64]= {
         0xfffffffffffffffeull,         0xfffffffffffffffdull,         0xfffffffffffffffbull,         0xfffffffffffffff7ull,
         0xffffffffffffffefull,         0xffffffffffffffdfull,         0xffffffffffffffbfull,         0xffffffffffffff7full,
         0xfffffffffffffeffull,         0xfffffffffffffdffull,         0xfffffffffffffbffull,         0xfffffffffffff7ffull,
         0xffffffffffffefffull,         0xffffffffffffdfffull,         0xffffffffffffbfffull,         0xffffffffffff7fffull,
         0xfffffffffffeffffull,         0xfffffffffffdffffull,         0xfffffffffffbffffull,         0xfffffffffff7ffffull,
         0xffffffffffefffffull,         0xffffffffffdfffffull,         0xffffffffffbfffffull,         0xffffffffff7fffffull,
         0xfffffffffeffffffull,         0xfffffffffdffffffull,         0xfffffffffbffffffull,         0xfffffffff7ffffffull,
         0xffffffffefffffffull,         0xffffffffdfffffffull,         0xffffffffbfffffffull,         0xffffffff7fffffffull,
         0xfffffffeffffffffull,         0xfffffffdffffffffull,         0xfffffffbffffffffull,         0xfffffff7ffffffffull,
         0xffffffefffffffffull,         0xffffffdfffffffffull,         0xffffffbfffffffffull,         0xffffff7fffffffffull,
         0xfffffeffffffffffull,         0xfffffdffffffffffull,         0xfffffbffffffffffull,         0xfffff7ffffffffffull,
         0xffffefffffffffffull,         0xffffdfffffffffffull,         0xffffbfffffffffffull,         0xffff7fffffffffffull,
         0xfffeffffffffffffull,         0xfffdffffffffffffull,         0xfffbffffffffffffull,         0xfff7ffffffffffffull,
         0xffefffffffffffffull,         0xffdfffffffffffffull,         0xffbfffffffffffffull,         0xff7fffffffffffffull,
         0xfeffffffffffffffull,         0xfdffffffffffffffull,         0xfbffffffffffffffull,         0xf7ffffffffffffffull,
         0xefffffffffffffffull,         0xdfffffffffffffffull,         0xbfffffffffffffffull,         0x7fffffffffffffffull
};


// Leen Ammeraal's conditional one:
extern u32 MagicTable[32];

 u32 bitScanAndReset(u64 &bb) {
   u32 *ptr = (u32*)&bb;
   u32 a = *ptr;
   if ( a ) {
      a &= -(int)a;
      *ptr ^= a;
      return MagicTable[(a * 0xe89b2be) >> 27];
   } else {
      ptr++;
      a = *ptr;
      a &= -(int)a;
      *ptr ^= a;
      return MagicTable[(a * 0xe89b2be) >> 27] + 32;
   }
}

#ifndef PENTIUM
u64 rankAttacks(u64 occupied, u32 sq) {
   union {u64 b; struct {u32 l; u32 h;};} b; // little endian!
   u32 f = sq & 7;
   u32 r = sq & 24; // 8 * folded rank
   if ( sq < 32 ) {
      b.l = (((u32)occupied) >> (r+1)) & 63;
      b.l = firstRankAttacks[b.l][f] << r;
      b.h = 0;
   } else {
      b.l = 0;
      b.h = (((u32)(occupied>>32)) >> (r+1)) & 63;
      b.h = firstRankAttacks[b.h][f] << r;
   }
   return b.b;
}
u64 fileAttacks(u64 occupied, u32 sq) {
   union {u64 b; struct {u32 l; u32 h;};} b; // little endian!
   u32 f = sq & 7;
   b.b = occupied;
   b.l = (b.l >> f) & 0x01010101;
   b.h = (b.h >> f) & 0x01010101;
   b.l = (b.l << 4) + b.h;
   b.h = (b.l       * 0x10080402) >> 26;
   b.l = 0x08040201 * firstRankAttacks[b.h][(sq^56)>>3];
   b.h =((b.l << 4) & 0x80808080) >> (f^7);
   b.l = (b.l       & 0x80808080) >> (f^7);
   return b.b;
}

u64 diagonalAttacks(u64 occupied, u32 sq) {
   union {u64 b; struct {u32 l; u32 h;};} b; // little endian!
   b.b = occupied & diagonalMask[sq];
   b.h = ((b.l + b.h) * 0x02020202) >> 26;
   b.h = b.l = 0x01010101 * firstRankAttacks[b.h][sq&7];
   return b.b & diagonalMask[sq];
}

u64 antiDiagAttacks(u64 occupied, u32 sq) {
   union {u64 b; struct {u32 l; u32 h;};} b; // little endian!
   b.b = occupied & antidiagMask[sq];
   b.h = ((b.l + b.h) * 0x02020202) >> 26;
   b.h = b.l = 0x01010101 * firstRankAttacks[b.h][sq&7];
   return b.b & antidiagMask[sq];
}


int Log2(int v)
{
	//	int v; // 32-bit integer to find the log base 2 of
	int r; // result of log_2(v) goes here
	union { unsigned int u[2]; double d; } t; // temp

	t.u[1] = 0x43300000;
	t.u[0] = v;
	t.d -= 4503599627370496.0;
	r = (t.u[1] >> 20) - 0x3FF;
	return r;
}

static const char LogTable256[] =
{
  0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7
};

int MSB(u64 a)
{
	union {u64 b; struct {u32 l; u32 h;};} b; // little endian!
	register unsigned int t, tt; // temporaries
	b.b = a;
	if(b.h)
	{
		if (tt = b.h >> 16)
		{
			return 32+((t = b.h >> 24) ? 24 + LogTable256[t] : 16 + LogTable256[tt & 0xFF]);
		}
		else
		{
			return 32+((t = b.h >> 8) ? 8 + LogTable256[t] : LogTable256[b.h]);
		}
	}
	else
	if(b.l)
	{
		if (tt = b.l >> 16)
		{
			return (t = b.l >> 24) ? 24 + LogTable256[t] : 16 + LogTable256[tt & 0xFF];
		}
		else
		{
			return (t = b.l >> 8) ? 8 + LogTable256[t] : LogTable256[b.l];
		}
	}
	return 0;
}




#else
u64 rankAttacks(u64 occ, u32 sq) {
//   u32 f = sq &  7;
   u32 c = sq &  7; // la columna
   u32 r = sq & ~7; // fila * 8
   u32 o = (u32)((occ >> (r+1)) & 63); // desplazamos y nos quedamos con los 6 bits importantes
   return (u64) firstRankAttacks[o][c] << r; // devolvemos la mascara
}
u64 fileAttacks(u64 occ, u32 sq) {
   u32 f = sq & 7;
   occ   =   0x0101010101010101ull & (occ   >> f); // a-file
   u32 o = (u32)(( 0x0080402010080400ull *  occ ) >> 58);
   return  ( aFileAttacks[o][sq>>3]    ) << f;
}

u64 diagonalAttacks(u64 occ, u32 sq) {
   u32 f = sq & 7;
   occ   = ( diagonalMask[sq]   &  occ );
//   u32 o = (u32)( 0x0202020202020202ull *  occ ) >> 58;
   u32 o = (u32)(( 0x0202020202020202ull *  occ ) >> 58);
   return  ( diagonalMask[sq]   &  fillUpAttacks[o][f] );
}

u64 antiDiagAttacks(u64 occ, u32 sq) {
   u32 f = sq & 7;
   occ   = ( antidiagMask[sq]   &  occ );
   u32 o = (u32)(( 0x0202020202020202ull *  occ ) >> 58);
   return  ( antidiagMask[sq]   &  fillUpAttacks[o][f] );
}
#endif

#define m1 ((u64) 0x5555555555555555ull)
#define m2 ((u64) 0x3333333333333333ull)

unsigned int non_iterative_popcount(const u64 b) {
    u32 n;
    u64 a = b - ((b >> 1) & m1);
    u64 c = (a & m2) + ((a >> 2) & m2);
    n = ((u32) c) + ((u32) (c >> 32));
    n = (n & 0x0F0F0F0F) + ((n >> 4) & 0x0F0F0F0F);
    n = (n & 0xFFFF) + (n >> 16);
    n = (n & 0xFF) + (n >> 8);
    return n;
}

/*******************************************************************/
void GeneraDiag()
{
	extern int UseLog;
	u64 valor;
	int i;
	int j;
	UseLog = 1;
		PrintLog("const u64 diagonalMask[64] = { \n");
	for(i=0;i < 64;i++)
	{
		valor = 0x0;
		for(j= i; (j & 7) <= 7 && (j >> 3) <= 7; j += 9)
		{
			valor |= ((u64)1 << j);
			if((j&7) == 7)
				break;
			if((j >>3) == 7)
				break;
		}
		for(j= i; (j & 7) >= 0 && (j >> 3) >= 0; j -= 9)
		{
			valor |= ((u64)1 << j);
			if((j&7) == 0)
				break;
			if((j >>3) == 0)
				break;
		}
		PrintLog("\t 0x%08lx%08lxull,\n",(u32)(valor>>32),(u32)(valor&0xffffffffull));
	}
	PrintLog("};\n");

	PrintLog("const u64 antidiagMask[64] = { \n");
	for(i=0;i < 64;i++)
	{
		valor = 0x0;
		for(j= i; (j & 7) >= 0 && (j >> 3) <= 7; j += 7)
		{
			valor |= ((u64)1 << j);
			if((j&7) == 0)
				break;
			if((j >>3) == 7)
				break;
		}
		for(j= i; (j & 7) <= 7 && (j >> 3) >= 0; j -= 7)
		{
			valor |= ((u64)1 << j);
			if((j&7) == 7)
				break;
			if((j >>3) == 0)
				break;
		}
		PrintLog("\t 0x%08lx%08lxull,\n",(u32)(valor>>32),(u32)(valor&0xffffffffull));
	}
	PrintLog("};\n");

	PrintLog("const u8 firstRankAttacks[64][8] = { // [occ64][file] \n");
	int scan = 0;
	int k;
	for(i = 0; i < 64;i++)
	{
		PrintLog("\t{  // occ == %d \n",i);
		// obtenemos la pos en 8 bits
		scan = i <<1;
		for(j=0; j < 8;j++)
		{
			valor = 0;
			// bits a la izquierda
			for(k = j-1; k >= 0;k--)
			{
				valor |= (1ull <<k);
				if(scan &(1ull<<k))
					break;
			}
			// bits a la derecha
			for(k = j+1; k < 8;k++)
			{
				valor |= (1ull <<k);
				if(scan &(1ull<<k))
					break;
			}
			PrintLog("0x%02x,",valor);
		}
		PrintLog("\t},\n");
	}
	PrintLog("};\n");
	int file,x;
	for(file =0;file < 8;file++)
	{
		for (x=0; x<64; x++) {
//			fillUpAttacks[x][file] = 0x0101010101010101ULL * firstRankAttacks[x][file];
//			aFileAttacks[x][file^7] = ((0x8040201008040201ULL * firstRankAttacks[x][file]) & 0x8080808080808080ULL) >> 7;
		}
	}
	PrintLog("const u64 fillUpAttacks[64][8] = { // [occ64][file] \n");
	for (x=0; x<64; x++) {
		PrintLog("\t{ ");
		for(file =0;file < 8;file++)
		{
			valor = fillUpAttacks[x][file];
			PrintLog("0x%08lx%08lxull,",(u32)(valor>>32),(u32)(valor&0xffffffffull));
		}
		PrintLog("},\n");
	}
	PrintLog("};\n");
	PrintLog("const u64 aFileAttacks[64][8] = { // [occ64][file] \n");
	for (x=0; x<64; x++) {
		PrintLog("\t{ ");
		for(file =0;file < 8;file++)
		{
			valor = aFileAttacks[x][file];
			PrintLog("0x%08lx%08lxull,",(u32)(valor>>32),(u32)(valor&0xffffffffull));
		}
		PrintLog("},\n");
	}
	PrintLog("};\n");
	UseLog = 0;
}

