//    Copyright 2009 Antonio Torrecillas Gonzalez
//
//    This file is part of Rocinante.
//
//    Rocinante is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    Rocinante is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Rocinante.  If not, see <http://www.gnu.org/licenses/>
//

// Uci.cpp: implementation of the CUci class.
//
//////////////////////////////////////////////////////////////////////

#include "Uci.h"
#include "Test.h"

#include <stdio.h>
#include <string.h>

#include <stdlib.h>
#include <stdarg.h>

#include "Ajedrez.h"

#include "PgnParse.h"
#include "PgnRunner.h"
#include "Pgn2Epd.h"

#include "Sort.h"
#include "PLY.h"

#include "epd.h"
#include "EpdMudo.h"

#include "TreeNode.h"
#include "BStar.h"
#include "DumpTree.h"

#include "SmpManager.h"
#include "C3FoldRep.h"


#ifndef _MSC_VER
#define stricmp strcasecmp
#endif

#define E_INVALIDARG	-1
extern void Print(const char *fmt, ...);


extern CPartida Partida;


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CUci::CUci()
{
	initDone = 0;
	InitG = 1;
}

CUci::~CUci()
{

}

/**********************************************************************
** Salida hacia la consola y el log
*/

int UseLog = 1;

int DontPrintToLog = 0;

char *LogName()
{
	static char nombre[1024];
	if(nombre[0] == '\0')
	{
		char base[15];
		strcpy(nombre,".");
		strcat(nombre,"\\");
		strcpy(base,"log");
		strcat(nombre,base);
		strcat(nombre,".txt");
	}
	return nombre;
}
void Print(const char *fmt, ...)
{
  va_list   ap;
  FILE *fd;

  va_start(ap, fmt);
  vprintf(fmt, ap);
  fflush(stdout);
  if(DontPrintToLog == 0 && UseLog)
  {
	  fd = fopen("log.txt" ,"a+"); // LogName()
	  if(fd)
	  {
		vfprintf(fd, fmt, ap);
		fclose(fd);
	  }
  }
  va_end(ap);
}
void PrintLog(char *fmt, ...)
{
  va_list   ap;
  FILE *fd;

  if(!UseLog)
	  return;
  va_start(ap, fmt);
//	fd = fopen(LogName(),"a+");
  fd = fopen("log.txt","a+");
	vfprintf(fd, fmt, ap);
	fclose(fd);
  va_end(ap);
}

void CUci::start()
{
	extern int UseLog;
	char *token;
	// bucle principal
	memset(InputBuffer,0,sizeof(InputBuffer));
	UseLog = 0;
	while(gets(InputBuffer))
	{
		PrintLog("%s\n",InputBuffer);
		NewBuffer = 1;
		while((token = GetNextToken()) && (*token))
		{
			if(stricmp(token,"uci")==0)
			{
				Print("id name Rocinante 1.01\nid author Antonio Torrecillas\n");
				Print("option name credit_nps type spin default 700000 min 0 max 4000000\n");
				Print("option name ufo_eval type check default true\n");
				Print("option name cpus type spin default 1 min 0 max 256\n");
				Print("option name Threads type spin default 1 min 0 max 256\n");
				
//	   "option name Nullmove type check default true\n"
//      "option name Selectivity type spin default 2 min 0 max 4\n"
//	   "option name Style type combo default Normal var Solid var Normal var Risky\n"
//	   "option name NalimovPath type string default c:\\n"
//	   "option name Clear Hash type button\n"
				Print("uciok\n");
			}
			else
			if(stricmp(token,"quit")==0)	{
				Partida.Cancela();
				exit(0);
			}
			else
			if(stricmp(token,"debug")==0)	{		Debug();	}
			else
			if(stricmp(token,"isready")==0)	{
				if(initDone)
				{
					if(InitG)	Print("readyok\n");
				}
				else
				{
					initDone = 1;
					// init engine
					Print("readyok\n");
				}
			}
			else 
			if(stricmp(token,"setoption")==0)	{		SetOption();	} 
			else
			if(stricmp(token,"ucinewgame")==0)	{		UciNewG();		} 
			else
			if(stricmp(token,"position")==0)		{		Position();		} 
			else
			if(stricmp(token,"go")==0)			{		Go();			} 
			else
			if(stricmp(token,"stop")==0)			{		Stop();			} 
			else
			if(stricmp(token,"ponderhit")==0)	{
				// to do switch to normal mode.
			} 
			else
			{
				if(*token == '\0')
					break;
				Print("info string token <%s>\n",token);
			}
		}
		memset(InputBuffer,0,sizeof(InputBuffer));
	}
}

char * CUci::GetNextToken()
{
static char *Seps = " \t\n\r";
static char *aux = NULL;
char *pres;
char car;
static char res[1024];
	if(aux == NULL)
		aux = InputBuffer;
	if(NewBuffer)
	{
		NewBuffer = 0;
		aux = InputBuffer;
	}
	if(!(*aux))
		return NULL;
	pres = &res[0];
	while(car = *aux)
	{
		if(car == ' ' || car == '\t' || car == '\n' || car == '\r' || car == '\0')
			break;
		*pres++ = car;
		aux++;
	}
	
	if(*aux)
		aux++;
	*pres = '\0';
	return &res[0];
}

void CUci::Debug()
{
	// on off
	char *token ; 
	token = GetNextToken();
	if(stricmp(token,"on")==0)	{		Print("info string debug mode on\n");	}
	else
	if(stricmp(token,"off")==0)	{		Print("info string debug mode off\n");	}
	else
	if(stricmp(token,"test")==0)
	{
		Print("info string debug test on\n");
		CTest t;
		t.Test();
		Print("info string debug test off\n");
	}
	else
	if(stricmp(token,"kiwipete")==0)
	{
		Partida.LoadEPD("r3k2r/p1ppqpb1/bn2pnp1/3PN3/1p2P3/2N2Q1p/PPPBBPPP/R3K2R w KQkq - 0 1 ");
		Print("info string kiwipete position loaded\n");
	}
	else
	if(stricmp(token,"testepd")==0)
	{
		int depth_time;
		char * path = GetNextToken();
		if(path)
		{
			depth_time = atoi(path);
			path = GetNextToken();
			if(path && *path)
			{
				char local[200];
				strcpy(local,path);
				CTest t;
				t.TestEpd(depth_time,local);
			}
			else
			{
				Print("info string Sintax: debug testepd depth(0-50) file.pgn\n");
				Print("info string Sintax: debug testepd time(miliseg) file.pgn\n");
			}
		}
		else
		{
				Print("info string Sintax: debug testepd depth(0-50) file.pgn\n");
				Print("info string Sintax: debug testepd time(miliseg) file.pgn\n");
		}
	}
	else
	if(stricmp(token,"perft")==0)
	{
	   int d = 0;
		token = GetNextToken();
		if(token && *token)
		{
			d = atoi(token);
			CTest t;
		   t.DoPerft(d);
		}
		else
		{
			Print("info string Sintax: debug perft depth\n");
		}
	}
	else
	if(stricmp(token,"display")==0)
	{
	   Partida.Taux.DibujaP();
	   char dest[100];
	   Partida.Taux.SaveFEN(&dest[0]);
	   Print("%s\n",dest);
	}
	else
	if(stricmp(token,"score")==0)
	{
		Partida.Taux.FullEval();
	   char dest[100];
	   Partida.Taux.SaveFEN(&dest[0]);
		Print("%s;%d\n",dest,Partida.Taux.GetEval());
    }
	else
	if(stricmp(token,"split")==0)
	{
		token = GetNextToken();
		if(token && *token)
		{
			CTest t;
			t.Split(token);
		}
	}
	else
	if(stricmp(token,"reset")==0)
	{
		Partida.ResetParam();
	}
	else
	if(stricmp(token,"suite")==0)
	{
		CTest t;
		t.TestSuite();
	}
	else
	if(stricmp(token,"simetria")==0)
	{
		token = GetNextToken();
		if(token && *token)
		{
			CTest t;
			t.TestSimetria(token);
		}
	}
	else
	if(stricmp(token,"pgn2epd")==0)
	{
		token = GetNextToken();
		Pgn2Epd t;
		t.Parsea(token);
	}
	else
	if(stricmp(token,"bstar")==0)
	{
		BStar bt;
		bt.Run();
	}
	else
	if(stricmp(token,"test1")==0)
	{
		CEpdMudo unTest;
		unTest.tiempo = 0;
		unTest.profundidad = 1;
		unTest.epdfile = "vtest11.epd";
		unTest.Start();
	}
	else
	if(stricmp(token,"eval")==0)
	{
		char test[200];
		CEpdMudo unTest;
		unTest.tiempo = 0;
		unTest.profundidad = 1;
		token = GetNextToken();
		test[0] = '\0';
		strcpy(test,token);
		unTest.epdfile = &test[0];
		unTest.Start();
	}
	else
	if(stricmp(token,"dumptree")==0)
	{
		DumpTree dt;
		dt.Write();
	}
}

void CUci::SetOption()
{
	char *name = GetNextToken();
	char *value;
	if(stricmp(name,"name") != 0) return;
//	   "setoption name Nullmove value true\n"
//      "setoption name Selectivity value 3\n"
//	   "setoption name Style value Risky\n"
//	   "setoption name Clear Hash\n"
//	   "setoption name NalimovPath value c:\chess\tb\4;c:\chess\tb\5\n"
	name = GetNextToken();
	// hacer lo que toque
	if(stricmp(name,"credit_nps")==0)
	{
		value = GetNextToken();
		if(stricmp(value,"value")==0)
		{
			extern int nps;
			value = GetNextToken();
			nps = atoi(value);
		}
	}
	else
	if(stricmp(name,"ufo_eval")==0)
	{
		value = GetNextToken();
		if(stricmp(value,"value")==0)
		{
			extern bool Useufo;
			value = GetNextToken();

			if(value && stricmp(value,"true")==0)
				Useufo = true;
			else
				Useufo = false;
		}
	}
	else
	if(stricmp(name,"cpus")==0)
	{
		value = GetNextToken();
		if(stricmp(value,"value")==0)
		{
			int ncpus;
			value = GetNextToken();
			ncpus = atoi(value);
			SmpWorkers.InitWorkers(ncpus);
		}
	}
	else
	if(stricmp(name,"Threads")==0)
	{
		value = GetNextToken();
		if(stricmp(value,"value")==0)
		{
			int ncpus;
			value = GetNextToken();
			ncpus = atoi(value);
			SmpWorkers.InitWorkers(ncpus);
		}
	}
}

void CUci::UciNewG()
{
	InitG = 0;
	Partida.Nueva();
	// to do new g....
	InitG = 1;
}

// position [fen <fenstring> | startpos ]  moves <move1> .... <movei>

void CUci::Position()
{
	static char *startpos = "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq -";
	char *token = GetNextToken();
	char fen[80];
	if(stricmp(token,"startpos")==0)
	{
		strcpy(fen,startpos);
	}
	else
	{	if(stricmp(token,"fen")==0)
		{
			token = GetNextToken();
			strcpy(fen,token);
			token = GetNextToken(); // w b
			strcat(fen," ");
			strcat(fen,token);
			token = GetNextToken(); // casting
			strcat(fen," ");
			strcat(fen,token);
			token = GetNextToken(); // e.p.
			strcat(fen," ");
			strcat(fen,token);
			token = GetNextToken(); // 
			strcat(fen," ");
			strcat(fen,token);
			token = GetNextToken(); // 
			strcat(fen," ");
			strcat(fen,token);
		}
	}
	// init to fen pos.
	Partida.Nueva();
	Partida.LoadEPD((char*)fen);

	ThreeFold.Reset();
	// get moves
	token = GetNextToken();
	if(token && *token && stricmp(token,"moves")==0)
	{
		token = GetNextToken();
		while(token && *token)
		{
			// process move
		   if(Partida.Mueve(token)== E_INVALIDARG)
		   {
			   PrintLog("Error en Movimiento %s\n",token);
		   }
		   // detect repetition.
		   Partida.Taux.SaveFEN(&fen[0]);
		   ThreeFold.Add(&fen[0]);
			// get next move
			token = GetNextToken();
		}
	}
//	Partida.T.Dibuja();
}

void CUci::Go()
{
	int wTime,bTime,winc,binc,movestogo,depth,nodes,mate,movetime;
	char movesList[1024];
	int PonderMode = 0;
	char *token = GetNextToken();
	wTime = bTime = winc = binc = movestogo = depth = nodes = mate = movetime = 0;
	Partida.LimiteProfundidad = 0;
	Partida.tiempo= 0;
	Partida.incremento= 0;
	while(token && *token)
	{
		if(stricmp(token,"infinite") == 0)
		{
			// to do no depth no time limit go
		}
		else
		if(stricmp(token,"searchmoves") == 0)
		{
			token = GetNextToken();
			while(token && *token)
			{
				strcat(movesList,token);
				strcat(movesList," ");
				token = GetNextToken();
			}
		}
		else
		if(stricmp(token,"ponder") == 0)
		{
			PonderMode = 1;
		}
		else
		if(stricmp(token,"wtime") == 0)
		{
			token = GetNextToken();
			wTime = atoi(token);
		}	
		else
		if(stricmp(token,"btime") == 0)
		{
			token = GetNextToken();
			bTime = atoi(token);
		}
		else
		if(stricmp(token,"winc") == 0)
		{
			token = GetNextToken();
			winc = atoi(token);
		}
		else
		if(stricmp(token,"binc") == 0)
		{
			token = GetNextToken();
			binc = atoi(token);
		}
		else
		if(stricmp(token,"movestogo") == 0)
		{
			token = GetNextToken();
			movestogo = atoi(token);
		}
		else
		if(stricmp(token,"depth") == 0)
		{
			token = GetNextToken();
			depth = atoi(token);
		}
		else
		if(stricmp(token,"nodes") == 0)
		{
			token = GetNextToken();
			nodes = atoi(token);
		}
		else
		if(stricmp(token,"mate") == 0)
		{
			token = GetNextToken();
			mate = atoi(token);
		}
		else
		if(stricmp(token,"movetime") == 0)
		{
			token = GetNextToken();
			movetime = atoi(token);
		}
		token = GetNextToken();
	}
	// execute go

   if (depth > 0) {
	   Partida.LimiteProfundidad = depth;
		BStar::SetProbeDepth(depth);
   } else if (mate > 0) {
	   Partida.LimiteProfundidad = mate*2-1; // conversion de jugadas a movimientos
   }

   // time limit
	if(Partida.ColorJuegan() == blanco)
	{
		Partida.tiempo= (long)wTime;
		Partida.incremento= (long)winc;
	}
	else
	{
		Partida.tiempo=(long) bTime;
		Partida.incremento=(long) binc;
	}

	if(Partida.incremento < 0)
		Partida.incremento = 0;
   if (movestogo <= 0 || movestogo > 30) movestogo = 30; // HACK

   if (movetime > 0) {

      // fixed time
	  Partida.tiempo_limite =(long) movetime;

   } 
   else 
   {

      // dynamic allocation
      double time_max = Partida.tiempo * 0.95 - 1.0;
      if (time_max < 0.0) time_max = 0.0;

      double alloc = (time_max + Partida.incremento * double(movestogo-1)) / double(movestogo);
      if (alloc > time_max) alloc = time_max;
	  Partida.tiempo_limite =(long) alloc;
   }

 static char dest[100];
   Partida.Taux.SaveFEN(&dest[0]);
   RunBStar(dest);
}

void CUci::Stop()
{
	extern 	char movestr[10];
	// la impresion de la jugada se realiza en Partida.IterativeDeepening();
	Partida.Cancela();
}
