//    Copyright 2009 Antonio Torrecillas Gonzalez
//
//    This file is part of Rocinante.
//
//    Rocinante is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    Rocinante is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Rocinante.  If not, see <http://www.gnu.org/licenses/>
//

#include "stdio.h"
#include "stdlib.h"
#include "memory.h"
#include "string.h"
#include <time.h>

#include "epd.h"
#include "Ajedrez.h"
#include "TestSimetria.h"
#include "Sort.h"
#include "PLY.h"

CTestSimetria::CTestSimetria()
{
}
CTestSimetria::~CTestSimetria()
{
}

bool CTestSimetria::ProcesaTestEpd()
{
	int uno,dos;
	// leer la posicion normal
	// evaluarla
	Partida.Taux.FullEval();
	uno = Partida.Taux.GetEval();
	// leer la posicion simetrica
   char dest[100];
   Partida.Taux.SaveFEN(&dest[0]);
	Partida.Taux.LoadEPD(dest,1);
	// evaluarla
	Partida.Taux.FullEval();
	dos = Partida.Taux.GetEval();
	// debe ser iguales.
	if(uno != dos)
	{
		Partida.Taux.LoadEPD(dest,1);
		Partida.Taux.Dibuja();
		Partida.Taux.LoadEPD(dest,1);
		Partida.Taux.Dibuja();
		
		return uno == dos;
	}
	else
		return uno == dos;
}
