//    Copyright 2009 Antonio Torrecillas Gonzalez
//
//    This file is part of Rocinante.
//
//    Rocinante is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    Rocinante is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Rocinante.  If not, see <http://www.gnu.org/licenses/>
//

#include "stdio.h"
#include "stdlib.h"
#include "memory.h"
#include "string.h"
#include <time.h>

#include "Test.h"
#include "Ajedrez.h"
#include "Sort.h"

#include "epd.h"
#include "EpdMudo.h"
#include "TestSimetria.h"


#include "PLY.h"

extern CPartida Partida;


const int VERIFPOS = false;


CTest::CTest(void)
{
}

CTest::~CTest(void)
{
}

void CTest::Test()
{
	extern int UseLog;

	Print("CSort %d\n",sizeof(CSort));
	Print("CJugada %d\n",sizeof(CJugada));
	Print("CDiagrama %d\n",sizeof(CDiagrama));
	Print("CPartida %d\n",sizeof(CPartida));
	Print("PLY %d\n",sizeof(PLY));
	return;
	UseLog = 1;
//3r1rk1/1pq1nppp/p7/2pB3Q/P4P2/1P2P3/6PP/2RR2K1 w - - bm Rxc5; id "GMG1.092";
	//T.LoadEPD("1R6/1brk2p1/4p2p/p1P1Pp2/P7/6P1/1P4P1/2R3K1 w - - ",0);//bm Rxb7; id "WAC.015";;8;850018
//	Partida.T.LoadEPD("rb3qk1/pQ3ppp/4p3/3P4/8/1P3N2/1P3PPP/3R2K1 w - - ",0);//bm Qxa8 d6 dxe6; id "WAC.031";;8;550012;10;2600052
//	Partida.T.LoadEPD("r5k1/1rpq1b1p/2p3p1/B1P2p2/1P2pb2/8/P1Q1NPPP/3RR1K1 b - - 6 40 ",0);// bm 40. ...Bf4-d6? ;
	//MuevePath("e4d6 c4d6 c1c6 a6c4 c6d6 e7d6 d1d6 c4a2 ");//c4d6 c1c6 a6c4 d1d6 c4a2 d6d7");
	Partida.Taux.LoadEPD("3r1rk1/1pq1nppp/p7/2pB3Q/P4P2/1P2P3/6PP/2RR2K1 w - - ",0);// bm 40. ...Bf4-d6? ;
	Partida.Taux.FullEval();
	int v = Partida.Taux.GetEval();
	Partida.Taux.Dibuja();

//	Partida.LimiteProfundidad =11;
	Partida.tiempo_limite = 60000;
	char PV[1024];
	PV[0] = '\0';
	Partida.cancelado = 0;

	return;
}

void CTest::TestSuite()
{
	// sanity check
	TestEpd(1000,"split_0.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_0.txt");
	TestEpd(1000,"split_1.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_1.txt");
	TestEpd(1000,"split_2.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_2.txt");
	TestEpd(1000,"split_3.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_3.txt");
	TestEpd(1000,"split_4.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_4.txt");
	TestEpd(1000,"split_5.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_5.txt");
	TestEpd(1000,"split_6.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_6.txt");
	TestEpd(1000,"split_7.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_7.txt");
	TestEpd(1000,"split_8.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_8.txt");
	TestEpd(1000,"split_9.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_9.txt");
	TestEpd(1000,"split_10.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_10.txt");
	TestEpd(1000,"split_11.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_11.txt");
	TestEpd(1000,"split_12.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_12.txt");
	TestEpd(1000,"split_13.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_13.txt");
	TestEpd(1000,"split_14.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_14.txt");
	TestEpd(1000,"split_15.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_15.txt");
	TestEpd(1000,"split_16.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_16.txt");
	TestEpd(1000,"split_17.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_17.txt");
	TestEpd(1000,"split_18.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_18.txt");
	TestEpd(1000,"split_19.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_19.txt");
	TestEpd(1000,"split_20.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_20.txt");
	TestEpd(1000,"split_21.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_21.txt");
	TestEpd(1000,"split_22.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_22.txt");
	TestEpd(1000,"split_23.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_23.txt");
	TestEpd(1000,"split_24.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_24.txt");
	TestEpd(1000,"split_25.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_25.txt");
	TestEpd(1000,"split_26.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_26.txt");
	TestEpd(1000,"split_27.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_27.txt");
	TestEpd(1000,"split_28.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_28.txt");
	TestEpd(1000,"split_29.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_29.txt");
	TestEpd(1000,"split_30.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_30.txt");
	TestEpd(1000,"split_31.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_31.txt");
	TestEpd(1000,"split_32.epd");
	rename("c:/test/testepd.txt","c:/test/result/split_32.txt");

	TestEpd(5000,"wac.epd");
	rename("c:/test/testepd.txt","c:/test/result/wac.txt");
	TestEpd(5000,"wcsac.epd");
	rename("c:/test/testepd.txt","c:/test/result/wcsac.txt");
	TestEpd(5000,"twgcg.epd");
	rename("c:/test/testepd.txt","c:/test/result/twgcg.txt");
	TestEpd(60000,"pet.epd");
	rename("c:/test/testepd.txt","c:/test/result/pet.txt");
	TestEpd(60000,"eet.epd");
	rename("c:/test/testepd.txt","c:/test/result/eet.txt");

	return;

}

void CTest::TestSimetria(char *epd)
{
	CTestSimetria unTest;
	unTest.tiempo = 0;
	unTest.profundidad = 0;
	unTest.epdfile = epd;
	unTest.Start();
}




// utilidad para separar los tests por numero de piezas presentes
//#define SPLIT
//#define SPLIT_FINAL

void CTest::Split(char *comando)
{
	extern int UseLog;
	char Test[0x300];
	char Epd[0x300];
	char *aux;
	int i;
//	char *path = strstr(comando," ");
	FILE * fi;
	FILE *fo;
	FILE *fsi;
	FILE *fno;
	// abrir el archivo
	fo = fopen("testepd.txt","w+");
	fi = fopen(comando,"r");
	fsi = fopen("si.txt","w+");
	fno = fopen("no.txt","w+");

	FILE *Split[33];
	int piezas;
	char nombre_spli[100];
	for(i=0;i< 33;i++)
	{
		sprintf(nombre_spli,"sp_%d.epd",i);
		Split[i] = fopen(nombre_spli,"w+");
	}

	if(fi)
	{
	// cada linea es un test individual
		int blancos;
		while(fgets(Test,sizeof(Test),fi))
		{
			if(Test[0] == '\r')
				break;
			if(Test[0] == '\n')
				break;
			if(Test[0] == ';') // saltamos los comentarios
			{
				PrintLog(Test);
				continue;
			}
			if(Test[0] == '\0')
				break;
			// separa epd de la solucion
			// buscar el ';' atras hasta un ' '
			memset(Epd,0,sizeof(Epd));
			blancos = 0;
			aux = Test;

			// carga y prueba del test
			Partida.Nueva();
			Partida.Taux.LoadEPD(Test,0);
			int fase = 0;
			u64 aux;
			aux = Partida.Taux.BPiezas[caballo][blanco] |Partida.Taux.BPiezas[caballo][negro];
			fase += popCount(aux);
			aux = Partida.Taux.BPiezas[alfil][blanco] |Partida.Taux.BPiezas[alfil][negro];
			fase += popCount(aux);
			aux = Partida.Taux.BPiezas[torre][blanco] |Partida.Taux.BPiezas[torre][negro];
			fase += 3*popCount(aux);
			aux = Partida.Taux.BPiezas[dama][blanco] |Partida.Taux.BPiezas[dama][negro];
			fase += 6*popCount(aux);
			fase = 32 - fase;
			if(fase < 0) fase = 0;
			if(fase >32) fase = 32;
			fprintf(Split[fase],"%s",Test);

			Test[0] = '\0';
		}
		fclose(fi);
		fclose(fo);
	}
	fclose(fsi);
	fclose(fno);
	for(i=0;i< 33;i++)
	{
		fclose(Split[i]);
	}
	Print("Separacion finalizada\n");
	DontPrintToLog = 0;
}

void CTest::TestEpd(int depth_time,char *pgnfile)// pasa un test epd
{
	CEpd unTest;
	if(depth_time < 25)
	{
		unTest.tiempo = 0;
		unTest.profundidad = depth_time;
	}
	else
	{
		unTest.tiempo = depth_time;
		unTest.profundidad = 0;
	}
	unTest.epdfile = pgnfile;
	unTest.Start();
}


//#define VERIFIPERFT
//#define TRAZA_PERFT
void CTest::DoPerft(int ply)
{
	extern void Print(const char *fmt, ...);
	extern int UseLog;
	static long inicio;

	inicio = TiempoTranscurrido();
	UseLog = 1;
	Partida.NodosVisitados = 0;
	Partida.Taux.FullEval();
	Perft(ply);
	int tiempo = TiempoTranscurrido()-inicio;
	if(tiempo == 0)tiempo = 1000;
	Print("Total Jugadas %ld en %ld nps=%ld\n",Partida.NodosVisitados,tiempo,Partida.NodosVisitados/(tiempo));
	UseLog = 0;
}

const int UsePerftCache = false;
const int UsePerftOrderedMove = false;
const int UsePerftEval = false;
const int UsePerftRepDet = false;
const int UsePerftVerifCheck = false;
const int UsePerftNeutras = false;
const int UsePerftPV = false;
const int UsePerft7 = false;

const int GenTestScore = false;

void CTest::Perft(int ply)
{
	extern int UseLog;
	int Vlocal;
	CSort Sort;
	int StatusEnroque; // color , 0 -> rey ,1 -> torre rey,2 -> torre dama
	int alpaso;
	u64 hash;
    int oldcount=Partida.NodosVisitados; 
	char PV[1024];
	int neutras = 0,legales = 0;
	if(ply == 0)
		return;
	char *fen_ori;
	if( VERIFPOS )
	{
	   char dest[100];
	   Partida.Taux.SaveFEN(&dest[0]);
		fen_ori = strdup(dest);
	}
	if(UsePerftVerifCheck)
	{
		int EsJaque = Partida.Taux.EstoyEnJaque();
	}

	Vlocal = Partida.Taux.GetEval();

	Sort.Init(Partida.Taux,false);

	// salvamos el estado
	alpaso = Partida.Taux.en_pasant ;
	StatusEnroque = Partida.Taux.EstadoEnroque;
	// ahora recorremos las jugadas
	CJugada J;
	J = Sort.GetNext();
	while(J.ToInt())
	{
		Partida.Taux.Mueve(J);
		if( VERIFPOS )
		{
			if(Partida.Taux.board(Partida.Taux.PosReyes[blanco]) != rey)
			{
				Print("Error en posReyes\n");
			}
			if(Partida.Taux.board(Partida.Taux.PosReyes[negro]) != rey)
			{
				Print("Error en posReyes\n");
			}
		}
		if(!Partida.Taux.EsAtacada(Partida.Taux.PosReyes[Partida.Taux.ColorJuegan^1],Partida.Taux.ColorJuegan^1))
		{
			if(UsePerft7)
			{
				Partida.Taux.Es7a(J);
			}
			if(UsePerftNeutras)
			{
				PV[0] = '\0';
				if( //J.jaque == 0 && 
					J.desglose.coronar == ninguna
					&& J.desglose.captura == ninguna
					)
				{
					neutras++;
				}
				legales++;
			}
			if(ply -1)
				Perft(ply-1);
			else
			{
				Partida.NodosVisitados++;
				if(GenTestScore )
				{
					UseLog = 1;
				   char dest[100];
				   Partida.Taux.SaveFEN(&dest[0]);
					PrintLog("position fen %s\n",dest);
					PrintLog("score\n");
					UseLog = 0;
				}
			}

		}

		Partida.Taux.DesMueve(J);
		// restaurar estatus...
		Partida.Taux.en_pasant = alpaso;
		Partida.Taux.EstadoEnroque = StatusEnroque;
		if( VERIFPOS )
		{
		   char dest[100];
		   Partida.Taux.SaveFEN(&dest[0]);
			char *fen_final = strdup(dest);
			if(strcmp(fen_final,fen_ori)!= 0)
			{
				Print("ERROR MOVIMIENTOS\n");
				Print("Original %s\n",fen_ori);
				Print("Final %s\n",fen_final);
				Print("Ultimo movimiento %s\n",J.ToString());
				Partida.Taux.Dibuja();
				Partida.Taux.LoadEPD(fen_ori,0); // restauramos el original
				Partida.Taux.Dibuja();
			}
			free(fen_final);
		}
		J = Sort.GetNext();
	}
	if(UsePerftRepDet)
	{
		Partida.PopHistory();
	}
	if( VERIFPOS )
	{
		free(fen_ori);
	}
}

