//    Copyright 2009 Antonio Torrecillas Gonzalez
//
//    This file is part of Rocinante.
//
//    Rocinante is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    Rocinante is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Rocinante.  If not, see <http://www.gnu.org/licenses/>
//

#include <assert.h>
#include "Ajedrez.h"
#include "PgnParse.h"
#include "PgnRunner.h"


void PgnRunner::EstudiaPartida(char *mov,int res)
{
	char *ptr;
	resultado = res;
	Partida.Nueva();
	// clean up
	memset(AnJugadas,0,sizeof(AnJugadas));
	AnUltimaJugada = 0;
	// trocear las jugadas // Parse Moves
	char *stAux = mov;
	ptr = mov;
   for (; ptr != NULL;) 
   {
	   while(*stAux)
	   {
		   switch(*stAux)
		   {
		   case '*':
		   case ' ':
			   *stAux++ = '\0';
			   while(*stAux == ' ' || *stAux == '.' || *stAux == '\n' || *stAux == '\r' )
				   *stAux++ = '\0';
			   goto siguiente;
			   break;
		   case '.':
			   *stAux++ = '\0';
			   while(*stAux == ' ' || *stAux == '.' || *stAux == '\n' || *stAux == '\r' )
				   *stAux++ = '\0';
			   goto siguiente;
			   break;
		   case '\n':
			   *stAux++ = '\0';
			   while(*stAux == ' ' || *stAux == '.' || *stAux == '\n' || *stAux == '\r' )
				   *stAux++ = '\0';
			   goto siguiente;
			   break;
		   case '\r':
			   *stAux++ = '\0';
			   while(*stAux == ' ' || *stAux == '.' || *stAux == '\n' || *stAux == '\r' )
				   *stAux++ = '\0';
			   goto siguiente;
			   break;
		   }
		   stAux++;
	   }
siguiente:
	   if(!*ptr)
		   break;
	   if(strcmp(ptr,"0-1")==0)
		   break;
	   if(strcmp(ptr,"1-0")==0)
		   break;
	   if(strcmp(ptr,"1/2-1/2")==0)
		   break;
	   if(strstr(ptr,"/"))
		   break;
	   if((*ptr >= '1') && (*ptr <= '9'))
	   {
		   if(Partida.Taux.ColorJuegan == negro)
		   {
			   PrintLog("Error de color en jugada %s\n",ptr);
			   break;
		   }
	   }
	   else
	   {
		// efectuarlas // Just do it
		   AnColorJuegan = Partida.Taux.ColorJuegan;
		   strcpy(AnJugadas[AnUltimaJugada][AnColorJuegan],ptr);
		   // realizamos el movimiento // do the move
		   Partida.Taux.MuevePgn(ptr);
		   // analiza la posicion
		   ProcesaPosicion();
		   if(cancela)
			return;
			// increment move number
		   if(Partida.Taux.ColorJuegan == blanco)
			   AnUltimaJugada++;
	   }
	   ptr = stAux;
   }
}

void PgnRunner::ProcesaPosicion()
{
}
