//    Copyright 2009 Antonio Torrecillas Gonzalez
//
//    This file is part of Rocinante.
//
//    Rocinante is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    Rocinante is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Rocinante.  If not, see <http://www.gnu.org/licenses/>
//

#include <assert.h>
#include "Ajedrez.h"
#include "PgnParse.h"


void PgnParse::Parsea(char *camino) // analiza un pgn
{
	init_time = TiempoTranscurrido();
	NumGames = 0;
	char *strAux;
static 	char Linea[0x2000];
static	char Digest[0x8000];
	int Resultado = 0;
	int Estado;
    Estado = 1;
	Digest[0] = '\0';
	Linea[0] = '\0';
	fi = fopen(camino,"r");
	if(!fi) return;
	Open();
	cancela = false;
	while(!feof(fi))
	{
		if(cancela) break;
		Linea[0] = '\0';
		fgets(Linea,sizeof(Linea),fi);
		if(	Linea[0] == '\0')
			break;

            if(Estado == 0)
            {
                if (Linea[0] == '[')
                {
                    // hemos completado una
                    // procesamos
					if(Digest[0] == '{')
					{
						QuitaComentarios(Digest);
					}
                    if(Digest[0] == '1' && Digest[1] == '.')
                    {
						// anyadimos el resultado
						QuitaComentarios(Digest);
						EstudiaPartida(Digest,Resultado);
						NumGames++;
						Digest[0] = '\0';
						Resultado = 0;
						// volver a empezar
						Estado = 1;
					}
				}
				else
				{
					char *stAux;
					if(stAux = strstr(Linea,"+\n"))
					{
						stAux[1] = ' ';
						stAux[2] = '\0';
					}
					
					strcat(Digest,Linea);
				}
            }
            else
            {
                if (Linea[0] != '[')
                {
					Digest[0] = '\0';
                    Estado = 0;
					Linea[0] = '\0';
                }
				if(strAux = strstr(Linea,"Event"))
				{
					strAux += 7; //[Event "14th World Computer Champ."]
					char *strd = &AnEvent[0];
					while(*strAux != '"' && *strAux != '\0')
						*strd++ = *strAux++;
					*strd = '\0';
				}
				if(strAux = strstr(Linea,"Round"))
				{
					strAux += 7; //[Round "1"]
					char *strd = &AnRound[0];
					while(*strAux != '"' && *strAux != '\0')
						*strd++ = *strAux++;
					*strd = '\0';
				}
				if(strAux = strstr(Linea,"White"))
				{
					strAux += 7; //[White "Ikarus"]
					char *strd = &AnWhite[0];
					while(*strAux != '"' && *strAux != '\0')
						*strd++ = *strAux++;
					*strd = '\0';
				}
				if(strAux = strstr(Linea,"Black"))
				{
					strAux += 7; //[Black "Etabeta"]
					char *strd = &AnBlack[0];
					while(*strAux != '"' && *strAux != '\0')
						*strd++ = *strAux++;
					*strd = '\0';
				}

				strcat(Digest,Linea);
				if (strncmp(Linea,"[Result \"1-0\"]",14) == 0)
				{
					Resultado = 1;
				}
				if (strncmp(Linea,"[Result \"0-1\"]",14) == 0)
				{
					Resultado = -1;
				}
				if (strncmp(Linea,"[Result \"1/2-1/2\"]",18) == 0)
				{
					Resultado = 0;
				}
			}
		Linea[0] = '\0';
	}
	// Procesamos la ultima partida
	QuitaComentarios(Digest);
	EstudiaPartida(Digest,Resultado);
	NumGames++;
	fclose(fi);
	time_end = TiempoTranscurrido();
	Close();
}
void PgnParse::QuitaComentarios(char *texto)
{
	char *from,*to;
	int status = 0; // status 0 -> initial
					// status 1 -> copy
					// status 2 -> skip
	from = texto;
	to = texto;
	while(*from) // until end of string
	{
		if(status == 1)
		{
			if(*from == '{')
			{
				status = 2;
				from++;
			}
			else
			{
			*to++ = *from++;
			}
		}
		else
			if(status == 2)
			{
				if(*from == '}')
				{
					status = 1;
					from++;
					while( *from == ' ')
						from++;
				}
				else
					from++;
			}
			else
			{
				if(*from == '{')
				{
					status = 2;
					from++;
				}
				else
				{
					from++;
					to++;
				}
			}
	}
	// end of string
	*to = '\0';
}



void PgnParse::EstudiaPartida(char *Digest,int Resultado)
{
}
