//    Copyright 2009 Antonio Torrecillas Gonzalez
//
//    This file is part of Rocinante.
//
//    Rocinante is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    Rocinante is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Rocinante.  If not, see <http://www.gnu.org/licenses/>
//

#include <assert.h>
#include "Ajedrez.h"
#include "Sort.h"
#include "string.h"
#include "PLY.h"
#include "ufo.h"

int EvalMode = 0;



extern u64 ataque[8][64];

const int UseBishopPair = true;


static int _BaseIndex[256] = {0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0
};
// generacion de jugadas y evaluacn
static CSort _SORT[256][MAXDEPTH];

PLY::PLY(int Thread)
{
	assert(_BaseIndex[Thread] < MAXDEPTH);
	ThreadId = Thread;
	PlyIndex = _BaseIndex[Thread]++;
	// asignar punteros a cosas....
	pSort = &_SORT[Thread][PlyIndex];
}

PLY::~PLY()
{
	assert(_BaseIndex[ThreadId] > 0);
	_BaseIndex[ThreadId]--;
}

void PLY::Init(CDiagrama &Tablero,int EsQuiesce)
{
	pSort->Init(Tablero,EsQuiesce);
}
CJugada PLY::GetNext()
{
	return pSort->GetNext();
}
CJugada PLY::GetNextQ()
{
	return pSort->GetNextQ();
}

void PLY::Move(CJugada J)
{
	pSort->T->Mueve(J);
}
void PLY::TakeBack(CJugada J)
{
	pSort->T->DesMueve(J);
	pSort->T->en_pasant = pSort->en_pasant;
	pSort->T->EstadoEnroque = pSort->EstadoEnroque;
}

