//    Copyright 2009 Antonio Torrecillas Gonzalez
//
//    This file is part of Rocinante.
//
//    Rocinante is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    Rocinante is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Rocinante.  If not, see <http://www.gnu.org/licenses/>
//

#include <assert.h>
#include "Ajedrez.h"
#include "Sort.h"
#include "TreeNode.h"
#include "JobWorker.h"
#include "Oracle.h"

extern bool Useufo;

const int MateOpt = 5000; //2000; //1100; 
const int CheckOpt = 2000; //1700; 
const int MateMove = 70; 

const int CheckValueDepth = 130;
const int PesoLegales = 40; 
const int ValorReyForzado = 600; 

JobWorker::JobWorker(void)
{
}
JobWorker::~JobWorker(void)
{
}
void JobWorker::DoJob(void)
{

	Board.LoadEPD(Node->fen,0);
	if(Node->StaticVal == UNDEFINED)
	{
		Node->RealVal = GetRealVal();
		Node->StaticVal = Node->RealVal;
	}
	if(EvalOptimism)
	{
		if(Node->RealVal > (MATE-50) ||
			Node->RealVal < (50-MATE))
		{
			Node->OptVal = Node->RealVal;
		}
		else
		{
			Node->OptVal = GetOptVal(Node->RealVal);
		}
	}
}

int JobWorker::GetOptVal(int RealVal)
{
	int Valor = 0;
	   char dest[100];
	   Board.SaveFEN(&dest[0]);
	Search.Taux.LoadEPD(dest,0);
	Search.SearchThread = ThreadId;
	if(Search.Taux.EstoyEnJaque())
	{
		return EvalCheck();
	}

	Search.Taux.SwitchColor();
	Search.FixedNodeSearch = CreditNps;
	Search.LimiteProfundidad = 0;
	Search.tiempo_limite = 0;
	Search.IterativeDeepening();
	Search.Taux.SwitchColor();
	Search.Taux.hash = 0;
	if(Search.Taux.ColorJuegan != blanco)
		Valor = Search.ValueSearch;
	else
		Valor = -Search.ValueSearch;

	Valor = DeSmooth(Valor);

	assert(Valor <= UNDEFINED);
	return Valor;
}


int JobWorker::GetRealVal(void)
{
	int Valor = 0;
	   char dest[100];
	   Board.SaveFEN(&dest[0]);
	Search.Taux.LoadEPD(dest,0);
	Search.SearchThread = ThreadId;
	Search.FixedNodeSearch = CreditNps;
	Search.LimiteProfundidad = 0;
	Search.tiempo_limite = 0;
	Search.IterativeDeepening();
	if(Search.ValueSearch == -UNDEFINED)
	{
		if(Search.Taux.ColorJuegan == blanco)
			Search.ValueSearch = -MATE;
		else
			Search.ValueSearch = MATE;
	}
	if(Search.ValueSearch == UNDEFINED)
		Search.ValueSearch = MATE;

	if(Search.Taux.ColorJuegan == blanco)
		Valor = Search.ValueSearch;
	else
		Valor = -Search.ValueSearch;
	assert(Valor != UNDEFINED);
	assert(Valor != -UNDEFINED);
	return Valor;
}

int JobWorker::EvalCheck(void)
{
	int Valor = 0;

	CSort Sort;
	int StatusEnroque; // color , 0 -> rey ,1 -> torre rey,2 -> torre dama
	int alpaso;
	int neutras = 0,legales = 0;
	int ReyForzado = 1;

	Sort.Init(Search.Taux,false);
	// salvamos el estado
	alpaso = Search.Taux.en_pasant ;
	StatusEnroque = Search.Taux.EstadoEnroque;
	// ahora recorremos las jugadas
	CJugada J;
	J = Sort.GetNext();
	while(J.ToInt())
	{
		Search.Taux.Mueve(J);
		if(!Search.Taux.EsAtacada(Search.Taux.PosReyes[Search.Taux.ColorJuegan^1],Search.Taux.ColorJuegan^1))
		{
			legales++;
			if(J.desglose.pieza != rey)
				ReyForzado = 0;
		}
		Search.Taux.DesMueve(J);
		// restaurar estatus...
		Search.Taux.en_pasant = alpaso;
		Search.Taux.EstadoEnroque = StatusEnroque;
		J = Sort.GetNext();
	}
	if(legales == 0)
		Valor = MATE;
	else
	{
		Delphos.Initialize(Search.Taux);
		Valor = Search.Taux.Value;
		if(Search.Taux.ColorJuegan == blanco)
			Valor  = -Valor;

		Valor += CheckOpt; 
		if(ReyForzado && legales < 3)
			Valor += ValorReyForzado;
		if(Valor < 0)
			Valor = 0;
	}
	if(Search.Taux.ColorJuegan == blanco)
	{

		return -Valor;
	}
	else
	{
		return Valor;
	}
	return Valor;
}
int JobWorker::DeSmooth(int Valor)
{
	int DepthNode = GetDepth(Node);
	if(Valor > (MATE-50))
	{
		if(false)
		{
			Valor = MateOpt - DepthNode * MateMove;
		}
		else
		{
			Valor -= MATE;
			Valor-=1;
			Valor *= MateMove;
			Valor = MateOpt - Valor ; //- DepthNode * MateMove;
		}
	}
	else
	if(Valor < (50-MATE))
	{
		if(false)
		{
			Valor = -MateOpt + DepthNode * MateMove;
		}
		else
		{
			Valor += MATE;
			Valor-=1;
			Valor *= MateMove;
			Valor = -MateOpt + Valor ;//+ DepthNode * MateMove;
		}
	}
	return Valor;
}

int JobWorker::GetDepth(TreeNode *node)
{
	int depth = 1;
	TreeNode *aux,*Root;
	for(aux = node->MoveTo(PARENT),Root = TreeNode::GetRootNode(); 
		aux != NULL && aux != Root; 
			aux = aux->MoveTo(PARENT))
	{
		depth++;
	}
	return depth;
}
