//    Copyright 2009 Antonio Torrecillas Gonzalez
//
//    This file is part of Rocinante.
//
//    Rocinante is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    Rocinante is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Rocinante.  If not, see <http://www.gnu.org/licenses/>
//

#include <string.h>
#include <fstream>
#include <iostream>
using namespace std;
#include "Ajedrez.h"
#include <assert.h>

#include "Sort.h"

#include "EvalOpt.h"


static const int Defectos[7][64] = 
{
	{ // 0 peon
		 0,  0,  0,  0,  0,  0,  0,  0,
		 5, 10, 10,-20,-20, 10, 10,  5,
		 5, -5,-10,  0,  0,-10, -5,  5,
		 0,  0,  0, 20, 20,  0,  0,  0,
		 5,  5, 10, 25, 25, 10,  5,  5,
		10, 10, 20, 30, 30, 20, 10, 10,
		50, 50, 50, 50, 50, 50, 50, 50,
		 0,  0,  0,  0,  0,  0,  0,  0
	},
	{ // 1 caballo
		-50,-40,-30,-30,-30,-30,-40,-50,
		-40,-20,  0,  5,  5,  0,-20,-40,
		-30,  5, 10, 15, 15, 10,  5,-30,
		-30,  0, 15, 20, 20, 15,  0,-30,
		-30,  5, 15, 20, 20, 15,  5,-30,
		-30,  0, 10, 15, 15, 10,  0,-30,
		-40,-20,  0,  0,  0,  0,-20,-40,
		-50,-40,-30,-30,-30,-30,-40,-50,
	},
	{ // 2 alfil
		// bishop
		-20,-10,-10,-10,-10,-10,-10,-20,
		-10,  5,  0,  0,  0,  0,  5,-10,
		-10, 10, 10, 10, 10, 10, 10,-10,
		-10,  0, 10, 10, 10, 10,  0,-10,
		-10,  5,  5, 10, 10,  5,  5,-10,
		-10,  0,  5, 10, 10,  5,  0,-10,
		-10,  0,  0,  0,  0,  0,  0,-10,
		-20,-10,-10,-10,-10,-10,-10,-20,
	},
	{ // 3 torre
		  0,  3,  4,  5,  5,  0,  0,  0
		 -5,  0,  0,  0,  0,  0,  0, -5,
		 -5,  0,  0,  0,  0,  0,  0, -5,
		 -5,  0,  0,  0,  0,  0,  0, -5,
		 -5,  0,  0,  0,  0,  0,  0, -5,
		 -5,  0,  0,  0,  0,  0,  0, -5,
		  5, 10, 10, 10, 10, 10, 10,  5,
		  0,  0,  0,  0,  0,  0,  0,  0,
	},
	{ // 4 dama
		//queen
		-20,-10,-10, -5, -5,-10,-10,-20
		-10,  0,  5,  0,  0,  0,  0,-10,
		-10,  5,  5,  5,  5,  5,  0,-10,
		  0,  0,  5,  5,  5,  5,  0, -5,
		 -5,  0,  5,  5,  5,  5,  0, -5,
		-10,  0,  5,  5,  5,  5,  0,-10,
		-10,  0,  0,  0,  0,  0,  0,-10,
		-20,-10,-10, -5, -5,-10,-10,-20,
	},
	{ // 5 rey
		//king middle game
		 20, 30, 10,  0,  0, 10, 30, 20,
		 20, 20,  0,  0,  0,  0, 20, 20,
		-10,-20,-20,-20,-20,-20,-20,-10,
		-20,-30,-30,-40,-40,-30,-30,-20,
		-30,-40,-40,-50,-50,-40,-40,-30,
		-30,-40,-40,-50,-50,-40,-40,-30,
		-30,-40,-40,-50,-50,-40,-40,-30,
		-30,-40,-40,-50,-50,-40,-40,-30,
	},
	{ // 6 rey final
		// king end game
		-50,-30,-30,-30,-30,-30,-30,-50
		-30,-30,  0,  0,  0,  0,-30,-30,
		-30,-10, 20, 30, 30, 20,-10,-30,
		-30,-10, 30, 40, 40, 30,-10,-30,
		-30,-10, 30, 40, 40, 30,-10,-30,
		-30,-10, 20, 30, 30, 20,-10,-30,
		-30,-20,-10,  0,  0,-10,-20,-30,
		-50,-40,-30,-20,-20,-30,-40,-50,
	},
};

EvalOpt::EvalOpt(void)
{
}

EvalOpt::~EvalOpt(void)
{
}

EvalOpt EvalOptEvaluation;

void EvalOpt::Initialize(CDiagrama &Board)
{
	int ValuePiece[7] = {100,320,330,500,900,0,0};
	int i,j;
	bool isEndGame;
	u64 aux;
//Both sides have no queens or 
	if(Board.BPiezas[dama][blanco] == 0ull && Board.BPiezas[dama][negro] == 0ull )
		isEndGame = true;
	else
	{
//Every side which has a queen has additionally no other pieces or one minorpiece maximum. 
		isEndGame = true;
		if(Board.BPiezas[dama][blanco] != 0ull )
		{
			aux = Board.BPiezas[caballo][blanco] |
				Board.BPiezas[alfil][blanco];
			if(popCount(aux) > 1)
			{
				isEndGame = false;
			}
			else
			if(Board.BPiezas[torre][blanco] != 0x0ull)
			{
				isEndGame = false;
			}
		}
		if(isEndGame)
		{
			if(Board.BPiezas[dama][negro] != 0ull )
			{
				aux = Board.BPiezas[caballo][negro] |
					Board.BPiezas[alfil][negro];
				if(popCount(aux) > 1)
				{
					isEndGame = false;
				}
				else
				if(Board.BPiezas[torre][negro] != 0x0ull)
				{
					isEndGame = false;
				}
			}
		}
	}
	if(isEndGame)
	{
		for(j = 0; j < 64;j++)
		{
			Board.Pst[rey][blanco][j] = Defectos[6][j];
			Board.Pst[rey][negro][j] = -Defectos[6][j^070];
		}
	}
	else
	{
		for(j = 0; j < 64;j++)
		{
			Board.Pst[rey][blanco][j] = Defectos[5][j];
			Board.Pst[rey][negro][j] = -Defectos[5][j^070];
		}
	}
	for(i=0; i < 5;i++)
	{
		for(j = 0; j < 64;j++)
		{
			Board.Pst[i+1][blanco][j] = ValuePiece[i] + Defectos[i][j];
			Board.Pst[i+1][negro][j] = -ValuePiece[i] - Defectos[i][j^070];
		}
	}
}
