//    Copyright 2009 Antonio Torrecillas Gonzalez
//
//    This file is part of Rocinante.
//
//    Rocinante is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    Rocinante is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Rocinante.  If not, see <http://www.gnu.org/licenses/>
//
#include "stdio.h"
#include "stdlib.h"
#include "memory.h"
#include "string.h"
#include <time.h>
#include <assert.h>

#include "epd.h"
#include "Ajedrez.h"

#include "EpdMudo.h"

#include "Sort.h"

#include "Oracle.h"

const int MargenError = 200;

/*
* Estadisticas para recuperar la media de desviacin de valores de iteracion a iteracion
* Se le supone que cuanto menor sea mejor (la evaluacon predice mejor la busqueda).
* Estadis[d][0] = cuenta de items medidos
* Estadis[d][1] = suma(abs(valor_depth_d - Valor_depth_1))
* Estadis[d][2] = suma(abs(valor_depth_d - Valor_depth_1)^2)
* Estadis[d][3] = cuenta de cambios de idea en este nivel respecto a la primera eleccion.
* Estadis[d][4] = veces que el valor no cambia
*/

double Estadis[MAXDEPTH][5];
void CleanEstadis()
{
	memset(Estadis,0,sizeof(Estadis));
}
void DumpEstadis()
{
	int i;
	double sdev;
	double media;
	for(i = 0; Estadis[i][0];i++)
	{
		media = Estadis[i][1]/Estadis[i][0];
		sdev = sqrt((Estadis[i][2]/Estadis[i][0]) - (media * media));

		Print("info string Estadis d=%d casos:%5.0lf Media=%5.2lf sdev=%5.2lf Cambio %3.2lf f:%5.0lf \n",
			i,Estadis[i][0],media,sdev ,Estadis[i][3]*100.0/Estadis[i][0],Estadis[i][4]
			);
	}
}


bool CEpdMudo::AbreArchivos()
{
	fi = fo = fsi = fno = NULL;
		// abrir el archivo
	fi = fopen(epdfile,"r");
	if(fi)
	{
		return true;
	}
	return false;
}
void CEpdMudo::CierraArchivos()
{
	TestAciertos = test_aciertos;
	TestNodeCount = NodeCount;
	fclose(fi);
}

static long Up = 0;
static long Total = 0;
static long SumDif = 0;

void CEpdMudo::Start()
{
	extern void Print(const char *fmt, ...);
	extern int UseLog;
	aclock_ini = 0;	aclock = 0;	Dm = 0; // depth media
	NodeCount = 0;	BFMedio = 0;

	Inicio = 0;
	Count = 1000000;

	test_aciertos = 0;	test_fallos = 0;
	items = 0;
	DontPrintToLog = 0;UseLog = 0;

	if(!epdfile)return;

	aclock_ini = TiempoTranscurrido();

	Partida.tiempo_limite = 0;
	Partida.LimiteProfundidad = 0;

	cuenta = 0;

	CleanEstadis();
	if(AbreArchivos())
	{
	// cada linea es un test individual
		while(fgets(Test,sizeof(Test),fi))
		{
			if(Test[0] == '\r')
				break;
			if(Test[0] == '\n')
				break;
			if(Test[0] == ';') // saltamos los comentarios
			{
				PrintLog(Test);
				continue;
			}
			// separa epd de la solucion
			SeparaLineaEpd();
			if(Test[0] == '\0')
				break;
			// analizar
			if(cuenta >= Inicio && cuenta < (Inicio+Count))
			{
				if(ProcesaTestEpd())
				{
					// test positivo
					test_aciertos++;
				}
				else
				{
					// test negativo
					test_fallos++;
				}
				items++;
			}
			cuenta++;
			if(cuenta > (Inicio+Count))
				break;
			Test[0] = '\0';
		}
	}
	CierraArchivos();
	aclock = TiempoTranscurrido();
//	Print("Test Finalizado %d - %d %f t=%d\n",test_aciertos,test_fallos,(test_aciertos*100.0)/(1.0*(test_aciertos+test_fallos)),aclock-aclock_ini);
//	DumpEstadis();
	// asignamos el score
//	score = test_aciertos; // + (int)(10000.0 - (Estadis[0][3]*10000.0/Estadis[0][0]));
	double media,sdev;
	sdev = Estadis[0][2]/Estadis[0][0];
	media = Estadis[0][1]/Estadis[0][0];
	sdev -= media *media;
	score = (int) -(sdev*100);
//	score = -Estadis[0][1];
	Print("Percent lowerbound ok %2.2lf\n",(Up*100.0)/Total);
}

bool CEpdMudo::ProcesaTestEpd()
{
	int ValReal;
	int ValMin;
	Partida.FixedNodeSearch = 0;
	Partida.LimiteProfundidad = 3;
	// get value from search
	Partida.IterativeDeepening();
	ValReal = Partida.ValueSearch;
	// get lower bound from nullmove
	Partida.Taux.SwitchColor();
	Partida.LimiteProfundidad = 1;
	Partida.IterativeDeepening();
	ValMin = -Partida.ValueSearch;
	Partida.Taux.SwitchColor();
	if(ValReal > (50-MATE) && ValReal < (MATE-50)
		&& ValMin < (MATE-50) && ValMin > (50-MATE)
		&& !Partida.Taux.EstoyEnJaque() 
		)
	{
		Total++;
		if(ValReal >= ValMin)
		{
			Up++;
//			if((ValReal -ValMin) < 200)
//			SumDif += 100;
			SumDif += ValReal -ValMin;
		}
		else
		{
	//		SumDif -= ValReal -ValMin;
		}
	}
	if((Total % 1000) == 0)
		Print("after %ld position Percent lowerbound ok %2.2lf dif %lf\n",Total,(Up*100.0)/Total,(1.0 *SumDif)/Up);

	IterativeDeepening();
	NodeCount += Partida.NodosVisitados;
	// es OK
	// quitamos el + final si lo hay
	char *aux = Partida.JugadaActual;
	while(*aux)
	{
		if(*aux == '+')
			*aux = '\0';
		aux++;
	}
	if(bm)
	{

		return !((strcmp(SolucionAlg[0],Partida.JugadaActual)!=0 )	&&
			(strcmp(SolucionAlg[1],Partida.JugadaActual)!=0 )		&&
			(strcmp(SolucionAlg[2],Partida.JugadaActual)!=0 ) 		);

	}
	else
	{	// avoid move
		return ((strcmp(SolucionAlg[0],Partida.JugadaActual)!=0 )	&&
			(strcmp(SolucionAlg[1],Partida.JugadaActual)!=0 )		&&
			(strcmp(SolucionAlg[2],Partida.JugadaActual)!=0 ) 		);
	}
	return false;
}




void CEpdMudo::IterativeDeepening(void)
{
	extern void Print(const char *fmt, ...);
	int value,value_i;
	int hasp;
	int MateCount = 0;
	// busqueda con ventana
	int VAlpha,VBeta,Pase;

	int Valor_d1;
	char JugD1[20];

	// copiamos tablero principal
	Partida.Taux.LoadEPD(Test,0);
	Partida.JugadaActual[0] = '\0';
	Delphos.Initialize(Partida.Taux);
	Partida.Taux.FullEval();
	Partida.tiempo_limite = 0;
	Partida.cancelado = false;
	Partida.ResetHistory();
	char PV[1024];
	char SavePV[1024];
	PV[0] = '\0';
	value = -INFINITO;
	Partida.cancelado = 0;
	int Depth = 1;
	Partida.NumRM = 0;
	value_i = value = Partida.RootPVS(Depth,-INFINITO,+INFINITO);
	Partida.ValueSearch = value;
//	return;
	Valor_d1 = value_i ;
	if(Valor_d1 == INFINITO || Valor_d1 == -INFINITO)
		Valor_d1 = 0;
	JugD1[0] = '\0';

	strcpy(JugD1,Partida.JugadaActual);
	Depth++;
	VAlpha = value-128;
	VBeta = value+128;
	Pase = 0;
	if(Partida.Unica)
	{
		strcpy(Partida.JugadaActual,strtok(PV," u"));
		Print("bestmove %s\n",Partida.JugadaActual);
		return;
	}
	{

		hasp = value;
		Partida.ResetHistory();
		Partida.cancelado = 0;
		value = Partida.RootPVS(Depth,-INFINITO,+INFINITO);

		double dif;
		dif = ((Valor_d1 - value));
		// falsos mates en 1
		if(false && Depth == 2 && (value > (50-MATE) && value < (MATE-50))
			&& ((Valor_d1 < (50-MATE) || Valor_d1 > (MATE-50))))
		{
			FILE *fl = fopen("falsos.log","a+");
			if(fl)
			{
				char fen[200];
				Partida.Taux.SaveFEN(&fen[0]);
				fprintf(fl,"%s bm %s;\n",fen,Partida.JugadaActual);
				fprintf(fl,"PV %s Eval1 %d Eval %d dif %4.0lf;\n",SavePV,Valor_d1,value,dif);
				Partida.Taux.Dibuja(fl);
				fclose(fl);
			}
		}

		if((value > (50-MATE) && value < (MATE-50))
			&& ((Valor_d1 > (50-MATE) && Valor_d1 < (MATE-50))))
		{

			Estadis[Depth-2][0]++;
			Estadis[Depth-2][1] += dif;
			Estadis[Depth-2][2] += dif * dif;
			if(dif == 0)
				Estadis[Depth-2][4]++;
			if(strcmp(Partida.JugadaActual,JugD1) != 0)
			{
				Estadis[Depth-2][3]++;
			}

			// miramos si es una jugada tactica
			// de momento si la primera jugada es captura o jaque
			if(false && Depth == 2 && abs((int)dif) > MargenError
				)
			{
				FILE *fe = fopen("badeval.epd","a+");
				if(fe)
				{
					char fen[200];
					Partida.Taux.SaveFEN(&fen[0]);
					fprintf(fe,"%s bm %s;\n",fen,Partida.JugadaActual);
					fclose(fe);
				}
				FILE *fl = fopen("badeval.log","a+");
				if(fl)
				{
					char fen[200];
					Partida.Taux.SaveFEN(&fen[0]);
					fprintf(fl,"%s bm %s;\n",fen,Partida.JugadaActual);
					fprintf(fl,"D1 %s = %d D2 %s = %d dif %4.0lf;\n",JugD1,Valor_d1,Partida.JugadaActual,value,dif);
					Partida.Taux.Dibuja(fl);
					fclose(fl);
				}
			}
		}
		Valor_d1 = value;
		strcpy(JugD1,Partida.JugadaActual);

		if(value == MATE || value == -MATE)
		{
			strcpy(Partida.JugadaActual,"resign");
			return;
		}
		PV[0] = '\0'; // reset de la mejor jugada
		// llevamos la cuenta de iteraciones que damos o recibimos mate
		if(value < (50-MATE) && value > -MATE)
			MateCount++;
		if(value > (MATE-50) && value < MATE)
			MateCount++;

		Depth++;
	}
	Partida.ValueSearch = value;
}

