//    Copyright 2009 Antonio Torrecillas Gonzalez
//
//    This file is part of Rocinante.
//
//    Rocinante is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    Rocinante is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Rocinante.  If not, see <http://www.gnu.org/licenses/>
//

class CDiagrama
{
public:
////////////////////////////////////////////////////////////////////////////
	// BITBOARD
	u64 hash;
	int StandPat;
	int ColorJuegan;
	u64 BOcupadas[2];
  u64 BPiezas[8][2]; // pieza color
	int PosReyes[2]; // posicion de los reyes en el tablero

	int EstadoEnroque;
	int en_pasant;

	int Value;
	int Pst2[6][64];
	int Pst[7][2][64];
	CJugada BestMove;

public:


	// posibles movimientos en esta posicin
	CJugada JugadasPosibles[MAXJUGADAS];  // array de 256 jugadas por bando
	int tope;
	// Nombres cortos piezas
	char NombreColumnas[9];
	char NombreFilas[9]; 
	char Algebra[10];
public:
	// Status de movimiento de rey y torres ( para los 0-0)
	// tomar el valor 0 si no se ha movido y 1 si ha sido movido

	int board(int c);
	int color(int c);


  void InitAtaque();
	int ValidaJugada(CJugada &j);
	int EsLegal(CJugada &J);


	void SwitchColor();
	HRESULT MueveAlgebra(char *JugAlg);
	int MuevePgn(char *JugAlg);
	int IdentificaPgn(char *JugAlg);
	int EstoyEnJaque();

	// variables internas

	inline void QuitaZ(int pieza, int color1,int casilla) {
		ClearBB(BPiezas[pieza][color1],casilla);
		ClearBB(BOcupadas[color1],casilla);
		Value -= Pst[pieza][color1][casilla];
	};
	inline  void PonZ(int pieza,int color1,int pos) {
		SetBB(BOcupadas[color1],pos);
		SetBB(BPiezas[pieza][color1],pos);
		Value += Pst[pieza][color1][pos];
	};

	inline COLOR GetColor(int pos)
	{
		return (COLOR)color(pos);
	};


	// contructor
	CDiagrama();
	// destructor
	~CDiagrama();
	// Otras
	void Dibuja(FILE *display_file);
	void Dibuja();
	void DibujaP();
	
//	void Draw(CDC *pDC,CRect &r);
	inline int FILA(int s)	{return ((s) >> 3);};
	inline int COLUMNA(int s)	{ return ((s) & 7);};
	inline int COLORCASILLA(int s)	{return ((FILA(s) + COLUMNA(s)) % 2);};
	int Mueve(const CJugada &j);
	int Mueve(int j);
	void DesMueve(int j);
	void DesMueve(const CJugada &j);
	void CalculaJugadasPosibles();

	int EsAtacada(int casilla,int bando);
public:
	void LoadEPD(char *fen,int Simetrico);
	void SaveFEN(char *dest);

	int Es7a(CJugada &J);

	void FullEval(void);
	int GetEval(void);
private:
	int Fire(unsigned long long input,int Color,int piece);
};
