//    Copyright 2009 Antonio Torrecillas Gonzalez
//
//    This file is part of Rocinante.
//
//    Rocinante is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    Rocinante is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Rocinante.  If not, see <http://www.gnu.org/licenses/>
//

#include <cassert>
#include <stdlib.h>
#include "Ajedrez.h"
#include "Sort.h"
#include "PLY.h"

#include "TreeNode.h"
#include "BStar.h"
#include "DumpTree.h"


#include "SmpManager.h"

#include "C3FoldRep.h"

extern void Print(const char *fmt, ...);


static	int TransPos = 0;


static int DepthEval = 4;
static bool FixedDepth = false;

const int minDepthEval = 1;

int nps = 2800000;


const int MaxExpand = 8000; 


BStar::BStar(void)
{
	MinAct = 0.01; 
	InGame = 0;
}

BStar::~BStar(void)
{
}

const bool DumpData = false;

void BStar::Run(char *fen)
{
	int TiempoLimiteOld;
	DumpTree *dt;
	ini = TimeElapsed();
	PrintPVV = true;
	if(DumpData)
	{
		dt = new DumpTree();
	}
	ExpandCount = 0;
	SelectNodes = 72; //72; //52; 
	VerifyNodes = 40; //40; //28; 
	TotalExpand = 0;
	TotalProbes = 0;

	TargetVal = -UNDEFINED;
	BestMoveAtRoot = NULL;
	RealValBest = 0;
	OptVal2ndBest = 0;
	ColorRoot = 0;
	ExpandCount = 0;
	TotalExpand = 0;
	Partida.InBStar = 1;
	TiempoLimiteOld = Partida.tiempo_limite;
	Partida.tiempo_limite = 0;
	Partida.Depth = DepthEval;
	Partida.DepthPrintInfo = DepthEval+1;
	if(TiempoLimiteOld == 0)
		TiempoLimiteOld = 60000;
	credit_expand = (int)((double)(TiempoLimiteOld) * nps /(1000.0 * 225.0));
	if(credit_expand < 0)
		credit_expand *= -1;
	if(DumpData)
		Print("info string credit %d nodes\n",credit_expand);
	
	TimeLimit = TiempoLimiteOld-15;
	if(TimeLimit <= 0)
	{
		TimeLimit = 60000-15;
	}

	Partida.cancelado = 0;
	Partida.ResetHistory();


	// antes primero a ver si ya tenemos en memoria el nodo a expandir
	TreeNode *raiz = GetNodeOfFEN(TreeNode::GetRootNode(),fen);
	if(raiz && raiz->SubtreeSize)
	{
		if(DumpData)
			Print("info string position in Cache saving %d nodes\n",raiz->SubtreeSize);
		TreeNode *OldRoot = TreeNode::GetRootNode();
		TreeNode::SetRootNode(raiz);
		OldRoot->Delete();
	}
	else
	{
		if(DumpData)
			Print("info string Position %s not found\n",fen);
		// limpiar el arbol
		raiz = TreeNode::GetRootNode();
		if(raiz)
			raiz->Delete();
		// establecer el nodo raiz
		raiz = TreeNode::GetFree();
		TreeNode::SetRootNode(raiz);
		strcpy(raiz->fen,fen);

		// expand del nodo raiz
		Expand(raiz,PLAYER);
	}

	Search();

	if(DumpData)
		Print("info string TransPos %d\n",TransPos);
	if(DumpData)
	{
		dt->Print("Probe depth %d, Select Nodes Limit %d, Verify Nodes limit %d\n",
			DepthEval, SelectNodes, VerifyNodes	);
		dt->Print("Time used %d Nodes Expanded %d\n",TimeElapsed()-ini,TotalExpand);
		int TargetVal = ((BestMoveAtRoot->RealVal) + OptVal2Best())/2;
		dt->Print("Target %d\n",TargetVal);

		dt->DumpRoot();
		dt->Write();
	}
	Partida.InBStar = 0;
	// Print the best move...
	CJugada Mejor;
	Mejor.Set(TreeNode::GetRootNode()->SelectBestReal()->Move) ;
	strcpy(Partida.JugadaActual,Mejor.ToString());
	Print("bestmove %s\n",Mejor.ToString());
	Partida.tiempo_limite = TiempoLimiteOld;
	if(false)
	{
		int Tiempo_empleado = TimeElapsed()-ini;
		dt->Print("Probe depth %d, Select Nodes Limit %d, Verify Nodes limit %d\n",
			DepthEval, SelectNodes, VerifyNodes	);
		dt->Print("Time used %d Nodes Expanded %d\n",TimeElapsed()-ini,TotalExpand);
		dt->Print("Moves on root %d\n",TreeNode::GetRootNode()->MoveCount);
	}
	if(DumpData)
	{
		delete dt;
	}
}

void BStar::Search()
{
	int Cancelar = 0;
	DumpTree *dt;
	TreeNode *CurNode = NULL;		// last move expanded
	TreeNode *CurBestNode = NULL;	// last best
	if(DumpData)
	{
		dt = new DumpTree();
	}

	TreeNode *a = NULL;
	TreeNode *SelectedNode = NULL;
	ColorRoot = TreeNode::GetRootNode()->Color;
	for(;;)
	{
		if(Cancelar)
			break;
		while (true	)
		{
			GetRealValBestAtRoot();
			if(BestMoveAtRoot != CurBestNode)
			{
				CurBestNode = BestMoveAtRoot;
				LastChange = TotalExpand;
				PrintPV();
			}
			if(TreeNode::GetRootNode()->RealVal > (MATE-50)
				|| TreeNode::GetRootNode()->RealVal < (50-MATE)
				)
			{
				Cancelar= 1;
				break;
			}

			OptValAnyOtherMoveAtRoot();
			TargetVal = ((BestMoveAtRoot->RealVal) + OptVal2Best())/2;
			RecalcSubtreeOptPrb(TreeNode::GetRootNode());
			if(DumpData )
			{
				dt->Print("SELECT STEP Color %d Best %d Target Value %d\n",ColorRoot,BestMoveAtRoot->RealVal,TargetVal);
				dt->Write();
			}
//			Select Root Node with greatest OptPrb;
			a = GetBestOptPrb(TreeNode::GetRootNode());
			if(!a)
				break;
			if(a != CurNode)
			{
				CurNode = a;
			}
//			Trace down the child subtree selecting
//			For Player-to-Move nodes, child with largest OptPrb
//			For Opponent-to-Move nodes, child with best RealVal
//			Until arriving at a leaf node;
			SelectedNode = a->TraceDown(true);
			if(SecondRootOptPrb() < MinAct) // if you skip this
				break;						// you end selecting a node with OptPrb=0 (pure non sense)
			if(DumpData)
			{
				dt->Print("Selected node:");
				dt->DumpPath(SelectedNode,TreeNode::GetRootNode());
				dt->Print("Color root %d\n",TreeNode::GetRootNode()->Color);
				dt->DumpRoot();
			}
			if(SelectedNode->MoveCount != 0) // already expanded, mate pos?
				break;
//			Get RealVal for each Child Node of this leaf;
//			If it is a Player-to-Move node get OptVals for each Child;
			Expand(SelectedNode,PLAYER);
			// search path down to new expanded
			a = SelectedNode;

			if(DumpData)
			{
				dt->Print("Backup Node :");
				dt->DumpPath(a,TreeNode::GetRootNode());
			}

//			Back up Values;
			if(
				SelectedNode->RealVal == 0 
				&& SelectedNode->OptVal == 0
				&& SelectedNode->MoveCount == -1
				)
				Backup(PLAYER,a->MoveTo(PARENT));
			else
				Backup(PLAYER,a);

			if(TotalExpand > MaxExpand)
			{
				Cancelar = 1;
				break;
			}
			if ((TimeElapsed()-ini) >= (TimeLimit - credit_expand * 10000/nps)) 
			{
				// 10 last expands for verify
				break;
			}
			if ((TimeElapsed()-ini) >= TimeLimit || (ExpandCount > SelectNodes)) 
			{
				ExpandCount = 0;

				if((TimeElapsed()-ini) >= TimeLimit )
				{
					Cancelar = 1;
				}
				break; // EffortLimitsExceeded
			}
		}
		if(Cancelar)
			break;


		if(ColorRoot == blanco)
			TargetVal = RealVal2ndBstMoveAtRoot() - 1;
		else
			TargetVal = RealVal2ndBstMoveAtRoot() + 1;

		if(DumpData)
		{
			dt->Print("VERIFY Step\n");
			dt->Print("Target Value %d\n",TargetVal);
		}
		
		if((TimeElapsed()-ini) >= TimeLimit )
		{
			break;
		}

		VerifyInit();
		if((TimeElapsed()-ini) >= TimeLimit )
			break;		

		ExpandCount = 0;
		while(true )
		{
			GetRealValBestAtRoot(); 
			if(BestMoveAtRoot != CurBestNode)
			{
				CurBestNode = BestMoveAtRoot;
				LastChange = TotalExpand;
				// print info
				PrintPV();
			}
			if(DumpData)
			{
				dt->Print("Verify 1:");
			}
			// si ha cambiado el valor debemos adecuarnos al nuevo target.
			if(ColorRoot == blanco)
				TargetVal = RealVal2ndBstMoveAtRoot() - 1;
			else
				TargetVal = RealVal2ndBstMoveAtRoot() + 1;

			RecalcSubtreeOptPrbVerify(TreeNode::GetRootNode());
//			Select reply Node with Greatest RealVal
			a = BestMoveAtRoot;
			if(DumpData)
				dt->Print("BestMove Real %d Opt %d Pess %d\n",a->RealVal,a->OptVal,a->PessVal);
//			Trace down the child subtree selecting
//			For Opponent-to-Move nodes, child with largest OptPrb
//			For Player-to-Move nodes, child with best RealVal
//			Until arriving at a leaf node;
			SelectedNode = TraceDownVerify(a);
			if(SelectedNode->RealVal == 0 && SelectedNode->OptVal == 0)
				break;
			if(DumpData)
			{
				dt->Print("Verify Selected node:");
				dt->DumpPath(SelectedNode,TreeNode::GetRootNode());
			}
			if(DumpData)
			{
				dt->Print("Verify 2:");
			}

//			Get RealVal for each Child Node of this leaf;
//			If it is an Opponent-to-Move node get OptVals for each Child;
			Expand(SelectedNode,OPPONENT);
			if(SelectedNode->MoveCount > 0)
			{
				Backup(OPPONENT,SelectedNode);			    // and Back up Values;
				if(DumpData)
				{
					dt->Print("Verify Selected node:");
					dt->DumpPath(SelectedNode,TreeNode::GetRootNode());
					dt->DumpRoot();
				}
			}
			else
			{
				if(
					SelectedNode->RealVal == 0 
					&& SelectedNode->OptVal == 0
					&& SelectedNode->MoveCount == -1
					)
				//	Backup(PLAYER,a->MoveTo(PARENT));
				//else
					break;
			}
			if(DumpData)
			{
				dt->Print("Verify 3:");
			}
			if(TotalExpand > MaxExpand)
			{
				Cancelar = 1;
				break;
			}
			if (((TimeElapsed()-ini) >= TimeLimit && ExpandCount > 3 )|| (ExpandCount > VerifyNodes))
			{
				ExpandCount = 0;
				if((TimeElapsed()-ini) >= TimeLimit )
				{
					goto salida;
				}
				break;
			}
		}
		if(DumpData)
		{
			int TargetVal = ((BestMoveAtRoot->RealVal) + OptVal2Best())/2;
			dt->Print("Target %d\n",TargetVal);
			dt->Write();
		}
	}
salida:
	PrintPV();
	if(DumpData)
	{
		delete dt;
	}

}
void BStar::Reset()
{
	TreeNode::InitTree();
}
// default test implementation
void BStar::Run()
{
	Run("r3kb1r/1pp3p1/p3bp1p/5q2/3QN3/1P6/PBP3P1/3RR1K1 w kq - bm Qd7+;");
	// id "WAC.217";

}

int BStar::EsRepeticion(TreeNode *nodo)
{
	TreeNode *aux;
	for(aux = nodo->MoveTo(PARENT);aux;aux = aux->MoveTo(PARENT))
	{
		if(strcmp(nodo->fen,aux->fen)==0)
		{
			return 1;
		}
	}
	if(ThreeFold.IsRep(nodo->fen))
		return 1;
	return 0;
}

void BStar::BackupSubtreeSize(TreeNode *node)
{
	TreeNode *aux,*childs;
	int sum;

	// while not root
	// goto parent
	for(aux = node->MoveTo(PARENT);aux;aux = aux->MoveTo(PARENT))
	{
		// sum child subtreesize
		sum = 1;
		for(childs = aux->MoveTo(FIRSTCHILD);childs;childs = childs->MoveTo(NEXTSIBBLING))
		{
			sum += childs->SubtreeSize;
		}
		aux->SubtreeSize = sum;
	}
}
//			Get RealVal for each Child Node of this leaf;
//			If it is a Player-to-Move node get OptVals for each Child;
void BStar::Expand(TreeNode *SelectedNode,int modo)
{
int EsRaiz;
	EsRaiz = SelectedNode == TreeNode::GetRootNode();
	PLY ply(0);
	CJugada J;
	int NMoves = 0;
	bool EvalOpt;
	int StatusEnroque; 
	int alpaso;
	int TotalNodesPVS = 0;
	int fase = 0;
	TreeNode *aux;

	// miramos si es una transposicion.
	aux= GetNodeOfFEN(TreeNode::GetRootNode(),SelectedNode->fen);
	if(aux && aux != SelectedNode)
	{
		TransPos++;
		TransPos += aux->SubtreeSize;
	}

	ExpandCount++;
	TotalExpand++;
	if(!EsRaiz && EsRepeticion(SelectedNode))
	{
		SelectedNode->RealVal = 0;
		SelectedNode->OptVal = 0;
		SelectedNode->OptPrb = 0;
		SelectedNode->PessVal = 0;
		SelectedNode->MoveCount = -1;
		RecalProb(SelectedNode);
		return;
	}
	assert(SelectedNode->MoveCount == 0);

	Board.LoadEPD(SelectedNode->fen,0);

	if(EsRaiz)
	{
		SelectedNode->Color = Board.ColorJuegan;
		if(SelectedNode->Color == blanco)
		{
			SelectedNode->OptVal = UNDEFINED;
			SelectedNode->PessVal = -UNDEFINED;
		}
		else
		{
			SelectedNode->OptVal = -UNDEFINED;
			SelectedNode->PessVal = +UNDEFINED;
		}
	}


	SelectedNode->Color = Board.ColorJuegan;
	SelectedNode->SubtreeSize = 1;
	ply.Init(Board,false);

   char dest[100];
   Board.SaveFEN(&dest[0]);
	Partida.Taux.LoadEPD(dest,0);

	// salvamos el estado
	alpaso = Board.en_pasant ;
	StatusEnroque = Board.EstadoEnroque;

	DepthNode = GetDepth(SelectedNode);
	// determinar si necesitamos optvalues

	EvalOpt = (SelectedNode->Color == TreeNode::GetRootNode()->Color);
	for(J = ply.GetNext();J.ToInt();J = ply.GetNext())
	{
		Board.Mueve(J);
		if(!Board.EsAtacada(Board.PosReyes[Board.ColorJuegan^1],Board.ColorJuegan^1))
		{
			// agregamos un nodo.
			aux = TreeNode::GetFree();
			aux->Color = Board.ColorJuegan;
			aux->Move = J.ToInt();
			strcpy(aux->MoveStr,J.ToString());

			Board.hash = 0;
			assert(aux->OptVal <= UNDEFINED);
			assert(aux->PessVal <= UNDEFINED);

	   char dest[100];
	   Board.SaveFEN(&dest[0]);
			strcpy(aux->fen,dest);
			SelectedNode->Add(aux);
			NMoves++;
		}
        Board.DesMueve(J);
		// restaurar estatus...
		Board.en_pasant = alpaso;
		Board.EstadoEnroque = StatusEnroque;
	}
	SelectedNode->MoveCount = NMoves;

	if(NMoves)
	{
		credit_probe = credit_expand /(2 * NMoves);

		// segunda fase calculamos el valor real
		// Calculamos el valor real y el optimista.
		// Get Real and optimistic value.
		for(aux = SelectedNode->MoveTo(FIRSTCHILD);aux; aux = aux->MoveTo(NEXTSIBBLING))
		{
			// verify repets
			if(EsRepeticion(aux))
			{
				aux->RealVal = 0;
				aux->OptVal = 0;
				aux->OptPrb = 0;
				aux->PessVal = 0;
				aux->MoveCount = -1;
			}
			else
			{
				aux->OptVal = SelectedNode->PessVal;
				aux->PessVal = SelectedNode->OptVal;
				aux->StaticVal = UNDEFINED;
				if(aux->Color == blanco)
					aux->RealVal = -MATE;
				else
					aux->RealVal = MATE;
				if(FixedDepth)
				{
					SmpWorkers.DoWork(aux,EvalOpt,DepthEval);
				}
				else
				{
					SmpWorkers.DoWork(aux,EvalOpt,credit_probe);
				}
			}
		}
	}
	// wait for all workers end his job
	while(!SmpWorkers.AllIdle())SmpWorkers.Sleep();

	int dif;
	for(aux = SelectedNode->MoveTo(FIRSTCHILD);aux; aux = aux->MoveTo(NEXTSIBBLING))
	{
		RecalProb(aux);
	}
	if(SelectedNode->MoveCount == 0)
	{
		if(ply.pSort->EstoyEnJaque())
		{
			// mate
			if(SelectedNode->Color == blanco)
			{
				SelectedNode->RealVal = -MATE;
				SelectedNode->OptVal = -MATE;
				SelectedNode->PessVal = -MATE;
			}
			else
			{
				SelectedNode->RealVal = MATE;
				SelectedNode->OptVal = MATE;
				SelectedNode->PessVal = MATE;
			}
		}
		else
		{
			// stalemate
			SelectedNode->RealVal = 0;
			SelectedNode->OptVal = 0;
			SelectedNode->PessVal = 0;
		}
	}
	else
	{
		aux = SelectedNode->SelectBestReal();
		SelectedNode->RealVal = SelectedNode->SelectBestReal()->RealVal;
		if(EvalOpt)
		{
			SelectedNode->OptVal = SelectedNode->SelectBestOpt()->OptVal;
		}
	}
	BackupSubtreeSize(SelectedNode);
}


int BStar::OptVal2Best()
{
	TreeNode *aux,*Root;
	int Value = -UNDEFINED;
	int opt = 0;
	Root = TreeNode::GetRootNode();
	if(Root->Color == blanco)
	{
		Value = -UNDEFINED;
		for(aux = Root->MoveTo(FIRSTCHILD);aux;aux = aux->MoveTo(NEXTSIBBLING))
		{
			if(aux != BestMoveAtRoot )
			{
				if(aux->RealVal > Value)
				{
					Value = aux->RealVal; 
					opt = aux->OptVal;
				}
				else
				if(aux->RealVal == Value && aux->OptVal > opt)
				{
					Value = aux->RealVal; 
					opt = aux->OptVal;
				}
			}
		}
	}
	else
	{
		Value = UNDEFINED;
		for(aux = Root->MoveTo(FIRSTCHILD);aux;aux = aux->MoveTo(NEXTSIBBLING))
		{
			if(aux != BestMoveAtRoot )
			{
				if(aux->RealVal < Value)
				{
					Value = aux->RealVal;
					opt = aux->OptVal;
				}
				else
				if(aux->RealVal == Value && aux->OptVal < opt)
				{
					Value = aux->RealVal; 
					opt = aux->OptVal;
				}
			}
		}
	}
	return opt;
}

int BStar::GetRealValBestAtRoot()
{
	BestMoveAtRoot = TreeNode::GetRootNode()->SelectBestReal();
	if(!BestMoveAtRoot)
		return RealValBest = 0;
	return RealValBest = BestMoveAtRoot->RealVal;
}

// Best OptVal but not BestAtRoot
int BStar::OptValAnyOtherMoveAtRoot()
{
	TreeNode *FromNode = TreeNode::GetRootNode();
	TreeNode *aux;
	int MaxValue = -UNDEFINED;
	if(FromNode->Color == blanco)
	{
		MaxValue = -UNDEFINED;
	}
	else
	{
		MaxValue = UNDEFINED;
	}
	for(aux = FromNode->MoveTo(FIRSTCHILD);
		aux; aux = aux->MoveTo(NEXTSIBBLING))
	{
		if(FromNode->Color == blanco)
		{
			if(true)
			{
				if(aux->OptVal > MaxValue )
				{
					MaxValue = aux->OptVal;
				}
			}
			else
			{
				if(aux->PessVal > MaxValue )
				{
					MaxValue = aux->PessVal;
				}
			}
		}
		else
		{
			if(true)
			{
				if(aux->OptVal < MaxValue )
				{
					MaxValue = aux->OptVal;
				}
			}
			else
			{
				if(aux->PessVal < MaxValue )
				{
					MaxValue = aux->PessVal;
				}
			}
		}
	}
	OptVal2ndBest = MaxValue;
	return MaxValue;
}

void BStar::RecalProb(TreeNode *node)
{
	const double MinOpt = 0.0;
	if(node->Color == ColorRoot && node->OptVal >= UNDEFINED)
	{
		if(ColorRoot == blanco && (node->RealVal ) > TargetVal)
			node->OptPrb = 1.0;
		else
		if(ColorRoot == negro && (node->RealVal ) < TargetVal)
			node->OptPrb = 1.0;
		else
		if(ColorRoot == blanco && (node->PessVal) < TargetVal)
			node->OptPrb = MinOpt;
		else
		if(ColorRoot == negro && (node->PessVal) > TargetVal)
			node->OptPrb = MinOpt;
		else
		if((node->PessVal) == node->RealVal)
		{
			if(ColorRoot == blanco && TargetVal <= node->RealVal)
			{
				node->OptPrb = 1.0;
			}
			else
			if(ColorRoot == negro && TargetVal >= node->RealVal)
			{
				node->OptPrb = 1.0;
			}
			else
				node->OptPrb = MinOpt;
		}
		else
			node->OptPrb = (node->PessVal - TargetVal)*1.00/(node->PessVal-node->RealVal);
	}
	else
	{
		if(ColorRoot == blanco && (node->RealVal ) > TargetVal)
			node->OptPrb = 1.0;
		else
		if(ColorRoot == negro && (node->RealVal ) < TargetVal)
			node->OptPrb = 1.0;
		else
		if(ColorRoot == blanco && (node->OptVal) < TargetVal)
			node->OptPrb = MinOpt;
		else
		if(ColorRoot == negro && (node->OptVal ) > TargetVal)
			node->OptPrb = MinOpt;
		else
		if((node->OptVal ) == node->RealVal)
		{
			if(ColorRoot == blanco && TargetVal <= node->RealVal)
			{
				node->OptPrb = 1.0;
			}
			else
			if(ColorRoot == negro && TargetVal >= node->RealVal)
			{
				node->OptPrb = 1.0;
			}
			else
				node->OptPrb = MinOpt;
		}
		else
			node->OptPrb = (node->OptVal- TargetVal)*1.00/(1.0*(node->OptVal-node->RealVal));
	}
	if(node->OptPrb  > 1.0)
		node->OptPrb  = 1.0;
	if(node->OptPrb  < 0.0)
		node->OptPrb  = MinOpt;
}

TreeNode *BStar::GetBestOptPrb(TreeNode *parent)
{
	double MaxValue = 0.0;
	double PrbD = 0.0;
	TreeNode *aux = 0;
	TreeNode *Sel = 0;

	for(aux = parent->MoveTo(FIRSTCHILD);
		aux; aux = aux->MoveTo(NEXTSIBBLING))
	{
		if(aux->SubtreeSize)
			PrbD = aux->OptPrb  / (sqrt((double)(aux->SubtreeSize)));
		else
			PrbD = aux->OptPrb ;
		if(	PrbD > MaxValue	)
		{
			MaxValue = PrbD; 
			Sel = aux ;
		}
	}
	return Sel;
}

double BStar::SecondRootOptPrb()
{
	double MaxValue = 0.0;
	TreeNode *aux = 0;
	for(aux = TreeNode::GetRootNode()->MoveTo(FIRSTCHILD);
		aux; aux = aux->MoveTo(NEXTSIBBLING))
	{
		if(aux->OptPrb >= MaxValue 
			&& aux != BestMoveAtRoot
			)
		{
			MaxValue = aux->OptPrb;
		}
	}
	return MaxValue ;
}

void BStar::PropagateReal(TreeNode *parent)
{
	int Value;
	TreeNode *Best;
	Best = parent->SelectBestReal();
	if(!Best)
		return; // defensive
	Value = Best->RealVal;
	if(Value > MATE-50)
	{
		Value--;
	}
	else
	if(Value < 50-MATE)
	{
		Value++;
	}
	parent->RealVal = Value;
}
void BStar::PropagateOpt(TreeNode *parent)
{
	int Value;
	TreeNode *son = parent->SelectBestOpt();
	if(!son) return; // defensive
	Value = son->OptVal;
	if(Value > MATE || Value < -MATE)
		return;
	if(Value > MATE-50)
	{
		Value--;
	}
	else
	if(Value < 50-MATE)
	{
		Value++;
	}
	parent->PessVal = Value; 
}
void BStar::PropagatePess(TreeNode *parent)
{
	int Value;
	TreeNode *son = parent->SelectBestPess();
	if(!son)return; // defensive

	Value = son->PessVal;
	if(Value > MATE || Value < -MATE)
		return;
	if(Value > MATE-50)
	{
		Value--;
	}
	else
	if(Value < 50-MATE)
	{
		Value++;
	}
	parent->OptVal = Value; 
}

void BStar::Propagate1(TreeNode *nodo,TreeNode *parent,int mode)
{
	TreeNode *Root = TreeNode::GetRootNode();

	PropagateReal(parent);
	PropagateOpt(parent);
	PropagatePess(parent);
}

void BStar::Backup(int mode,TreeNode *node)
{
	TreeNode *aux = 0;
	TreeNode *aux1 = node;

	for(aux = node->MoveTo(PARENT);
		aux; aux = aux->MoveTo(PARENT))
	{
		Propagate1(aux1,aux,mode);
		aux1 = aux;
	}
}

double BStar::Product(TreeNode *parent,int modo)
{
	double producto = 1.0;
	TreeNode *aux;
	aux = parent->MoveTo(FIRSTCHILD);
	for(;aux; aux = aux->MoveTo(NEXTSIBBLING))
	{
		assert(aux->RealVal  < (UNDEFINED-50));
		producto *= aux->OptPrb;
		if(producto == 0.0)break;
	}
	return producto;
}

double BStar::GetBestChildOptPrb(TreeNode *parent)
{
	double MaxValue = -1.0;
	TreeNode *aux;

	for(aux = parent->MoveTo(FIRSTCHILD);
		aux; aux = aux->MoveTo(NEXTSIBBLING))
	{
		if(aux->OptPrb > MaxValue)
		{
			MaxValue = aux->OptPrb;
		}
	}
	return MaxValue;
}

void BStar::CalcPrb(TreeNode *parent)
{
	if(parent->OptVal != UNDEFINED)
	{
		assert(parent->OptVal != UNDEFINED);
		// (o-t)/(o-r)
		if(parent->OptVal == parent->RealVal)
			parent->OptPrb = 0;
		else
			parent->OptPrb = ((parent->OptVal-TargetVal)*1.0)/(1.0*(parent->OptVal-parent->RealVal));
		if(parent->OptPrb < 0)
			parent->OptPrb = 0;
		if(parent->OptPrb > 1)
			parent->OptPrb = 1;
	}
	else
	{
		assert(parent->PessVal != UNDEFINED);
		// (p-t)/(p-r)
		if(parent->PessVal == parent->RealVal)
			parent->OptPrb = 0;
		else
			parent->OptPrb = ((parent->PessVal-TargetVal)*1.0)/(1.0*(parent->PessVal-parent->RealVal));
		if(parent->OptPrb < 0)
			parent->OptPrb = 0;
		if(parent->OptPrb > 1)
			parent->OptPrb = 1;
	}
}

void BStar::BackupPrb(TreeNode *node)
{
	TreeNode *aux = 0;
	TreeNode *aux1 = node;

	for(aux = node->MoveTo(PARENT);
		aux; aux = aux->MoveTo(PARENT))
	{
		PropagatePrb1(aux1,aux);
		aux1 = aux;
	}
}

void BStar::PropagatePrb1(TreeNode *nodo,TreeNode *parent)
{

	if(nodo->Color != ColorRoot ) 
		parent->OptPrb = Product(parent,0);
	else
		parent->OptPrb =  GetBestChildOptPrb(parent);
}

//			Trace down the child subtree selecting
//			For Opponent-to-Move nodes, child with largest OptPrb
//			For Player-to-Move nodes, child with best RealVal
//			Until arriving at a leaf node;

TreeNode *BStar::TraceDownVerify(TreeNode *a)
{
	TreeNode *SelectedNode;
	SelectedNode = a;
	while( SelectedNode && SelectedNode->MoveTo(FIRSTCHILD))
	{
		a = SelectedNode;
		if(SelectedNode->Color == ColorRoot)
		{
			SelectedNode = GetBestOptPrbVerify(SelectedNode);
		}
		else
		{
			SelectedNode = GetRealValBestVerify(SelectedNode);
		}
	}
	if(SelectedNode)
		return SelectedNode;
	return a;
}

int BStar::RealVal2ndBstMoveAtRoot()
{
	TreeNode *aux = 0;
	int MaxValue;
	if(ColorRoot == blanco)
	{
		MaxValue = -UNDEFINED;
		for(aux = TreeNode::GetRootNode()->MoveTo(FIRSTCHILD);
			aux; aux = aux->MoveTo(NEXTSIBBLING))
		{
			if(aux->RealVal > MaxValue && aux != BestMoveAtRoot)
			{
				MaxValue = aux->RealVal;
			}
		}
	}
	else
	{
		MaxValue = UNDEFINED;
		for(aux = TreeNode::GetRootNode()->MoveTo(FIRSTCHILD);
			aux; aux = aux->MoveTo(NEXTSIBBLING))
		{
			if(aux->RealVal < MaxValue && aux != BestMoveAtRoot)
			{
				MaxValue = aux->RealVal;
			}
		}
	}
	return MaxValue ;

}

void BStar::VerifyInitNode(int ColorRoot,TreeNode *parent)
{
	TreeNode *aux;

	if(parent->MoveCount)
		credit_probe = credit_expand /(2 * parent->MoveCount);

	for(aux = parent->MoveTo(FIRSTCHILD);
		aux; aux = aux->MoveTo(NEXTSIBBLING))
	{
		if((TimeElapsed()-ini) >= TimeLimit )
			break;

		if(aux->OptVal == UNDEFINED)
		{
			SmpWorkers.DoWork(aux,true,DepthEval);

		}
	}
// wait for all workers end his job
	while(!SmpWorkers.AllIdle())SmpWorkers.Sleep();

	for(aux = parent->MoveTo(FIRSTCHILD);
		aux; aux = aux->MoveTo(NEXTSIBBLING))
	{
		CalcPrb(aux);
		VerifyInitNode(ColorRoot,aux);
	}
}
// Compute OptVal for all Opp nodes and calc OptPrb
void BStar::VerifyInit()
{
	// recorrer el arbol
	TreeNode *aux = TreeNode::GetRootNode();
	int ColorRoot = aux->Color;
	VerifyInitNode(ColorRoot,aux);
}

TreeNode *BStar::GetBestOptPrbVerify(TreeNode *parent)
{
	double MaxValue = -1.0;
	double PrbD = 0.0;

	TreeNode *aux;
	TreeNode *Sel = 0;
	for(aux = parent->MoveTo(FIRSTCHILD);
		aux; aux = aux->MoveTo(NEXTSIBBLING))
	{
		if(aux->SubtreeSize)
			PrbD = aux->OptPrb  / (sqrt((double)(aux->SubtreeSize)));
		else
			PrbD = aux->OptPrb ;
		if(	PrbD > MaxValue	)
		{
			MaxValue = PrbD; 
			Sel = aux ;
		}
	}
	return Sel;
}

// Best for player -> maximize
TreeNode *BStar::GetRealValBestVerify(TreeNode *n)
{
	return n->SelectBestReal();
}

void BStar::PropagateDown(TreeNode *parent)
{
	TreeNode *aux;

	for(aux = parent->MoveTo(FIRSTCHILD);
		aux; aux = aux->MoveTo(NEXTSIBBLING))
	{
		aux->PessVal = parent->OptVal;
	}
}
int BStar::GetDepth(TreeNode *node)
{
	int depth = 1;
	TreeNode *aux,*Root;
	for(aux = node->MoveTo(PARENT),Root = TreeNode::GetRootNode(); 
		aux != NULL && aux != Root; 
			aux = aux->MoveTo(PARENT))
	{
		depth++;
	}
	return depth;
}


void BStar::RecalcSubtreeOptPrb(TreeNode *parent)
{
	TreeNode *aux;
	aux = parent->MoveTo(FIRSTCHILD);
	if(!aux)
	{
		// if leaf recalc OptPrb
		RecalProb(parent);
	}
	else
	{
		// if not leaf recalc each child
		for(;aux;aux = aux->MoveTo(NEXTSIBBLING))
		{
			RecalcSubtreeOptPrb(aux);
		}
		// backup value
		if(parent->Color != ColorRoot )
		{
			parent->OptPrb =  Product(parent,0);
		}
		else
			parent->OptPrb = GetBestChildOptPrb(parent);
	}
}

void BStar::RecalcSubtreeOptPrbVerify(TreeNode *parent)
{
	TreeNode *aux;
	aux = parent->MoveTo(FIRSTCHILD);
	if(!aux)
	{
		// if leaf recalc OptPrb
		RecalProb(parent);
	}
	else
	{
		// if not leaf recalc each child
		for(;aux;aux = aux->MoveTo(NEXTSIBBLING))
		{
			RecalcSubtreeOptPrb(aux);
		}
		// backup value
		if(parent->Color != ColorRoot )
		{
			parent->OptPrb = GetBestChildOptPrb(parent);
		}
		else
			parent->OptPrb =  Product(parent,0);
	}
}

void BStar::PrintPV()
{
	if(!PrintPVV)return;
	int timeUsed;
	char Path[1024];
	int SelDepth = 0;
	TreeNode *aux;
	Path[0] = '\0';
	for(aux = TreeNode::GetRootNode()->SelectBestReal();aux; aux = aux->SelectBestReal())
	{
		strcat(Path,aux->MoveStr);
		strcat(Path," ");
		SelDepth++;
	}

	timeUsed = TimeElapsed()-ini;
	if(timeUsed <=0)
		timeUsed = 1;
	int nps;
	nps = (TotalExpand * 1000)/ timeUsed;
	int mate;

	int value =  BestMoveAtRoot->RealVal;
	if(BestMoveAtRoot->Color == blanco)
		value = -value;

	mate = 0;
	if(value >= MATE -50)
	{
		mate = MATE -value;
	}
	if(value <= -MATE +50)
	{
		mate = MATE +value;
		mate = -mate;
	}
	if(!mate)
	{
		Print("info depth %d seldepth %d pv %s score cp %d nodes %d nps %d hashfull %d time %ld\n",
			DepthEval,
			SelDepth,
			Path,
			value,
			TotalExpand ,
			nps,
			0,	
			timeUsed);
	}
	else
	{
		Print("info depth %d seldepth %d pv %s score mate %d nodes %d nps %d hashfull %d time %ld\n",
			DepthEval,
			SelDepth,
			Path,
			mate/2,
			TotalExpand ,
			nps,
			0,	
			timeUsed);
	}

}
void BStar::SetProbeDepth(int d)
{
	FixedDepth = true;
	DepthEval = d;
}

TreeNode *BStar::GetNodeOfFEN(TreeNode *parent,char *fen)
{
	TreeNode *aux,*aux1;
	if(!parent)
		return NULL;

	for(aux = parent->MoveTo(FIRSTCHILD);aux;aux = aux->MoveTo(NEXTSIBBLING))
	{
		if(strcmp(aux->fen,fen)==0)
			return aux;
		aux1 = GetNodeOfFEN(aux,fen);
		if(aux1)
			return aux1;
	}
	return NULL;
}
int BStar::GetToSq(char *movestr)
{
	int sq = 0;
	sq = (movestr[2]-'a')*8+(movestr[3]-'1');
	return sq;
}
