//    Copyright 2009 Antonio Torrecillas Gonzalez
//
//    This file is part of Rocinante.
//
//    Rocinante is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    Rocinante is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Rocinante.  If not, see <http://www.gnu.org/licenses/>
//

#define NMRED 2
const bool UseNullMove = true;

const bool DoExtensions = true;

#ifndef WIN32
#define THREAD
#endif

#include "stdio.h"
#include "stdlib.h"
#include "memory.h"
#include "string.h"
#include <time.h>
#include <assert.h>

// Clase para la base de nuestro programa
#include "Ajedrez.h"

#include "Oracle.h"

extern void Print(const char *fmt, ...);

extern u64 ataque[8][64]; // casilla pieza // distinguiendo peones blancos y negros

#include "Sort.h"
#include "PLY.h"



void CPartida::Nueva()
{
	Taux.ColorJuegan = 0;
	Taux.LoadEPD("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - bm 1;id 1;",0);
	Taux.CalculaJugadasPosibles();
	Taux.hash = 0ull;
	NumMoves = 0;

}

HRESULT CPartida::Mueve(char *Jugada)
{
	int retorno;
	Taux.CalculaJugadasPosibles();
	if(
		strcmp(Jugada,"0-0") == 0 || 
		strcmp(Jugada,"O-O") == 0 || 
		strcmp(Jugada,"00") == 0 || 
		strcmp(Jugada,"OO") == 0 
		)
	{
		if(Taux.ColorJuegan == blanco)
		{
			retorno =  Taux.MueveAlgebra("e1g1");
		}
		else
		{
			retorno =  Taux.MueveAlgebra("e8g8");
		}
	}
	else if(
		strcmp(Jugada,"0-0-0") == 0 || 
		strcmp(Jugada,"O-O-O") == 0 || 
		strcmp(Jugada,"000") == 0 || 
		strcmp(Jugada,"OOO") == 0 
		)
	{
		if(Taux.ColorJuegan == blanco)
		{
			retorno =  Taux.MueveAlgebra("e1c1");
		}
		else
		{
			retorno =  Taux.MueveAlgebra("e8c8");
		}
	}
	else
	{
		retorno =  Taux.MueveAlgebra(Jugada);
	}
	NumMoves++;
	// normalizamos las condiciones de entoque
	if(Taux.EstadoEnroque & MRB)
		Taux.EstadoEnroque |= MRB|MTRB|MTDB;
	if(Taux.EstadoEnroque & MRN)
		Taux.EstadoEnroque |= MRN|MTRN|MTDN;

	Taux.hash = 0ull;

	return retorno;
}


CPartida::CPartida()
{
	DepthPrintInfo = 6;
	InBStar = 0;
	SearchThread = 0;
#ifdef _DEBUG
	tiempo_limite = 20000;
#else
	tiempo_limite = 500000;
#endif
}

CPartida::~CPartida()
{
#ifdef THREADS
	if(hThread)
		CloseThread();
#endif
}


#define CORTA

void CPartida::LoadEPD(char *fen)
{
	Taux.LoadEPD(fen,0);
	Taux.hash = 0ull;

	NumMoves = 0;
}



void CPartida::Cancela()
{
	cancelado = 1;
}

void CPartida::PrintInfo(int value,char * path)
{
	extern void Print(const char *fmt, ...);

	int time;
	int segs;
	int mate;
	int nps = 0;

	if(Depth < DepthPrintInfo)
		return;

	time = TiempoTranscurrido() - inicio;
	if(time == 0)
		time++;
	segs = time / 1000;
	if(segs == 0)
		segs++;
	if(NodosVisitados < 2000000)
		nps = NodosVisitados*1000/time;
	else
		nps = NodosVisitados / segs;

	mate = 0;
	if(value >= MATE -50)
	{
		mate = MATE -value;
	}
	if(value <= -MATE +50)
	{
		mate = MATE +value;
		mate = -mate;
	}
	if(!mate)
	{
		Print("info depth %d seldepth %d pv %s score cp %d nodes %d nps %d hashfull %d time %ld\n",
			Depth,
			SelDepth,
			path,
			value,
			NodosVisitados,
			nps,
			0,	// numero de veces que se recalcula
			time);
	}
	else
	{
		Print("info depth %d seldepth %d pv %s score mate %d nodes %d nps %d hashfull %d time %ld\n",
			Depth,
			SelDepth,
			path,
			mate/2,
			NodosVisitados,
			nps,
			0,	
			time);
	}
}

int NodesFaseDepth[33][16][2]; // fase depth nodos/n
int initNodesFaseDepth = 0;

void DumpNodesFaseDepth()
{
	int f,d;
	printf("int NodeDepthFase[33][16] = {\n");
	for(f = 0; f < 33;f++)
	{
		printf(" {");
		for(d = 0; d < 16;d++)
		{
			if(NodesFaseDepth[f][d][1])
				printf("%d,",NodesFaseDepth[f][d][0] / NodesFaseDepth[f][d][1]);
			else
				printf("%d,",1);
		}
		printf(" },\n");
	}
	printf("};\n");
}

int CPartida::ColorJuegan()
{
	return Taux.ColorJuegan;
}
int CPartida::HayRepeticionPartida(u64 hash) // verifica si esta posicion ya la hemos visto
{
	int i;
	int repe = 0;
	// buscamos en las posiciones 
	for(i= 0; i < 	NumMoves;i++)
	{
		if(PosPartida[i] == hash)
			repe++;
	}
	if(repe)
		return 1;
	return 0;
}

int CPartida::HayRepeticion(u64 hash)
// verifica si esta posicion ya la hemos visto
{
	int i;
	int repe = 0;
	for(i=0;i < stHistory;i++)
	{
		if(HashHistory[i] == hash)
			repe++;
	}
	if(repe)
		return repe;

	if(true)
	{
	// buscamos en las posiciones 
	for(i= 0; i < 	NumMoves;i++)
	{
		if(PosPartida[i] == hash)
			repe++;
	}
	if(repe)// == 2)
		return 1;
	}
	return 0;
}
void CPartida::SetHashHistory(u64 hash)
// asigna una firma de la posicion
{
	if(cancelado)
		return;

	if(stHistory < MAXDEPTH )
		HashHistory[stHistory++] = hash;
	else
		stHistory--;
	if(stHistory > SelDepth)
		SelDepth = stHistory;
}
void CPartida::ResetHistory()
{
	memset(HashHistory,0,sizeof(HashHistory));
	stHistory = 0;
}

void CPartida::PopHistory()
{
	stHistory--;
	if(stHistory < 0)
		stHistory = 0;
}

int CPartida::ValorMate(int signo)
{
	if(signo > 0)
		return( MATE - stHistory);
	else
		return ( -MATE + stHistory);
}
//
// Rutina de busqueda principal
//
void CPartida::IncNodes()
{
	// incrementamos los nodos vistos
	NodosVisitados++;
	if((NodosVisitados-NodosRepasados) > TOPENODOSREPASO)
	{		
		if(tiempo_limite)
		{
			if(((TiempoTranscurrido() - inicio) > tiempo_limite))
			{
				Cancela();
			}
			else
				NodosRepasados = NodosVisitados;
			if(FixedNodeSearch && FixedNodeSearch < NodosVisitados 
			)
			{
				Cancela();
			}
		}
	}
}


void CPartida::IncNodesQ()
{
//	NodosQS++;
	NodosVisitados++;
	if(tiempo_limite)
	if(NodosVisitados-NodosRepasados > TOPENODOSREPASO)
	{		
		if(((TiempoTranscurrido() - inicio) > tiempo_limite))
		{
			Cancela();
		}
		else
			NodosRepasados = NodosVisitados;
	}
}

// buscamos capturas y jaques y analizamos las posibilidades de escape.
int CPartida::NoCreativa(int alpha,int beta)
{
	int value,a,fase;
	
	value = ValorMate(-1);
	if(alpha < value)
		alpha = value;

	value = ValorMate(1);
	if(beta > value)
		beta = value;

	fase = 0;
	if(cancelado + (stHistory >> 6)) // si llenamos el pozo lo dejamos en tablas
		return Taux.GetEval(); //alpha;

	IncNodesQ();


	int Valor_i;

	PLY ply(SearchThread);

	SetHashHistory(1);

	ply.Init(Taux,true);

	int EsJaque = Taux.EstoyEnJaque();
//	Taux.FullEval();
	Valor_i = Taux.GetEval();

	// Vamos con material de sobra
	if(Valor_i >= beta && !EsJaque) 
	{
		PopHistory();
		return Valor_i;
	}

	a = alpha;
//	if(Valor_i > alpha && (beta-alpha) > 1)
	a = Valor_i;
	value = a;

	bool InPV = (beta-alpha) > 1;

	CJugada J;
	int legales = 0;
	for(J = ply.GetNextQ();J.ToInt();J = ply.GetNextQ())
	{
		if(J.desglose.captura == rey)
		{
			a = ValorMate(1);
			PopHistory();
			return a;
		}
		if(J.desglose.peso < (PesoCaptura+PesoCapturaBuena))
			continue;
		ply.Move(J);
		if(!Taux.EsAtacada(Taux.PosReyes[Taux.ColorJuegan^1],Taux.ColorJuegan^1) )
		{
			legales++;
			if(legales == 1)
			{
				value = -NoCreativa(-beta,-alpha);
			}
			else
				value = -NoCreativa(-beta,-a);
		}
		ply.TakeBack(J);
		if(value > Valor_i )
		{
			Valor_i = value;
			if(value > a)
			{
				a = value;
				if(a >= beta && legales > 0 ) 
				{
					break;
				}
			}
		}	
	} // for

	PopHistory();
//	if(a == -INFINITO)
	if(EsJaque && legales == 0)
	{
		a = Valor_i;
//		return QNoCreativa(alpha,beta);
	}
	return ( a );   
}
void CPartida::MuevePath(char *path)
{
	char string[2024];
	char seps[]   = " #,\t\n";
	char *token;
	int i = 0;

	strcpy(string,path);
   /* Establish string and get the first token: */
   token = strtok( string, seps );
   while( token != NULL )
   {
	   Mueve(token);
      /* Get next token: */
      token = strtok( NULL, seps );
	  i++;
   }
}

int CPartida::PVS(int depth, int alpha, int beta)
{
	u64 hash2;
	int ext_local;
	u64 hash;
	int value;
	int InPV = beta-alpha > 1;
	int EsJaque,legales = 0;
	int fFoundPv = false;
	int Valor_i = 0;
	Valor_i = ValorMate(-1);
	if(alpha < Valor_i)
		alpha = Valor_i;

	Valor_i = ValorMate(1);
	if(beta > Valor_i)
		beta = Valor_i;
	if(cancelado)
		return alpha;
	PLY ply(SearchThread);

	IncNodes();

	Valor_i = Taux.GetEval();
	if(EsJaque = Taux.EstoyEnJaque())
	{
		if(DoExtensions)
			depth++;
	}

	if((depth <= 0 || stHistory > MAXDEPTHC)) // extendiendo jaques agotamos la pila
	{
		NodosVisitados--; // correccion para no contarlos dos veces
		EnterQuiesce = stHistory;
		value = NoCreativa(alpha,beta);
		return value;
	}

	if(UseNullMove)
	{
		if( 
//			!InPV && 
			!EsJaque  
//			&& 	depth >= (NMRED)
//			&& Valor_i >= beta
			) 
		{
			int d = depth -NMRED;
			if(d < 0) d = 0;
			Taux.SwitchColor();
			value = -PVS(d, -beta,-beta+1);
			Taux.SwitchColor();
			if(value < (MATE-50))
			{
				if (value >= beta) 
				{
					value = beta;
#ifdef _DEBUG
					strcpy(Global," NULLMOVE ");
					strcat(Global,PV);
#endif
					return value;
				}
			}
		}
	} // UseNullMove


	SetHashHistory(1);


	// ahora recorremos las jugadas
	CJugada J;
	value = alpha;
	int MejorJ;
	MejorJ = 0;
	ply.Init(Taux,false);
	for(J = ply.GetNext();J.ToInt();J = ply.GetNext())
	{
		if(cancelado)
			break;
		ext_local = 0;

		if(J.desglose.captura == rey)
		{
			// esta posicion es mate
			alpha = ValorMate(-1);
			PopHistory();
            return alpha;
		}

		ply.Move(J);
		if(!Taux.EsAtacada(Taux.PosReyes[Taux.ColorJuegan^1],Taux.ColorJuegan^1))
		{
			legales++;
			if (true && fFoundPv) {
				value = -PVS(depth + ext_local - 1, -alpha-1, -alpha);
				if ((value > alpha) && (value < beta)) // Check for failure.
				{
					value = -PVS(depth + ext_local - 1, -beta, -alpha);
				}
			} else
			{
				value = -PVS(depth + ext_local - 1, -beta, -alpha);
				if (false && ext_local < 0 && (value > alpha) ) // Check for failure.
				{
					value = -PVS(depth - 1, -beta, -alpha);
				}
			}
		}
		ply.TakeBack(J);
        if (value >= beta)
		{
			if(J.desglose.captura == ninguna && J.desglose.coronar == ninguna && J.desglose.jaque == 0)
			{
				ply.pSort->SetKiller(J.ToInt());
			}
			PopHistory();
            return value; // beta;
		}

        if (value > alpha)
		{
            alpha = value;
			fFoundPv = true;
		}
    }
	if(legales == 0)
	{
		if(EsJaque)
		{
			// recibo mate
			alpha = ValorMate(-1);
		}
		else
		{
			// estoy ahogado
			alpha = 0;
		}
	}
	//if(alpha == -INFINITO)
	//	alpha = ValorMate(-1);
	PopHistory();
    return alpha;
}


void CPartida::ResetParam() 
{
	return;
}

int CPartida::IterativeDeepening(void)
{
	extern void Print(const char *fmt, ...);
	long ini_it;
	int value,value_i;
	int hasp;
	int MateCount = 0;
	// busqueda con ventana
//	FixedNodeSearch = 0;
//	LimiteProfundidad = 3;


	ValueSearch = 0;
	NodosVisitados = 0;
	cancelado  = 0;
	NodosRepasados = 0;
	SelDepth = 0;
	inicio = TiempoTranscurrido();
	JugadaActual[0] = '\0';
	NumRM = 0;
	Delphos.Initialize(Taux);
	Partida.cancelado = false;
	Partida.ResetHistory();
	JugadaActual[0] = '\0';
	// copiamos tablero principal
	ResetHistory();
	value = -INFINITO;
	// preparamos la primera evaluacion
	Depth = 1;
	value_i = value = RootPVS(Depth,-INFINITO,+INFINITO);
	Depth++;
	while(1)
	{
		if(cancelado)
			break;
		if(FixedNodeSearch && FixedNodeSearch < NodosVisitados 
			)
		{
			break;
		}

		if(tiempo_limite)
		{
			ini_it = TiempoTranscurrido();
			if((ini_it  - inicio) > tiempo_limite) // tiempo excedido
			{
				break;
			}
		}

		if(LimiteProfundidad)
			if(Depth > LimiteProfundidad)
				break;
		if(Depth > MAXDEPTHC)
			break;


		SelDepth = 0;
		hasp = value;
		ResetHistory();
		// nos colocamos en la historia
		value = RootPVS(Depth,-INFINITO,+INFINITO);
		if( cancelado == 1)
			break;
		if(value == MATE || value == -MATE)
		{
			strcpy(JugadaActual,"resign");
			break;
		}
		// llevamos la cuenta de iteraciones que damos o recibimos mate
		if(value < (50-MATE) && value > -MATE)
			MateCount++;
		if(value > (MATE-50) && value < MATE)
			MateCount++;

		// a partir de 2 iteraciones de mate podemos dar el resultado por bueno
		if(tiempo_limite)
		if(MateCount >= 2)
			break;

		Depth++;
	}
	ValueSearch = value;
	return value;
}


int CPartida::RootPVS(int depth, int alpha, int beta)
{
	u64 hash2;
	int ext_local;
	u64 hash;
	int value;
	int InPV = beta-alpha > 1;
	int EsJaque,legales = 0;
	int fFoundPv = false;
	int Valor_i = 0;
	CJugada J;

	if(NumRM == 0)
	{
		// first charge all moves
		PLY ply(SearchThread);
		ply.Init(Taux,false);
		for(J = ply.GetNext();J.ToInt();J = ply.GetNext())
		{
			ply.Move(J);
			if(!Taux.EsAtacada(Taux.PosReyes[Taux.ColorJuegan^1],Taux.ColorJuegan^1))
			{
				// save move
				RootMoves[NumRM] = J;
				RootNodeCount[NumRM] = 0;
				NumRM++;
			}
			ply.TakeBack(J);
		}
	}

	if(NumRM == 0)
	{
		EsJaque = Taux.EstoyEnJaque();
		if(!EsJaque )
		{
			return 0;
		}
		else
		{
			return -MATE;
		}
	}
	IncNodes();

	SetHashHistory(1);
	Valor_i = Taux.GetEval();
	// ahora recorremos las jugadas
	value = alpha;
	unsigned long long IniNc,FinNc,MejorNc;
	int MejorJ;
	MejorNc = 0ull;
	MejorJ = 0;
	int nmove;
	int BestM = 0;
	for(nmove = 0;nmove < NumRM;nmove++)
	{
		if(cancelado)
			break;
		ext_local = 0;
		J = RootMoves[nmove];
		if(J.desglose.captura == rey)
		{
			// esta posicion es mate
			strcpy(JugadaActual,J.ToString());
			alpha = ValorMate(-1);
			PopHistory();
            return alpha;
		}
		Taux.Mueve(J);
		if(!Taux.EsAtacada(Taux.PosReyes[Taux.ColorJuegan^1],Taux.ColorJuegan^1))
		{
			IniNc = NodosVisitados;
			legales++;

			if (true && fFoundPv) {
				value = -PVS(depth + ext_local - 1, -alpha-1, -alpha);
				if ((value > alpha) && (value < beta)) // Check for failure.
				{
					IniNc = NodosVisitados;
					value = -PVS(depth + ext_local - 1, -beta, -alpha);
				}
			} else
			{
				value = -PVS(depth + ext_local - 1, -beta, -alpha);
				//if (ext_local < 0 && (value > alpha) ) // Check for failure.
				//{
				//	IniNc = NodosVisitados;
				//	value = -PVS(depth - 1, -beta, -alpha);
				//}
			}


			FinNc = NodosVisitados;
			RootNodeCount[nmove] = (int)(FinNc-IniNc);
		}
		Taux.DesMueve(J);
        if (value > alpha)
		{
			BestM = nmove;
            alpha = value;
			fFoundPv = true;
		}
    }
	if(legales == 0)
	{
		if(EsJaque)
		{
			// recibo mate
			alpha = ValorMate(-1);
		}
		else
		{
			// estoy ahogado
			alpha = 0;
		}
	}

	// reordenar la mejor
	if(BestM != 0)
	{
		J = RootMoves[0];
		RootMoves[0] = RootMoves[BestM];
		RootMoves[BestM] = J;
		RootNodeCount[BestM] = RootNodeCount[0];
		RootNodeCount[0] = 999999999;
	}

	J = RootMoves[0];
	strcpy(JugadaActual,J.ToString());

	// reordenamos el resto por RootNodeCount[nmove]
	int i,Besti;
	for(nmove = 1; nmove < (NumRM-1); nmove++)
	{
		Besti = nmove;
		for(i=nmove+1; i< NumRM;i++)
		{
			if(RootNodeCount[i] > RootNodeCount[Besti])
			{
				Besti = i;
			}
		}
		// intercambiamos
		J = RootMoves[nmove];
		RootMoves[nmove] = RootMoves[Besti];
		RootMoves[Besti] = J;
		RootNodeCount[Besti] = RootNodeCount[nmove];
		RootNodeCount[nmove] = 0;
	}

	PopHistory();

    return alpha;
}

int CPartida::QNoCreativa(int alpha,int beta)
{
	int value,a;
	
	if(cancelado + (stHistory >> 6)) // si llenamos el pozo lo dejamos en tablas
		return Taux.GetEval();

	IncNodesQ();


	int Valor_i;

	PLY ply(SearchThread);

	SetHashHistory(1);
	ply.Init(Taux,false);

	int EsJaque = 1; 
	Valor_i = Taux.GetEval();

//	value = Valor_i;
	a = ValorMate(-1);
	value = a;


	CJugada J;
	int legales = 0;
	for(J = ply.GetNext();J.ToInt();J = ply.GetNext())
	{

		if(J.desglose.captura == rey)
		{
			a = ValorMate(1);
			PopHistory();
			return a;
		}
		ply.Move(J);
		if(!Taux.EsAtacada(Taux.PosReyes[Taux.ColorJuegan^1],Taux.ColorJuegan^1) )
		{
			value = -NoCreativa(-beta,-a);
			legales++;
		}
		ply.TakeBack(J);
		if(value > a )//&& legales > 0)
		{
			a = value;
			if(a >= beta ) 
			{
				break;
			}
		}	
	} // for

	PopHistory();
	if(legales == 0)
	{
		a = ValorMate(-1);
	}
	return ( a );   
}

