/* PurpleHaze 2.0.0
 * Copyright (C) 2007-2011  Vincent Ollivier
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef EVAL_H
#define EVAL_H

#include "common.h"

#define MALUS_BREAKING_CASTLE               -40
#define BONUS_CASTLE			    100
#define BONUS_KING_SHIELD		     30
#define BONUS_BISHOP_PAIR		     40
#define MALUS_NO_PAWN			    -30
#define MALUS_QUEEN_EARLY_MOVE		    -20
#define BONUS_ROOK_OPEN_FILE		     30
#define BONUS_ROOK_SEMI_OPEN_FILE	     15
#define BONUS_ROOK_SEVENTH_RANK		      5

// Hans Berliner's system
const int PIECE_VALUE[8] = { 
        0, // Empty piece
      100, // Pawn
      320, // Knight
      333, // Bishop
      510, // Rook
      880, // Queen
    10000, // King
};

// Adjustement based on the number of own paws (taken from CPW engine)
const int KNIGHT_ADJ[9] = {
    -20, -16, -12, -8, -4,  0,  4,  8, 12
};
const int ROOK_ADJ[9] = {
    15,  12,   9,  6,  3,  0, -3, -6, -9
};
const int MALUS_MULTI_PAWN[7] = { // Pawns on the same file
    0, 0, -25, -60, -100, -100, -100
};

/*
 * TODO: Those PCSQ tables comes from CPW engine and were utilized in
 * PurpleHaze 1.x. They will be replaced by something better when 
 * PurpleHaze 2.x will be ready for it.
 */ 
const int PAWN_PCSQ[BOARD_SIZE] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     -6,  -4,   1,   1,   1,   1,  -4,  -6,   0,   0,   0,   0,   0,   0,   0,   0,
     -6,  -4,   1,   2,   2,   1,  -4,  -6,   0,   0,   0,   0,   0,   0,   0,   0,
     -6,  -4,   2,   8,   8,   2,  -4,  -6,   0,   0,   0,   0,   0,   0,   0,   0,
     -6,  -4,   5,  10,  10,   5,  -4,  -6,   0,   0,   0,   0,   0,   0,   0,   0,
     -4,  -4,   1,   5,   5,   1,  -4,  -4,   0,   0,   0,   0,   0,   0,   0,   0,
     -6,  -4,   1, -24, -24,   1,  -4,  -6,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};
const int KNIGHT_PCSQ[BOARD_SIZE] = {
     -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,   0,   0,   0,   0,   0,   0,   0,   0,
     -8,   0,   0,   0,   0,   0,   0,  -8,   0,   0,   0,   0,   0,   0,   0,   0,
     -8,   0,   4,   4,   4,   4,   0,  -8,   0,   0,   0,   0,   0,   0,   0,   0,
     -8,   0,   4,   8,   8,   4,   0,  -8,   0,   0,   0,   0,   0,   0,   0,   0,
     -8,   0,   4,   8,   8,   4,   0,  -8,   0,   0,   0,   0,   0,   0,   0,   0,
     -8,   0,   4,   4,   4,   4,   0,  -8,   0,   0,   0,   0,   0,   0,   0,   0,
     -8,   0,   1,   2,   2,   1,   0,  -8,   0,   0,   0,   0,   0,   0,   0,   0,
     -8,  -12, -8,  -8,  -8,  -8, -12,  -8,   0,   0,   0,   0,   0,   0,   0,   0
};
const int BISHOP_PCSQ[BOARD_SIZE] = {
     -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,   0,   0,   0,   0,   0,   0,   0,   0,
     -4,   0,   0,   0,   0,   0,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,
     -4,   0,   2,   4,   4,   2,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,
     -4,   0,   4,   6,   6,   4,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,
     -4,   0,   4,   6,   6,   4,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,
     -4,   1,   2,   4,   4,   2,   1,  -4,   0,   0,   0,   0,   0,   0,   0,   0,
     -4,   2,   1,   1,   1,   1,   2,  -4,   0,   0,   0,   0,   0,   0,   0,   0,
     -4,  -4, -12,  -4,  -4, -12,  -4,  -4,   0,   0,   0,   0,   0,   0,   0,   0
};
const int ROOK_PCSQ[BOARD_SIZE] = {
      5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,
     20,  20,  20,  20,  20,  20,  20,  20,   0,   0,   0,   0,   0,   0,   0,   0,
     -5,   0,   0,   0,   0,   0,   0,  -5,   0,   0,   0,   0,   0,   0,   0,   0,
     -5,   0,   0,   0,   0,   0,   0,  -5,   0,   0,   0,   0,   0,   0,   0,   0,
     -5,   0,   0,   0,   0,   0,   0,  -5,   0,   0,   0,   0,   0,   0,   0,   0,
     -5,   0,   0,   0,   0,   0,   0,  -5,   0,   0,   0,   0,   0,   0,   0,   0,
     -5,   0,   0,   0,   0,   0,   0,  -5,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};
const int QUEEN_PCSQ[BOARD_SIZE] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   1,   1,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   1,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   2,   3,   3,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   2,   3,   3,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   1,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   1,   1,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     -5,  -5,  -5,  -5,  -5,  -5,  -5,  -5,   0,   0,   0,   0,   0,   0,   0,   0
};
const int KING_PCSQ[BOARD_SIZE] = {
    -40, -40, -40, -40, -40, -40, -40, -40,   0,   0,   0,   0,   0,   0,   0,   0,
    -40, -40, -40, -40, -40, -40, -40, -40,   0,   0,   0,   0,   0,   0,   0,   0,
    -40, -40, -40, -40, -40, -40, -40, -40,   0,   0,   0,   0,   0,   0,   0,   0,
    -40, -40, -40, -40, -40, -40, -40, -40,   0,   0,   0,   0,   0,   0,   0,   0,
    -40, -40, -40, -40, -40, -40, -40, -40,   0,   0,   0,   0,   0,   0,   0,   0,
    -40, -40, -40, -40, -40, -40, -40, -40,   0,   0,   0,   0,   0,   0,   0,   0,
    -15, -15, -20, -20, -20, -20, -15, -15,   0,   0,   0,   0,   0,   0,   0,   0,
      0,  20,  30, -30,   0, -20,  30,  20,   0,   0,   0,   0,   0,   0,   0,   0
};
const int KING_ENDGAME_PCSQ[BOARD_SIZE] = {
      0,  10,  20,  30,  30,  20,  10,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     10,  20,  30,  40,  40,  30,  20,  10,   0,   0,   0,   0,   0,   0,   0,   0,
     20,  30,  40,  50,  50,  40,  30,  20,   0,   0,   0,   0,   0,   0,   0,   0,
     30,  40,  50,  60,  60,  50,  40,  30,   0,   0,   0,   0,   0,   0,   0,   0,
     30,  40,  50,  60,  60,  50,  40,  30,   0,   0,   0,   0,   0,   0,   0,   0,
     20,  30,  40,  50,  50,  40,  30,  20,   0,   0,   0,   0,   0,   0,   0,   0,
     10,  20,  30,  40,  40,  30,  20,  10,   0,   0,   0,   0,   0,   0,   0,   0,
      0,  10,  20,  30,  30,  20,  10,   0,   0,   0,   0,   0,   0,   0,   0,   0
};
const int WEAK_PAWN_PCSQ[BOARD_SIZE] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    -10, -12, -14, -16, -16, -14, -12, -10,   0,   0,   0,   0,   0,   0,   0,   0,
    -10, -12, -14, -16, -16, -14, -12, -10,   0,   0,   0,   0,   0,   0,   0,   0,
    -10, -12, -14, -16, -16, -14, -12, -10,   0,   0,   0,   0,   0,   0,   0,   0,
    -10, -12, -14, -16, -16, -14, -12, -10,   0,   0,   0,   0,   0,   0,   0,   0,
     -8, -12, -14, -16, -16, -14, -12, -10,   0,   0,   0,   0,   0,   0,   0,   0,
     -8, -12, -14, -16, -16, -14, -12, -10,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};
const int PASSED_PAWN_PCSQ[BOARD_SIZE] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    100, 100, 100, 100, 100, 100, 100, 100,   0,   0,   0,   0,   0,   0,   0,   0,
     80,  80,  60,  80,  80,  80,  80,  80,   0,   0,   0,   0,   0,   0,   0,   0,
     60,  60,  60,  60,  60,  60,  60,  60,   0,   0,   0,   0,   0,   0,   0,   0,
     40,  40,  40,  40,  40,  40,  40,  40,   0,   0,   0,   0,   0,   0,   0,   0,
     20,  20,  20,  20,  20,  20,  20,  20,   0,   0,   0,   0,   0,   0,   0,   0,
     20,  20,  20,  20,  20,  20,  20,  20,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
 };
const int FLIP[BOARD_SIZE] = {
    112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
     96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
     80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,
     64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,
     48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
     32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
     16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
};

#endif /* !EVAL_H */
