/*
    Protector -- a UCI chess engine

    Copyright (C) 2009-2010 Raimund Heid (Raimund_Heid@yahoo.com)

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
/* Generated file -- do not edit! */
/* Hamming distance: 24 */

#include "keytable.h"

/* *INDENT-OFF* */

#ifdef TARGET_WINDOWS
UINT64 GENERATED_KEYTABLE[16][64] = {
   {12135172739437583129ui64, 11737613270708064789ui64,
    4496086737129178157ui64, 16187781064122049457ui64,
    16260440349225833334ui64, 7956310733409149768ui64,
    8817727161355116867ui64, 17265776973028307303ui64,
    15820037989886940682ui64, 11170664958511013619ui64,
    2146590870477676138ui64, 11113777446122106696ui64,
    278143126232886016ui64, 13283206935762625021ui64,
    12492328768749848525ui64, 11753056338017801566ui64,
    14510567019952079291ui64, 9185481576830120976ui64,
    18117818412660387317ui64, 8970124670895500652ui64,
    5115750201277481292ui64, 5713007101515241997ui64,
    922073907735713351ui64, 10673420361063995977ui64,
    2232248603257461367ui64, 17513849144397132379ui64,
    17425887554629103087ui64, 9342995760541824110ui64,
    4732404835099393645ui64, 10512846546049443946ui64,
    14827370676913039216ui64, 14241286334891468534ui64,
    10505192827146057091ui64, 14016880361215686419ui64,
    17708893330433293883ui64, 15508938792308616732ui64,
    15973346400070986352ui64, 13378186418551653288ui64,
    17003724301772639233ui64, 5195828147076714873ui64,
    7749379853043810307ui64, 2326073933967268150ui64,
    3885723993611153444ui64, 4446101150945716283ui64,
    3044354430354950309ui64, 3346128046587717747ui64,
    12656799072892902114ui64, 16979077793727939949ui64,
    6147378701111015125ui64, 12557986347651610117ui64,
    12597981769386078612ui64, 8627832138059657503ui64,
    12811674494002944689ui64, 2137114292115298690ui64,
    17953453134294029505ui64, 5468022729871218123ui64,
    922878320496071934ui64, 1484318952767544735ui64,
    2745896100267209231ui64, 1872674116797421960ui64,
    9559860632083868116ui64, 11272226094915946120ui64,
    1549204614009196008ui64, 5891142945007582891ui64,
    }
   ,
   {15743372961331394457ui64, 2518258191839706616ui64,
    14760139519387094410ui64, 16340844469464403422ui64,
    14326152593639017774ui64, 10111524140316012213ui64,
    1634265388627846640ui64, 10893696708141821726ui64,
    13137430380371491862ui64, 6216325164556063938ui64,
    14593402137290011241ui64, 11172432704076097145ui64,
    10272566591371214737ui64, 10893238713811120561ui64,
    8429570897912376889ui64, 6105061922040303384ui64,
    1430716640713844199ui64, 17841599275678827756ui64,
    17589945182771647650ui64, 7055539468546397466ui64,
    10656903515187695417ui64, 14464627806066038279ui64,
    14187351090405875460ui64, 7489320599978926975ui64,
    9829076772968152537ui64, 13044304444439878572ui64,
    9596441334428887865ui64, 11703783367276950040ui64,
    15911069107312409080ui64, 13942472280782200104ui64,
    11691014131865372894ui64, 3476345434108776063ui64,
    15777808698776672630ui64, 14672055879803999295ui64,
    2712769881733438957ui64, 11989680087152166911ui64,
    8963698069449416876ui64, 9085095497239063109ui64,
    9049015533180770267ui64, 18147016788251691435ui64,
    16698158265970372534ui64, 2574736008657446249ui64,
    737866203811942484ui64, 3353291349879562061ui64,
    15812081823820322410ui64, 7418285723711353951ui64,
    7742619109201777386ui64, 2038272679765180182ui64,
    8987334100977934556ui64, 17166409097244367940ui64,
    18173504320254827545ui64, 93878131565230103ui64,
    5362988470492793557ui64, 17146685513836167235ui64,
    9178468825086349675ui64, 4561740581656300540ui64,
    11324718189359880053ui64, 1533892791568636114ui64,
    7817832010959761850ui64, 17365817366541988934ui64,
    3086328016631205590ui64, 18018333519571885943ui64,
    13615373014815088503ui64, 17828010923335671392ui64,
    }
   ,
   {9347870459615392479ui64, 17448645783287062590ui64,
    6441172483192504575ui64, 12626735058274469397ui64,
    16108053131752923150ui64, 6523628744137818190ui64,
    13597938225374883331ui64, 1664696658590957037ui64,
    6612003930616327456ui64, 18295379594581855359ui64,
    3882696871813489051ui64, 12601681673940937871ui64,
    14230831474413597423ui64, 18299296095892537804ui64,
    3333418158555101395ui64, 13638690462774045797ui64,
    2122913865090405744ui64, 4085598469884468996ui64,
    8623253106648370830ui64, 13659495951250723355ui64,
    17663359776305897165ui64, 11250720858045107960ui64,
    1540150359238499083ui64, 6322628742229990875ui64,
    1186484013258455836ui64, 9870155727264040106ui64,
    14608009207277648063ui64, 13489096341266851881ui64,
    2449012600239179866ui64, 15601222368313198738ui64,
    17411433946231022458ui64, 9461529946846160836ui64,
    15360199975693154418ui64, 12570743233365962106ui64,
    8157637113392903844ui64, 8320572923838346506ui64,
    7439036752287275650ui64, 12851135430189424179ui64,
    8205286689791286975ui64, 3213714467186976662ui64,
    7945600052317850462ui64, 12037849193094347662ui64,
    7930620180605357628ui64, 1928208381601623959ui64,
    15130976445122455968ui64, 17299968960949735859ui64,
    16116242405514873535ui64, 12534861925027691245ui64,
    6119450011306622390ui64, 18357552588410155917ui64,
    6311225164251717777ui64, 8141615682424749920ui64,
    15109213930213506887ui64, 1797746550462906367ui64,
    10553488240226667493ui64, 16000825410687823650ui64,
    7738540858643611476ui64, 13140107386215282042ui64,
    7266987564058046265ui64, 13520652432029620938ui64,
    648291050261999261ui64, 9087137970090662466ui64,
    11471252938124079995ui64, 13974208696011933913ui64,
    }
   ,
   {10837201445049393682ui64, 6306414572119541485ui64,
    17178307266351244944ui64, 5359255352565066636ui64,
    5556205186692243983ui64, 7831981595458894343ui64,
    3562559510186845729ui64, 7328079098375689771ui64,
    15903194267803993029ui64, 18052535286624816706ui64,
    11031333598649620166ui64, 16500305219759662192ui64,
    9176249066746404023ui64, 11238787993528737647ui64,
    357330943156824034ui64, 6590012309889318606ui64,
    16542821378395347960ui64, 562299726046096725ui64,
    17982019179393379352ui64, 10359365927414926676ui64,
    11080111473721999370ui64, 5040073430793691454ui64,
    10072978059945288154ui64, 9648425197362692358ui64,
    12664673596280488180ui64, 16280621358837103956ui64,
    14824686366029265809ui64, 14945799398229579099ui64,
    3739762414380503941ui64, 12049255546093683420ui64,
    11725666868971793025ui64, 8516539841005448883ui64,
    17671889868135775554ui64, 14731077879484079546ui64,
    9889294032804596052ui64, 1609044793273194416ui64,
    7624895969155279786ui64, 13504483072755280434ui64,
    2692893490687740765ui64, 7533203434479543410ui64,
    15498585720903514155ui64, 2016516491085107286ui64,
    2006892955716882206ui64, 6742893265044621796ui64,
    5526878573820902835ui64, 11068342700340587361ui64,
    5997860233557528152ui64, 17932870122849898839ui64,
    5184617676784628777ui64, 14259037644007390691ui64,
    12570459558594352018ui64, 15003936253856949879ui64,
    6501869002009411527ui64, 9978162544974142902ui64,
    7371849583647364573ui64, 7924174333445215892ui64,
    11782292229476830671ui64, 18156982767848541863ui64,
    8123654007703585556ui64, 12628561737791516871ui64,
    3301124175410790233ui64, 2565859552317767543ui64,
    10339364815879982501ui64, 11932572208937724372ui64,
    }
   ,
   {1431396125531474277ui64, 17950472683123214208ui64,
    6237222104345045426ui64, 3849066386005683651ui64,
    12293208350245052602ui64, 14620575847416375618ui64,
    3666785955711020040ui64, 17564571334270005202ui64,
    15345621176117297568ui64, 1140730616179232925ui64,
    16381720906996608613ui64, 1639186353928667525ui64,
    2279285975597874485ui64, 4437738176321328749ui64,
    16452734681705022598ui64, 16487916592325350062ui64,
    14616365347933611188ui64, 5635577024781413613ui64,
    13177747357981865212ui64, 5163635355845073667ui64,
    15118843128543641429ui64, 18091465131434618926ui64,
    5306112857486495488ui64, 10918654654036742572ui64,
    16060667621170871663ui64, 13144723939085408994ui64,
    2869412500706796115ui64, 13675238825579018013ui64,
    35370734629610723ui64, 15777313964739878673ui64,
    11171665683360343212ui64, 1122879439251127074ui64,
    16092594035994579861ui64, 402749122289360185ui64,
    12352143501287371261ui64, 12325638131341508111ui64,
    2294683088344889625ui64, 8563168174309380630ui64,
    11409929301696827632ui64, 1776000859292650532ui64,
    12739675943714221134ui64, 9861883786729504641ui64,
    6317742196777013574ui64, 1835478851580617656ui64,
    9789498336046849953ui64, 2764730342883909616ui64,
    16762104071140364417ui64, 17371413867597986844ui64,
    6428001885114591795ui64, 13443206795837749981ui64,
    1764177864273234638ui64, 12936237138877165823ui64,
    2810656527165640611ui64, 9490484050076183244ui64,
    9549094521660078395ui64, 13958455099087191055ui64,
    5005006898941250397ui64, 8352178217082364686ui64,
    7941717367726381279ui64, 16388548531219604790ui64,
    17851438458269356243ui64, 15992615811563450079ui64,
    3697749094065730411ui64, 12580421006700214570ui64,
    }
   ,
   {4153920718013588447ui64, 12366121416462773951ui64,
    13349428463127894916ui64, 5978897684964974433ui64,
    5610526313714748001ui64, 11912961690316500187ui64,
    16459772319206309314ui64, 8564036645711597629ui64,
    17914933492232837609ui64, 13487772226498881923ui64,
    6495029722067797674ui64, 10535848235111176871ui64,
    12749317822959852700ui64, 5294676882849328162ui64,
    15157865069149841626ui64, 15087415424988919703ui64,
    12453070527037740129ui64, 1696606573277202273ui64,
    9062147379904774261ui64, 13420308902145018835ui64,
    3724969542902143357ui64, 6366678047303583253ui64,
    9881033056316066937ui64, 7311298978516034437ui64,
    7803951246101523107ui64, 4827175072228987457ui64,
    13460066660084780152ui64, 16624249693641160948ui64,
    3762314891758936739ui64, 16512884593079916871ui64,
    6061542715858705134ui64, 16939569200916046305ui64,
    10246482394653382402ui64, 8582183883362329729ui64,
    8676635579492028879ui64, 7281866690184419979ui64,
    8573905236748182587ui64, 18103907814292633585ui64,
    8408769691499954595ui64, 4941960543203085891ui64,
    16507625394596198000ui64, 13255597309136371678ui64,
    15284301863301046579ui64, 15116640009518158297ui64,
    15087540278161992102ui64, 9446184683536040595ui64,
    13561844303423042880ui64, 8776703661441425390ui64,
    17333134705418554383ui64, 11257055658351983291ui64,
    8170377024514022675ui64, 14458904671999942927ui64,
    12187316467034121256ui64, 12058553233511884694ui64,
    9651843265001584308ui64, 7611690501907750909ui64,
    13374180756172673749ui64, 2431538464179839335ui64,
    9581545432393052301ui64, 17576594680918150879ui64,
    13287937964535291814ui64, 9672287906197472587ui64,
    8579126318346276197ui64, 987146529066302180ui64,
    }
   ,
   {597838019196249062ui64, 4186748468526602522ui64,
    8130611199171644360ui64, 545402823915708486ui64,
    2982058267486518241ui64, 9010134855958378479ui64,
    1911659972896229087ui64, 8612375662340787187ui64,
    6631517845152172905ui64, 14182090963422450123ui64,
    752653659870113369ui64, 5693450253657799756ui64,
    9992837954551652216ui64, 14371806845847499283ui64,
    14464432168003837043ui64, 15218766308696184290ui64,
    13280675749471133981ui64, 15013361919761412807ui64,
    2801851774919304246ui64, 3469987298518607946ui64,
    17768731195568715512ui64, 5653986698560869929ui64,
    2190967898127249734ui64, 1853168567980889432ui64,
    14889691113729714508ui64, 15867225474263000978ui64,
    12201038080606559503ui64, 13889054102659705738ui64,
    10209242942442736562ui64, 7398336903110806634ui64,
    13646629897388442181ui64, 10662867155188573661ui64,
    2128139621008583387ui64, 12399434036101852234ui64,
    16831110044466691223ui64, 5646706242612388336ui64,
    14864988266685070653ui64, 16327203678893362271ui64,
    15766407196669786708ui64, 472092371844162333ui64,
    16930743571552624444ui64, 18261322507507559622ui64,
    2420108699588285670ui64, 12829252962703265536ui64,
    5746334463058267828ui64, 18330083654644484700ui64,
    11846471873399943585ui64, 3319151465870931375ui64,
    7103516229667091290ui64, 13092526960255450163ui64,
    10637362638531042573ui64, 17065312056045314934ui64,
    233301343003212211ui64, 12720926745162728386ui64,
    3115010269685250681ui64, 15733986037301909639ui64,
    14816313374595982888ui64, 4455679111085935784ui64,
    15892855806495164277ui64, 16849018351631806480ui64,
    7446433526580969617ui64, 6612064943689379966ui64,
    11888513173238295151ui64, 5688046588506625262ui64,
    }
   ,
   {11840778381986327486ui64, 4474563102257035657ui64,
    9283540770252031160ui64, 13353355746517817450ui64,
    6851970731751530890ui64, 8961500490458719535ui64,
    3983768882059657386ui64, 12879807616957781491ui64,
    6023113370240447166ui64, 8760297754772981944ui64,
    8781488989623003294ui64, 14721224276143067301ui64,
    4115964412397708533ui64, 15323469045273011837ui64,
    14882523106970114028ui64, 8234709566641548284ui64,
    11758062925167736655ui64, 17136064883963457641ui64,
    5795620725334180905ui64, 1582637084092193985ui64,
    12136804301633140462ui64, 17275906817347777841ui64,
    14036582212589430932ui64, 9630384447904405140ui64,
    8783837645387258309ui64, 11043565098540597039ui64,
    10564711803728802030ui64, 4535529165030459965ui64,
    10846228788788618834ui64, 11795847316278272952ui64,
    10960068800168565578ui64, 14071420555027911023ui64,
    11259489737827489139ui64, 3046434358174762386ui64,
    10769908858241646800ui64, 8545343070737071961ui64,
    2173371243454391736ui64, 7269161250166034359ui64,
    9570542768176282572ui64, 2550699185904474922ui64,
    2518898407805733142ui64, 16016239109149499529ui64,
    10817160464138372158ui64, 4505850284012610411ui64,
    17340317214866976693ui64, 17437209948410254052ui64,
    1067948230353732523ui64, 8620598211437893938ui64,
    16947286455702394608ui64, 12038092402102985786ui64,
    8922512919770498416ui64, 9044729567291149784ui64,
    11620656202951678537ui64, 8973329031509338245ui64,
    2854191644844658114ui64, 3116186065605351102ui64,
    5976831306529983818ui64, 12301787558473514578ui64,
    15518362301156378963ui64, 14491221117469574126ui64,
    8013575722107929530ui64, 16463218878507933989ui64,
    6483474290481419385ui64, 15161072451395085929ui64,
    }
   ,
   {4440661799640574550ui64, 116140077341520987ui64,
    14582152565288185124ui64, 4291059205588589894ui64,
    4420383784905035328ui64, 10615051635118445449ui64,
    13197313607618912317ui64, 12411216738989979326ui64,
    607646074187659531ui64, 11991783091275219132ui64,
    2770385270693218156ui64, 15038524493516927071ui64,
    16381981162459480511ui64, 2112818748556987360ui64,
    16810099447166978705ui64, 1122937871417033575ui64,
    7689169266191598635ui64, 12306517819999332633ui64,
    17463970096037295393ui64, 3139732645026104093ui64,
    13442085347825082002ui64, 3294312218711524633ui64,
    7963741861898295224ui64, 14297437432673684128ui64,
    9999238093212064174ui64, 8149880276450250820ui64,
    8304833712976726787ui64, 10424434965495814090ui64,
    10179087527641216239ui64, 18347876302700528263ui64,
    12610269426343141689ui64, 12785067233617897709ui64,
    16643380527026888212ui64, 10551023730428470250ui64,
    6880443205752389340ui64, 9249330002898198358ui64,
    11999546642751839944ui64, 16961707028910414412ui64,
    1954647834563164511ui64, 10261621256779345909ui64,
    13769935048303473408ui64, 10747958837705987855ui64,
    8221781086022930357ui64, 15484103769052024881ui64,
    2897813987710087989ui64, 1991202219549665508ui64,
    12302327243798348527ui64, 9492365156290170048ui64,
    7199495444231734692ui64, 5438189905121688060ui64,
    5921513281185144200ui64, 17252577072428775647ui64,
    16175783867470255461ui64, 3529718838528202237ui64,
    13656563596977227054ui64, 5110845734716978907ui64,
    13138178618595945136ui64, 8231086896192316716ui64,
    8716106506175486591ui64, 6875191877257045480ui64,
    8422605754813652893ui64, 6580643732628591430ui64,
    10427158956704453488ui64, 11289723461812307094ui64,
    }
   ,
   {1798978223418582791ui64, 16752548975951616538ui64,
    2634439484625158441ui64, 1614984984285910953ui64,
    16266098512963402173ui64, 15444766626902170892ui64,
    10850223996040040549ui64, 7117881613683636873ui64,
    6651011733736445036ui64, 7771765348836222436ui64,
    3780897413246119387ui64, 12439719090821725734ui64,
    5976620856000625861ui64, 10103871308748840130ui64,
    3548526059711146870ui64, 16771420736055944913ui64,
    13664425472371299144ui64, 5969924719656499887ui64,
    3601543419094681543ui64, 8342876690125659377ui64,
    2751169792940277267ui64, 9150349122627332006ui64,
    14752143404344491656ui64, 7928833884133672155ui64,
    1415362608833500598ui64, 14947783541790168999ui64,
    2677347025338804672ui64, 4572507326112077271ui64,
    8864329142566489111ui64, 8377101686123445544ui64,
    14176575921128068374ui64, 13452021187961398547ui64,
    12739727677336627427ui64, 15417727998155033539ui64,
    7205100800894009265ui64, 15765478879179676481ui64,
    6555566720930057016ui64, 10716258189479453323ui64,
    9463113568171843096ui64, 16321913146625954019ui64,
    12018379620264668716ui64, 4139827272061210869ui64,
    2481066159741621359ui64, 17557826793817985305ui64,
    9882012232457263670ui64, 13416925554042026071ui64,
    6689185431970406650ui64, 5471770065597806467ui64,
    15561216640904079257ui64, 13372741164993375852ui64,
    12083035013553131354ui64, 1780233499825079655ui64,
    12731539610669628343ui64, 8973871860447821428ui64,
    3845012015273127474ui64, 18311687480946120554ui64,
    14945093124287490049ui64, 14599786755585262425ui64,
    10551676512983027871ui64, 2493717673105096008ui64,
    14060459892613451482ui64, 463296046931193220ui64,
    9700520066038765774ui64, 6882914676796272285ui64,
    }
   ,
   {4588139352825098995ui64, 3546369649017738018ui64,
    14059900603164507532ui64, 5956649516412933137ui64,
    12210125062601515459ui64, 2422706826951604400ui64,
    7963380634565564326ui64, 5463771919022341923ui64,
    13538304847789290870ui64, 17589351552960023226ui64,
    17673142189872154234ui64, 11233277926016345229ui64,
    10239856341675373537ui64, 2672956746943122569ui64,
    10123106752654722311ui64, 8258234576211908030ui64,
    17781545870017744469ui64, 15997470902828154674ui64,
    2678439797261096915ui64, 15092500741306901612ui64,
    3968709541643584247ui64, 12113363352748935599ui64,
    14903798259578973203ui64, 2568908906834651723ui64,
    939531733054233791ui64, 4233006148862515721ui64,
    3785514452635732278ui64, 1754074213607066910ui64,
    18315808009836603564ui64, 14651271030794690163ui64,
    6712545231064209936ui64, 390165904773908920ui64,
    7559357847066489641ui64, 10295603565636783337ui64,
    757126940400561586ui64, 11053208387752872279ui64,
    3740015978027054212ui64, 54882040002468979ui64,
    7996886095953584976ui64, 9754104761979800694ui64,
    3493222199076932693ui64, 1774154028878593044ui64,
    4381247460965112591ui64, 9009622704439438475ui64,
    16973167890019474930ui64, 14019473391386281143ui64,
    12827072847238374089ui64, 3871497361657802986ui64,
    15507510219761086248ui64, 6393117062895119183ui64,
    5184131927801677982ui64, 10573119168718120484ui64,
    7036747959324007619ui64, 14899961872142172705ui64,
    14382706400408020185ui64, 484545753441448529ui64,
    16748648646755502893ui64, 7173552456256500278ui64,
    10634981607881997425ui64, 8981892347823766383ui64,
    14013341939569419184ui64, 15182435632061531993ui64,
    2729667609944135464ui64, 16530367947516840492ui64,
    }
   ,
   {998338408329656122ui64, 14147481447966325375ui64,
    14693103088994073640ui64, 7173238944186095893ui64,
    7882658699815921599ui64, 12404592732240236308ui64,
    10580404683043233859ui64, 6570315407779678517ui64,
    1260646897660221233ui64, 8445603118513962618ui64,
    8209056552821801618ui64, 14817267193979536548ui64,
    3265475412573583440ui64, 3854328144024213517ui64,
    7096483416745664166ui64, 10283761112914267086ui64,
    3650637679018280430ui64, 94466833362601978ui64,
    1612576146458523249ui64, 1390180630412087457ui64,
    4589271307507511172ui64, 3506468835905451675ui64,
    6824230931137248504ui64, 12759394937756526944ui64,
    2996984961994921936ui64, 1685408898596095127ui64,
    9531405145274616658ui64, 12121205384981012206ui64,
    3371483228088882138ui64, 9285915962090358015ui64,
    3737497773763347248ui64, 7586742416729122317ui64,
    16912185851136139991ui64, 17039580598140371529ui64,
    4017731911054776665ui64, 16250819157895522384ui64,
    6465247073279438269ui64, 16534460397647235507ui64,
    16454834688824190747ui64, 10806440206083016193ui64,
    11394648955744435877ui64, 11661307429002611307ui64,
    7347426312981071136ui64, 345621559936207159ui64,
    12918101934132313421ui64, 14519269818476261970ui64,
    17872469867426527890ui64, 5886203320895256870ui64,
    7627776461635727298ui64, 13422090367986726074ui64,
    18075213242391155628ui64, 4991911450811887799ui64,
    17116513736334756793ui64, 12512621912037553410ui64,
    1616161741722577924ui64, 10203525310220168275ui64,
    13895718284514036119ui64, 2031058582667358437ui64,
    9867830839039752416ui64, 16216218663581585317ui64,
    3753689340353643837ui64, 8961119212259912348ui64,
    16856523031228092157ui64, 11406155353171276692ui64,
    }
   ,
   {1127796741991317152ui64, 3860445709557037386ui64,
    1600083166448777999ui64, 15480431550358570999ui64,
    11151142521115273121ui64, 5168587456735155737ui64,
    11306325239769165705ui64, 3936998598845422260ui64,
    10152978299819399321ui64, 10912303489365934246ui64,
    3955611014914185538ui64, 6633245879432790865ui64,
    9838898124685509174ui64, 13524464538315461006ui64,
    10811617557492560068ui64, 5995636575372289095ui64,
    6393252529955858465ui64, 1255194568630832284ui64,
    1650472998759977900ui64, 3043609541486814374ui64,
    18431337321776634132ui64, 5989598008747634402ui64,
    11448175512063062836ui64, 12687126110314776318ui64,
    335423811940450546ui64, 4998026425053583239ui64,
    1628824750220729309ui64, 18244213327099156894ui64,
    17310173172169878496ui64, 2038055093440005918ui64,
    509846382323908501ui64, 9196637839649368001ui64,
    11477726708741717163ui64, 970669468447505372ui64,
    9382325199563679358ui64, 1958928740091065907ui64,
    11261905526578102391ui64, 17915857093269164191ui64,
    12044477961165816641ui64, 14570774418881171334ui64,
    3064208060615348728ui64, 1210127626183665278ui64,
    1086554006459633378ui64, 16072527272818201110ui64,
    5883065804149495634ui64, 12472711482353203111ui64,
    12995840662368271884ui64, 7029022382778501736ui64,
    12619213624195459551ui64, 10455184974311418650ui64,
    13974399063287408196ui64, 17327618159340505755ui64,
    3738195813735278300ui64, 1321070859087497528ui64,
    407840670946740394ui64, 17433599567037821668ui64,
    5376841321894522333ui64, 17804387966790885151ui64,
    3802851349978705987ui64, 16359600645089933525ui64,
    8848714914850052754ui64, 11550921279329776499ui64,
    7297661771285973987ui64, 16027469491049267119ui64,
    }
   ,
   {349868073204954046ui64, 17141612588793591832ui64,
    10469619596760883534ui64, 7582708489525245022ui64,
    16236646198202364238ui64, 1611406609271440634ui64,
    1443623228929066313ui64, 1774373089594465327ui64,
    15176492685396408734ui64, 4404789883659875506ui64,
    10999500353442262225ui64, 4199480508376773208ui64,
    2392561348978120996ui64, 8884226056008481445ui64,
    3166533187852181657ui64, 6183878600766069948ui64,
    16088728630838045926ui64, 17835565535388085664ui64,
    7770899956213274436ui64, 79198348536578679ui64,
    1132667842213709093ui64, 15168779591452166940ui64,
    3781836405344791461ui64, 13348848602633807027ui64,
    17752422262553691849ui64, 4636026775778436635ui64,
    15753725790737873592ui64, 10198636488923764187ui64,
    9837852693685003534ui64, 16440853556209561173ui64,
    5598508554745672554ui64, 3409375865224289124ui64,
    7107465246768148459ui64, 3025333085638747468ui64,
    2853495069211824740ui64, 864038957272343231ui64,
    16290231655035622437ui64, 2946584826995695203ui64,
    12008147181847711089ui64, 12054068472385668015ui64,
    2332729497119100290ui64, 803640216543197407ui64,
    14968176847934095083ui64, 15375994425138026126ui64,
    9694471490230675552ui64, 17515785553539077400ui64,
    15319653294621923442ui64, 5351717582410758637ui64,
    4275909884816715898ui64, 1993976247613777902ui64,
    15197436936341392332ui64, 15351439561125240664ui64,
    2993703908740225981ui64, 6677770004857896033ui64,
    9522193901853783771ui64, 15571013028262415598ui64,
    4356577970748399505ui64, 12671802387253663916ui64,
    16111629369705360503ui64, 5540610732463731203ui64,
    10188038233629315869ui64, 16371527005256530769ui64,
    7162597580400747658ui64, 2473820438656575303ui64,
    }
   ,
   {16831378163860501196ui64, 6715360364526713313ui64,
    10128724604964997197ui64, 2881001910952074030ui64,
    7553096140967152831ui64, 17622301035311645467ui64,
    15360344377260537052ui64, 17958278328700947676ui64,
    12091092959422857158ui64, 7147516112277745519ui64,
    13312246356972338635ui64, 1082850966738409849ui64,
    10553377974394639576ui64, 14025713487184940497ui64,
    15467677486249051188ui64, 7350105734228277490ui64,
    8297374888480397977ui64, 11462039045710244365ui64,
    7574183913342845224ui64, 2966381839588739354ui64,
    3905778688350656330ui64, 1463344083634490510ui64,
    14802457519749484735ui64, 5143283033085403471ui64,
    14809792366541302550ui64, 12215164482347513957ui64,
    1569324708582438417ui64, 4533747669000494243ui64,
    15036751396337277605ui64, 1867858175927173774ui64,
    208275948235887621ui64, 10005420078658423462ui64,
    4678049936346475120ui64, 6698737812751527308ui64,
    10597440676764300084ui64, 12850622438559574820ui64,
    11883622614082766822ui64, 1656766921814686362ui64,
    13919010217054866823ui64, 4206593667916827950ui64,
    5738811258305697160ui64, 16506342903455884540ui64,
    12072535680887563400ui64, 9130760839532269631ui64,
    1987957450843506368ui64, 9245104059044695706ui64,
    5099587533869873510ui64, 10185134888532980228ui64,
    11617160365652239824ui64, 3829503021193877110ui64,
    9138641453747615978ui64, 1121114417259555352ui64,
    14477739258243201614ui64, 11584749300009598582ui64,
    16436219965912266761ui64, 11757012342022601990ui64,
    7997471373643898144ui64, 12004655702435616433ui64,
    5940300330842271130ui64, 14748689582762798263ui64,
    2984376642740630406ui64, 6001591253613174857ui64,
    12752291305271227898ui64, 9569272301088618017ui64,
    }
   ,
   {877311701491147086ui64, 7143680594866172660ui64,
    3713631000718339817ui64, 2406429823007025656ui64,
    6208416686881706902ui64, 8906247940946687490ui64,
    8659893398294557132ui64, 15372702216337027768ui64,
    2259562403694385842ui64, 12883689313203783443ui64,
    16608922951738525688ui64, 2892793619882253445ui64,
    11772357373042225545ui64, 1920319188674341988ui64,
    11668062453621148532ui64, 17207135156138212042ui64,
    14488086142677966071ui64, 9663489839879399485ui64,
    14776530223596569289ui64, 14435818178258132432ui64,
    14780859344785188119ui64, 11446885156390218218ui64,
    6662797109071888032ui64, 16298726073776148490ui64,
    2252321755453870776ui64, 4266727084029777439ui64,
    9154632560191881693ui64, 569214833689939646ui64,
    9782533930623201274ui64, 11743028486387488395ui64,
    6227113503821376118ui64, 15770630891331233410ui64,
    106436588185059407ui64, 3616745517676370646ui64,
    9255366832314215854ui64, 770229791070090421ui64,
    15789818131683330080ui64, 357638127174645125ui64,
    1109328231855825544ui64, 2600983128825042743ui64,
    16722322407197547489ui64, 5493984794376662032ui64,
    1744239106772287963ui64, 4698960128736497289ui64,
    154054465040186936ui64, 3517340449667097849ui64,
    10235912165106356672ui64, 329905986857775652ui64,
    11576688857604010320ui64, 2406320231694733818ui64,
    1340595305144523306ui64, 2382053530983856020ui64,
    5416589487830942808ui64, 5050585225060491986ui64,
    5332570266650062695ui64, 1441555840292169192ui64,
    1189644953587954049ui64, 8646917375917092494ui64,
    10481839323547244597ui64, 14237482309492513456ui64,
    5243808064050201170ui64, 1192484576678017936ui64,
    4037110364307453552ui64, 7224411795167305924ui64,
    }
};
#endif

#ifdef TARGET_LINUX
UINT64 GENERATED_KEYTABLE[16][64] = {
   {12135172739437583129llu, 11737613270708064789llu,
    4496086737129178157llu, 16187781064122049457llu,
    16260440349225833334llu, 7956310733409149768llu,
    8817727161355116867llu, 17265776973028307303llu,
    15820037989886940682llu, 11170664958511013619llu,
    2146590870477676138llu, 11113777446122106696llu,
    278143126232886016llu, 13283206935762625021llu,
    12492328768749848525llu, 11753056338017801566llu,
    14510567019952079291llu, 9185481576830120976llu,
    18117818412660387317llu, 8970124670895500652llu,
    5115750201277481292llu, 5713007101515241997llu,
    922073907735713351llu, 10673420361063995977llu,
    2232248603257461367llu, 17513849144397132379llu,
    17425887554629103087llu, 9342995760541824110llu,
    4732404835099393645llu, 10512846546049443946llu,
    14827370676913039216llu, 14241286334891468534llu,
    10505192827146057091llu, 14016880361215686419llu,
    17708893330433293883llu, 15508938792308616732llu,
    15973346400070986352llu, 13378186418551653288llu,
    17003724301772639233llu, 5195828147076714873llu,
    7749379853043810307llu, 2326073933967268150llu,
    3885723993611153444llu, 4446101150945716283llu,
    3044354430354950309llu, 3346128046587717747llu,
    12656799072892902114llu, 16979077793727939949llu,
    6147378701111015125llu, 12557986347651610117llu,
    12597981769386078612llu, 8627832138059657503llu,
    12811674494002944689llu, 2137114292115298690llu,
    17953453134294029505llu, 5468022729871218123llu,
    922878320496071934llu, 1484318952767544735llu,
    2745896100267209231llu, 1872674116797421960llu,
    9559860632083868116llu, 11272226094915946120llu,
    1549204614009196008llu, 5891142945007582891llu,
    }
   ,
   {15743372961331394457llu, 2518258191839706616llu,
    14760139519387094410llu, 16340844469464403422llu,
    14326152593639017774llu, 10111524140316012213llu,
    1634265388627846640llu, 10893696708141821726llu,
    13137430380371491862llu, 6216325164556063938llu,
    14593402137290011241llu, 11172432704076097145llu,
    10272566591371214737llu, 10893238713811120561llu,
    8429570897912376889llu, 6105061922040303384llu,
    1430716640713844199llu, 17841599275678827756llu,
    17589945182771647650llu, 7055539468546397466llu,
    10656903515187695417llu, 14464627806066038279llu,
    14187351090405875460llu, 7489320599978926975llu,
    9829076772968152537llu, 13044304444439878572llu,
    9596441334428887865llu, 11703783367276950040llu,
    15911069107312409080llu, 13942472280782200104llu,
    11691014131865372894llu, 3476345434108776063llu,
    15777808698776672630llu, 14672055879803999295llu,
    2712769881733438957llu, 11989680087152166911llu,
    8963698069449416876llu, 9085095497239063109llu,
    9049015533180770267llu, 18147016788251691435llu,
    16698158265970372534llu, 2574736008657446249llu,
    737866203811942484llu, 3353291349879562061llu,
    15812081823820322410llu, 7418285723711353951llu,
    7742619109201777386llu, 2038272679765180182llu,
    8987334100977934556llu, 17166409097244367940llu,
    18173504320254827545llu, 93878131565230103llu,
    5362988470492793557llu, 17146685513836167235llu,
    9178468825086349675llu, 4561740581656300540llu,
    11324718189359880053llu, 1533892791568636114llu,
    7817832010959761850llu, 17365817366541988934llu,
    3086328016631205590llu, 18018333519571885943llu,
    13615373014815088503llu, 17828010923335671392llu,
    }
   ,
   {9347870459615392479llu, 17448645783287062590llu,
    6441172483192504575llu, 12626735058274469397llu,
    16108053131752923150llu, 6523628744137818190llu,
    13597938225374883331llu, 1664696658590957037llu,
    6612003930616327456llu, 18295379594581855359llu,
    3882696871813489051llu, 12601681673940937871llu,
    14230831474413597423llu, 18299296095892537804llu,
    3333418158555101395llu, 13638690462774045797llu,
    2122913865090405744llu, 4085598469884468996llu,
    8623253106648370830llu, 13659495951250723355llu,
    17663359776305897165llu, 11250720858045107960llu,
    1540150359238499083llu, 6322628742229990875llu,
    1186484013258455836llu, 9870155727264040106llu,
    14608009207277648063llu, 13489096341266851881llu,
    2449012600239179866llu, 15601222368313198738llu,
    17411433946231022458llu, 9461529946846160836llu,
    15360199975693154418llu, 12570743233365962106llu,
    8157637113392903844llu, 8320572923838346506llu,
    7439036752287275650llu, 12851135430189424179llu,
    8205286689791286975llu, 3213714467186976662llu,
    7945600052317850462llu, 12037849193094347662llu,
    7930620180605357628llu, 1928208381601623959llu,
    15130976445122455968llu, 17299968960949735859llu,
    16116242405514873535llu, 12534861925027691245llu,
    6119450011306622390llu, 18357552588410155917llu,
    6311225164251717777llu, 8141615682424749920llu,
    15109213930213506887llu, 1797746550462906367llu,
    10553488240226667493llu, 16000825410687823650llu,
    7738540858643611476llu, 13140107386215282042llu,
    7266987564058046265llu, 13520652432029620938llu,
    648291050261999261llu, 9087137970090662466llu,
    11471252938124079995llu, 13974208696011933913llu,
    }
   ,
   {10837201445049393682llu, 6306414572119541485llu,
    17178307266351244944llu, 5359255352565066636llu,
    5556205186692243983llu, 7831981595458894343llu,
    3562559510186845729llu, 7328079098375689771llu,
    15903194267803993029llu, 18052535286624816706llu,
    11031333598649620166llu, 16500305219759662192llu,
    9176249066746404023llu, 11238787993528737647llu,
    357330943156824034llu, 6590012309889318606llu,
    16542821378395347960llu, 562299726046096725llu,
    17982019179393379352llu, 10359365927414926676llu,
    11080111473721999370llu, 5040073430793691454llu,
    10072978059945288154llu, 9648425197362692358llu,
    12664673596280488180llu, 16280621358837103956llu,
    14824686366029265809llu, 14945799398229579099llu,
    3739762414380503941llu, 12049255546093683420llu,
    11725666868971793025llu, 8516539841005448883llu,
    17671889868135775554llu, 14731077879484079546llu,
    9889294032804596052llu, 1609044793273194416llu,
    7624895969155279786llu, 13504483072755280434llu,
    2692893490687740765llu, 7533203434479543410llu,
    15498585720903514155llu, 2016516491085107286llu,
    2006892955716882206llu, 6742893265044621796llu,
    5526878573820902835llu, 11068342700340587361llu,
    5997860233557528152llu, 17932870122849898839llu,
    5184617676784628777llu, 14259037644007390691llu,
    12570459558594352018llu, 15003936253856949879llu,
    6501869002009411527llu, 9978162544974142902llu,
    7371849583647364573llu, 7924174333445215892llu,
    11782292229476830671llu, 18156982767848541863llu,
    8123654007703585556llu, 12628561737791516871llu,
    3301124175410790233llu, 2565859552317767543llu,
    10339364815879982501llu, 11932572208937724372llu,
    }
   ,
   {1431396125531474277llu, 17950472683123214208llu,
    6237222104345045426llu, 3849066386005683651llu,
    12293208350245052602llu, 14620575847416375618llu,
    3666785955711020040llu, 17564571334270005202llu,
    15345621176117297568llu, 1140730616179232925llu,
    16381720906996608613llu, 1639186353928667525llu,
    2279285975597874485llu, 4437738176321328749llu,
    16452734681705022598llu, 16487916592325350062llu,
    14616365347933611188llu, 5635577024781413613llu,
    13177747357981865212llu, 5163635355845073667llu,
    15118843128543641429llu, 18091465131434618926llu,
    5306112857486495488llu, 10918654654036742572llu,
    16060667621170871663llu, 13144723939085408994llu,
    2869412500706796115llu, 13675238825579018013llu,
    35370734629610723llu, 15777313964739878673llu,
    11171665683360343212llu, 1122879439251127074llu,
    16092594035994579861llu, 402749122289360185llu,
    12352143501287371261llu, 12325638131341508111llu,
    2294683088344889625llu, 8563168174309380630llu,
    11409929301696827632llu, 1776000859292650532llu,
    12739675943714221134llu, 9861883786729504641llu,
    6317742196777013574llu, 1835478851580617656llu,
    9789498336046849953llu, 2764730342883909616llu,
    16762104071140364417llu, 17371413867597986844llu,
    6428001885114591795llu, 13443206795837749981llu,
    1764177864273234638llu, 12936237138877165823llu,
    2810656527165640611llu, 9490484050076183244llu,
    9549094521660078395llu, 13958455099087191055llu,
    5005006898941250397llu, 8352178217082364686llu,
    7941717367726381279llu, 16388548531219604790llu,
    17851438458269356243llu, 15992615811563450079llu,
    3697749094065730411llu, 12580421006700214570llu,
    }
   ,
   {4153920718013588447llu, 12366121416462773951llu,
    13349428463127894916llu, 5978897684964974433llu,
    5610526313714748001llu, 11912961690316500187llu,
    16459772319206309314llu, 8564036645711597629llu,
    17914933492232837609llu, 13487772226498881923llu,
    6495029722067797674llu, 10535848235111176871llu,
    12749317822959852700llu, 5294676882849328162llu,
    15157865069149841626llu, 15087415424988919703llu,
    12453070527037740129llu, 1696606573277202273llu,
    9062147379904774261llu, 13420308902145018835llu,
    3724969542902143357llu, 6366678047303583253llu,
    9881033056316066937llu, 7311298978516034437llu,
    7803951246101523107llu, 4827175072228987457llu,
    13460066660084780152llu, 16624249693641160948llu,
    3762314891758936739llu, 16512884593079916871llu,
    6061542715858705134llu, 16939569200916046305llu,
    10246482394653382402llu, 8582183883362329729llu,
    8676635579492028879llu, 7281866690184419979llu,
    8573905236748182587llu, 18103907814292633585llu,
    8408769691499954595llu, 4941960543203085891llu,
    16507625394596198000llu, 13255597309136371678llu,
    15284301863301046579llu, 15116640009518158297llu,
    15087540278161992102llu, 9446184683536040595llu,
    13561844303423042880llu, 8776703661441425390llu,
    17333134705418554383llu, 11257055658351983291llu,
    8170377024514022675llu, 14458904671999942927llu,
    12187316467034121256llu, 12058553233511884694llu,
    9651843265001584308llu, 7611690501907750909llu,
    13374180756172673749llu, 2431538464179839335llu,
    9581545432393052301llu, 17576594680918150879llu,
    13287937964535291814llu, 9672287906197472587llu,
    8579126318346276197llu, 987146529066302180llu,
    }
   ,
   {597838019196249062llu, 4186748468526602522llu,
    8130611199171644360llu, 545402823915708486llu,
    2982058267486518241llu, 9010134855958378479llu,
    1911659972896229087llu, 8612375662340787187llu,
    6631517845152172905llu, 14182090963422450123llu,
    752653659870113369llu, 5693450253657799756llu,
    9992837954551652216llu, 14371806845847499283llu,
    14464432168003837043llu, 15218766308696184290llu,
    13280675749471133981llu, 15013361919761412807llu,
    2801851774919304246llu, 3469987298518607946llu,
    17768731195568715512llu, 5653986698560869929llu,
    2190967898127249734llu, 1853168567980889432llu,
    14889691113729714508llu, 15867225474263000978llu,
    12201038080606559503llu, 13889054102659705738llu,
    10209242942442736562llu, 7398336903110806634llu,
    13646629897388442181llu, 10662867155188573661llu,
    2128139621008583387llu, 12399434036101852234llu,
    16831110044466691223llu, 5646706242612388336llu,
    14864988266685070653llu, 16327203678893362271llu,
    15766407196669786708llu, 472092371844162333llu,
    16930743571552624444llu, 18261322507507559622llu,
    2420108699588285670llu, 12829252962703265536llu,
    5746334463058267828llu, 18330083654644484700llu,
    11846471873399943585llu, 3319151465870931375llu,
    7103516229667091290llu, 13092526960255450163llu,
    10637362638531042573llu, 17065312056045314934llu,
    233301343003212211llu, 12720926745162728386llu,
    3115010269685250681llu, 15733986037301909639llu,
    14816313374595982888llu, 4455679111085935784llu,
    15892855806495164277llu, 16849018351631806480llu,
    7446433526580969617llu, 6612064943689379966llu,
    11888513173238295151llu, 5688046588506625262llu,
    }
   ,
   {11840778381986327486llu, 4474563102257035657llu,
    9283540770252031160llu, 13353355746517817450llu,
    6851970731751530890llu, 8961500490458719535llu,
    3983768882059657386llu, 12879807616957781491llu,
    6023113370240447166llu, 8760297754772981944llu,
    8781488989623003294llu, 14721224276143067301llu,
    4115964412397708533llu, 15323469045273011837llu,
    14882523106970114028llu, 8234709566641548284llu,
    11758062925167736655llu, 17136064883963457641llu,
    5795620725334180905llu, 1582637084092193985llu,
    12136804301633140462llu, 17275906817347777841llu,
    14036582212589430932llu, 9630384447904405140llu,
    8783837645387258309llu, 11043565098540597039llu,
    10564711803728802030llu, 4535529165030459965llu,
    10846228788788618834llu, 11795847316278272952llu,
    10960068800168565578llu, 14071420555027911023llu,
    11259489737827489139llu, 3046434358174762386llu,
    10769908858241646800llu, 8545343070737071961llu,
    2173371243454391736llu, 7269161250166034359llu,
    9570542768176282572llu, 2550699185904474922llu,
    2518898407805733142llu, 16016239109149499529llu,
    10817160464138372158llu, 4505850284012610411llu,
    17340317214866976693llu, 17437209948410254052llu,
    1067948230353732523llu, 8620598211437893938llu,
    16947286455702394608llu, 12038092402102985786llu,
    8922512919770498416llu, 9044729567291149784llu,
    11620656202951678537llu, 8973329031509338245llu,
    2854191644844658114llu, 3116186065605351102llu,
    5976831306529983818llu, 12301787558473514578llu,
    15518362301156378963llu, 14491221117469574126llu,
    8013575722107929530llu, 16463218878507933989llu,
    6483474290481419385llu, 15161072451395085929llu,
    }
   ,
   {4440661799640574550llu, 116140077341520987llu,
    14582152565288185124llu, 4291059205588589894llu,
    4420383784905035328llu, 10615051635118445449llu,
    13197313607618912317llu, 12411216738989979326llu,
    607646074187659531llu, 11991783091275219132llu,
    2770385270693218156llu, 15038524493516927071llu,
    16381981162459480511llu, 2112818748556987360llu,
    16810099447166978705llu, 1122937871417033575llu,
    7689169266191598635llu, 12306517819999332633llu,
    17463970096037295393llu, 3139732645026104093llu,
    13442085347825082002llu, 3294312218711524633llu,
    7963741861898295224llu, 14297437432673684128llu,
    9999238093212064174llu, 8149880276450250820llu,
    8304833712976726787llu, 10424434965495814090llu,
    10179087527641216239llu, 18347876302700528263llu,
    12610269426343141689llu, 12785067233617897709llu,
    16643380527026888212llu, 10551023730428470250llu,
    6880443205752389340llu, 9249330002898198358llu,
    11999546642751839944llu, 16961707028910414412llu,
    1954647834563164511llu, 10261621256779345909llu,
    13769935048303473408llu, 10747958837705987855llu,
    8221781086022930357llu, 15484103769052024881llu,
    2897813987710087989llu, 1991202219549665508llu,
    12302327243798348527llu, 9492365156290170048llu,
    7199495444231734692llu, 5438189905121688060llu,
    5921513281185144200llu, 17252577072428775647llu,
    16175783867470255461llu, 3529718838528202237llu,
    13656563596977227054llu, 5110845734716978907llu,
    13138178618595945136llu, 8231086896192316716llu,
    8716106506175486591llu, 6875191877257045480llu,
    8422605754813652893llu, 6580643732628591430llu,
    10427158956704453488llu, 11289723461812307094llu,
    }
   ,
   {1798978223418582791llu, 16752548975951616538llu,
    2634439484625158441llu, 1614984984285910953llu,
    16266098512963402173llu, 15444766626902170892llu,
    10850223996040040549llu, 7117881613683636873llu,
    6651011733736445036llu, 7771765348836222436llu,
    3780897413246119387llu, 12439719090821725734llu,
    5976620856000625861llu, 10103871308748840130llu,
    3548526059711146870llu, 16771420736055944913llu,
    13664425472371299144llu, 5969924719656499887llu,
    3601543419094681543llu, 8342876690125659377llu,
    2751169792940277267llu, 9150349122627332006llu,
    14752143404344491656llu, 7928833884133672155llu,
    1415362608833500598llu, 14947783541790168999llu,
    2677347025338804672llu, 4572507326112077271llu,
    8864329142566489111llu, 8377101686123445544llu,
    14176575921128068374llu, 13452021187961398547llu,
    12739727677336627427llu, 15417727998155033539llu,
    7205100800894009265llu, 15765478879179676481llu,
    6555566720930057016llu, 10716258189479453323llu,
    9463113568171843096llu, 16321913146625954019llu,
    12018379620264668716llu, 4139827272061210869llu,
    2481066159741621359llu, 17557826793817985305llu,
    9882012232457263670llu, 13416925554042026071llu,
    6689185431970406650llu, 5471770065597806467llu,
    15561216640904079257llu, 13372741164993375852llu,
    12083035013553131354llu, 1780233499825079655llu,
    12731539610669628343llu, 8973871860447821428llu,
    3845012015273127474llu, 18311687480946120554llu,
    14945093124287490049llu, 14599786755585262425llu,
    10551676512983027871llu, 2493717673105096008llu,
    14060459892613451482llu, 463296046931193220llu,
    9700520066038765774llu, 6882914676796272285llu,
    }
   ,
   {4588139352825098995llu, 3546369649017738018llu,
    14059900603164507532llu, 5956649516412933137llu,
    12210125062601515459llu, 2422706826951604400llu,
    7963380634565564326llu, 5463771919022341923llu,
    13538304847789290870llu, 17589351552960023226llu,
    17673142189872154234llu, 11233277926016345229llu,
    10239856341675373537llu, 2672956746943122569llu,
    10123106752654722311llu, 8258234576211908030llu,
    17781545870017744469llu, 15997470902828154674llu,
    2678439797261096915llu, 15092500741306901612llu,
    3968709541643584247llu, 12113363352748935599llu,
    14903798259578973203llu, 2568908906834651723llu,
    939531733054233791llu, 4233006148862515721llu,
    3785514452635732278llu, 1754074213607066910llu,
    18315808009836603564llu, 14651271030794690163llu,
    6712545231064209936llu, 390165904773908920llu,
    7559357847066489641llu, 10295603565636783337llu,
    757126940400561586llu, 11053208387752872279llu,
    3740015978027054212llu, 54882040002468979llu,
    7996886095953584976llu, 9754104761979800694llu,
    3493222199076932693llu, 1774154028878593044llu,
    4381247460965112591llu, 9009622704439438475llu,
    16973167890019474930llu, 14019473391386281143llu,
    12827072847238374089llu, 3871497361657802986llu,
    15507510219761086248llu, 6393117062895119183llu,
    5184131927801677982llu, 10573119168718120484llu,
    7036747959324007619llu, 14899961872142172705llu,
    14382706400408020185llu, 484545753441448529llu,
    16748648646755502893llu, 7173552456256500278llu,
    10634981607881997425llu, 8981892347823766383llu,
    14013341939569419184llu, 15182435632061531993llu,
    2729667609944135464llu, 16530367947516840492llu,
    }
   ,
   {998338408329656122llu, 14147481447966325375llu,
    14693103088994073640llu, 7173238944186095893llu,
    7882658699815921599llu, 12404592732240236308llu,
    10580404683043233859llu, 6570315407779678517llu,
    1260646897660221233llu, 8445603118513962618llu,
    8209056552821801618llu, 14817267193979536548llu,
    3265475412573583440llu, 3854328144024213517llu,
    7096483416745664166llu, 10283761112914267086llu,
    3650637679018280430llu, 94466833362601978llu,
    1612576146458523249llu, 1390180630412087457llu,
    4589271307507511172llu, 3506468835905451675llu,
    6824230931137248504llu, 12759394937756526944llu,
    2996984961994921936llu, 1685408898596095127llu,
    9531405145274616658llu, 12121205384981012206llu,
    3371483228088882138llu, 9285915962090358015llu,
    3737497773763347248llu, 7586742416729122317llu,
    16912185851136139991llu, 17039580598140371529llu,
    4017731911054776665llu, 16250819157895522384llu,
    6465247073279438269llu, 16534460397647235507llu,
    16454834688824190747llu, 10806440206083016193llu,
    11394648955744435877llu, 11661307429002611307llu,
    7347426312981071136llu, 345621559936207159llu,
    12918101934132313421llu, 14519269818476261970llu,
    17872469867426527890llu, 5886203320895256870llu,
    7627776461635727298llu, 13422090367986726074llu,
    18075213242391155628llu, 4991911450811887799llu,
    17116513736334756793llu, 12512621912037553410llu,
    1616161741722577924llu, 10203525310220168275llu,
    13895718284514036119llu, 2031058582667358437llu,
    9867830839039752416llu, 16216218663581585317llu,
    3753689340353643837llu, 8961119212259912348llu,
    16856523031228092157llu, 11406155353171276692llu,
    }
   ,
   {1127796741991317152llu, 3860445709557037386llu,
    1600083166448777999llu, 15480431550358570999llu,
    11151142521115273121llu, 5168587456735155737llu,
    11306325239769165705llu, 3936998598845422260llu,
    10152978299819399321llu, 10912303489365934246llu,
    3955611014914185538llu, 6633245879432790865llu,
    9838898124685509174llu, 13524464538315461006llu,
    10811617557492560068llu, 5995636575372289095llu,
    6393252529955858465llu, 1255194568630832284llu,
    1650472998759977900llu, 3043609541486814374llu,
    18431337321776634132llu, 5989598008747634402llu,
    11448175512063062836llu, 12687126110314776318llu,
    335423811940450546llu, 4998026425053583239llu,
    1628824750220729309llu, 18244213327099156894llu,
    17310173172169878496llu, 2038055093440005918llu,
    509846382323908501llu, 9196637839649368001llu,
    11477726708741717163llu, 970669468447505372llu,
    9382325199563679358llu, 1958928740091065907llu,
    11261905526578102391llu, 17915857093269164191llu,
    12044477961165816641llu, 14570774418881171334llu,
    3064208060615348728llu, 1210127626183665278llu,
    1086554006459633378llu, 16072527272818201110llu,
    5883065804149495634llu, 12472711482353203111llu,
    12995840662368271884llu, 7029022382778501736llu,
    12619213624195459551llu, 10455184974311418650llu,
    13974399063287408196llu, 17327618159340505755llu,
    3738195813735278300llu, 1321070859087497528llu,
    407840670946740394llu, 17433599567037821668llu,
    5376841321894522333llu, 17804387966790885151llu,
    3802851349978705987llu, 16359600645089933525llu,
    8848714914850052754llu, 11550921279329776499llu,
    7297661771285973987llu, 16027469491049267119llu,
    }
   ,
   {349868073204954046llu, 17141612588793591832llu,
    10469619596760883534llu, 7582708489525245022llu,
    16236646198202364238llu, 1611406609271440634llu,
    1443623228929066313llu, 1774373089594465327llu,
    15176492685396408734llu, 4404789883659875506llu,
    10999500353442262225llu, 4199480508376773208llu,
    2392561348978120996llu, 8884226056008481445llu,
    3166533187852181657llu, 6183878600766069948llu,
    16088728630838045926llu, 17835565535388085664llu,
    7770899956213274436llu, 79198348536578679llu,
    1132667842213709093llu, 15168779591452166940llu,
    3781836405344791461llu, 13348848602633807027llu,
    17752422262553691849llu, 4636026775778436635llu,
    15753725790737873592llu, 10198636488923764187llu,
    9837852693685003534llu, 16440853556209561173llu,
    5598508554745672554llu, 3409375865224289124llu,
    7107465246768148459llu, 3025333085638747468llu,
    2853495069211824740llu, 864038957272343231llu,
    16290231655035622437llu, 2946584826995695203llu,
    12008147181847711089llu, 12054068472385668015llu,
    2332729497119100290llu, 803640216543197407llu,
    14968176847934095083llu, 15375994425138026126llu,
    9694471490230675552llu, 17515785553539077400llu,
    15319653294621923442llu, 5351717582410758637llu,
    4275909884816715898llu, 1993976247613777902llu,
    15197436936341392332llu, 15351439561125240664llu,
    2993703908740225981llu, 6677770004857896033llu,
    9522193901853783771llu, 15571013028262415598llu,
    4356577970748399505llu, 12671802387253663916llu,
    16111629369705360503llu, 5540610732463731203llu,
    10188038233629315869llu, 16371527005256530769llu,
    7162597580400747658llu, 2473820438656575303llu,
    }
   ,
   {16831378163860501196llu, 6715360364526713313llu,
    10128724604964997197llu, 2881001910952074030llu,
    7553096140967152831llu, 17622301035311645467llu,
    15360344377260537052llu, 17958278328700947676llu,
    12091092959422857158llu, 7147516112277745519llu,
    13312246356972338635llu, 1082850966738409849llu,
    10553377974394639576llu, 14025713487184940497llu,
    15467677486249051188llu, 7350105734228277490llu,
    8297374888480397977llu, 11462039045710244365llu,
    7574183913342845224llu, 2966381839588739354llu,
    3905778688350656330llu, 1463344083634490510llu,
    14802457519749484735llu, 5143283033085403471llu,
    14809792366541302550llu, 12215164482347513957llu,
    1569324708582438417llu, 4533747669000494243llu,
    15036751396337277605llu, 1867858175927173774llu,
    208275948235887621llu, 10005420078658423462llu,
    4678049936346475120llu, 6698737812751527308llu,
    10597440676764300084llu, 12850622438559574820llu,
    11883622614082766822llu, 1656766921814686362llu,
    13919010217054866823llu, 4206593667916827950llu,
    5738811258305697160llu, 16506342903455884540llu,
    12072535680887563400llu, 9130760839532269631llu,
    1987957450843506368llu, 9245104059044695706llu,
    5099587533869873510llu, 10185134888532980228llu,
    11617160365652239824llu, 3829503021193877110llu,
    9138641453747615978llu, 1121114417259555352llu,
    14477739258243201614llu, 11584749300009598582llu,
    16436219965912266761llu, 11757012342022601990llu,
    7997471373643898144llu, 12004655702435616433llu,
    5940300330842271130llu, 14748689582762798263llu,
    2984376642740630406llu, 6001591253613174857llu,
    12752291305271227898llu, 9569272301088618017llu,
    }
   ,
   {877311701491147086llu, 7143680594866172660llu,
    3713631000718339817llu, 2406429823007025656llu,
    6208416686881706902llu, 8906247940946687490llu,
    8659893398294557132llu, 15372702216337027768llu,
    2259562403694385842llu, 12883689313203783443llu,
    16608922951738525688llu, 2892793619882253445llu,
    11772357373042225545llu, 1920319188674341988llu,
    11668062453621148532llu, 17207135156138212042llu,
    14488086142677966071llu, 9663489839879399485llu,
    14776530223596569289llu, 14435818178258132432llu,
    14780859344785188119llu, 11446885156390218218llu,
    6662797109071888032llu, 16298726073776148490llu,
    2252321755453870776llu, 4266727084029777439llu,
    9154632560191881693llu, 569214833689939646llu,
    9782533930623201274llu, 11743028486387488395llu,
    6227113503821376118llu, 15770630891331233410llu,
    106436588185059407llu, 3616745517676370646llu,
    9255366832314215854llu, 770229791070090421llu,
    15789818131683330080llu, 357638127174645125llu,
    1109328231855825544llu, 2600983128825042743llu,
    16722322407197547489llu, 5493984794376662032llu,
    1744239106772287963llu, 4698960128736497289llu,
    154054465040186936llu, 3517340449667097849llu,
    10235912165106356672llu, 329905986857775652llu,
    11576688857604010320llu, 2406320231694733818llu,
    1340595305144523306llu, 2382053530983856020llu,
    5416589487830942808llu, 5050585225060491986llu,
    5332570266650062695llu, 1441555840292169192llu,
    1189644953587954049llu, 8646917375917092494llu,
    10481839323547244597llu, 14237482309492513456llu,
    5243808064050201170llu, 1192484576678017936llu,
    4037110364307453552llu, 7224411795167305924llu,
    }
};
#endif

/* *INDENT-ON* */
