/*
 * Decompiled with CFR 0.152.
 */
public class SEE {
    private static Board Board;

    public SEE() {
        Board = Board.getInstance();
    }

    public static boolean isPinned(int side, int to, int from) {
        int relation;
        long enemies;
        long king;
        if (side == 1) {
            king = SEE.Board.blackking;
            enemies = SEE.Board.whitepieces;
        } else {
            king = SEE.Board.whiteking;
            enemies = SEE.Board.blackpieces;
        }
        int kingPos = Long.numberOfTrailingZeros(king);
        if (kingPos == from) {
            return false;
        }
        enemies = side == 1 ? (enemies &= SEE.Board.whitequeen | SEE.Board.whitebishops | SEE.Board.whiterooks) : (enemies &= SEE.Board.blackqueen | SEE.Board.blackbishops | SEE.Board.blackrooks);
        int difference = kingPos - from;
        int rankDifference = kingPos / 8 - from / 8;
        if (difference < 0) {
            rankDifference *= -1;
        }
        if (rankDifference != 0) {
            if (difference % rankDifference != 0) {
                return false;
            }
            relation = difference / rankDifference;
        } else {
            relation = kingPos < from ? -99 : 99;
        }
        switch (relation) {
            case -9: {
                int nextPos;
                if (Global.Diag2Groups[from] == Global.Diag2Groups[to]) {
                    return false;
                }
                long temp = SEE.Board.bitboard & Global.plus9[kingPos];
                if ((nextPos = Long.numberOfTrailingZeros(temp &= -temp)) < from) {
                    return false;
                }
                return (Board.getAttack2(from) & enemies & Global.diag2Masks[Global.Diag2Groups[from]]) != 0L;
            }
            case 9: {
                int nextPos;
                if (Global.Diag2Groups[from] == Global.Diag2Groups[to]) {
                    return false;
                }
                long temp = SEE.Board.bitboard & Global.plus9[from];
                if ((nextPos = Long.numberOfTrailingZeros(temp &= -temp)) < kingPos) {
                    return false;
                }
                return (Board.getAttack2(from) & enemies & Global.diag2Masks[Global.Diag2Groups[from]]) != 0L;
            }
            case -7: {
                int nextPos;
                if (Global.Diag1Groups[from] == Global.Diag1Groups[to]) {
                    return false;
                }
                long temp = SEE.Board.bitboard & Global.plus7[kingPos];
                if ((nextPos = Long.numberOfTrailingZeros(temp &= -temp)) < from) {
                    return false;
                }
                return (Board.getAttack2(from) & enemies & Global.diag1Masks[Global.Diag1Groups[from]]) != 0L;
            }
            case 7: {
                int nextPos;
                if (Global.Diag1Groups[from] == Global.Diag1Groups[to]) {
                    return false;
                }
                long temp = SEE.Board.bitboard & Global.plus7[from];
                if ((nextPos = Long.numberOfTrailingZeros(temp &= -temp)) < kingPos) {
                    return false;
                }
                return (Board.getAttack2(from) & enemies & Global.diag1Masks[Global.Diag1Groups[from]]) != 0L;
            }
            case -8: {
                int nextPos;
                if (from % 8 == to % 8) {
                    return false;
                }
                long temp = SEE.Board.bitboard & Global.plus8[kingPos];
                if ((nextPos = Long.numberOfTrailingZeros(temp &= -temp)) < from) {
                    return false;
                }
                return (Board.getAttack2(from) & enemies & Global.fileMasks[from % 8]) != 0L;
            }
            case 8: {
                int nextPos;
                if (from % 8 == to % 8) {
                    return false;
                }
                long temp = SEE.Board.bitboard & Global.plus8[from];
                if ((nextPos = Long.numberOfTrailingZeros(temp &= -temp)) < kingPos) {
                    return false;
                }
                return (Board.getAttack2(from) & enemies & Global.fileMasks[from % 8]) != 0L;
            }
            case -99: {
                int nextPos;
                if (from / 8 == to / 8) {
                    return false;
                }
                long temp = SEE.Board.bitboard & Global.plus1[kingPos];
                if ((nextPos = Long.numberOfTrailingZeros(temp &= -temp)) < from) {
                    return false;
                }
                return (Board.getAttack2(from) & enemies & Global.rankMasks[from / 8]) != 0L;
            }
            case 99: {
                int nextPos;
                if (from / 8 == to / 8) {
                    return false;
                }
                long temp = SEE.Board.bitboard & Global.plus1[from];
                if ((nextPos = Long.numberOfTrailingZeros(temp &= -temp)) < kingPos) {
                    return false;
                }
                return (Board.getAttack2(from) & enemies & Global.rankMasks[from / 8]) != 0L;
            }
        }
        return false;
    }

    private static final void SortCaptures(int start, int noMoves, int[] Pieces) {
        boolean done = false;
        for (int i = start; i < noMoves && !done; ++i) {
            done = true;
            for (int j = noMoves - 1; j > i; --j) {
                if (Pieces[j] >= Pieces[j - 1]) continue;
                int temp = Pieces[j];
                Pieces[j] = Pieces[j - 1];
                Pieces[j - 1] = temp;
                done = false;
            }
        }
    }

    public static int getSEE(int side, int to, int from, int passant) {
        long temp2;
        long temp22;
        int cp;
        long enemies;
        long friends;
        if (side == 1) {
            friends = SEE.Board.blackpieces;
            enemies = SEE.Board.whitepieces;
        } else {
            friends = SEE.Board.whitepieces;
            enemies = SEE.Board.blackpieces;
        }
        int[] ePieces = new int[10];
        int[] fPieces = new int[10];
        int eCount = 0;
        int fCount = 0;
        ePieces[0] = to == passant ? Global.values[5] << 6 : ((cp = Board.piece_in_square[to]) != -1 ? Global.values[Board.piece_in_square[to]] << 6 : 0);
        eCount = 1;
        fPieces[0] = Global.values[Board.piece_in_square[from]] << 6 | from;
        fCount = 1;
        long attack = Board.getAttack2(to);
        for (long enemyDefenders = attack & enemies; enemyDefenders != 0L; enemyDefenders ^= temp22) {
            temp22 = enemyDefenders & -enemyDefenders;
            int pos = Long.numberOfTrailingZeros(temp22);
            int n = eCount++;
            ePieces[n] = Global.values[Board.piece_in_square[pos]] << 6 | pos;
        }
        if (eCount > 2) {
            SEE.SortCaptures(1, eCount, ePieces);
        }
        for (long friendAttackers = attack & friends & (Global.set_Mask[from] ^ 0xFFFFFFFFFFFFFFFFL); friendAttackers != 0L; friendAttackers ^= temp2) {
            temp2 = friendAttackers & -friendAttackers;
            int pos = Long.numberOfTrailingZeros(temp2);
            int n = fCount++;
            fPieces[n] = Global.values[Board.piece_in_square[pos]] << 6 | pos;
        }
        if (fCount > 2) {
            SEE.SortCaptures(1, fCount, fPieces);
        }
        int tempVal = 0;
        int alpha = -20000;
        int beta = 20000;
        int moveNumber = 0;
        long removedBits = 0L;
        while (true) {
            int pos;
            long temp23;
            if (fCount <= moveNumber) {
                SEE.Board.bitboard ^= removedBits;
                return alpha;
            }
            beta = Math.min(beta, tempVal += ePieces[moveNumber] >> 6);
            if (alpha >= beta) {
                SEE.Board.bitboard ^= removedBits;
                return alpha;
            }
            int removedPosition = fPieces[moveNumber] & 0x3F;
            SEE.Board.bitboard ^= Global.set_Mask[removedPosition];
            removedBits |= Global.set_Mask[removedPosition];
            long newAttack = Board.getAttack2(to);
            newAttack ^= attack;
            attack |= newAttack;
            if (newAttack != 0L) {
                if ((newAttack & friends) != 0L) {
                    temp23 = newAttack & -newAttack;
                    newAttack ^= temp23;
                    pos = Long.numberOfTrailingZeros(temp23);
                    int n = fCount++;
                    fPieces[n] = Global.values[Board.piece_in_square[pos]] << 6 | pos;
                    if (fCount - moveNumber > 2) {
                        SEE.SortCaptures(moveNumber + 1, fCount, fPieces);
                    }
                } else if ((newAttack & enemies) != 0L) {
                    temp23 = newAttack & -newAttack;
                    newAttack ^= temp23;
                    pos = Long.numberOfTrailingZeros(temp23);
                    int n = eCount++;
                    ePieces[n] = Global.values[Board.piece_in_square[pos]] << 6 | pos;
                    if (eCount - moveNumber >= 2) {
                        SEE.SortCaptures(moveNumber + 1, eCount, ePieces);
                    }
                }
            }
            if (eCount <= moveNumber + 1) {
                if ((alpha = Math.max(alpha, tempVal)) >= beta) {
                    SEE.Board.bitboard ^= removedBits;
                    return beta;
                }
                return alpha;
            }
            alpha = Math.max(alpha, tempVal -= fPieces[moveNumber] >> 6);
            if (alpha >= beta) {
                SEE.Board.bitboard ^= removedBits;
                return beta;
            }
            removedPosition = ePieces[moveNumber + 1] & 0x3F;
            SEE.Board.bitboard ^= Global.set_Mask[removedPosition];
            removedBits |= Global.set_Mask[removedPosition];
            newAttack = Board.getAttack2(to);
            newAttack ^= attack;
            attack |= newAttack;
            if (newAttack != 0L) {
                if ((newAttack & friends) != 0L) {
                    temp23 = newAttack & -newAttack;
                    newAttack ^= temp23;
                    pos = Long.numberOfTrailingZeros(temp23);
                    int n = fCount++;
                    fPieces[n] = Global.values[Board.piece_in_square[pos]] << 6 | pos;
                    if (fCount - moveNumber > 2) {
                        SEE.SortCaptures(moveNumber + 1, fCount, fPieces);
                    }
                } else if ((newAttack & enemies) != 0L) {
                    temp23 = newAttack & -newAttack;
                    newAttack ^= temp23;
                    pos = Long.numberOfTrailingZeros(temp23);
                    int n = eCount++;
                    ePieces[n] = Global.values[Board.piece_in_square[pos]] << 6 | pos;
                    if (eCount - moveNumber >= 3) {
                        SEE.SortCaptures(moveNumber + 2, eCount, ePieces);
                    }
                }
            }
            ++moveNumber;
        }
    }
}

