/*
 * Decompiled with CFR 0.152.
 */
public final class MoveHelper {
    private static final long[] KingMoveBoard = new long[64];
    private static final long[] kingCastleBoard = new long[256];
    private static final MoveHelper INSTANCE = new MoveHelper();

    private MoveHelper() {
        this.initKingBoard(KingMoveBoard);
        for (int i = 0; i < 256; ++i) {
            this.setKingCastle(i);
        }
    }

    public static MoveHelper getInstance() {
        return INSTANCE;
    }

    public final long getKingPosition(int square) {
        return KingMoveBoard[square];
    }

    private final void initKingBoard(long[] board) {
        for (int square = 0; square < 64; ++square) {
            int rank = square / 8;
            int file = square % 8;
            board[square] = 0L;
            if (rank > 0) {
                int n = square;
                board[n] = board[n] | 1L << square - 8;
                if (file > 0) {
                    int n2 = square;
                    board[n2] = board[n2] | 1L << square - 9;
                }
                if (file < 7) {
                    int n3 = square;
                    board[n3] = board[n3] | 1L << square - 7;
                }
            }
            if (rank < 7) {
                int n = square;
                board[n] = board[n] | 1L << square + 8;
                if (file > 0) {
                    int n4 = square;
                    board[n4] = board[n4] | 1L << square + 7;
                }
                if (file < 7) {
                    int n5 = square;
                    board[n5] = board[n5] | 1L << square + 9;
                }
            }
            if (file > 0) {
                int n = square;
                board[n] = board[n] | 1L << square - 1;
            }
            if (file >= 7) continue;
            int n = square;
            board[n] = board[n] | 1L << square + 1;
        }
    }

    public final long getKingCastle(int rank) {
        return kingCastleBoard[rank];
    }

    private final void setKingCastle(int file) {
        long temp;
        if (file >= 144 && file < 160) {
            MoveHelper.kingCastleBoard[file] = 64L;
        }
        if ((temp = (long)(file & 0x1F)) == 17L) {
            int n = file;
            kingCastleBoard[n] = kingCastleBoard[n] | 4L;
        }
    }

    public final long getDiag1Attack(int index1, int index2) {
        int i;
        int ind2;
        int DistToLeft = 0;
        int temp = index1;
        index2 &= (1 << Global.Diag1Length[index1]) - 1;
        long diag = 0L;
        while (temp % 8 != 0 && temp < 56) {
            temp += 7;
            ++DistToLeft;
        }
        if (index1 % 8 != 0) {
            ind2 = DistToLeft;
            for (i = index1 + 7; i < 64 && i % 8 != 7; i += 7) {
                diag |= 1L << i;
                if (((long)index2 & 1L << --ind2) != 0L) break;
            }
        }
        if (index1 % 8 != 7) {
            ind2 = DistToLeft;
            for (i = index1 - 7; i >= 0 && i % 8 != 0; i -= 7) {
                diag |= 1L << i;
                if (((long)index2 & 1L << ++ind2) != 0L) break;
            }
        }
        return diag;
    }

    public final long getDiag2Attack(int index1, int index2) {
        int i;
        int ind2;
        int DistToLeft = 0;
        int temp = index1;
        index2 &= (1 << Global.Diag2Length[index1]) - 1;
        long diag = 0L;
        while (temp % 8 != 0 && temp > 7) {
            temp -= 9;
            ++DistToLeft;
        }
        if (index1 % 8 != 0) {
            ind2 = DistToLeft;
            for (i = index1 - 9; i >= 0 && i % 8 != 7; i -= 9) {
                diag |= 1L << i;
                if (((long)index2 & 1L << --ind2) != 0L) break;
            }
        }
        if (index1 % 8 != 7) {
            ind2 = DistToLeft;
            for (i = index1 + 9; i < 64 && i % 8 != 0; i += 9) {
                diag |= 1L << i;
                if (((long)index2 & 1L << ++ind2) != 0L) break;
            }
        }
        return diag;
    }

    public final long getRooksRank2(int index1, int index2) {
        int i;
        long rank = 0L;
        for (i = index1 + 1; i < index1 / 8 * 8 + 8; ++i) {
            rank |= 1L << i;
            if (((long)index2 & 1L << i % 8) != 0L) break;
        }
        for (i = index1 - 1; i >= index1 / 8 * 8; --i) {
            rank |= 1L << i;
            if (((long)index2 & 1L << i % 8) != 0L) break;
        }
        return rank;
    }

    public final long getRooksFile2(int index1, int index2) {
        int i;
        long file = 0L;
        for (i = index1 + 8; i < 64; i += 8) {
            file |= 1L << i;
            if (((long)index2 & 1L << i / 8) != 0L) break;
        }
        for (i = index1 - 8; i >= 0; i -= 8) {
            file |= 1L << i;
            if (((long)index2 & 1L << i / 8) != 0L) break;
        }
        return file;
    }
}

