/*
 * Decompiled with CFR 0.152.
 */
public class MoveFunctions {
    private static Board chessBoard;

    public MoveFunctions() {
        chessBoard = Board.getInstance();
    }

    public static int getTo(int move) {
        return move >> 6 & 0x3F;
    }

    public static int getFrom(int move) {
        return move & 0x3F;
    }

    public static int getPiece(int move) {
        return move >> 12 & 0xF;
    }

    public static int getCapture(int move) {
        return (move >> 16 & 0xF) - 1;
    }

    public static int moveType(int move) {
        return move >> 20 & 0xF;
    }

    public static int getValue(int move) {
        return move >>> 24;
    }

    public static int setValue(int move, int value) {
        return move |= value << 24;
    }

    public static int makeMove(int to, int from, int piece, int capture, int type) {
        int move = from | to << 6 | piece << 12 | capture + 1 << 16 | type << 20;
        return move;
    }

    public static int makeMove(int to, int from) {
        int piece = Board.piece_in_square[from];
        int cP = Board.piece_in_square[to];
        int type = 0;
        if (piece == 4) {
            if (from == 4) {
                if (to == 2) {
                    type = 4;
                } else if (to == 6) {
                    type = 2;
                }
            }
        } else if (piece == 10) {
            if (from == 60) {
                if (to == 58) {
                    type = 4;
                } else if (to == 62) {
                    type = 2;
                }
            }
        } else if (piece == 5) {
            if (to - from == 16) {
                type = 8;
            }
            if (to / 8 == 7) {
                type = 3;
            } else if (to == chessBoard.getPassantB()) {
                type = 1;
            }
        } else if (piece == 11) {
            if (from - to == 16) {
                type = 9;
            }
            if (to / 8 == 0) {
                type = 3;
            } else if (to == chessBoard.getPassantW()) {
                type = 1;
            }
        }
        return from | to << 6 | piece << 12 | cP + 1 << 16 | type << 20;
    }
}

