/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Main {
    public static final int DEFAULT_WTIME = 1000;
    public static final int DEFAULT_BTIME = 1000;
    public static final int DEFAULT_WINC = 0;
    public static final int DEFAULT_BINC = 0;
    public static final int DEFAULT_TOGO = 35;
    public static BufferedReader reader;
    public static String cmd;
    public static Engine theSearch;
    public static Board Board;
    public static HistoryWriter writer;
    public static Evaluation2 eval;
    public static MoveFunctions moveFunctions;
    public static SEE see;

    public static void main(String[] args) throws IOException {
        try {
            see = new SEE();
            eval = new Evaluation2();
            moveFunctions = new MoveFunctions();
            Board = Board.getInstance();
            writer = new HistoryWriter();
            Board.newGame();
            reader = new BufferedReader(new InputStreamReader(System.in));
            theSearch = new Engine();
            Main.printGreeting();
            Main.getCmd();
        }
        catch (Exception ex) {
            System.out.print("info string ");
            System.out.println(ex);
            ex.printStackTrace();
        }
    }

    public static void printGreeting() {
        System.out.println("*****************MAGNUM CHESS***************");
        System.out.println("***************Version 3.00 JA***************");
    }

    public static void uci() throws IOException {
        int wtime = 0;
        int btime = 0;
        int winc = 0;
        int binc = 0;
        int togo = 0;
        boolean infinite = false;
        System.out.println("id name Magnum 3.0 JA");
        System.out.println("id author Eric Stock");
        System.out.println("option name Hash type spin default 8 min 8 max 512");
        System.out.println("option name Evaluation Table type spin default 4 min 1 max 64");
        System.out.println("option name Pawn Table type spin default 4 min 1 max 64");
        System.out.println("uciok");
        while (true) {
            int index;
            int depth;
            if ((cmd = reader.readLine()).startsWith("quit")) {
                System.exit(0);
            } else if (cmd.equals("eval_dump")) {
                Evaluation2.getEval(1);
                Evaluation2.printEvalTerms();
                Evaluation2.getEval(-1);
                Evaluation2.printEvalTerms();
            } else if ("isready".equals(cmd)) {
                System.out.println("readyok");
            }
            if (cmd.startsWith("perft")) {
                cmd = cmd.substring(5);
                cmd = cmd.trim();
                depth = Integer.parseInt(cmd.substring(0));
                theSearch.PerftTest(depth);
            }
            if (cmd.startsWith("divide")) {
                cmd = cmd.substring(6);
                cmd = cmd.trim();
                depth = Integer.parseInt(cmd.substring(0));
                theSearch.Divide(depth);
            }
            if (cmd.startsWith("position")) {
                String fen;
                int mstart;
                if (cmd.indexOf("startpos") != -1) {
                    mstart = cmd.indexOf("moves");
                    if (mstart <= -1) continue;
                    String moves = cmd.substring(mstart + 5);
                    Board.undoAll();
                    HistoryWriter.acceptMoves(moves);
                    continue;
                }
                mstart = cmd.indexOf("moves");
                if (mstart > -1) {
                    Board.undoAll();
                    fen = cmd.substring(cmd.indexOf("fen") + 4, mstart - 1);
                    Board.acceptFen(fen);
                    String moves = cmd.substring(mstart + 5);
                    HistoryWriter.acceptMoves(moves);
                    continue;
                }
                fen = cmd.substring(cmd.indexOf("fen") + 4);
                Board.acceptFen(fen);
                continue;
            }
            if (cmd.startsWith("setoption")) {
                index = cmd.indexOf("Hash");
                if (index != -1) {
                    index = cmd.indexOf("value");
                    cmd = cmd.substring(index + 5);
                    cmd = cmd.trim();
                    int hashSize = Integer.parseInt(cmd.substring(0));
                    Global.HASHSIZE = hashSize * 32768;
                    Engine.resetHash();
                    System.out.println("info string hashsize is " + hashSize);
                    continue;
                }
                if (cmd.indexOf("Evaluation Table") != -1) {
                    index = cmd.indexOf("value");
                    cmd = cmd.substring(index + 5);
                    cmd = cmd.trim();
                    int evalSize = Integer.parseInt(cmd.substring(0));
                    Global.EvalHASHSIZE = evalSize * 87381;
                    Evaluation2.reSizeEvalHash();
                    System.out.println("info string evalHash is " + evalSize);
                    continue;
                }
                if (cmd.indexOf("Pawn Table") != -1) {
                    index = cmd.indexOf("value");
                    cmd = cmd.substring(index + 5);
                    cmd = cmd.trim();
                    int evalSize = Integer.parseInt(cmd.substring(0));
                    Global.EvalHASHSIZE = evalSize * 43690;
                    Evaluation2.reSizeEvalHash();
                    System.out.println("info string pawnHash is " + evalSize);
                    continue;
                }
                System.out.println("info string command not recognized");
                continue;
            }
            if (cmd.startsWith("go")) {
                int movetime = 0;
                int maxMoveTime = 0;
                int searchDepth = 0;
                if (cmd.indexOf("depth") != -1) {
                    try {
                        index = cmd.indexOf("depth");
                        cmd = cmd.substring(index + 5);
                        cmd = cmd.trim();
                        searchDepth = Integer.parseInt(cmd.substring(0));
                        maxMoveTime = movetime = 9999999;
                    }
                    catch (NumberFormatException ex) {}
                } else if (cmd.indexOf("movetime") != -1) {
                    try {
                        index = cmd.indexOf("movetime");
                        cmd = cmd.substring(index + 8);
                        cmd = cmd.trim();
                        maxMoveTime = movetime = Integer.parseInt(cmd.substring(0));
                        searchDepth = 40;
                    }
                    catch (NumberFormatException ex) {}
                } else if (cmd.indexOf("infinite") != -1) {
                    infinite = true;
                    searchDepth = 40;
                    maxMoveTime = movetime = 1000;
                } else {
                    try {
                        int maxTimeLimit;
                        String temp;
                        searchDepth = 40;
                        int index2 = cmd.indexOf("wtime");
                        if (index2 == -1) {
                            wtime = 1000;
                        } else {
                            String temp2 = cmd.substring(index2 + 5).trim();
                            wtime = Integer.parseInt(temp2.substring(0, temp2.indexOf(" ")));
                        }
                        index2 = cmd.indexOf("btime");
                        btime = index2 == -1 ? 1000 : ((temp = cmd.substring(index2 + 5).trim()).indexOf(" ") != -1 ? Integer.parseInt(temp.substring(0, temp.indexOf(" "))) : Integer.parseInt(temp));
                        index2 = cmd.indexOf("winc");
                        winc = index2 == -1 ? 0 : ((temp = cmd.substring(index2 + 4).trim()).indexOf(" ") != -1 ? Integer.parseInt(temp.substring(0, temp.indexOf(" "))) : Integer.parseInt(temp));
                        index2 = cmd.indexOf("binc");
                        if (index2 == -1) {
                            binc = 0;
                        } else {
                            temp = cmd.substring(index2 + 4);
                            binc = (temp = temp.trim()).indexOf(" ") != -1 ? Integer.parseInt(temp.substring(0, temp.indexOf(" "))) : Integer.parseInt(temp);
                        }
                        index2 = cmd.indexOf("movestogo");
                        if (index2 == -1) {
                            togo = 35;
                        } else {
                            temp = cmd.substring(index2 + 9).trim();
                            togo = Integer.parseInt(temp);
                        }
                        if (Board.getTurn() == 1) {
                            movetime = Math.max(0, btime / togo + binc - 200);
                            movetime = (int)((double)movetime * 0.85);
                            maxTimeLimit = (int)(((double)btime + (double)binc) * 0.6);
                            maxMoveTime = Math.min(movetime * 4, maxTimeLimit);
                        } else {
                            movetime = Math.max(0, wtime / togo + winc - 200);
                            movetime = (int)((double)movetime * 0.85);
                            maxTimeLimit = (int)(((double)wtime + (double)winc) * 0.6);
                            maxMoveTime = Math.min(movetime * 4, maxTimeLimit);
                        }
                        if (movetime > maxMoveTime) {
                            maxMoveTime = movetime;
                        }
                    }
                    catch (NumberFormatException ex) {
                        ex.printStackTrace(System.err);
                    }
                }
                String move = theSearch.search(movetime, maxMoveTime, searchDepth, infinite);
                System.out.println("bestmove " + move);
                continue;
            }
            if (!cmd.equals("ucinewgame")) continue;
            Board.newGame();
            Engine.resetHash();
        }
    }

    public static void getCmd() throws IOException {
        cmd = reader.readLine();
        if (cmd.startsWith("quit")) {
            System.exit(0);
        }
        Main.uci();
    }
}

