/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;

public final class HistoryWriter {
    private static String[] boardString;
    private static String[] pieceSt;
    private static Board Magnum;
    private static ArrayList<String> history;

    public HistoryWriter() {
        Magnum = Board.getInstance();
        boardString = new String[64];
        pieceSt = new String[12];
        HistoryWriter.setAlgebraicNotes();
        history = new ArrayList(100);
    }

    public static void acceptMoves(String moves) {
        int from = 0;
        int to = 0;
        int[] piece_in_square = Magnum.getPiecesInSquare();
        moves = HistoryWriter.removeFrontWhiteSpace(moves);
        int type = 0;
        while (moves.length() >= 4) {
            int i;
            String m2;
            String m1;
            String move = moves.indexOf(" ") == -1 ? moves : moves.substring(0, moves.indexOf(" "));
            if (move.length() == 4) {
                int i2;
                move = moves.substring(0, 4);
                m1 = move.substring(0, 2);
                m2 = move.substring(2, 4);
                for (i2 = 0; i2 < 64; ++i2) {
                    if (!boardString[i2].equals(m1)) continue;
                    from = i2;
                }
                for (i2 = 0; i2 < 64; ++i2) {
                    if (!boardString[i2].equals(m2)) continue;
                    to = i2;
                }
                int mv = MoveFunctions.makeMove(to, from);
                Magnum.AddMove(mv);
                Magnum.MakeMove(mv, false);
                Magnum.AddRepetitionRoot();
                if (moves.indexOf(" ") == -1) break;
                moves = moves.substring(moves.indexOf(" "));
                moves = HistoryWriter.removeFrontWhiteSpace(moves);
                continue;
            }
            if (move.length() != 5) continue;
            move = moves.substring(0, 5);
            m1 = move.substring(0, 2);
            m2 = move.substring(2, 4);
            String m3 = move.substring(4, 5);
            for (i = 0; i < 64; ++i) {
                if (!boardString[i].equals(m1)) continue;
                from = i;
            }
            for (i = 0; i < 64; ++i) {
                if (!boardString[i].equals(m2)) continue;
                to = i;
            }
            int piece = piece_in_square[from];
            int cp = piece_in_square[to];
            if (m3.equals("q")) {
                type = 3;
            } else if (m3.equals("n")) {
                type = 5;
            } else if (m3.equals("b")) {
                type = 7;
            } else if (m3.equals("r")) {
                type = 6;
            }
            int mv = MoveFunctions.makeMove(to, from, piece, cp, type);
            Magnum.AddMove(mv);
            Magnum.MakeMove(mv, true);
            Magnum.AddRepetitionRoot();
            if (moves.indexOf(" ") == -1) break;
            moves = moves.substring(moves.indexOf(" "));
            moves = HistoryWriter.removeFrontWhiteSpace(moves);
        }
    }

    public static String getUCIMove(int to, int from, int piece) {
        String st = "";
        st = st.concat(boardString[from]);
        st = st.concat(boardString[to]);
        if (piece % 6 == 5 && (to / 8 == 0 || to / 8 == 7)) {
            st = st.concat("q");
        }
        return st;
    }

    public static String getUCIMove(int move) {
        int to = MoveFunctions.getTo(move);
        int from = MoveFunctions.getFrom(move);
        int piece = MoveFunctions.getPiece(move);
        String st = "";
        st = st.concat(boardString[from]);
        st = st.concat(boardString[to]);
        if (piece % 6 == 5 && (to / 8 == 0 || to / 8 == 7)) {
            int type = MoveFunctions.moveType(move);
            if (type == 3) {
                st = st.concat("q");
            } else if (type == 7) {
                st = st.concat("b");
            } else if (type == 5) {
                st = st.concat("n");
            } else if (type == 6) {
                st = st.concat("r");
            }
        }
        return st;
    }

    public void reset() {
        history.clear();
    }

    public static String getLastMove() {
        return history.get(history.size() - 1);
    }

    public void removeLastHistory() {
        history.remove(history.size() - 1);
    }

    public void historyToFile(File f) {
        try {
            File gameFile = f;
            FileWriter fileWriter = new FileWriter(gameFile);
            BufferedWriter writer = new BufferedWriter(fileWriter);
            writer.write("[Event \"\"]\n[Site \"\"]\n[Date \"\"]\n[Round \"\"]\n[White \"\"]\n[Black \"\"]\n[TimeControl \"\"]\n[Result \"\"]\n");
            for (int i = 0; i < history.size(); ++i) {
                writer.write(history.get(i));
            }
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    public void readHistory(File f) {
        try {
            File gameFile = f;
            FileReader fileReader = new FileReader(gameFile);
            BufferedReader reader = new BufferedReader(fileReader);
            String line = null;
            while ((line = reader.readLine()) != null && line.indexOf("]") != -1 || this.isEmptyLine(line)) {
                this.processLine(line);
            }
            while ((line = reader.readLine()) != null && !this.isEmptyLine(line)) {
                this.processLine(line);
            }
            reader.close();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            System.out.println("File Initialization Failed");
            Magnum.newGame();
        }
    }

    private boolean isEmptyLine(String st) {
        int index = 0;
        for (int i = 0; i < st.length(); ++i) {
            if (st.charAt(i) < '!' || st.charAt(i) > 'z') continue;
            index = i;
        }
        return index == 0;
    }

    private static String removeFrontWhiteSpace(String st) {
        int index = 0;
        for (int i = 0; i < st.length(); ++i) {
            index = i;
            if (st.charAt(i) >= '!' && st.charAt(i) <= 'z') break;
        }
        return st.substring(index);
    }

    private String removeEndWhiteSpace(String st) {
        int index = 0;
        for (int i = 0; i < st.length(); ++i) {
            if (st.charAt(i) < '!' || st.charAt(i) > 'z') continue;
            index = i;
        }
        return st.substring(0, index + 1);
    }

    public String removeChar(String st, char s) {
        int index = -1;
        String temp = "";
        String temp2 = "";
        for (int i = 0; i < st.length(); ++i) {
            if (st.charAt(i) != s) continue;
            index = i;
        }
        if (index > -1) {
            temp = st.substring(0, index);
            temp2 = st.substring(index + 1, st.length());
            temp = temp.concat(temp2);
            return temp;
        }
        return st;
    }

    public void processLine(String st) {
        int start = st.indexOf(".") + 1;
        st = st.substring(start);
        st = HistoryWriter.removeFrontWhiteSpace(st);
        int end = st.indexOf(" ");
        String move1 = st.substring(0, end);
        this.processMove(move1);
        start = st.indexOf(" ") + 1;
        String move2 = st.substring(start);
        move2 = HistoryWriter.removeFrontWhiteSpace(move2);
        if (move2.length() > 0) {
            move2 = this.removeEndWhiteSpace(move2);
            this.processMove(move2);
        }
    }

    public void processMove(String move1) {
        int to = -1;
        int from = -1;
        long bit = 0L;
        move1 = this.removeChar(move1, '+');
        if ((move1 = this.removeChar(move1, '=')).charAt(0) == 'O') {
            if (Magnum.getTurn() == 1) {
                if (move1.lastIndexOf(79) > 3) {
                    int mv = MoveFunctions.makeMove(58, 60);
                    Magnum.AddMove(mv);
                    Magnum.MakeMove(mv, true);
                } else {
                    int mv = MoveFunctions.makeMove(62, 60);
                    Magnum.AddMove(mv);
                    Magnum.MakeMove(mv, true);
                }
            } else if (move1.lastIndexOf(79) > 3) {
                int mv = MoveFunctions.makeMove(2, 4);
                Magnum.AddMove(mv);
                Magnum.MakeMove(mv, true);
            } else {
                int mv = MoveFunctions.makeMove(6, 4);
                Magnum.AddMove(mv);
                Magnum.MakeMove(mv, true);
            }
        } else {
            long pieces = Magnum.getTurn() == -1 ? this.getPieces(move1, false) : this.getPieces(move1, true);
            if (move1.indexOf("Q") == move1.length() - 1) {
                move1 = move1.substring(0, move1.length() - 1);
            }
            String toSt = move1.substring(move1.length() - 2, move1.length());
            for (int i = 0; i < 64; ++i) {
                if (!boardString[i].equals(toSt)) continue;
                to = i;
            }
            int[] piece_in_square = Magnum.getPiecesInSquare();
            if (move1.charAt(0) > '`' && piece_in_square[to] == -1) {
                int file = to % 8;
                pieces &= Global.fileMasks[file];
                if (Magnum.getTurn() == 1) {
                    bit = pieces & -pieces;
                } else {
                    while (pieces != 0L) {
                        bit = pieces & -pieces;
                        pieces ^= bit;
                    }
                }
                from = Magnum.getPos(bit);
                int mv = MoveFunctions.makeMove(to, from);
                Magnum.AddMove(mv);
                Magnum.MakeMove(mv, true);
            } else {
                char pos;
                int count = 0;
                int rank = 0;
                int file = 0;
                for (int i = 0; i < move1.length(); ++i) {
                    pos = move1.charAt(i);
                    if (pos >= 'a' && pos <= 'h') {
                        ++file;
                    }
                    if (pos < '1' || pos > '8') continue;
                    ++rank;
                }
                if (rank > 1) {
                    count = 0;
                    while ((pos = move1.charAt(count)) < '1' || pos > '8') {
                        ++count;
                    }
                    pieces &= Global.rankMasks[pos - 49];
                }
                if (file > 1) {
                    count = 0;
                    while ((pos = move1.charAt(count)) < 'a' || pos > 'h') {
                        ++count;
                    }
                    pieces &= Global.fileMasks[pos - 97];
                }
                long attackers = Magnum.getAttack2(to);
                attackers &= pieces;
                attackers &= -attackers;
                from = Magnum.getPos(attackers);
                int mv = MoveFunctions.makeMove(to, from);
                Magnum.AddMove(mv);
                Magnum.MakeMove(mv, true);
            }
        }
    }

    public long getPieces(String st, boolean side) {
        long temp;
        char p = st.charAt(0);
        switch (p) {
            case 'B': {
                if (side) {
                    temp = HistoryWriter.Magnum.blackbishops;
                    break;
                }
                temp = HistoryWriter.Magnum.whitebishops;
                break;
            }
            case 'K': {
                if (side) {
                    temp = HistoryWriter.Magnum.blackking;
                    break;
                }
                temp = HistoryWriter.Magnum.whiteking;
                break;
            }
            case 'N': {
                if (side) {
                    temp = HistoryWriter.Magnum.blackknights;
                    break;
                }
                temp = HistoryWriter.Magnum.whiteknights;
                break;
            }
            case 'R': {
                if (side) {
                    temp = HistoryWriter.Magnum.blackrooks;
                    break;
                }
                temp = HistoryWriter.Magnum.whiterooks;
                break;
            }
            case 'Q': {
                if (side) {
                    temp = HistoryWriter.Magnum.blackqueen;
                    break;
                }
                temp = HistoryWriter.Magnum.whitequeen;
                break;
            }
            default: {
                temp = side ? HistoryWriter.Magnum.blackpawns : HistoryWriter.Magnum.whitepawns;
            }
        }
        return temp;
    }

    public void addHistory(int to, int from, int c) {
        int count = c;
        String moveSt = "";
        if (Board.piece_in_square[from] == 4 && Math.abs(to - from) == 2) {
            moveSt = to > from ? moveSt.concat("O-O") : moveSt.concat("O-O-O");
        } else if (Board.piece_in_square[from] == 10 && Math.abs(to - from) == 2) {
            moveSt = to > from ? moveSt.concat("O-O") : moveSt.concat("O-O-O");
        } else {
            moveSt = moveSt.concat(pieceSt[Board.piece_in_square[from]]);
            int pType = Board.piece_in_square[from] % 6;
            if (pType == 3 || pType == 1 || pType == 0) {
                int rank = from / 8;
                int file = from % 8;
                long samePieces = this.getSame(Board.piece_in_square[from]);
                long attackers = Magnum.getAttack2(to);
                samePieces &= attackers;
                boolean sameFile = false;
                boolean sameRank = false;
                if ((samePieces ^= 1L << from) != 0L) {
                    while (samePieces != 0L) {
                        long temp = samePieces & -samePieces;
                        int pos = Magnum.getPos(temp);
                        if (pos % 8 == file) {
                            sameFile = true;
                        }
                        if (pos / 8 == rank) {
                            sameRank = true;
                        }
                        samePieces ^= temp;
                    }
                    moveSt = sameFile ? moveSt.concat(boardString[from].substring(1, 2)) : (sameRank ? moveSt.concat(boardString[from].substring(0, 1)) : moveSt.concat(boardString[from].substring(0, 1)));
                }
            }
            if (Board.piece_in_square[to] != -1) {
                if (Board.piece_in_square[from] % 6 == 5) {
                    moveSt = moveSt.concat(boardString[from].substring(0, 1));
                }
                moveSt = moveSt.concat("x");
            }
            moveSt = moveSt.concat(boardString[to]);
            if (Board.piece_in_square[from] % 6 == 5 && (to / 8 == 0 || to / 8 == 7)) {
                moveSt = moveSt.concat("Q");
            }
        }
        moveSt = moveSt.concat(" ");
        if (count % 2 == 1) {
            moveSt = moveSt.concat("\n");
        }
        history.add(moveSt);
    }

    private long getSame(int pType) {
        long pieces;
        switch (pType) {
            case 0: {
                pieces = HistoryWriter.Magnum.whiterooks;
                break;
            }
            case 1: {
                pieces = HistoryWriter.Magnum.whiteknights;
                break;
            }
            case 3: {
                pieces = HistoryWriter.Magnum.whitequeen;
                break;
            }
            case 6: {
                pieces = HistoryWriter.Magnum.blackrooks;
                break;
            }
            case 7: {
                pieces = HistoryWriter.Magnum.blackknights;
                break;
            }
            case 9: {
                pieces = HistoryWriter.Magnum.blackqueen;
                break;
            }
            default: {
                pieces = 0L;
            }
        }
        return pieces;
    }

    public static int getNumericPosition(String st) {
        for (int i = 0; i < 64; ++i) {
            if (!st.equals(boardString[i])) continue;
            return i;
        }
        return -1;
    }

    private static void setAlgebraicNotes() {
        int i;
        block34: for (i = 0; i < 12; ++i) {
            switch (i) {
                case 0: {
                    HistoryWriter.pieceSt[i] = "R";
                    continue block34;
                }
                case 1: {
                    HistoryWriter.pieceSt[i] = "N";
                    continue block34;
                }
                case 2: {
                    HistoryWriter.pieceSt[i] = "B";
                    continue block34;
                }
                case 3: {
                    HistoryWriter.pieceSt[i] = "Q";
                    continue block34;
                }
                case 4: {
                    HistoryWriter.pieceSt[i] = "K";
                    continue block34;
                }
                case 5: {
                    HistoryWriter.pieceSt[i] = "";
                    continue block34;
                }
                case 6: {
                    HistoryWriter.pieceSt[i] = "R";
                    continue block34;
                }
                case 7: {
                    HistoryWriter.pieceSt[i] = "N";
                    continue block34;
                }
                case 8: {
                    HistoryWriter.pieceSt[i] = "B";
                    continue block34;
                }
                case 9: {
                    HistoryWriter.pieceSt[i] = "Q";
                    continue block34;
                }
                case 10: {
                    HistoryWriter.pieceSt[i] = "K";
                    continue block34;
                }
                case 11: {
                    HistoryWriter.pieceSt[i] = "";
                }
            }
        }
        block35: for (i = 0; i < 64; ++i) {
            int rank = i / 8;
            int file = i % 8;
            switch (file) {
                case 0: {
                    HistoryWriter.boardString[i] = "a";
                    break;
                }
                case 1: {
                    HistoryWriter.boardString[i] = "b";
                    break;
                }
                case 2: {
                    HistoryWriter.boardString[i] = "c";
                    break;
                }
                case 3: {
                    HistoryWriter.boardString[i] = "d";
                    break;
                }
                case 4: {
                    HistoryWriter.boardString[i] = "e";
                    break;
                }
                case 5: {
                    HistoryWriter.boardString[i] = "f";
                    break;
                }
                case 6: {
                    HistoryWriter.boardString[i] = "g";
                    break;
                }
                case 7: {
                    HistoryWriter.boardString[i] = "h";
                }
            }
            switch (rank) {
                case 0: {
                    int n = i;
                    boardString[n] = boardString[n] + "1";
                    continue block35;
                }
                case 1: {
                    int n = i;
                    boardString[n] = boardString[n] + "2";
                    continue block35;
                }
                case 2: {
                    int n = i;
                    boardString[n] = boardString[n] + "3";
                    continue block35;
                }
                case 3: {
                    int n = i;
                    boardString[n] = boardString[n] + "4";
                    continue block35;
                }
                case 4: {
                    int n = i;
                    boardString[n] = boardString[n] + "5";
                    continue block35;
                }
                case 5: {
                    int n = i;
                    boardString[n] = boardString[n] + "6";
                    continue block35;
                }
                case 6: {
                    int n = i;
                    boardString[n] = boardString[n] + "7";
                    continue block35;
                }
                case 7: {
                    int n = i;
                    boardString[n] = boardString[n] + "8";
                }
            }
        }
    }
}

