/*
 * Decompiled with CFR 0.152.
 */
public class Evaluation2 {
    private static Board chessBoard;
    private static TransTable PawnTable;
    private static TransTable EvalTable;
    private static final int[] wPassedPawnBonus;
    private static final int[] wPassedPawnBonusEndGame;
    private static final int[] bPassedPawnBonus;
    private static final int[] bPassedPawnBonusEndGame;
    private static final int CONNECTED_PASSED_BONUS = 20;
    private static final int PROTECTED_PASSED_BONUS = 8;
    private static final int ISOLATED_PAWN = 10;
    private static final int WEAK_PAWN = 10;
    private static final int WEAK_OPEN_PAWN = 4;
    private static final int DOUBLED_PAWN = 20;
    private static final int TRIPLE_PAWN = 50;
    private static final int MOBILITY_BONUS = 1;
    private static final int BISHOP_MOBILITY = 4;
    private static final int ROOK_MOBILITY = 1;
    private static final int KNIGHT_MOBILITY = 4;
    private static final int QUEEN_MOBILITY = 1;
    private static final int PAWN_MOBILITY = 2;
    private static final int CENTER_BONUS = 1;
    private static final int BACKRANK_MINOR = 20;
    private static final int TEMPO_BONUS = 30;
    private static final int ROOK_OPEN = 20;
    private static final int ROOK_SEMI = 10;
    private static final int ROOK_DOUBLED = 20;
    private static final int DOUBLED_ROOKS_7TH = 60;
    private static final int ROOK_IN_FRONT_QUEEN = 25;
    private static final int ROOK_BEHIND_QUEEN = 12;
    private static final int ROOK_7TH_RANK = 35;
    private static final int QUEEN_ROOK_7TH_RANK = 100;
    private static final int HUNG_PENALTY = 30;
    private static final int[] kingSafetyEval;
    private static final byte[] TABLE;
    private static final int[] wKingAttackVal;
    private static final int[] bKingAttackVal;
    private static final int KING_PAWN_OPEN_FILE = 5;
    private static final int ENEMY_KING_PAWN_OPEN_FILE = 20;
    private static final int ENEMY_KING_PAWN_SEMI_OPEN = 8;
    private static final int[] whitePawnProtection;
    private static final int[] blackPawnProtection;
    private static long whiteKingZone;
    private static long blackKingZone;
    private static final int[] wKnightVals;
    private static final int[] bKnightVals;
    private static final int[] kingVals;
    private static final int[] wPawnVals;
    private static final int[] bPawnVals;
    private static final int[] wPawnEnemyKingTropism;
    private static final int[] bPawnEnemyKingTropism;
    private static final int[] centreArr;
    private static byte[] WB;
    private static byte[] BB;
    private static final int PAWN_BIT = 8;
    private static final int MINOR_BIT = 16;
    private static final int ROOK_BIT = 32;
    private static final int QUEEN_BIT = 64;
    private static final int KING_BIT = -128;
    private static final int COUNT_MASK = 7;
    private static byte[] wPawnFileVals;
    private static byte[] bPawnFileVals;
    private static int finalScore;
    private static int material;
    private static int pawnScore;
    private static int passScore;
    private static int weakAttackScore;
    private static int hungPenalty;
    private static int centre;
    private static int mobility;
    private static int develop;
    private static int castle;
    private static int trapped;
    private static int wkingSafety;
    private static int bkingSafety;
    private static int endKingSafety;
    private static int tempo;
    private static int bishopEval;
    private static int knightEval;
    private static int queenEval;
    private static int rookEval;
    private static long wWeakPawns;
    private static long bWeakPawns;
    private static int bKingPos;
    private static int wKingPos;
    private static int noWhitePawns;
    private static int noBlackPawns;
    private static double endGameCoefficient;
    private static MoveHelper Helper;

    public Evaluation2() {
        chessBoard = Board.getInstance();
    }

    public static final void clearPawnHash() {
        PawnTable.clearPawnHash();
    }

    public static final void clearEvalHash() {
        EvalTable.clearEvalHash();
    }

    public static final void reSizeEvalHash() {
        EvalTable = new TransTable(Global.EvalHASHSIZE, 2);
    }

    public static final void reSizePawnHash() {
        PawnTable = new TransTable(Global.PawnHASHSIZE, 1);
    }

    public static final int getEval(int side) {
        long passBits;
        int evalKey = (int)(Evaluation2.chessBoard.hashValue % (long)Global.EvalHASHSIZE);
        if (EvalTable.hasEvalHash(evalKey = Math.abs(evalKey), Evaluation2.chessBoard.hashValue)) {
            return EvalTable.getEvalValue(evalKey);
        }
        material = chessBoard.GetRawMaterialScore();
        if (material > 100000) {
            return 0;
        }
        endGameCoefficient = Math.min(1.0, (8000.0 - (double)Evaluation2.chessBoard.totalValue) / 6600.0);
        tempo = 0;
        noWhitePawns = 0;
        noBlackPawns = 0;
        weakAttackScore = 0;
        centre = 0;
        mobility = 0;
        develop = 0;
        castle = 0;
        trapped = 0;
        wkingSafety = 0;
        bkingSafety = 0;
        endKingSafety = 0;
        Evaluation2.setDevelopmentBonus();
        WB = new byte[64];
        BB = new byte[64];
        Evaluation2.setPawnAttack();
        long hash = chessBoard.getPawnHash();
        int key = (int)(hash % (long)Global.PawnHASHSIZE);
        key = Math.abs(key);
        boolean hasHash = PawnTable.hasPawnHash(key, chessBoard.getPawnHash());
        if (hasHash) {
            int wfileBit = PawnTable.getWPawnFile(key);
            int bfileBit = PawnTable.getBPawnFile(key);
            Evaluation2.bitToArrayWhitePawnFile(wfileBit);
            Evaluation2.bitToArrayBlackPawnFile(bfileBit);
            pawnScore = PawnTable.getPawnValue(key);
            passBits = PawnTable.getPawnPassed(key);
        } else {
            int wfileBit = Evaluation2.getWhitePawnFile();
            int bfileBit = Evaluation2.getBlackPawnFile();
            Evaluation2.bitToArrayWhitePawnFile(wfileBit);
            Evaluation2.bitToArrayBlackPawnFile(bfileBit);
            pawnScore = Evaluation2.getWPawnsScore2();
            passBits = Evaluation2.getPassedPawnsBits();
            PawnTable.addPawnHash(key, chessBoard.getPawnHash(), pawnScore += Evaluation2.getBPawnsScore2(), wfileBit, bfileBit, passBits);
        }
        Evaluation2.setWKingEval();
        Evaluation2.setBKingEval();
        Evaluation2.setTrapPenalties();
        knightEval = Evaluation2.getWKnightEval();
        knightEval += Evaluation2.getBKnightEval();
        queenEval = Evaluation2.getWQueenEval();
        queenEval += Evaluation2.getBQueenEval();
        bishopEval = Evaluation2.getWBishopEval();
        bishopEval += Evaluation2.getBBishopEval();
        rookEval = Evaluation2.getWRookEval();
        rookEval += Evaluation2.getBRookEval();
        passScore = Evaluation2.GetWhitePassedPawnScore(passBits);
        passScore += Evaluation2.GetBlackPassedPawnScore(passBits);
        if (side == 1) {
            tempo = 30;
            hungPenalty = Evaluation2.blackHungPieces();
        } else {
            tempo = -30;
            hungPenalty = Evaluation2.whiteHungPieces();
        }
        if (Evaluation2.chessBoard.totalValue > 2500) {
            wkingSafety = Evaluation2.getKingSafetyWhite();
            bkingSafety = Evaluation2.getKingSafetyBlack();
        } else {
            endKingSafety = Evaluation2.getEndGameKing();
        }
        finalScore = side * (material + pawnScore + mobility * 1 + centre * 1 + develop + castle + trapped + wkingSafety + bkingSafety + endKingSafety + tempo + hungPenalty + passScore + bishopEval + knightEval + rookEval + queenEval);
        EvalTable.addEvalHash(evalKey, Evaluation2.chessBoard.hashValue, finalScore);
        return finalScore;
    }

    public static final void printEvalTerms() {
        System.out.println("score is " + finalScore);
        System.out.println("material is " + material);
        System.out.println("pawn score is " + pawnScore);
        System.out.println("weak attack is " + weakAttackScore);
        System.out.println("mobility is " + mobility * 1);
        System.out.println("center is " + centre * 1);
        System.out.println("develop is " + develop);
        System.out.println("castle is " + castle);
        System.out.println("trapped is " + trapped);
        System.out.println("whtie king safety is " + wkingSafety);
        System.out.println("black king safety is " + bkingSafety);
        System.out.println("tempo is " + tempo);
        System.out.println("hung is " + hungPenalty);
        System.out.println("pass score is " + passScore);
        System.out.println("bishop eval is " + bishopEval);
        System.out.println("knight eval is " + knightEval);
        System.out.println("rook eval is " + rookEval);
        System.out.println("queen eval is " + queenEval);
        System.out.println("end game coefficient is " + endGameCoefficient);
        System.out.println("total value is " + Evaluation2.chessBoard.totalValue);
    }

    private static final int GetDistance(int square1, int square2) {
        int rankDist = Math.abs(square1 / 8 - square2 / 8);
        int fileDist = Math.abs(square1 % 8 - square2 % 8);
        return Math.max(rankDist, fileDist);
    }

    private static final boolean CanKingStopWPawn(int pawn, int king, boolean pMoves) {
        if (pawn / 8 == 1) {
            pawn += 8;
        }
        int pdist = 7 - pawn / 8;
        int kdist = Evaluation2.GetDistance(king, pawn % 8 + 56);
        if (!pMoves) {
            --kdist;
        }
        return pdist >= kdist;
    }

    private static final boolean CanKingStopBPawn(int pawn, int king, boolean pMoves) {
        if (pawn / 8 == 6) {
            pawn -= 8;
        }
        int pdist = pawn / 8;
        int kdist = Evaluation2.GetDistance(king, pawn % 8);
        if (!pMoves) {
            --kdist;
        }
        return pdist >= kdist;
    }

    private static final int GetEndPawnRaceScore(int side, long passBits) {
        int moving;
        int position;
        long piece;
        long pawns;
        int enemyKingPos;
        int kingPos;
        if (Evaluation2.chessBoard.totalValue == Global.values[5] * noWhitePawns) {
            kingPos = Long.numberOfTrailingZeros(Evaluation2.chessBoard.whiteking);
            enemyKingPos = Long.numberOfTrailingZeros(Evaluation2.chessBoard.blackking);
            pawns = Evaluation2.chessBoard.whitepawns;
            while (pawns != 0L) {
                int kingRank;
                int enemyKingRank;
                piece = pawns & -pawns;
                pawns ^= piece;
                position = Long.numberOfTrailingZeros(piece);
                if (kingPos / 8 <= position / 8) continue;
                if (position % 8 == 0) {
                    if (kingPos % 8 != 1 || Evaluation2.GetDistance(kingPos, 56) >= Evaluation2.GetDistance(enemyKingPos, 56)) continue;
                    return -500;
                }
                if (position % 8 == 7) {
                    if (kingPos % 8 != 6 || Evaluation2.GetDistance(kingPos, 63) >= Evaluation2.GetDistance(enemyKingPos, 63)) continue;
                    return -500;
                }
                if (Evaluation2.GetDistance(kingPos, position) < Evaluation2.GetDistance(enemyKingPos, position)) {
                    if (kingPos / 8 >= position / 8 + 2) {
                        return -500;
                    }
                    if (kingPos / 8 == 5) {
                        return -500;
                    }
                }
                moving = 0;
                if (side == -1) {
                    moving = 1;
                }
                if (kingPos / 8 != position / 8 + 1 || Evaluation2.GetDistance(kingPos, position) - moving > Evaluation2.GetDistance(enemyKingPos, position)) continue;
                if (side == -1 && (enemyKingPos == position + 16 || enemyKingPos == kingPos + 16)) {
                    return 0;
                }
                if (side == 1 && enemyKingPos / 8 == kingPos / 8 + 2 && ((enemyKingRank = enemyKingPos % 8) == (kingRank = kingPos % 8) + 1 || enemyKingRank == kingRank - 1)) {
                    return 0;
                }
                if (Evaluation2.GetDistance(kingPos, position) == 2 && (enemyKingPos == position + 16 || enemyKingPos == position + 8)) {
                    return 0;
                }
                return -500;
            }
        }
        if (Evaluation2.chessBoard.totalValue == Global.values[5] * noBlackPawns) {
            kingPos = Long.numberOfTrailingZeros(Evaluation2.chessBoard.blackking);
            enemyKingPos = Long.numberOfTrailingZeros(Evaluation2.chessBoard.whiteking);
            pawns = Evaluation2.chessBoard.blackpawns;
            while (pawns != 0L) {
                int kingRank;
                int enemyKingRank;
                piece = pawns & -pawns;
                pawns ^= piece;
                position = Long.numberOfTrailingZeros(piece);
                if (kingPos / 8 >= position / 8) continue;
                if (position % 8 == 0) {
                    if (kingPos % 8 != 1 || Evaluation2.GetDistance(kingPos, 0) >= Evaluation2.GetDistance(enemyKingPos, 0)) continue;
                    return 500;
                }
                if (position % 8 == 7) {
                    if (kingPos % 8 != 6 || Evaluation2.GetDistance(kingPos, 7) >= Evaluation2.GetDistance(enemyKingPos, 7)) continue;
                    return 500;
                }
                if (Evaluation2.GetDistance(kingPos, position) < Evaluation2.GetDistance(enemyKingPos, position)) {
                    if (kingPos / 8 <= position / 8 - 2) {
                        return 500;
                    }
                    if (kingPos / 8 == 2) {
                        return 500;
                    }
                }
                moving = 0;
                if (side == 1) {
                    moving = 1;
                }
                if (kingPos / 8 != position / 8 - 1 || Evaluation2.GetDistance(kingPos, position) - moving > Evaluation2.GetDistance(enemyKingPos, position)) continue;
                if (side == 1 && (enemyKingPos == position - 16 || enemyKingPos == kingPos - 16)) {
                    return 0;
                }
                if (side == -1 && enemyKingPos / 8 == kingPos / 8 - 2 && ((enemyKingRank = enemyKingPos % 8) == (kingRank = kingPos % 8) + 1 || enemyKingRank == kingRank - 1)) {
                    return 0;
                }
                if (Evaluation2.GetDistance(kingPos, position) == 2 && (enemyKingPos == position - 16 || enemyKingPos == position - 8)) {
                    return 0;
                }
                return -500;
            }
        }
        return Evaluation2.GetEndPawnRace(passBits, side);
    }

    private static final int GetEndPawnRace(long passBits, int side) {
        int queen_dist;
        int nextPosition;
        int position;
        long piece;
        boolean pMoves;
        long whitepass = passBits & Evaluation2.chessBoard.whitepawns;
        long blackpass = passBits & Evaluation2.chessBoard.blackpawns;
        int wQueenDist = 8;
        int bQueenDist = 8;
        boolean forcedKingMoveW = false;
        boolean forcedKingMoveB = false;
        if (whitepass != 0L && Evaluation2.chessBoard.blackpieces == (Evaluation2.chessBoard.blackking | Evaluation2.chessBoard.blackpawns)) {
            pMoves = false;
            if (side == -1) {
                pMoves = true;
            }
            while (whitepass != 0L) {
                piece = whitepass & -whitepass;
                whitepass ^= piece;
                position = Long.numberOfTrailingZeros(piece);
                nextPosition = position + 8;
                if (position / 8 == 1) {
                    nextPosition += 8;
                }
                if (side == -1 && Evaluation2.CanKingStopWPawn(position, bKingPos, true) && !Evaluation2.CanKingStopWPawn(nextPosition, bKingPos, true)) {
                    forcedKingMoveB = true;
                    continue;
                }
                if (side == 1 && Evaluation2.CanKingStopWPawn(position, bKingPos, false) && !Evaluation2.CanKingStopWPawn(position, bKingPos, true)) {
                    forcedKingMoveB = true;
                    continue;
                }
                if (Evaluation2.CanKingStopWPawn(position, bKingPos, pMoves)) continue;
                queen_dist = 7 - position / 8;
                if ((Global.plus8[position] & Evaluation2.chessBoard.whiteking) != 0L) {
                    if (position % 8 == 0 || position % 8 == 7) continue;
                    ++queen_dist;
                }
                if (position / 8 == 1) {
                    --queen_dist;
                }
                if (queen_dist >= wQueenDist) continue;
                wQueenDist = queen_dist;
            }
        }
        if (blackpass != 0L && Evaluation2.chessBoard.whitepieces == (Evaluation2.chessBoard.whiteking | Evaluation2.chessBoard.whitepawns)) {
            pMoves = false;
            if (side == 1) {
                pMoves = true;
            }
            while (blackpass != 0L) {
                piece = blackpass & -blackpass;
                blackpass ^= piece;
                position = Long.numberOfTrailingZeros(piece);
                nextPosition = position - 8;
                if (position / 8 == 6) {
                    nextPosition -= 8;
                }
                if (side == 1 && Evaluation2.CanKingStopBPawn(position, wKingPos, true) && !Evaluation2.CanKingStopBPawn(nextPosition, wKingPos, true)) {
                    forcedKingMoveW = true;
                    continue;
                }
                if (side == -1 && Evaluation2.CanKingStopBPawn(position, wKingPos, false) && !Evaluation2.CanKingStopBPawn(position, wKingPos, true)) {
                    forcedKingMoveW = true;
                    continue;
                }
                if (Evaluation2.CanKingStopBPawn(position, wKingPos, pMoves)) continue;
                queen_dist = position / 8;
                if ((Global.minus8[position] & Evaluation2.chessBoard.blackking) != 0L) {
                    if (position % 8 == 0 || position % 8 == 7) continue;
                    ++queen_dist;
                }
                if (position / 8 == 6) {
                    --queen_dist;
                }
                if (queen_dist >= bQueenDist) continue;
                bQueenDist = queen_dist;
            }
        }
        if (forcedKingMoveW && forcedKingMoveB) {
            return 0;
        }
        if (wQueenDist < 8 && bQueenDist == 8) {
            return -500;
        }
        if (bQueenDist < 8 && wQueenDist == 8) {
            return 500;
        }
        if (wQueenDist < bQueenDist && forcedKingMoveW && !forcedKingMoveB) {
            return -500;
        }
        if (bQueenDist < wQueenDist && forcedKingMoveB && !forcedKingMoveW) {
            return 500;
        }
        return 0;
    }

    private static final void setTrapPenalties() {
        if ((Evaluation2.chessBoard.whitebishops & Global.set_Mask[48]) != 0L && (Evaluation2.chessBoard.blackpawns & Global.set_Mask[41]) != 0L && (Evaluation2.chessBoard.blackpawns & Global.set_Mask[50]) != 0L) {
            trapped += 150;
        }
        if ((Evaluation2.chessBoard.whitebishops & Global.set_Mask[55]) != 0L && (Evaluation2.chessBoard.blackpawns & Global.set_Mask[53]) != 0L && (Evaluation2.chessBoard.blackpawns & Global.set_Mask[46]) != 0L) {
            trapped += 150;
        }
        if ((Evaluation2.chessBoard.blackbishops & Global.set_Mask[15]) != 0L && (Evaluation2.chessBoard.whitepawns & Global.set_Mask[13]) != 0L && (Evaluation2.chessBoard.whitepawns & Global.set_Mask[22]) != 0L) {
            trapped -= 150;
        }
        if ((Evaluation2.chessBoard.blackbishops & Global.set_Mask[8]) != 0L && (Evaluation2.chessBoard.whitepawns & Global.set_Mask[10]) != 0L && (Evaluation2.chessBoard.whitepawns & Global.set_Mask[17]) != 0L) {
            trapped -= 150;
        }
        if (Evaluation2.chessBoard.wCastle == 0) {
            if ((Evaluation2.chessBoard.whiterooks & Global.wRookTrap[0]) != 0L && wKingPos < 4 && wKingPos > 0) {
                trapped += 50;
            }
            if ((Evaluation2.chessBoard.whiterooks & Global.wRookTrap[1]) != 0L && wKingPos > 4 && wKingPos < 7) {
                trapped += 50;
            }
        }
        if (Evaluation2.chessBoard.bCastle == 0) {
            if ((Evaluation2.chessBoard.blackrooks & Global.bRookTrap[0]) != 0L && bKingPos < 60 && bKingPos > 56) {
                trapped -= 50;
            }
            if ((Evaluation2.chessBoard.blackrooks & Global.bRookTrap[1]) != 0L && bKingPos > 60 && bKingPos < 63) {
                trapped -= 50;
            }
        }
    }

    private static final void setDevelopmentBonus() {
        if (Evaluation2.chessBoard.wCastle > 1 && Evaluation2.chessBoard.bCastle > 1) {
            if ((Evaluation2.chessBoard.whitequeen & Global.set_Mask[3]) != 0L) {
                develop -= 20;
            }
            if ((Evaluation2.chessBoard.blackqueen & Global.set_Mask[59]) != 0L) {
                develop += 20;
            }
        }
        switch (Evaluation2.chessBoard.wCastle) {
            case 1: {
                castle -= 40;
                break;
            }
            case 2: {
                castle -= 10;
                break;
            }
            case 4: {
                castle -= 10;
                break;
            }
            case 6: {
                castle -= 20;
            }
        }
        switch (Evaluation2.chessBoard.bCastle) {
            case 1: {
                castle += 40;
                break;
            }
            case 2: {
                castle += 10;
                break;
            }
            case 4: {
                castle += 10;
                break;
            }
            case 6: {
                castle += 20;
            }
        }
    }

    private static final void setPawnAttack() {
        long pawns = Evaluation2.chessBoard.whitepawns;
        while (pawns != 0L) {
            ++noWhitePawns;
            long piece = pawns & -pawns;
            pawns ^= piece;
            int position = Long.numberOfTrailingZeros(piece);
            if (position % 8 > 0) {
                int n = position + 7;
                WB[n] = (byte)(WB[n] + 1);
                int n2 = position + 7;
                WB[n2] = (byte)(WB[n2] | 8);
                centre -= centreArr[position + 7];
            }
            if (position % 8 >= 7) continue;
            int n = position + 9;
            WB[n] = (byte)(WB[n] + 1);
            int n3 = position + 9;
            WB[n3] = (byte)(WB[n3] | 8);
            centre -= centreArr[position + 9];
        }
        long forwardMove = Evaluation2.chessBoard.whitepawns << 8;
        forwardMove &= Evaluation2.chessBoard.bitboard ^ 0xFFFFFFFFFFFFFFFFL;
        int count = 0;
        while (forwardMove != 0L) {
            forwardMove &= forwardMove - 1L;
            ++count;
        }
        mobility -= count * 2;
        pawns = Evaluation2.chessBoard.blackpawns;
        while (pawns != 0L) {
            ++noBlackPawns;
            long piece = pawns & -pawns;
            pawns ^= piece;
            int position = Long.numberOfTrailingZeros(piece);
            if (position % 8 > 0) {
                int n = position - 9;
                BB[n] = (byte)(BB[n] + 1);
                int n4 = position - 9;
                BB[n4] = (byte)(BB[n4] | 8);
                centre += centreArr[position - 9];
            }
            if (position % 8 >= 7) continue;
            int n = position - 7;
            BB[n] = (byte)(BB[n] + 1);
            int n5 = position - 7;
            BB[n5] = (byte)(BB[n5] | 8);
            centre += centreArr[position - 7];
        }
        forwardMove = Evaluation2.chessBoard.blackpawns >> 8;
        forwardMove &= Evaluation2.chessBoard.bitboard ^ 0xFFFFFFFFFFFFFFFFL;
        count = 0;
        while (forwardMove != 0L) {
            forwardMove &= forwardMove - 1L;
            ++count;
        }
        mobility += count * 2;
    }

    private static final int getWhitePawnFile() {
        int wPawnFile = 0;
        for (int i = 0; i <= 7; ++i) {
            long temp = Evaluation2.chessBoard.whitepawns & Global.fileMasks[i];
            if (temp != 0L) {
                long temp2 = temp & -temp;
                temp ^= temp2;
                wPawnFile |= Long.numberOfTrailingZeros(temp2) / 8 << 3 * i;
                continue;
            }
            wPawnFile |= 7 << 3 * i;
        }
        return wPawnFile;
    }

    private static final int getBlackPawnFile() {
        int bPawnFile = 0;
        for (int i = 0; i <= 7; ++i) {
            long temp = Evaluation2.chessBoard.blackpawns & Global.fileMasks[i];
            while (temp != 0L) {
                long temp2;
                if ((temp ^= (temp2 = temp & -temp)) != 0L) continue;
                bPawnFile |= Long.numberOfTrailingZeros(temp2) / 8 << 3 * i;
            }
        }
        return bPawnFile;
    }

    private static final void bitToArrayWhitePawnFile(int fileBit) {
        wPawnFileVals = new byte[8];
        for (int i = 0; i <= 7; ++i) {
            Evaluation2.wPawnFileVals[i] = (byte)(fileBit >>> 3 * i & 7);
        }
    }

    private static final void bitToArrayBlackPawnFile(int fileBit) {
        bPawnFileVals = new byte[8];
        for (int i = 0; i <= 7; ++i) {
            Evaluation2.bPawnFileVals[i] = (byte)(fileBit >>> 3 * i & 7);
        }
    }

    private static final int getWPawnsScore2() {
        int isolatedScore = 0;
        int doubledScore = 0;
        int weakScore = 0;
        int positionScore = 0;
        int doubleCount = 0;
        for (int i = 0; i <= 7; ++i) {
            long file = Evaluation2.chessBoard.whitepawns & Global.fileMasks[i];
            boolean isolated = true;
            doubleCount = 0;
            if (i > 0 && wPawnFileVals[i - 1] < 7) {
                isolated = false;
            } else if (i < 7 && wPawnFileVals[i + 1] < 7) {
                isolated = false;
            }
            while (file != 0L) {
                long piece = file & -file;
                file ^= piece;
                int position = Long.numberOfTrailingZeros(piece);
                positionScore -= wPawnVals[position];
                if (doubleCount == 1) {
                    doubledScore += 20;
                } else if (doubleCount > 1) {
                    doubledScore += 50;
                }
                ++doubleCount;
                if (isolated) {
                    isolatedScore += 10;
                }
                if (isolated || WB[position] != 0 || BB[position] != 0) continue;
                boolean tempWeak = true;
                if (Board.piece_in_square[position + 8] != 5 && WB[position + 8] >= BB[position + 8]) {
                    tempWeak = false;
                } else if (tempWeak & position / 8 >= 3) {
                    if (i - 1 >= 0 && Board.piece_in_square[position - 17] == 5 && Board.piece_in_square[position - 9] != 11 && WB[position - 9] >= BB[position - 9]) {
                        tempWeak = false;
                    }
                    if (tempWeak && i + 1 <= 7 && Board.piece_in_square[position - 15] == 5 && Board.piece_in_square[position - 7] != 11 && WB[position - 7] >= BB[position - 7]) {
                        tempWeak = false;
                    }
                }
                if (!tempWeak) continue;
                if (bPawnFileVals[i] == 0) {
                    weakScore += 4;
                }
                weakScore += 10;
            }
        }
        return isolatedScore + weakScore + positionScore + doubledScore;
    }

    private static final int getBPawnsScore2() {
        int isolatedScore = 0;
        int doubledScore = 0;
        int weakScore = 0;
        int positionScore = 0;
        int doubleCount = 0;
        for (int i = 0; i <= 7; ++i) {
            long file = Evaluation2.chessBoard.blackpawns & Global.fileMasks[i];
            boolean isolated = true;
            doubleCount = 0;
            if (i > 0 && bPawnFileVals[i - 1] > 0) {
                isolated = false;
            } else if (i < 7 && bPawnFileVals[i + 1] > 0) {
                isolated = false;
            }
            while (file != 0L) {
                long piece = file & -file;
                file ^= piece;
                int position = Long.numberOfTrailingZeros(piece);
                positionScore += bPawnVals[position];
                if (doubleCount == 1) {
                    doubledScore -= 20;
                } else if (doubleCount > 1) {
                    doubledScore -= 50;
                }
                ++doubleCount;
                if (isolated) {
                    isolatedScore -= 10;
                }
                if (isolated || BB[position] != 0 || WB[position] != 0) continue;
                boolean tempWeak = true;
                if (Board.piece_in_square[position - 8] != 11 && BB[position - 8] >= WB[position - 8]) {
                    tempWeak = false;
                } else if (tempWeak & position / 8 <= 4) {
                    if (i - 1 >= 0 && Board.piece_in_square[position + 15] == 11 && Board.piece_in_square[position + 7] != 5 && BB[position + 7] >= WB[position + 7]) {
                        tempWeak = false;
                    }
                    if (tempWeak && i + 1 <= 7 && Board.piece_in_square[position + 17] == 11 && Board.piece_in_square[position + 9] != 5 && BB[position + 9] >= WB[position + 9]) {
                        tempWeak = false;
                    }
                }
                if (!tempWeak) continue;
                if (wPawnFileVals[i] == 7) {
                    weakScore -= 4;
                }
                weakScore -= 10;
            }
        }
        return isolatedScore + weakScore + positionScore + doubledScore;
    }

    public static final boolean isPassedPawn(int side, int position) {
        if (side == -1) {
            return (Global.whitePassedPawnMasks[position] & Evaluation2.chessBoard.blackpawns) == 0L;
        }
        return (Global.blackPassedPawnMasks[position] & Evaluation2.chessBoard.whitepawns) == 0L;
    }

    private static final long getPassedPawnsBits() {
        int position;
        long pawns;
        long piece;
        long passers = 0L;
        for (pawns = Evaluation2.chessBoard.whitepawns; pawns != 0L; pawns ^= piece) {
            piece = pawns & -pawns;
            position = Long.numberOfTrailingZeros(piece);
            if (!Evaluation2.isPassedPawn(-1, position)) continue;
            passers |= piece;
        }
        for (pawns = Evaluation2.chessBoard.blackpawns; pawns != 0L; pawns ^= piece) {
            piece = pawns & -pawns;
            position = Long.numberOfTrailingZeros(piece);
            if (!Evaluation2.isPassedPawn(1, position)) continue;
            passers |= piece;
        }
        return passers;
    }

    private static final int GetWhitePassedPawnScore(long passers) {
        int currentScore = 0;
        int totalPass = 0;
        long whitePassers = passers &= Evaluation2.chessBoard.whitepawns;
        while (passers != 0L) {
            long piece = passers & -passers;
            passers ^= piece;
            int position = Long.numberOfTrailingZeros(piece);
            long rookAttacks = chessBoard.getMagicRookMoves(position);
            int rank = position / 8;
            int file = position % 8;
            currentScore = (int)((double)(-wPassedPawnBonus[rank]) * (1.0 - endGameCoefficient));
            currentScore -= (int)((double)wPassedPawnBonusEndGame[rank] * endGameCoefficient);
            if (file > 0 && (whitePassers & Global.fileMasks[file - 1]) != 0L) {
                currentScore = (int)((double)currentScore - (10.0 + 20.0 * endGameCoefficient));
            } else if (file > 0 && (Board.piece_in_square[position - 9] == 5 || Board.piece_in_square[position - 1] == 5)) {
                currentScore = (int)((double)currentScore - (5.0 + 8.0 * endGameCoefficient));
            }
            if (file < 7 && (whitePassers & Global.fileMasks[file + 1]) != 0L) {
                currentScore = (int)((double)currentScore - (10.0 + 20.0 * endGameCoefficient));
            } else if (file < 7 && (Board.piece_in_square[position - 7] == 5 || Board.piece_in_square[position + 1] == 5)) {
                currentScore = (int)((double)currentScore - (5.0 + 8.0 * endGameCoefficient));
            }
            if ((rookAttacks & Global.minus8[position] & Evaluation2.chessBoard.whiterooks) != 0L) {
                currentScore = (int)((double)currentScore - (5.0 + (double)currentScore * 0.2 * endGameCoefficient));
            }
            if (Board.piece_in_square[position + 8] >= 0) {
                currentScore = Board.piece_in_square[position + 8] > 5 ? (int)((double)currentScore * 0.6) : (int)((double)currentScore * 0.8);
            }
            if (BB[position + 8] != 0) {
                currentScore = (int)((double)currentScore * 0.85);
            }
            if (WB[position + 8] >= 16) {
                currentScore = (int)((double)currentScore * 1.15);
            }
            if (endGameCoefficient >= 0.99) {
                if ((WB[position] & 0xFFFFFF80) != 0) {
                    currentScore = (int)((double)currentScore * 1.15);
                } else if ((WB[position + 8] & 0xFFFFFF80) != 0) {
                    currentScore = (int)((double)currentScore * 1.15);
                }
            }
            if (Evaluation2.chessBoard.totalValue < 1200) {
                int x = Math.abs(bKingPos % 8 - file);
                int y = Math.abs(bKingPos / 8 - rank);
                if (y > x) {
                    x = y;
                }
                currentScore -= x * wPawnEnemyKingTropism[position];
            }
            if ((Global.plus8[position] & Evaluation2.chessBoard.whitepawns) != 0L) {
                currentScore /= 3;
            }
            totalPass += currentScore;
        }
        return totalPass;
    }

    private static final int GetBlackPassedPawnScore(long passers) {
        int currentScore = 0;
        int totalPass = 0;
        long blackPassers = passers &= Evaluation2.chessBoard.blackpawns;
        while (passers != 0L) {
            long piece = passers & -passers;
            passers ^= piece;
            int position = Long.numberOfTrailingZeros(piece);
            long rookAttacks = chessBoard.getMagicRookMoves(position);
            int rank = position / 8;
            int file = position % 8;
            currentScore = (int)((double)bPassedPawnBonus[rank] * (1.0 - endGameCoefficient));
            currentScore += (int)((double)bPassedPawnBonusEndGame[rank] * endGameCoefficient);
            if (file > 0 && (blackPassers & Global.fileMasks[file - 1]) != 0L) {
                currentScore = (int)((double)currentScore + (10.0 + 20.0 * endGameCoefficient));
            } else if (file > 0 && (Board.piece_in_square[position - 9] == 11 || Board.piece_in_square[position - 1] == 11)) {
                currentScore = (int)((double)currentScore + (5.0 + 8.0 * endGameCoefficient));
            }
            if (file < 7 && (blackPassers & Global.fileMasks[file + 1]) != 0L) {
                currentScore = (int)((double)currentScore + (10.0 + 20.0 * endGameCoefficient));
            } else if (file < 7 && (Board.piece_in_square[position - 7] == 11 || Board.piece_in_square[position + 1] == 11)) {
                currentScore = (int)((double)currentScore + (5.0 + 8.0 * endGameCoefficient));
            }
            if ((rookAttacks & Global.plus8[position] & Evaluation2.chessBoard.blackrooks) != 0L) {
                currentScore = (int)((double)currentScore + (5.0 + (double)currentScore * 0.2 * endGameCoefficient));
            }
            if (Board.piece_in_square[position - 8] >= 0) {
                currentScore = Board.piece_in_square[position + 8] < 6 ? (int)((double)currentScore * 0.6) : (int)((double)currentScore * 0.8);
            }
            if (WB[position + 8] != 0) {
                currentScore = (int)((double)currentScore * 0.85);
            }
            if (BB[position + 8] >= 16) {
                currentScore = (int)((double)currentScore * 1.15);
            }
            if (endGameCoefficient >= 0.99) {
                if ((BB[position] & 0xFFFFFF80) != 0) {
                    currentScore = (int)((double)currentScore * 1.15);
                } else if ((BB[position + 8] & 0xFFFFFF80) != 0) {
                    currentScore = (int)((double)currentScore * 1.15);
                }
            }
            if (Evaluation2.chessBoard.totalValue < 1200) {
                int x = Math.abs(wKingPos % 8 - file);
                int y = Math.abs(wKingPos / 8 - rank);
                if (y > x) {
                    x = y;
                }
                currentScore += x * bPawnEnemyKingTropism[position];
            }
            if ((Global.minus8[position] & Evaluation2.chessBoard.blackpawns) != 0L) {
                currentScore /= 3;
            }
            totalPass += currentScore;
        }
        return totalPass;
    }

    private static final int getWeakAttackScore() {
        int attackers;
        int defenders;
        int position;
        long pawns;
        long pawn;
        int weakAttack = 0;
        for (pawns = wWeakPawns; pawns != 0L; pawns ^= pawn) {
            pawn = pawns & -pawns;
            position = Long.numberOfTrailingZeros(pawn);
            if ((BB[position] & 8) != 0 || BB[position] == 0) continue;
            defenders = WB[position] >> 3;
            attackers = BB[position] >> 3;
            if ((defenders &= -defenders) < (attackers &= -attackers)) continue;
            weakAttack += 5 * (BB[position] & 7);
        }
        for (pawns = bWeakPawns; pawns != 0L; pawns ^= pawn) {
            pawn = pawns & -pawns;
            position = Long.numberOfTrailingZeros(pawn);
            if ((WB[position] & 8) != 0 || WB[position] == 0) continue;
            defenders = BB[position] >> 3;
            attackers = WB[position] >> 3;
            if ((defenders &= -defenders) < (attackers &= -attackers)) continue;
            weakAttack -= 5 * (WB[position] & 7);
        }
        return weakAttack;
    }

    private static int getWKnightEval() {
        long knights = Evaluation2.chessBoard.whiteknights;
        int score = 0;
        while (knights != 0L) {
            int position = Long.numberOfTrailingZeros(knights);
            knights ^= Global.set_Mask[position];
            if (position < 8) {
                develop += 20;
            }
            long attacks = chessBoard.getKnightMoves(position);
            while (attacks != 0L) {
                int pos = Long.numberOfTrailingZeros(attacks);
                attacks ^= Global.set_Mask[pos];
                centre -= centreArr[pos];
                if ((Board.piece_in_square[pos] == -1 || Board.piece_in_square[pos] > 5) && (BB[pos] & 8) == 0) {
                    mobility -= 4;
                }
                int n = pos;
                WB[n] = (byte)(WB[n] + 1);
                int n2 = pos;
                WB[n2] = (byte)(WB[n2] | 0x10);
            }
            score -= wKnightVals[position];
            score += chessBoard.getDistance(position, bKingPos);
        }
        return score;
    }

    private static int getBKnightEval() {
        long knights = Evaluation2.chessBoard.blackknights;
        int score = 0;
        while (knights != 0L) {
            long piece = knights & -knights;
            knights ^= piece;
            int position = Long.numberOfTrailingZeros(piece);
            if (position / 8 == 7) {
                develop -= 20;
            }
            long attacks = chessBoard.getKnightMoves(position);
            while (attacks != 0L) {
                long attack = attacks & -attacks;
                attacks ^= attack;
                int pos = Long.numberOfTrailingZeros(attack);
                centre += centreArr[pos];
                if (Board.piece_in_square[pos] < 6 && (WB[pos] & 8) == 0) {
                    mobility += 4;
                }
                int n = pos;
                BB[n] = (byte)(BB[n] + 1);
                int n2 = pos;
                BB[n2] = (byte)(BB[n2] | 0x10);
            }
            score += bKnightVals[position];
            score -= chessBoard.getDistance(position, wKingPos);
        }
        return score;
    }

    private static int getWQueenEval() {
        long queens = Evaluation2.chessBoard.whitequeen;
        int score = 0;
        while (queens != 0L) {
            long piece = queens & -queens;
            queens ^= piece;
            int position = Long.numberOfTrailingZeros(piece);
            long attacks = chessBoard.getQueenMoves(position);
            while (attacks != 0L) {
                long attack = attacks & -attacks;
                attacks ^= attack;
                int pos = Long.numberOfTrailingZeros(attack);
                centre -= centreArr[pos];
                if (Board.piece_in_square[pos] < 0 || Board.piece_in_square[pos] > 5) {
                    --mobility;
                }
                int n = pos;
                WB[n] = (byte)(WB[n] + 1);
                int n2 = pos;
                WB[n2] = (byte)(WB[n2] | 0x40);
            }
            score += 3 * chessBoard.getDistance(position, bKingPos);
        }
        return score;
    }

    private static int getBQueenEval() {
        long queens = Evaluation2.chessBoard.blackqueen;
        int score = 0;
        while (queens != 0L) {
            long piece = queens & -queens;
            queens ^= piece;
            int position = Long.numberOfTrailingZeros(piece);
            long attacks = chessBoard.getQueenMoves(position);
            while (attacks != 0L) {
                long attack = attacks & -attacks;
                attacks ^= attack;
                int pos = Long.numberOfTrailingZeros(attack);
                centre += centreArr[pos];
                if (Board.piece_in_square[pos] < 6) {
                    ++mobility;
                }
                int n = pos;
                BB[n] = (byte)(BB[n] + 1);
                int n2 = pos;
                BB[n2] = (byte)(BB[n2] | 0x40);
            }
            score -= 3 * chessBoard.getDistance(position, wKingPos);
        }
        return score;
    }

    private static void setWKingEval() {
        long attack;
        long king = Evaluation2.chessBoard.whiteking;
        wKingPos = Long.numberOfTrailingZeros(king);
        int kingFile = wKingPos % 8;
        if (kingFile < 3) {
            kingFile = 0;
        } else if (kingFile > 4) {
            kingFile = 7;
        }
        whiteKingZone = wKingPos / 8 < 6 ? Global.wKingMask[kingFile] << wKingPos / 8 * 8 : 0L;
        for (long attacks = Helper.getKingPosition(wKingPos); attacks != 0L; attacks ^= attack) {
            int pos;
            attack = attacks & -attacks;
            int n = pos = Long.numberOfTrailingZeros(attack);
            WB[n] = (byte)(WB[n] + 1);
            int n2 = pos;
            WB[n2] = (byte)(WB[n2] | 0xFFFFFF80);
        }
    }

    private static void setBKingEval() {
        long attack;
        long king = Evaluation2.chessBoard.blackking;
        bKingPos = Long.numberOfTrailingZeros(king);
        int kingFile = bKingPos % 8;
        if (kingFile < 3) {
            kingFile = 0;
        } else if (kingFile > 4) {
            kingFile = 7;
        }
        blackKingZone = bKingPos / 8 > 1 ? Global.bKingMask[kingFile] >>> (7 - bKingPos / 8) * 8 : 0L;
        for (long attacks = Helper.getKingPosition(bKingPos); attacks != 0L; attacks ^= attack) {
            int pos;
            attack = attacks & -attacks;
            int n = pos = Long.numberOfTrailingZeros(attack);
            BB[n] = (byte)(BB[n] + 1);
            int n2 = pos;
            BB[n2] = (byte)(BB[n2] | 0xFFFFFF80);
        }
    }

    private static int getEndGameKing() {
        int score = 0;
        score -= kingVals[wKingPos];
        return score += kingVals[bKingPos];
    }

    private static int getKingSafetyWhite() {
        int score = 0;
        int attackScore = 0;
        int openFilePenalty = 0;
        int file = wKingPos % 8;
        int rank = wKingPos / 8;
        if (Evaluation2.chessBoard.wCastle <= 1 || Evaluation2.chessBoard.bCastle <= 1) {
            int pawnShieldScore = 0;
            long pawnProtect = whiteKingZone & Evaluation2.chessBoard.whitepawns;
            while (pawnProtect != 0L) {
                long pawn = pawnProtect & -pawnProtect;
                pawnProtect ^= pawn;
                int position = Long.numberOfTrailingZeros(pawn);
                pawnShieldScore += whitePawnProtection[position / 8];
            }
            score -= pawnShieldScore;
            if (Evaluation2.chessBoard.blackqueen != 0L && endGameCoefficient <= 0.7) {
                int counter = 0;
                int mask = 0;
                if (rank < 6) {
                    if (file - 1 >= 0) {
                        mask |= BB[wKingPos + 15];
                    }
                    if (file + 1 <= 7) {
                        mask |= BB[wKingPos + 17];
                    }
                    mask |= BB[wKingPos + 16];
                }
                if (file - 1 >= 0) {
                    if (BB[wKingPos - 1] > 0) {
                        mask |= BB[wKingPos - 1];
                        ++counter;
                        if (WB[wKingPos - 1] == -127) {
                            ++counter;
                        }
                    }
                    if (rank > 0 && BB[wKingPos - 9] > 0) {
                        mask |= BB[wKingPos - 9];
                        ++counter;
                        if (WB[wKingPos - 9] == -127) {
                            ++counter;
                        }
                    }
                }
                if (file + 1 <= 7) {
                    if (BB[wKingPos + 1] > 0) {
                        mask |= BB[wKingPos + 1];
                        ++counter;
                        if (WB[wKingPos + 1] == -127) {
                            ++counter;
                        }
                    }
                    if (rank > 0 && BB[wKingPos - 7] > 0) {
                        mask |= BB[wKingPos - 7];
                        ++counter;
                        if (WB[wKingPos - 7] == -127) {
                            ++counter;
                        }
                    }
                }
                if (rank > 0 && BB[wKingPos - 8] > 0) {
                    mask |= BB[wKingPos - 8];
                    ++counter;
                    if (WB[wKingPos - 8] == -127) {
                        ++counter;
                    }
                }
                if (rank < 7) {
                    if (BB[wKingPos + 8] > 0) {
                        mask |= BB[wKingPos + 8];
                        ++counter;
                        if (WB[wKingPos + 8] == -127) {
                            ++counter;
                        }
                        if (Board.piece_in_square[wKingPos + 8] > 5) {
                            ++counter;
                        }
                    }
                    if (file - 1 >= 0 && BB[wKingPos + 7] > 0) {
                        mask |= BB[wKingPos + 7];
                        ++counter;
                        if (WB[wKingPos + 7] == -127) {
                            ++counter;
                        }
                        if (Board.piece_in_square[wKingPos + 7] > 5) {
                            ++counter;
                        }
                    }
                    if (file + 1 <= 7 && BB[wKingPos + 9] > 0) {
                        mask |= BB[wKingPos + 9];
                        ++counter;
                        if (WB[wKingPos + 9] == -127) {
                            ++counter;
                        }
                        if (Board.piece_in_square[wKingPos + 9] > 5) {
                            ++counter;
                        }
                    }
                }
                mask >>= 3;
                attackScore += kingSafetyEval[(counter += TABLE[mask &= 0x1F]) + wKingAttackVal[wKingPos]];
            }
            if (file == 0) {
                if (wPawnFileVals[0] == 7) {
                    openFilePenalty += 5;
                    if (bPawnFileVals[0] == 0) {
                        openFilePenalty += 20;
                    }
                } else if (bPawnFileVals[0] == 0) {
                    openFilePenalty += 8;
                }
                if (wPawnFileVals[1] == 7) {
                    openFilePenalty += 5;
                    if (bPawnFileVals[1] == 0) {
                        openFilePenalty += 20;
                    }
                } else if (bPawnFileVals[1] == 0) {
                    openFilePenalty += 8;
                }
                if (wPawnFileVals[2] == 7) {
                    openFilePenalty += 5;
                    if (bPawnFileVals[2] == 0) {
                        openFilePenalty += 20;
                    }
                } else if (bPawnFileVals[2] == 0) {
                    openFilePenalty += 8;
                }
            } else if (file == 7) {
                if (wPawnFileVals[5] == 7) {
                    openFilePenalty += 5;
                    if (bPawnFileVals[5] == 0) {
                        openFilePenalty += 20;
                    }
                } else if (bPawnFileVals[5] == 0) {
                    openFilePenalty += 8;
                }
                if (wPawnFileVals[6] == 7) {
                    openFilePenalty += 5;
                    if (bPawnFileVals[6] == 0) {
                        openFilePenalty += 20;
                    }
                } else if (bPawnFileVals[6] == 0) {
                    openFilePenalty += 8;
                }
                if (wPawnFileVals[7] == 7) {
                    openFilePenalty += 5;
                    if (bPawnFileVals[7] == 0) {
                        openFilePenalty += 20;
                    }
                } else if (bPawnFileVals[7] == 0) {
                    openFilePenalty += 8;
                }
            } else {
                if (wPawnFileVals[file] == 7) {
                    openFilePenalty += 5;
                    if (bPawnFileVals[file] == 0) {
                        openFilePenalty += 20;
                    }
                } else if (bPawnFileVals[file] == 0) {
                    openFilePenalty += 8;
                }
                if (wPawnFileVals[file - 1] == 7) {
                    openFilePenalty += 5;
                    if (bPawnFileVals[file - 1] == 0) {
                        openFilePenalty += 20;
                    }
                } else if (bPawnFileVals[file - 1] == 0) {
                    openFilePenalty += 8;
                }
                if (wPawnFileVals[file + 1] == 7) {
                    openFilePenalty += 5;
                    if (bPawnFileVals[file + 1] == 0) {
                        openFilePenalty += 20;
                    }
                } else if (bPawnFileVals[file + 1] == 0) {
                    openFilePenalty += 8;
                }
            }
        }
        return (int)(((double)score + (double)openFilePenalty) * (1.0 - endGameCoefficient)) + attackScore;
    }

    private static int getKingSafetyBlack() {
        int score = 0;
        int attackScore = 0;
        int openFilePenalty = 0;
        int file = bKingPos % 8;
        int rank = bKingPos / 8;
        if (Evaluation2.chessBoard.bCastle <= 1 || Evaluation2.chessBoard.wCastle <= 1) {
            int pawnShieldScore = 0;
            long pawnProtect = blackKingZone & Evaluation2.chessBoard.blackpawns;
            while (pawnProtect != 0L) {
                long pawn = pawnProtect & -pawnProtect;
                pawnProtect ^= pawn;
                int position = Long.numberOfTrailingZeros(pawn);
                pawnShieldScore += blackPawnProtection[position / 8];
            }
            score += pawnShieldScore;
            if (Evaluation2.chessBoard.whitequeen != 0L && endGameCoefficient <= 0.7) {
                byte mask = 0;
                int counter = 0;
                if (rank > 1) {
                    if (file - 1 >= 0) {
                        mask = (byte)(mask | WB[bKingPos - 17]);
                    }
                    if (file + 1 <= 7) {
                        mask = (byte)(mask | WB[bKingPos - 15]);
                    }
                    mask = (byte)(mask | WB[bKingPos - 16]);
                }
                if (file - 1 >= 0) {
                    if (WB[bKingPos - 1] > 0) {
                        mask = (byte)(mask | WB[bKingPos - 1]);
                        ++counter;
                        if (BB[bKingPos - 1] == -127) {
                            ++counter;
                        }
                    }
                    if (rank < 7 && WB[bKingPos + 7] > 0) {
                        mask = (byte)(mask | WB[bKingPos + 7]);
                        ++counter;
                        if (BB[bKingPos + 7] == -127) {
                            ++counter;
                        }
                    }
                }
                if (file + 1 <= 7) {
                    if (WB[bKingPos + 1] > 0) {
                        mask = (byte)(mask | WB[bKingPos + 1]);
                        ++counter;
                        if (BB[bKingPos + 1] == -127) {
                            ++counter;
                        }
                    }
                    if (rank < 7 && WB[bKingPos + 9] > 0) {
                        mask = (byte)(mask | WB[bKingPos + 9]);
                        ++counter;
                        if (BB[bKingPos + 9] == -127) {
                            ++counter;
                        }
                    }
                }
                if (rank < 7 && WB[bKingPos + 8] > 0) {
                    mask = (byte)(mask | WB[bKingPos + 8]);
                    ++counter;
                    if (BB[bKingPos + 8] == -127) {
                        ++counter;
                    }
                }
                if (rank > 0) {
                    if (WB[bKingPos - 8] > 0) {
                        mask = (byte)(mask | WB[bKingPos - 8]);
                        ++counter;
                        if (BB[bKingPos - 8] == -127) {
                            ++counter;
                        }
                        if (Board.piece_in_square[bKingPos - 8] < 6 && Board.piece_in_square[bKingPos - 8] >= 0) {
                            ++counter;
                        }
                    }
                    if (file - 1 >= 0 && WB[bKingPos - 9] > 0) {
                        mask = (byte)(mask | WB[bKingPos - 9]);
                        ++counter;
                        if (BB[bKingPos - 9] == -127) {
                            ++counter;
                        }
                        if (Board.piece_in_square[bKingPos - 9] < 6 && Board.piece_in_square[bKingPos - 9] >= 0) {
                            ++counter;
                        }
                    }
                    if (file + 1 <= 7 && WB[bKingPos - 7] > 0) {
                        mask = (byte)(mask | WB[bKingPos - 7]);
                        ++counter;
                        if (BB[bKingPos - 7] == -127) {
                            ++counter;
                        }
                        if (Board.piece_in_square[bKingPos - 7] < 6 && Board.piece_in_square[bKingPos - 7] >= 0) {
                            ++counter;
                        }
                    }
                }
                mask = (byte)(mask >> 3);
                mask = (byte)(mask & 0x1F);
                attackScore -= kingSafetyEval[(counter += TABLE[mask]) + bKingAttackVal[bKingPos]];
            }
            if (file == 0) {
                if (bPawnFileVals[0] == 0) {
                    openFilePenalty -= 5;
                    if (wPawnFileVals[0] == 7) {
                        openFilePenalty -= 20;
                    }
                } else if (wPawnFileVals[0] == 7) {
                    openFilePenalty -= 8;
                }
                if (bPawnFileVals[1] == 0) {
                    openFilePenalty -= 5;
                    if (wPawnFileVals[1] == 7) {
                        openFilePenalty -= 20;
                    }
                } else if (wPawnFileVals[1] == 7) {
                    openFilePenalty -= 8;
                }
                if (bPawnFileVals[2] == 0) {
                    openFilePenalty -= 5;
                    if (wPawnFileVals[2] == 7) {
                        openFilePenalty -= 20;
                    }
                } else if (wPawnFileVals[2] == 7) {
                    openFilePenalty -= 8;
                }
            } else if (file == 7) {
                if (bPawnFileVals[5] == 0) {
                    openFilePenalty -= 5;
                    if (wPawnFileVals[5] == 7) {
                        openFilePenalty -= 20;
                    }
                } else if (wPawnFileVals[5] == 7) {
                    openFilePenalty -= 8;
                }
                if (bPawnFileVals[6] == 0) {
                    openFilePenalty -= 5;
                    if (wPawnFileVals[6] == 7) {
                        openFilePenalty -= 20;
                    }
                } else if (wPawnFileVals[6] == 7) {
                    openFilePenalty -= 8;
                }
                if (bPawnFileVals[7] == 0) {
                    openFilePenalty -= 5;
                    if (wPawnFileVals[7] == 7) {
                        openFilePenalty -= 20;
                    }
                } else if (wPawnFileVals[7] == 7) {
                    openFilePenalty -= 8;
                }
            } else {
                if (bPawnFileVals[file] == 0) {
                    openFilePenalty -= 5;
                    if (wPawnFileVals[file] == 7) {
                        openFilePenalty -= 20;
                    }
                } else if (wPawnFileVals[file] == 7) {
                    openFilePenalty -= 8;
                }
                if (bPawnFileVals[file - 1] == 0) {
                    openFilePenalty -= 5;
                    if (wPawnFileVals[file - 1] == 7) {
                        openFilePenalty -= 20;
                    }
                } else if (wPawnFileVals[file - 1] == 7) {
                    openFilePenalty -= 8;
                }
                if (bPawnFileVals[file + 1] == 0) {
                    openFilePenalty -= 5;
                    if (wPawnFileVals[file + 1] == 7) {
                        openFilePenalty -= 20;
                    }
                } else if (wPawnFileVals[file + 1] == 7) {
                    openFilePenalty -= 8;
                }
            }
        }
        return (int)(((double)score + (double)openFilePenalty) * (1.0 - endGameCoefficient)) + attackScore;
    }

    private static int getWBishopEval() {
        long bishops = Evaluation2.chessBoard.whitebishops;
        int score = 0;
        while (bishops != 0L) {
            long piece = bishops & -bishops;
            bishops ^= piece;
            int position = Long.numberOfTrailingZeros(piece);
            if (position / 8 == 0) {
                develop += 20;
            }
            long attacks = chessBoard.getMagicBishopMoves(position);
            while (attacks != 0L) {
                long attack = attacks & -attacks;
                attacks ^= attack;
                int pos = Long.numberOfTrailingZeros(attack);
                centre -= centreArr[pos];
                if (Board.piece_in_square[pos] < 0 || Board.piece_in_square[pos] > 5) {
                    mobility -= 4;
                }
                int n = pos;
                WB[n] = (byte)(WB[n] + 1);
                int n2 = pos;
                WB[n2] = (byte)(WB[n2] | 0x10);
            }
            score += chessBoard.getDistance(position, bKingPos);
        }
        return score;
    }

    private static int getBBishopEval() {
        long bishops = Evaluation2.chessBoard.blackbishops;
        int score = 0;
        while (bishops != 0L) {
            long piece = bishops & -bishops;
            bishops ^= piece;
            int position = Long.numberOfTrailingZeros(piece);
            if (position / 8 == 7) {
                develop -= 20;
            }
            long attacks = chessBoard.getMagicBishopMoves(position);
            while (attacks != 0L) {
                long attack = attacks & -attacks;
                attacks ^= attack;
                int pos = Long.numberOfTrailingZeros(attack);
                centre += centreArr[pos];
                if (Board.piece_in_square[pos] < 6) {
                    mobility += 4;
                }
                int n = pos;
                BB[n] = (byte)(BB[n] + 1);
                int n2 = pos;
                BB[n2] = (byte)(BB[n2] | 0x10);
            }
            score -= chessBoard.getDistance(position, wKingPos);
        }
        return score;
    }

    private static int getWRookEval() {
        long rooks = Evaluation2.chessBoard.whiterooks;
        int rookScore = 0;
        int oldFile = -1;
        int oldRank = -1;
        while (rooks != 0L) {
            int nearEnemyKing = 1;
            long piece = rooks & -rooks;
            rooks ^= piece;
            int position = Long.numberOfTrailingZeros(piece);
            int file = position % 8;
            int rank = position / 8;
            if (bKingPos / 8 == 7 && rank == 6) {
                rookScore -= 35;
                if (rank == oldRank) {
                    rookScore -= 60;
                }
                if ((Global.rankMasks[rank] & Evaluation2.chessBoard.whitequeen) != 0L) {
                    rookScore -= 100;
                }
            }
            if (wPawnFileVals[position % 8] == 7) {
                long rookQueen;
                if (Math.abs(position % 8 - bKingPos % 8) < 2) {
                    nearEnemyKing = 2;
                }
                if ((rookQueen = Global.fileMasks[file] & Evaluation2.chessBoard.whitequeen) != 0L) {
                    rookScore = position > Long.numberOfTrailingZeros(rookQueen & -rookQueen) ? (rookScore -= 25) : (rookScore -= 12);
                }
                if (file == oldFile) {
                    rookScore -= 20 * nearEnemyKing;
                }
                rookScore = bPawnFileVals[position % 8] == 0 ? (rookScore -= 20 * nearEnemyKing) : (rookScore -= 10 * nearEnemyKing);
            }
            oldFile = file;
            oldRank = rank;
            long attacks = chessBoard.getMagicRookMoves(position);
            while (attacks != 0L) {
                long attack = attacks & -attacks;
                attacks ^= attack;
                int pos = Long.numberOfTrailingZeros(attack);
                centre -= centreArr[pos];
                if (Board.piece_in_square[pos] < 0 || Board.piece_in_square[pos] > 5) {
                    --mobility;
                }
                int n = pos;
                WB[n] = (byte)(WB[n] + 1);
                int n2 = pos;
                WB[n2] = (byte)(WB[n2] | 0x20);
            }
            rookScore += chessBoard.getDistance(position, bKingPos);
        }
        return rookScore;
    }

    private static int getBRookEval() {
        long rooks = Evaluation2.chessBoard.blackrooks;
        int rookScore = 0;
        int oldFile = -1;
        int oldRank = -1;
        while (rooks != 0L) {
            int nearEnemyKing = 1;
            long piece = rooks & -rooks;
            rooks ^= piece;
            int position = Long.numberOfTrailingZeros(piece);
            int file = position % 8;
            int rank = position / 8;
            if (wKingPos / 8 == 0 && rank == 1) {
                rookScore += 35;
                if (rank == oldRank) {
                    rookScore += 60;
                }
                if ((Global.rankMasks[rank] & Evaluation2.chessBoard.blackqueen) != 0L) {
                    rookScore += 100;
                }
            }
            if (bPawnFileVals[position % 8] == 0) {
                long rookQueen;
                if (Math.abs(position % 8 - wKingPos % 8) < 2) {
                    nearEnemyKing = 2;
                }
                if ((rookQueen = Global.fileMasks[file] & Evaluation2.chessBoard.blackqueen) != 0L) {
                    rookScore = position < Long.numberOfTrailingZeros(rookQueen & -rookQueen) ? (rookScore += 25) : (rookScore += 12);
                }
                if (file == oldFile) {
                    rookScore += 20 * nearEnemyKing;
                }
                rookScore = wPawnFileVals[position % 8] == 7 ? (rookScore += 20 * nearEnemyKing) : (rookScore += 10 * nearEnemyKing);
            }
            oldFile = file;
            oldRank = rank;
            long attacks = chessBoard.getMagicRookMoves(position);
            while (attacks != 0L) {
                long attack = attacks & -attacks;
                attacks ^= attack;
                int pos = Long.numberOfTrailingZeros(attack);
                centre += centreArr[pos];
                if (Board.piece_in_square[pos] < 6) {
                    ++mobility;
                }
                int n = pos;
                BB[n] = (byte)(BB[n] + 1);
                int n2 = pos;
                BB[n2] = (byte)(BB[n2] | 0x20);
            }
            rookScore -= chessBoard.getDistance(position, wKingPos);
        }
        return rookScore;
    }

    private static int whiteHungPieces() {
        long side = Evaluation2.chessBoard.whitepieces & (Evaluation2.chessBoard.whiteking ^ 0xFFFFFFFFFFFFFFFFL);
        int hung = 0;
        int score = 0;
        while (side != 0L) {
            long piece = side & -side;
            side ^= piece;
            int position = Long.numberOfTrailingZeros(piece);
            if (BB[position] > 0 && WB[position] == 0) {
                ++hung;
                continue;
            }
            if (BB[position] <= 0) continue;
            switch (Board.piece_in_square[position]) {
                case 0: {
                    if ((BB[position] & 0x18) == 0) break;
                    ++hung;
                    break;
                }
                case 1: {
                    if ((BB[position] & 8) == 0) break;
                    ++hung;
                    break;
                }
                case 2: {
                    if ((BB[position] & 8) == 0) break;
                    ++hung;
                    break;
                }
                case 3: {
                    if ((BB[position] & 0x38) == 0) break;
                    ++hung;
                }
            }
        }
        if (hung == 2) {
            score = 30;
        } else if (hung > 2) {
            score = 60;
        }
        return score;
    }

    public static int blackHungPieces() {
        long side = Evaluation2.chessBoard.blackpieces & (Evaluation2.chessBoard.blackking ^ 0xFFFFFFFFFFFFFFFFL);
        int hung = 0;
        int score = 0;
        while (side != 0L) {
            long piece = side & -side;
            side ^= piece;
            int position = Long.numberOfTrailingZeros(piece);
            if (WB[position] > 0 && BB[position] == 0) {
                ++hung;
                continue;
            }
            if (WB[position] <= 0) continue;
            switch (Board.piece_in_square[position]) {
                case 6: {
                    if ((WB[position] & 0x18) == 0) break;
                    ++hung;
                    break;
                }
                case 7: {
                    if ((WB[position] & 8) == 0) break;
                    ++hung;
                    break;
                }
                case 8: {
                    if ((WB[position] & 8) == 0) break;
                    ++hung;
                    break;
                }
                case 9: {
                    if ((WB[position] & 0x38) == 0) break;
                    ++hung;
                }
            }
        }
        if (hung == 2) {
            score = -30;
        } else if (hung > 2) {
            score = -60;
        }
        return score;
    }

    static {
        PawnTable = new TransTable(Global.PawnHASHSIZE, 1);
        EvalTable = new TransTable(Global.EvalHASHSIZE, 2);
        wPassedPawnBonus = new int[]{0, 7, 13, 17, 25, 38, 80, 0};
        wPassedPawnBonusEndGame = new int[]{0, 15, 23, 35, 47, 90, 200, 0};
        bPassedPawnBonus = new int[]{0, 80, 38, 25, 17, 13, 7, 0};
        bPassedPawnBonusEndGame = new int[]{0, 200, 90, 47, 35, 23, 15, 0};
        kingSafetyEval = new int[]{0, 2, 3, 6, 12, 18, 25, 37, 50, 75, 100, 125, 150, 175, 200, 225, 250, 275, 300, 325, 350, 375, 400, 425, 450, 475, 500, 525, 550, 575, 600, 600, 600, 600, 600};
        TABLE = new byte[]{0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 2, 2, 2, 3, 3, 3, 0, 0, 0, 0, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3};
        wKingAttackVal = new int[]{2, 0, 0, 0, 0, 0, 0, 2, 2, 1, 1, 1, 1, 1, 1, 2, 4, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
        bKingAttackVal = new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 4, 2, 1, 1, 1, 1, 1, 1, 2, 2, 0, 0, 0, 0, 0, 0, 2};
        whitePawnProtection = new int[]{0, 15, 8, 2, 1, 0, 0, 0};
        blackPawnProtection = new int[]{0, 0, 0, 1, 2, 8, 15, 0};
        wKnightVals = new int[]{-2, -2, -2, -2, -2, -2, -2, -2, -2, 1, 1, 1, 1, 1, 1, -2, -2, 1, 4, 4, 4, 4, 1, -2, -2, 1, 5, 6, 6, 5, 1, -2, -2, 1, 6, 8, 8, 6, 1, -2, -2, 1, 6, 8, 8, 6, 1, -2, -2, 1, 1, 1, 1, 1, 1, -2, -2, -2, -2, -2, -2, -2, -2, -2};
        bKnightVals = new int[]{-2, -2, -2, -2, -2, -2, -2, -2, -2, 1, 1, 1, 1, 1, 1, -2, -2, 1, 6, 8, 8, 6, 1, -2, -2, 1, 6, 8, 8, 6, 1, -2, -2, 1, 5, 6, 6, 5, 1, -2, -2, 1, 4, 4, 4, 4, 1, -2, -2, 1, 1, 1, 1, 1, 1, -2, -2, -2, -2, -2, -2, -2, -2, -2};
        kingVals = new int[]{-2, -2, -2, -2, -2, -2, -2, -2, -2, 1, 1, 1, 1, 1, 1, -2, -2, 1, 4, 4, 4, 4, 1, -2, -2, 1, 4, 8, 8, 4, 1, -2, -2, 1, 4, 8, 8, 4, 1, -2, -2, 1, 4, 4, 4, 4, 1, -2, -2, 1, 1, 1, 1, 1, 1, -2, -2, -2, -2, -2, -2, -2, -2, -2};
        wPawnVals = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -10, -10, 0, 0, 0, 1, 1, 1, 10, 10, 1, 1, 1, 3, 3, 3, 13, 13, 3, 3, 3, 6, 6, 6, 13, 13, 6, 6, 6, 10, 10, 10, 20, 20, 10, 10, 10, 10, 10, 10, 20, 20, 10, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0};
        bPawnVals = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 10, 10, 10, 20, 20, 10, 10, 10, 10, 10, 10, 20, 20, 10, 10, 10, 6, 6, 6, 13, 13, 6, 6, 6, 3, 3, 3, 13, 13, 3, 3, 3, 1, 1, 1, 10, 10, 1, 1, 1, 0, 0, 0, -10, -10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        wPawnEnemyKingTropism = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 5, 5, 5, 5, 5, 5, 5, 5, 8, 8, 8, 8, 8, 8, 8, 8, 15, 15, 15, 15, 15, 15, 15, 15, 30, 30, 30, 30, 30, 30, 30, 30, 0, 0, 0, 0, 0, 0, 0, 0};
        bPawnEnemyKingTropism = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 30, 30, 30, 30, 30, 30, 30, 30, 15, 15, 15, 15, 15, 15, 15, 15, 8, 8, 8, 8, 8, 8, 8, 8, 5, 5, 5, 5, 5, 5, 5, 5, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0};
        centreArr = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 5, 5, 1, 0, 0, 0, 0, 1, 5, 5, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        Helper = MoveHelper.getInstance();
    }
}

