/*
 * Decompiled with CFR 0.152.
 */
public final class Engine {
    private static final boolean PERFT_ENABLED = false;
    private Board chessBoard;
    private static long nodes;
    private static long hashnodes;
    private static long nps;
    private static final int[][] Hist;
    private static final int[][] Hist2;
    private static TransTable HashTable;
    private static final int[] moveOrder;
    private static final int[][] killerMoves;
    private static boolean stop;
    private static long nextTimeCheck;
    private static long startTime;
    private static long endTime;
    private static long searchTime;
    private static long maximumTime;
    private static long maximumRootGetAScoreTime;
    private static final int TIME_STATE_HAVE_1ST_MOVE = 0;
    private static final int TIME_STATE_FAIL_LOW = 1;
    private static final int TIME_STATE_FAIL_HIGH = 2;
    private static final int TIME_STATE_ITERATION_START = 3;
    private static final int SEARCH_HASH = 1;
    private static final int KILLER_MOVES = 4;
    private static final int MATE_KILLER = 2;
    private static final int GOOD_CAPTURES = 3;
    private static final int NON_CAPS = 5;
    private static final int BAD_CAPS = 6;
    private static final int SEARCH_END = 7;
    private static final int TT_PV = 4096;
    private static final int STANDPAT_PV = 8192;
    private static final int ROOTDRAW_PV = 12288;
    private static final int SEARCHDRAW_PV = 16384;
    private static final int MATE_PV = 20480;
    private static final int HASH_EXACT = 1;
    private static final int HASH_ALPHA = 0;
    private static final int HASH_BETA = 2;
    private static final long ALPHA_START = -21000L;
    private static final long BETA_START = 21000L;
    private static final long VALUE_START = -21000L;
    private static int thisDepth;
    private static boolean infiniteTimeControl;
    private int ancient;
    private long perft = 0L;
    private MoveHelper Helper = MoveHelper.getInstance();
    private static final int[][] PV;
    private static final int[] lengthPV;

    public Engine() {
        this.chessBoard = Board.getInstance();
    }

    private void GotoTimeState(int timeState) {
        switch (timeState) {
            case 0: {
                endTime = startTime + searchTime;
                break;
            }
            case 1: {
                long currentTime = System.currentTimeMillis();
                long last60Percent = (long)((double)maximumRootGetAScoreTime * (double)0.6f);
                if (currentTime + last60Percent <= endTime) break;
                searchTime = maximumRootGetAScoreTime + last60Percent * 2L;
                searchTime = Math.min(searchTime, maximumTime);
                endTime = startTime + searchTime;
                maximumRootGetAScoreTime += last60Percent * 4L;
                maximumRootGetAScoreTime = Math.min(maximumRootGetAScoreTime, maximumTime);
                break;
            }
            case 2: {
                endTime = startTime + maximumRootGetAScoreTime;
                break;
            }
            case 3: {
                endTime = startTime + maximumRootGetAScoreTime;
            }
        }
        nextTimeCheck = nodes + Math.max(nps / 100L, (endTime - System.currentTimeMillis()) / 2L * (nps / 1000L));
    }

    public boolean timeLeft() {
        try {
            if (Main.reader.ready() && "stop".equals(Main.reader.readLine())) {
                return false;
            }
        }
        catch (Exception e) {
            System.out.println("Exception Caught and Swallowed !!!");
        }
        long temp = System.currentTimeMillis();
        if (!infiniteTimeControl) {
            if (endTime > temp) {
                nextTimeCheck = nodes + Math.max(nps / 100L, (endTime - temp) / 2L * (nps / 1000L));
                return true;
            }
            return false;
        }
        nextTimeCheck += 1000L;
        return true;
    }

    public static void resetHash() {
        HashTable = new TransTable(Global.HASHSIZE, 0);
    }

    public int GetAllMoves(int side, int[] arrMoves) {
        int numberOfCaputres = this.getCaptures(side, arrMoves);
        int numberOfMoves = this.getMoves(side, arrMoves, numberOfCaputres);
        return numberOfMoves;
    }

    public String search(int time, int maxTime, int searchDepth, boolean inf) {
        int j;
        int i;
        int theSide = this.chessBoard.getTurn();
        int[] moveArr = new int[128];
        boolean isExact = false;
        boolean hasValue = false;
        int bestMove = 0;
        long bestValue = 0L;
        maximumRootGetAScoreTime = maxTime != time ? (long)(maxTime - (int)((double)maxTime * 0.55)) : (long)maxTime;
        maximumRootGetAScoreTime = Math.max((long)time, maximumRootGetAScoreTime);
        maximumTime = maxTime;
        startTime = System.currentTimeMillis();
        endTime = startTime + (long)time;
        searchTime = time;
        stop = false;
        nps = 15L;
        nextTimeCheck = Math.min(1000L, (long)time * nps);
        this.ancient = this.chessBoard.getCount() / 2 % 8;
        infiniteTimeControl = inf;
        if (this.chessBoard.getCount() / 2 % 8 == 7) {
            for (i = 0; i < 64; ++i) {
                for (j = 0; j < 64; ++j) {
                    Engine.Hist[i][j] = 0;
                    Engine.Hist2[i][j] = 0;
                }
            }
        } else {
            for (i = 0; i < 64; ++i) {
                j = 0;
                while (j < 64) {
                    int[] nArray = Hist[i];
                    int n = j;
                    nArray[n] = nArray[n] / 10;
                    int[] nArray2 = Hist2[i];
                    int n2 = j++;
                    nArray2[n2] = nArray2[n2] / 10;
                }
            }
        }
        for (int j2 = 0; j2 < 25; ++j2) {
            Engine.killerMoves[j2][0] = 0;
            Engine.killerMoves[j2][1] = 0;
        }
        theSide = this.chessBoard.getTurn();
        nodes = 0L;
        hashnodes = 0L;
        int numberOfMoves = !this.inCheck(theSide) ? this.GetAllMoves(theSide, moveArr) : this.getCheckEscapes(theSide, moveArr);
        thisDepth = 0;
        int[] compareArray = new int[128];
        for (int i2 = numberOfMoves - 1; i2 >= 0; --i2) {
            int tempMove = moveArr[i2];
            int reps = this.chessBoard.MakeMove(tempMove, true);
            if (this.inCheck(theSide)) {
                for (int j3 = i2; j3 <= numberOfMoves - 1; ++j3) {
                    moveArr[j3] = moveArr[j3 + 1];
                    compareArray[j3] = compareArray[j3 + 1];
                }
                --numberOfMoves;
                this.chessBoard.UnMake(tempMove, true);
                continue;
            }
            if (reps == 3) {
                compareArray[i2] = 1;
            } else if (this.chessBoard.getDraw() == 100) {
                compareArray[i2] = 1;
            } else if (this.isStaleMate(-theSide)) {
                compareArray[i2] = 1;
            } else {
                compareArray[i2] = (int)(-this.Quies(-theSide, 1, -21000L, 21000L));
                int n = i2;
                compareArray[n] = compareArray[n] & 0xFFFFFFFE;
                --thisDepth;
            }
            this.chessBoard.UnMake(tempMove, true);
        }
        Engine.sortMoves(0, numberOfMoves, moveArr, compareArray);
        for (int depth = 2; depth <= searchDepth; ++depth) {
            long mate;
            long elapsedTime;
            this.GotoTimeState(3);
            if (!this.timeLeft()) {
                stop = true;
            }
            if (stop && hasValue) break;
            if (depth > 2) {
                for (int i3 = 0; i3 < 64; ++i3) {
                    int insertDepth = 0;
                    int mv = PV[0][i3];
                    if (mv == 4096) {
                        for (int j4 = i3 - 1; j4 >= 0; --j4) {
                            this.chessBoard.UnMake(PV[0][j4], false);
                        }
                        break;
                    }
                    if (mv == 8192) {
                        for (int j5 = i3 - 1; j5 >= 0; --j5) {
                            this.chessBoard.UnMake(PV[0][j5], false);
                        }
                        break;
                    }
                    if (mv == 12288) {
                        for (int j6 = i3 - 1; j6 >= 0; --j6) {
                            this.chessBoard.UnMake(PV[0][j6], false);
                        }
                        break;
                    }
                    if (mv == 16384) {
                        for (int j7 = i3 - 1; j7 >= 0; --j7) {
                            this.chessBoard.UnMake(PV[0][j7], false);
                        }
                        break;
                    }
                    if (mv == 20480) {
                        for (int j8 = i3 - 1; j8 >= 0; --j8) {
                            this.chessBoard.UnMake(PV[0][j8], false);
                        }
                        break;
                    }
                    int key = (int)(this.chessBoard.hashValue % (long)Global.HASHSIZE);
                    HashTable.addHash(key, this.chessBoard.hashValue, mv, -20000L, insertDepth++, 2, 0, this.ancient);
                    this.chessBoard.MakeMove(mv, false);
                }
            }
            long value = -21000L;
            long alpha = -21000L;
            long beta = 21000L;
            long tempBestMove = Integer.MIN_VALUE;
            isExact = false;
            thisDepth = 0;
            for (int i4 = numberOfMoves - 1; i4 >= 0; --i4) {
                int tempMove = moveArr[i4];
                if ((compareArray[i4] & 1) != 0) {
                    value = 0L;
                    if (!isExact && value < bestValue - 30L && !stop) {
                        this.GotoTimeState(1);
                    }
                } else if (!isExact) {
                    this.chessBoard.MakeMove(tempMove, true);
                    value = -this.Max(-theSide, depth - 1, -beta, -alpha, false, this.inCheck(-theSide), false, false);
                    this.chessBoard.UnMake(tempMove, true);
                    --thisDepth;
                    if (value < bestValue - 30L && value < 10000L && !stop) {
                        this.GotoTimeState(1);
                    }
                } else {
                    this.chessBoard.MakeMove(tempMove, true);
                    value = -this.Max(-theSide, depth - 1, -alpha - 1L, -alpha, false, this.inCheck(-theSide), false, false);
                    --thisDepth;
                    if (value > alpha && !stop) {
                        this.GotoTimeState(2);
                        value = -this.Max(-theSide, depth - 1, -beta, -alpha, false, this.inCheck(-theSide), false, false);
                        --thisDepth;
                    }
                    this.chessBoard.UnMake(tempMove, true);
                }
                if (value > tempBestMove && !stop || !hasValue) {
                    this.GotoTimeState(0);
                    alpha = value;
                    isExact = true;
                    hasValue = true;
                    bestValue = value;
                    tempBestMove = value;
                    bestMove = tempMove;
                    if (value == 0L && (compareArray[i4] & 1) != 0) {
                        Engine.PV[0][0] = tempMove;
                        Engine.PV[0][1] = 12288;
                        compareArray[i4] = 10000 - i4 << 1 | 1;
                        continue;
                    }
                    compareArray[i4] = 10000 - i4 << 1;
                    continue;
                }
                this.GotoTimeState(0);
                compareArray[i4] = value == 0L && (compareArray[i4] & 1) != 0 ? 2000 + i4 << 1 | 1 : 2000 + i4 << 1;
            }
            String pv = HistoryWriter.getUCIMove(bestMove >> 6 & 0x3F, bestMove & 0x3F, bestMove >> 12 & 0xF);
            for (int i5 = 1; i5 < 64; ++i5) {
                pv = pv.concat(" ");
                int mv = PV[0][i5];
                if (mv == 4096) {
                    pv = pv.concat("tt");
                    break;
                }
                if (mv == 8192) {
                    pv = pv.concat("standPat");
                    break;
                }
                if (mv == 12288) {
                    pv = pv.concat("rootDraw");
                    break;
                }
                if (mv == 16384) {
                    pv = pv.concat("searchDraw");
                    break;
                }
                if (mv == 20480) {
                    pv = pv.concat("mate");
                    break;
                }
                pv = pv.concat(HistoryWriter.getUCIMove(PV[0][i5] >> 6 & 0x3F, PV[0][i5] & 0x3F, PV[0][i5] >> 12 & 0xF));
            }
            if (stop && !isExact) {
                --depth;
            }
            nps = (elapsedTime = System.currentTimeMillis() - startTime) == 0L ? 100000L : (long)((int)((double)nodes / ((double)elapsedTime / 1000.0)));
            if (bestValue > 10000L) {
                mate = (20000L - bestValue) / 2L;
                System.out.println("info depth " + depth + " score mate " + mate + " nodes " + nodes + " nps " + nps + " pv " + pv);
            } else if (bestValue < -10000L) {
                mate = (-20000L - bestValue) / 2L;
                System.out.println("info depth " + depth + " score mate " + mate + " nodes " + nodes + " nps " + nps + " pv " + pv);
            } else {
                System.out.println("info depth " + depth + " score cp " + bestValue + " nodes " + nodes + " nps " + nps + " pv " + pv);
            }
            Engine.sortMoves(0, numberOfMoves, moveArr, compareArray);
        }
        this.chessBoard.AddMove(bestMove);
        this.chessBoard.MakeMove(bestMove, false);
        this.chessBoard.AddRepetitionRoot();
        return HistoryWriter.getUCIMove(bestMove);
    }

    private boolean inCheck(int side) {
        if (side == 1) {
            return this.chessBoard.isBlackAttacked(Long.numberOfTrailingZeros(this.chessBoard.blackking));
        }
        return this.chessBoard.isWhiteAttacked(Long.numberOfTrailingZeros(this.chessBoard.whiteking));
    }

    private boolean isStaleMate(int side) {
        if (!this.inCheck(side)) {
            int[] Moves = new int[128];
            int numberOfMoves = this.GetAllMoves(side, Moves);
            for (int i = 0; i < numberOfMoves; ++i) {
                int temp = Moves[i];
                this.chessBoard.MakeMove(temp, false);
                if (!this.inCheck(side)) {
                    this.chessBoard.UnMake(temp, false);
                    return false;
                }
                this.chessBoard.UnMake(temp, false);
            }
            return true;
        }
        return false;
    }

    public int getMoves(int side, int[] Moves, int start) {
        int index = start;
        if (side == -1) {
            int from;
            int to;
            long toBit;
            long moves;
            long pieces = this.chessBoard.whitepawns;
            long doubleMoves = moves << 8 & Global.rankMasks[3] & (this.chessBoard.bitboard ^ 0xFFFFFFFFFFFFFFFFL);
            for (moves = pieces << 8 & (this.chessBoard.bitboard ^ 0xFFFFFFFFFFFFFFFFL) & (Global.rankMasks[7] ^ 0xFFFFFFFFFFFFFFFFL); moves != 0L; moves ^= toBit) {
                toBit = moves & -moves;
                to = Long.numberOfTrailingZeros(toBit);
                from = to - 8;
                Engine.moveOrder[index] = Hist2[from][to];
                Moves[index++] = MoveFunctions.makeMove(to, from, 5, -1, 0);
            }
            while (doubleMoves != 0L) {
                toBit = doubleMoves & -doubleMoves;
                doubleMoves ^= toBit;
                to = Long.numberOfTrailingZeros(toBit);
                from = to - 16;
                Engine.moveOrder[index] = Hist2[from][to];
                Moves[index++] = MoveFunctions.makeMove(to, from, 5, -1, 8);
            }
            from = Long.numberOfTrailingZeros(this.chessBoard.whiteking);
            long toSquares = this.Helper.getKingPosition(from);
            if (this.chessBoard.wCastle > 1) {
                long castle = this.chessBoard.getWKingCastle(from);
                if (this.chessBoard.wCastle == 4) {
                    castle &= Global.set_Mask[2];
                } else if (this.chessBoard.wCastle == 2) {
                    castle &= Global.set_Mask[6];
                }
                toSquares |= castle;
            }
            toSquares &= this.chessBoard.bitboard ^ 0xFFFFFFFFFFFFFFFFL;
            while (toSquares != 0L) {
                toBit = toSquares & -toSquares;
                toSquares ^= toBit;
                to = Long.numberOfTrailingZeros(toBit);
                int type = 0;
                if (from == 4 && to == 2) {
                    type = 4;
                } else if (from == 4 && to == 6) {
                    type = 2;
                }
                Engine.moveOrder[index] = Hist2[from][to];
                Moves[index++] = MoveFunctions.makeMove(to, from, 4, -1, type);
            }
            pieces = this.chessBoard.whitepieces & ((this.chessBoard.whiteking | this.chessBoard.whitepawns) ^ 0xFFFFFFFFFFFFFFFFL);
            while (pieces != 0L) {
                from = Long.numberOfTrailingZeros(pieces);
                pieces ^= Global.set_Mask[from];
                toSquares = this.chessBoard.getAttackBoard(from);
                toSquares &= this.chessBoard.bitboard ^ 0xFFFFFFFFFFFFFFFFL;
                while (toSquares != 0L) {
                    toBit = toSquares & -toSquares;
                    toSquares ^= toBit;
                    to = Long.numberOfTrailingZeros(toBit);
                    Engine.moveOrder[index] = Hist2[from][to];
                    Moves[index++] = MoveFunctions.makeMove(to, from, Board.piece_in_square[from], -1, 0);
                }
            }
        } else {
            long toSquares;
            int from;
            int to;
            long toBit;
            long moves;
            long pieces = this.chessBoard.blackpawns;
            long doubleMoves = moves >> 8 & Global.rankMasks[4] & (this.chessBoard.bitboard ^ 0xFFFFFFFFFFFFFFFFL);
            for (moves = pieces >> 8 & (this.chessBoard.bitboard ^ 0xFFFFFFFFFFFFFFFFL) & (Global.rankMasks[0] ^ 0xFFFFFFFFFFFFFFFFL); moves != 0L; moves ^= toBit) {
                toBit = moves & -moves;
                to = Long.numberOfTrailingZeros(toBit);
                from = to + 8;
                Engine.moveOrder[index] = Hist[from][to];
                Moves[index++] = MoveFunctions.makeMove(to, from, 11, -1, 0);
            }
            while (doubleMoves != 0L) {
                toBit = doubleMoves & -doubleMoves;
                doubleMoves ^= toBit;
                to = Long.numberOfTrailingZeros(toBit);
                from = to + 16;
                Engine.moveOrder[index] = Hist[from][to];
                Moves[index++] = MoveFunctions.makeMove(to, from, 11, -1, 9);
            }
            pieces = this.chessBoard.blackpieces & ((this.chessBoard.blackking | this.chessBoard.blackpawns) ^ 0xFFFFFFFFFFFFFFFFL);
            while (pieces != 0L) {
                from = Long.numberOfTrailingZeros(pieces);
                pieces ^= Global.set_Mask[from];
                toSquares = this.chessBoard.getAttackBoard(from);
                toSquares &= this.chessBoard.bitboard ^ 0xFFFFFFFFFFFFFFFFL;
                while (toSquares != 0L) {
                    toBit = toSquares & -toSquares;
                    toSquares ^= toBit;
                    to = Long.numberOfTrailingZeros(toBit);
                    Engine.moveOrder[index] = Hist[from][to];
                    Moves[index++] = MoveFunctions.makeMove(to, from, Board.piece_in_square[from], -1, 0);
                }
            }
            from = Long.numberOfTrailingZeros(this.chessBoard.blackking);
            toSquares = this.Helper.getKingPosition(from);
            if (this.chessBoard.bCastle > 1) {
                long castle = this.chessBoard.getBKingCastle(from);
                if (this.chessBoard.bCastle == 4) {
                    castle &= Global.set_Mask[58];
                } else if (this.chessBoard.bCastle == 2) {
                    castle &= Global.set_Mask[62];
                }
                toSquares |= castle;
            }
            toSquares &= this.chessBoard.bitboard ^ 0xFFFFFFFFFFFFFFFFL;
            while (toSquares != 0L) {
                toBit = toSquares & -toSquares;
                toSquares ^= toBit;
                to = Long.numberOfTrailingZeros(toBit);
                int type = 0;
                if (from == 60 && to == 58) {
                    type = 4;
                } else if (from == 60 && to == 62) {
                    type = 2;
                }
                Engine.moveOrder[index] = Hist[from][to];
                Moves[index++] = MoveFunctions.makeMove(to, from, 10, -1, type);
            }
        }
        Engine.sortMoves(start, index, Moves);
        return index;
    }

    private static final void sortMoves(int start, int noMoves, int[] Moves) {
        for (int i = start; i < noMoves; ++i) {
            int element = Moves[i];
            int score = moveOrder[i];
            for (int j = i; j > start && moveOrder[j - 1] > score; --j) {
                Moves[j] = Moves[j - 1];
                Engine.moveOrder[j] = moveOrder[j - 1];
            }
            Moves[j] = element;
            Engine.moveOrder[j] = score;
        }
    }

    private static final void sortCaps(int start, int noMoves, int[] Moves) {
        boolean done = false;
        for (int i = start; i < noMoves && !done; ++i) {
            done = true;
            for (int j = noMoves - 1; j > i; --j) {
                if (moveOrder[j] >= moveOrder[j - 1]) continue;
                int temp = Moves[j];
                Moves[j] = Moves[j - 1];
                Moves[j - 1] = temp;
                temp = moveOrder[j];
                Engine.moveOrder[j] = moveOrder[j - 1];
                Engine.moveOrder[j - 1] = temp;
                done = false;
            }
        }
    }

    private static final void sortMoves(int start, int noMoves, int[] Moves, int[] compareArray) {
        boolean done = false;
        for (int i = start; i < noMoves && !done; ++i) {
            done = true;
            for (int j = noMoves - 1; j > i; --j) {
                if (compareArray[j] >= compareArray[j - 1]) continue;
                int temp = Moves[j];
                Moves[j] = Moves[j - 1];
                Moves[j - 1] = temp;
                temp = compareArray[j];
                compareArray[j] = compareArray[j - 1];
                compareArray[j - 1] = temp;
                done = false;
            }
        }
    }

    public int getCaptures(int side, int[] Captures) {
        int index = 0;
        if (side == -1) {
            int cP;
            int type;
            int from;
            int to;
            long toBit;
            int passant = this.chessBoard.getPassantB();
            long pMask = Global.set_Mask[passant];
            long enemies = this.chessBoard.blackpieces;
            long pieces = this.chessBoard.whitepawns;
            long lAttack = pieces << 7 & (enemies | pMask) & (Global.fileMasks[7] ^ 0xFFFFFFFFFFFFFFFFL);
            long rAttack = pieces << 9 & (enemies | pMask) & (Global.fileMasks[0] ^ 0xFFFFFFFFFFFFFFFFL);
            long promo = pieces & Global.rankMasks[6];
            if (promo != 0L) {
                promo <<= 8;
                promo &= this.chessBoard.bitboard ^ 0xFFFFFFFFFFFFFFFFL;
            }
            while (lAttack != 0L) {
                toBit = lAttack & -lAttack;
                lAttack ^= toBit;
                to = Long.numberOfTrailingZeros(toBit);
                from = to - 7;
                type = 0;
                cP = Board.piece_in_square[to];
                if (to == passant) {
                    Engine.moveOrder[index] = Global.values[5] + 4;
                    type = 1;
                } else if (to / 8 == 7) {
                    Engine.moveOrder[index] = Global.values[cP] + 700;
                    type = 3;
                } else {
                    Engine.moveOrder[index] = Global.values[cP] + 4;
                }
                Captures[index++] = MoveFunctions.makeMove(to, from, 5, cP, type);
            }
            while (rAttack != 0L) {
                toBit = rAttack & -rAttack;
                rAttack ^= toBit;
                to = Long.numberOfTrailingZeros(toBit);
                from = to - 9;
                type = 0;
                cP = Board.piece_in_square[to];
                if (to == passant) {
                    Engine.moveOrder[index] = Global.values[5] + 4;
                    type = 1;
                } else if (to / 8 == 7) {
                    Engine.moveOrder[index] = Global.values[cP] + 700;
                    type = 3;
                } else {
                    Engine.moveOrder[index] = Global.values[cP] + 4;
                }
                Captures[index++] = MoveFunctions.makeMove(to, from, 5, cP, type);
            }
            while (promo != 0L) {
                toBit = promo & -promo;
                promo ^= toBit;
                to = Long.numberOfTrailingZeros(toBit);
                from = to - 8;
                Engine.moveOrder[index] = 700;
                Captures[index++] = MoveFunctions.makeMove(to, from, 5, -1, 3);
            }
            pieces = this.chessBoard.whitepieces & (this.chessBoard.whitepawns ^ 0xFFFFFFFFFFFFFFFFL);
            while (pieces != 0L) {
                long fromBit = pieces & -pieces;
                pieces ^= fromBit;
                from = Long.numberOfTrailingZeros(fromBit);
                int fromPiece = Board.piece_in_square[from];
                int fromVal = Global.invValues[fromPiece];
                long toSquares = this.chessBoard.getAttackBoard(from);
                toSquares &= enemies;
                while (toSquares != 0L) {
                    toBit = toSquares & -toSquares;
                    toSquares ^= toBit;
                    to = Long.numberOfTrailingZeros(toBit);
                    cP = Board.piece_in_square[to];
                    Engine.moveOrder[index] = Global.values[cP] + fromVal;
                    Captures[index++] = MoveFunctions.makeMove(to, from, fromPiece, cP, 0);
                }
            }
        } else {
            int type;
            int cP;
            int from;
            int to;
            long toBit;
            int passant = this.chessBoard.getPassantW();
            long pMask = Global.set_Mask[passant];
            long enemies = this.chessBoard.whitepieces;
            long pieces = this.chessBoard.blackpawns;
            long lAttack = pieces >> 9 & (enemies | pMask) & (Global.fileMasks[7] ^ 0xFFFFFFFFFFFFFFFFL);
            long rAttack = pieces >> 7 & (enemies | pMask) & (Global.fileMasks[0] ^ 0xFFFFFFFFFFFFFFFFL);
            long promo = pieces & Global.rankMasks[1];
            if (promo != 0L) {
                promo >>= 8;
                promo &= this.chessBoard.bitboard ^ 0xFFFFFFFFFFFFFFFFL;
            }
            while (lAttack != 0L) {
                toBit = lAttack & -lAttack;
                lAttack ^= toBit;
                to = Long.numberOfTrailingZeros(toBit);
                from = to + 9;
                cP = Board.piece_in_square[to];
                type = 0;
                if (to == passant) {
                    Engine.moveOrder[index] = Global.values[5] + 4;
                    type = 1;
                } else if (to / 8 == 0) {
                    Engine.moveOrder[index] = Global.values[cP] + 700;
                    type = 3;
                } else {
                    Engine.moveOrder[index] = Global.values[cP] + 4;
                }
                Captures[index++] = MoveFunctions.makeMove(to, from, 11, cP, type);
            }
            while (rAttack != 0L) {
                toBit = rAttack & -rAttack;
                rAttack ^= toBit;
                to = Long.numberOfTrailingZeros(toBit);
                from = to + 7;
                cP = Board.piece_in_square[to];
                type = 0;
                if (to == passant) {
                    type = 1;
                    Engine.moveOrder[index] = Global.values[5] + 4;
                } else if (to / 8 == 0) {
                    Engine.moveOrder[index] = Global.values[cP] + 700;
                    type = 3;
                } else {
                    Engine.moveOrder[index] = Global.values[cP] + 4;
                }
                Captures[index++] = MoveFunctions.makeMove(to, from, 11, cP, type);
            }
            while (promo != 0L) {
                toBit = promo & -promo;
                promo ^= toBit;
                to = Long.numberOfTrailingZeros(toBit);
                from = to + 8;
                Engine.moveOrder[index] = 700;
                Captures[index++] = MoveFunctions.makeMove(to, from, 11, -1, 3);
            }
            pieces = this.chessBoard.blackpieces & (this.chessBoard.blackpawns ^ 0xFFFFFFFFFFFFFFFFL);
            while (pieces != 0L) {
                long fromBit = pieces & -pieces;
                pieces ^= fromBit;
                from = Long.numberOfTrailingZeros(fromBit);
                int fromPiece = Board.piece_in_square[from];
                int fromVal = Global.invValues[fromPiece];
                long toSquares = this.chessBoard.getAttackBoard(from);
                toSquares &= enemies;
                while (toSquares != 0L) {
                    toBit = toSquares & -toSquares;
                    toSquares ^= toBit;
                    to = Long.numberOfTrailingZeros(toBit);
                    cP = Board.piece_in_square[to];
                    Engine.moveOrder[index] = Global.values[cP] + fromVal;
                    Captures[index++] = MoveFunctions.makeMove(to, from, fromPiece, cP, 0);
                }
            }
        }
        Engine.sortCaps(0, index, Captures);
        return index;
    }

    private int getCheckEscapes(int side, int[] escapes) {
        int value;
        int from;
        long fromBit;
        long knights;
        long rooks;
        long queen;
        long bishops;
        long king;
        long friends;
        int attacks = 0;
        int attackFrom = -1;
        int index = 0;
        if (side == -1) {
            friends = this.chessBoard.whitepieces;
            king = this.chessBoard.whiteking;
            bishops = this.chessBoard.blackbishops;
            queen = this.chessBoard.blackqueen;
            rooks = this.chessBoard.blackrooks;
            knights = this.chessBoard.blackknights;
        } else {
            friends = this.chessBoard.blackpieces;
            king = this.chessBoard.blackking;
            bishops = this.chessBoard.whitebishops;
            queen = this.chessBoard.whitequeen;
            rooks = this.chessBoard.whiterooks;
            knights = this.chessBoard.whiteknights;
        }
        int kingPos = Long.numberOfTrailingZeros(king);
        long toSquares = this.chessBoard.getAttackBoard(kingPos) & (friends ^ 0xFFFFFFFFFFFFFFFFL);
        long temp = this.chessBoard.getMagicBishopMoves(kingPos);
        temp &= bishops | queen;
        while (temp != 0L) {
            fromBit = temp & -temp;
            attackFrom = Long.numberOfTrailingZeros(fromBit);
            toSquares = Global.Diag1Groups[kingPos] == Global.Diag1Groups[attackFrom] ? (toSquares &= Global.diag1Masks[Global.Diag1Groups[kingPos]] ^ 0xFFFFFFFFFFFFFFFFL ^ Global.set_Mask[attackFrom]) : (toSquares &= Global.diag2Masks[Global.Diag2Groups[kingPos]] ^ 0xFFFFFFFFFFFFFFFFL ^ Global.set_Mask[attackFrom]);
            temp ^= fromBit;
            ++attacks;
        }
        temp = this.chessBoard.getMagicRookMoves(kingPos);
        temp &= rooks | queen;
        while (temp != 0L) {
            fromBit = temp & -temp;
            attackFrom = Long.numberOfTrailingZeros(fromBit);
            toSquares = attackFrom / 8 == kingPos / 8 ? (toSquares &= Global.rankMasks[kingPos / 8] ^ 0xFFFFFFFFFFFFFFFFL ^ Global.set_Mask[attackFrom]) : (toSquares &= Global.fileMasks[kingPos % 8] ^ 0xFFFFFFFFFFFFFFFFL ^ Global.set_Mask[attackFrom]);
            temp ^= fromBit;
            ++attacks;
        }
        while (toSquares != 0L) {
            long bit = toSquares & -toSquares;
            toSquares ^= bit;
            int to = Long.numberOfTrailingZeros(bit);
            if (side == -1 ? this.chessBoard.isWhiteAttacked(to) : this.chessBoard.isBlackAttacked(to)) continue;
            int cP = Board.piece_in_square[to];
            int value2 = 10;
            value2 = cP != -1 ? ((value2 = SEE.getSEE(side, to, kingPos, -1)) >= 0 ? (value2 += 10000) : 0) : (side == -1 ? Hist2[kingPos][to] : Hist[kingPos][to]);
            Engine.moveOrder[index] = value2;
            escapes[index++] = MoveFunctions.makeMove(to, kingPos, Board.piece_in_square[kingPos], cP, 0);
        }
        if (attacks == 2) {
            Engine.sortCaps(0, index, escapes);
            return index;
        }
        temp = this.chessBoard.getKnightMoves(kingPos);
        temp &= knights;
        while (temp != 0L) {
            fromBit = temp & -temp;
            attackFrom = Long.numberOfTrailingZeros(fromBit);
            temp ^= fromBit;
            ++attacks;
        }
        if (side == -1) {
            temp = this.chessBoard.getWPawnAttack(kingPos);
            temp &= this.chessBoard.blackpawns;
            while (temp != 0L) {
                fromBit = temp & -temp;
                attackFrom = Long.numberOfTrailingZeros(fromBit);
                temp ^= fromBit;
                ++attacks;
            }
        } else {
            temp = this.chessBoard.getBPawnAttack(kingPos);
            temp &= this.chessBoard.whitepawns;
            while (temp != 0L) {
                fromBit = temp & -temp;
                attackFrom = Long.numberOfTrailingZeros(fromBit);
                temp ^= fromBit;
                ++attacks;
            }
        }
        if (attacks == 2) {
            Engine.sortCaps(0, index, escapes);
            return index;
        }
        temp = this.chessBoard.getAttack2(attackFrom);
        temp &= friends & (king ^ 0xFFFFFFFFFFFFFFFFL);
        int cP = Board.piece_in_square[attackFrom];
        while (temp != 0L) {
            int type = 0;
            fromBit = temp & -temp;
            temp ^= fromBit;
            from = Long.numberOfTrailingZeros(fromBit);
            if (SEE.isPinned(side, attackFrom, from)) continue;
            value = SEE.getSEE(side, attackFrom, from, -1);
            value = value >= 0 ? (value += 10000) : 0;
            if (Board.piece_in_square[from] % 6 == 5 && (attackFrom / 8 == 0 || attackFrom / 8 == 7)) {
                type = 3;
            }
            Engine.moveOrder[index] = value;
            escapes[index++] = MoveFunctions.makeMove(attackFrom, from, Board.piece_in_square[from], cP, type);
        }
        if (Board.piece_in_square[attackFrom] == 5 && attackFrom - 8 == this.chessBoard.getPassantW()) {
            temp = this.chessBoard.getWPawnAttack(attackFrom - 8) & this.chessBoard.blackpawns;
            while (temp != 0L) {
                fromBit = temp & -temp;
                temp ^= fromBit;
                from = Long.numberOfTrailingZeros(fromBit);
                if (SEE.isPinned(side, attackFrom - 8, from)) continue;
                value = SEE.getSEE(side, attackFrom - 8, from, this.chessBoard.getPassantW());
                value = value >= 0 ? (value += 10000) : 0;
                Engine.moveOrder[index] = value;
                escapes[index++] = MoveFunctions.makeMove(attackFrom - 8, from, Board.piece_in_square[from], -1, 1);
            }
        }
        if (Board.piece_in_square[attackFrom] == 11 && attackFrom + 8 == this.chessBoard.getPassantB()) {
            temp = this.chessBoard.getBPawnAttack(attackFrom + 8) & this.chessBoard.whitepawns;
            while (temp != 0L) {
                fromBit = temp & -temp;
                temp ^= fromBit;
                from = Long.numberOfTrailingZeros(fromBit);
                if (SEE.isPinned(side, attackFrom + 8, from)) continue;
                value = SEE.getSEE(side, attackFrom + 8, from, this.chessBoard.getPassantB());
                value = value >= 0 ? (value += 10000) : 0;
                Engine.moveOrder[index] = value;
                escapes[index++] = MoveFunctions.makeMove(attackFrom + 8, from, Board.piece_in_square[from], -1, 1);
            }
        }
        if (!Global.slides[Board.piece_in_square[attackFrom]]) {
            return index;
        }
        long squares = 0L;
        int difference = kingPos - attackFrom;
        int rankDiff = kingPos / 8 - attackFrom / 8;
        if (difference < 0) {
            rankDiff *= -1;
        }
        int relation = -1;
        relation = rankDiff != 0 ? difference / rankDiff : (kingPos < attackFrom ? -99 : 99);
        switch (relation) {
            case -9: {
                squares = Global.plus9[kingPos] ^ Global.plus9[attackFrom - 9];
                break;
            }
            case 9: {
                squares = Global.plus9[attackFrom] ^ Global.plus9[kingPos - 9];
                break;
            }
            case -7: {
                squares = Global.plus7[kingPos] ^ Global.plus7[attackFrom - 7];
                break;
            }
            case 7: {
                squares = Global.plus7[attackFrom] ^ Global.plus7[kingPos - 7];
                break;
            }
            case -8: {
                squares = Global.plus8[kingPos] ^ Global.plus8[attackFrom - 8];
                break;
            }
            case 8: {
                squares = Global.plus8[attackFrom] ^ Global.plus8[kingPos - 8];
                break;
            }
            case -99: {
                squares = Global.plus1[kingPos] ^ Global.plus1[attackFrom - 1];
                break;
            }
            case 99: {
                squares = Global.plus1[attackFrom] ^ Global.plus1[kingPos - 1];
            }
        }
        while (squares != 0L) {
            long toBit = squares & -squares;
            squares ^= toBit;
            int to = Long.numberOfTrailingZeros(toBit);
            long attackers = this.chessBoard.getMovesTo(to);
            attackers &= friends & (king ^ 0xFFFFFFFFFFFFFFFFL);
            while (attackers != 0L) {
                int type = 0;
                fromBit = attackers & -attackers;
                attackers ^= fromBit;
                int from2 = Long.numberOfTrailingZeros(fromBit);
                if (SEE.isPinned(side, to, from2)) continue;
                value = side == -1 ? Hist2[from2][to] : Hist[from2][to];
                if (Board.piece_in_square[from2] == 5) {
                    if (to > 55) {
                        type = 3;
                    } else if (to - from2 == 16) {
                        type = 8;
                    }
                } else if (Board.piece_in_square[from2] == 11) {
                    if (to < 8) {
                        type = 3;
                    } else if (from2 - to == 16) {
                        type = 9;
                    }
                }
                Engine.moveOrder[index] = value;
                escapes[index++] = MoveFunctions.makeMove(to, from2, Board.piece_in_square[from2], -1, type);
            }
        }
        Engine.sortMoves(0, index, escapes);
        return index;
    }

    private boolean verifyKiller(int side, int move) {
        if (move == 0) {
            return false;
        }
        int piece = MoveFunctions.getPiece(move);
        if (side == -1 && piece > 5) {
            return false;
        }
        if (side == 1 && piece < 6) {
            return false;
        }
        int from = MoveFunctions.getFrom(move);
        if (Board.piece_in_square[from] != piece) {
            return false;
        }
        long temp = piece == 5 ? this.chessBoard.getWPawnMoves(from) : (piece == 11 ? this.chessBoard.getBPawnMoves(from) : this.chessBoard.getAttackBoard(from));
        int to = MoveFunctions.getTo(move);
        return ((temp &= this.chessBoard.bitboard ^ 0xFFFFFFFFFFFFFFFFL) & Global.set_Mask[to]) != 0L;
    }

    private void SavePV(int type) {
        Engine.PV[Engine.thisDepth - 1][Engine.thisDepth - 1] = Board.getInstance().GetMoveAtDepth(thisDepth - 1);
        Engine.PV[Engine.thisDepth - 1][Engine.thisDepth] = type;
        Engine.lengthPV[Engine.thisDepth - 1] = thisDepth;
    }

    private long Max(int side, int depth, long alpha, long beta, boolean nMove, boolean isInCheck, boolean wasExtended, boolean iid) {
        long value;
        ++thisDepth;
        if (++nodes >= nextTimeCheck && !this.timeLeft()) {
            stop = true;
        }
        if (stop) {
            return 0L;
        }
        int key = (int)(this.chessBoard.hashValue % (long)Global.HASHSIZE);
        int scoreThreshold = this.chessBoard.GetMaterialScore(side);
        boolean razored = false;
        if (!wasExtended && !isInCheck && depth == 3 && (long)(scoreThreshold + 900) <= alpha && this.chessBoard.getNumberOfPieces(-side) > 3) {
            razored = true;
            --depth;
        }
        int nullFail = 0;
        int hashCount = 0;
        int[] hashArr = new int[8];
        int theMove = 0;
        int index = HashTable.hasHash(key, this.chessBoard.hashValue);
        if (index != 1) {
            HashTable.setNew(key, index, this.ancient);
            switch (HashTable.getType(key, index)) {
                case 0: {
                    long hVal;
                    if (iid || HashTable.getDepth(key, index) < depth || (hVal = HashTable.getValue(key, index)) > alpha) break;
                    ++nodes;
                    return hVal;
                }
                case 1: {
                    long hVal;
                    if (iid || HashTable.getDepth(key, index) < depth || (hVal = HashTable.getValue(key, index)) <= alpha || hVal >= beta) break;
                    this.SavePV(4096);
                    ++nodes;
                    ++hashnodes;
                    return HashTable.getValue(key, index);
                }
                case 2: {
                    long hVal;
                    if (iid || HashTable.getDepth(key, index) < depth || (hVal = HashTable.getValue(key, index)) < beta) break;
                    ++nodes;
                    return hVal;
                }
                case 4: {
                    long hVal = HashTable.getValue(key, index);
                    if (hVal == -20000L) {
                        // empty if block
                    }
                    if ((hVal += (long)thisDepth) > alpha && hVal < beta) {
                        this.SavePV(4096);
                    }
                    return hVal;
                }
            }
            nullFail = HashTable.getNullFail(key, index);
        }
        boolean bFutilityPrune = false;
        int futilityMargin = 0;
        if (!wasExtended && !isInCheck && depth == 2 && (long)(scoreThreshold += 500) <= alpha) {
            bFutilityPrune = true;
            futilityMargin = 500;
        }
        if (!wasExtended && !isInCheck && depth == 1 && (long)(scoreThreshold -= 300) <= alpha) {
            bFutilityPrune = true;
            futilityMargin = 200;
        }
        if (!(razored || bFutilityPrune || isInCheck || nMove || nullFail == 1 || this.chessBoard.pawnsKings == this.chessBoard.bitboard || this.chessBoard.getMinNumberOfPieces() <= 1)) {
            this.chessBoard.switchTurn();
            int reduce = 2;
            if (depth > 6 && this.chessBoard.getMaxNumberOfPieces() > 3) {
                reduce = 3;
            }
            value = depth - reduce - 1 > 0 ? -this.Max(-side, depth - reduce - 1, -beta, -beta + 1L, true, false, false, false) : -this.Quies(-side, 0, -beta, -beta + 1L);
            --thisDepth;
            this.chessBoard.switchTurn();
            if (value >= beta) {
                if (!stop) {
                    HashTable.addHash(key, this.chessBoard.hashValue, 0, value, depth, 2, 0, this.ancient);
                }
                return value;
            }
            if (value <= -19000L) {
                nullFail = 1;
            }
        }
        int numberOfSkippedNodesFP = 0;
        long oldAlpha = alpha;
        boolean oneLegal = false;
        long bMove = -21000L;
        int hType = 0;
        int endIndex = 0;
        int capIndex = 0;
        int extendAmount = 0;
        int bestFullMove = 0;
        int[] moveArr = new int[128];
        int badCapIndex = 0;
        int moveCount = 0;
        boolean drawPV = false;
        int passant = side == -1 ? this.chessBoard.getPassantB() : this.chessBoard.getPassantW();
        for (int state = 1; state != 7; ++state) {
            int i;
            switch (state) {
                case 1: {
                    index = HashTable.hasHash(key, this.chessBoard.hashValue);
                    if (index != 1) {
                        bestFullMove = theMove = HashTable.getMove(key, index);
                        if (theMove != 0) {
                            hashArr[hashCount++] = theMove;
                        }
                        if (index == 0 && (index = HashTable.hasSecondHash(key, this.chessBoard.hashValue)) != 1 && (theMove = HashTable.getMove(key, index)) != 0) {
                            hashArr[hashCount++] = theMove;
                            if (hashCount == 2 && hashArr[0] == hashArr[1]) {
                                --hashCount;
                            }
                        }
                    }
                    if (hashCount == 0 && beta - alpha > 1L && depth > 3 && !isInCheck) {
                        --thisDepth;
                        this.Max(side, depth - 2, alpha, beta, true, false, false, true);
                        index = HashTable.hasHash(key, this.chessBoard.hashValue);
                        if (index != 1) {
                            hashArr[0] = HashTable.getMove(key, index);
                            if (hashArr[0] != 0) {
                                bestFullMove = hashArr[0];
                                ++hashCount;
                            }
                        }
                        if (hashCount == 0 && index == 0 && (index = HashTable.hasSecondHash(key, this.chessBoard.hashValue)) != 1) {
                            hashArr[0] = HashTable.getMove(key, index);
                            if (hashArr[0] != 0) {
                                bestFullMove = hashArr[0];
                                ++hashCount;
                            }
                        }
                    }
                    nMove = false;
                    System.arraycopy(hashArr, 0, moveArr, 0, hashCount);
                    index = hashCount;
                    break;
                }
                case 2: {
                    if (isInCheck) {
                        state = 6;
                        index = this.getCheckEscapes(side, moveArr);
                        break;
                    }
                    index = 0;
                    if (MoveFunctions.getValue(killerMoves[thisDepth][1]) >= 200 && this.verifyKiller(side, killerMoves[thisDepth][1])) {
                        moveArr[index++] = killerMoves[thisDepth][1] & 0xFFFFFF;
                        hashArr[hashCount++] = moveArr[index];
                        for (i = 0; i < hashCount - 1; ++i) {
                            if (moveArr[index] != hashArr[i]) continue;
                            --index;
                            --hashCount;
                        }
                    }
                    if (MoveFunctions.getValue(killerMoves[thisDepth][0]) < 200 || !this.verifyKiller(side, killerMoves[thisDepth][0])) break;
                    moveArr[index++] = killerMoves[thisDepth][0] & 0xFFFFFF;
                    hashArr[hashCount++] = moveArr[index];
                    for (i = 0; i < hashCount - 1; ++i) {
                        if (moveArr[index] != hashArr[i]) continue;
                        --index;
                        --hashCount;
                    }
                    break;
                }
                case 3: {
                    capIndex = index = this.getCaptures(side, moveArr);
                    badCapIndex = index - 1;
                    break;
                }
                case 4: {
                    index = 0;
                    if (this.verifyKiller(side, killerMoves[thisDepth][1])) {
                        moveArr[127] = killerMoves[thisDepth][1] & 0xFFFFFF;
                        hashArr[hashCount++] = moveArr[127];
                        ++index;
                        for (i = 0; i < hashCount - 1; ++i) {
                            if (moveArr[127] != hashArr[i]) continue;
                            --index;
                            --hashCount;
                        }
                    }
                    if (this.verifyKiller(side, killerMoves[thisDepth][0])) {
                        int position = 127 - index;
                        moveArr[position] = killerMoves[thisDepth][0] & 0xFFFFFF;
                        hashArr[hashCount++] = moveArr[position];
                        ++index;
                        for (int i2 = 0; i2 < hashCount - 1; ++i2) {
                            if (moveArr[position] != hashArr[i2]) continue;
                            --index;
                            --hashCount;
                        }
                    }
                    endIndex = 128 - index;
                    index = 128;
                    break;
                }
                case 5: {
                    index = this.getMoves(side, moveArr, capIndex);
                    endIndex = capIndex;
                    break;
                }
                case 6: {
                    index = capIndex;
                    endIndex = badCapIndex + 1;
                }
            }
            for (i = index - 1; i >= endIndex; --i) {
                theMove = moveArr[i];
                if (state == 3 || state == 5 || state == 6) {
                    boolean duplicate = false;
                    for (int j = 0; j < hashCount; ++j) {
                        if (theMove != hashArr[j]) continue;
                        duplicate = true;
                        break;
                    }
                    if (duplicate) continue;
                }
                int to = MoveFunctions.getTo(theMove);
                int from = MoveFunctions.getFrom(theMove);
                int piece = MoveFunctions.getPiece(theMove);
                if (state == 3) {
                    if (MoveFunctions.getValue(theMove) == 1) continue;
                    if (Board.piece_in_square[to] != -1) {
                        if (Global.values[Board.piece_in_square[from]] >= Global.values[Board.piece_in_square[to]] && SEE.getSEE(side, to, from, passant) < 0) {
                            moveArr[badCapIndex--] = theMove;
                            continue;
                        }
                    } else if (SEE.getSEE(side, to, from, passant) < 0) {
                        moveArr[badCapIndex--] = theMove;
                        continue;
                    }
                }
                extendAmount = 0;
                boolean draw = false;
                if (this.chessBoard.MakeMove(theMove, true) >= 2) {
                    draw = true;
                    oneLegal = true;
                    value = 0L;
                } else {
                    if (!isInCheck && this.inCheck(side)) {
                        this.chessBoard.UnMake(theMove, true);
                        continue;
                    }
                    oneLegal = true;
                    boolean checkingMove = false;
                    if (this.inCheck(-side)) {
                        checkingMove = true;
                        ++extendAmount;
                    }
                    boolean pawnExtension = false;
                    if (!(this.chessBoard.getTotalValue() >= 5000 || checkingMove || isInCheck || piece % 6 != 5 || to / 8 != 6 && to / 8 != 1)) {
                        pawnExtension = true;
                        ++extendAmount;
                    }
                    boolean passedPawnMove = false;
                    if (piece % 6 == 5) {
                        passedPawnMove = Evaluation2.isPassedPawn(side, to);
                    }
                    if (bFutilityPrune && extendAmount == 0 && !checkingMove && !passedPawnMove && (long)((scoreThreshold = this.chessBoard.GetMaterialScore(side)) + futilityMargin) <= alpha) {
                        ++numberOfSkippedNodesFP;
                        this.chessBoard.UnMake(theMove, true);
                        continue;
                    }
                    boolean lmr = false;
                    if (!(state != 5 || (alpha != beta - 1L || moveCount < 4) && moveCount < 15 || depth < 2 || passedPawnMove || isInCheck || checkingMove || MoveFunctions.moveType(theMove) != 0 && MoveFunctions.moveType(theMove) <= 8)) {
                        extendAmount = -1;
                        lmr = true;
                    }
                    int nextDepth = depth - 1 + extendAmount;
                    if (moveCount == 0) {
                        value = nextDepth > 0 ? -this.Max(-side, depth - 1 + extendAmount, -beta, -alpha, nMove, checkingMove, isInCheck | pawnExtension, false) : -this.Quies(-side, 0, -beta, -alpha);
                        --thisDepth;
                    } else {
                        value = nextDepth > 0 ? -this.Max(-side, depth - 1 + extendAmount, -alpha - 1L, -alpha, nMove, checkingMove, isInCheck | pawnExtension, false) : -this.Quies(-side, 0, -alpha - 1L, -alpha);
                        --thisDepth;
                        if (value > alpha && value < beta) {
                            if (lmr) {
                                extendAmount = 0;
                            }
                            value = depth - 1 > 0 ? -this.Max(-side, depth - 1 + extendAmount, -beta, -alpha, nMove, checkingMove, isInCheck | pawnExtension, false) : -this.Quies(-side, 0, -beta, -alpha);
                            --thisDepth;
                        } else if (value > alpha && lmr && depth - 1 > 0) {
                            value = -this.Max(-side, depth - 1, -beta, -alpha, nMove, false, false, false);
                            --thisDepth;
                        }
                    }
                }
                this.chessBoard.UnMake(theMove, true);
                if (stop) {
                    return 0L;
                }
                if (value > bMove) {
                    if (value > alpha) {
                        if (value >= beta) {
                            HashTable.addHash(key, this.chessBoard.hashValue, theMove, value, depth, 2, nullFail, this.ancient);
                            if (side == 1) {
                                int[] nArray = Hist[from];
                                int n = to;
                                nArray[n] = nArray[n] + 1;
                            } else {
                                int[] nArray = Hist2[from];
                                int n = to;
                                nArray[n] = nArray[n] + 1;
                            }
                            if (state == 5) {
                                if (value >= 19000L) {
                                    theMove = MoveFunctions.setValue(theMove, 200);
                                }
                                if (theMove != killerMoves[thisDepth][0]) {
                                    int temp1 = killerMoves[thisDepth][0];
                                    Engine.killerMoves[Engine.thisDepth][0] = theMove;
                                    Engine.killerMoves[Engine.thisDepth][1] = temp1;
                                }
                            }
                            return value;
                        }
                        bestFullMove = theMove;
                        if (draw) {
                            drawPV = true;
                            Engine.PV[Engine.thisDepth - 1][Engine.thisDepth - 1] = this.chessBoard.GetMoveAtDepth(thisDepth - 1);
                            Engine.PV[Engine.thisDepth - 1][Engine.thisDepth] = theMove;
                            Engine.PV[Engine.thisDepth - 1][Engine.thisDepth + 1] = 16384;
                            Engine.lengthPV[Engine.thisDepth - 1] = thisDepth + 1;
                        } else {
                            drawPV = false;
                        }
                        hType = 1;
                        alpha = value;
                    }
                    bMove = value;
                }
                ++moveCount;
            }
        }
        if (!isInCheck && !oneLegal) {
            bMove = 0L;
            if (bMove > alpha && bMove < beta) {
                this.SavePV(16384);
            }
            hType = 4;
        } else if (isInCheck && !oneLegal) {
            bMove = -20000 + thisDepth;
            if (bMove > alpha && bMove < beta) {
                this.SavePV(20480);
            }
            hType = 4;
            HashTable.addHash(key, this.chessBoard.hashValue, bestFullMove, -20000L, depth, hType, nullFail, this.ancient);
            return bMove;
        }
        if (numberOfSkippedNodesFP > 0) {
            if (hType == 1) {
                hType = 2;
            }
            if (hType == 0) {
                bMove = alpha;
            }
        }
        HashTable.addHash(key, this.chessBoard.hashValue, bestFullMove, bMove, depth, hType, nullFail, this.ancient);
        if (oneLegal && hType == 1) {
            if (side == 1) {
                int[] nArray = Hist[MoveFunctions.getFrom(bestFullMove)];
                int n = MoveFunctions.getTo(bestFullMove);
                nArray[n] = nArray[n] + 1;
            } else {
                int[] nArray = Hist2[MoveFunctions.getFrom(bestFullMove)];
                int n = MoveFunctions.getTo(bestFullMove);
                nArray[n] = nArray[n] + 1;
            }
        }
        if (alpha != oldAlpha && !drawPV) {
            Engine.PV[Engine.thisDepth - 1][Engine.thisDepth - 1] = this.chessBoard.GetMoveAtDepth(thisDepth - 1);
            Engine.lengthPV[Engine.thisDepth - 1] = lengthPV[thisDepth];
            System.arraycopy(PV[thisDepth], thisDepth, PV[thisDepth - 1], thisDepth, lengthPV[thisDepth] - thisDepth + 1);
        }
        return bMove;
    }

    private long Quies(int side, int depth, long alpha, long beta) {
        long value;
        long bValue;
        ++thisDepth;
        ++nodes;
        int[] capArr = new int[60];
        int index = 0;
        boolean isInCheck = false;
        long testValue = 0L;
        if (depth > 0 && this.inCheck(side)) {
            isInCheck = true;
            index = this.getCheckEscapes(side, capArr);
            bValue = -20000 + thisDepth;
            if (index == 0) {
                if (bValue > alpha && bValue < beta) {
                    this.SavePV(20480);
                }
                return -20000 + thisDepth;
            }
            bValue = -20000 + thisDepth;
        } else {
            value = Evaluation2.getEval(side);
            if (value > alpha) {
                if (value >= beta) {
                    return value;
                }
                this.SavePV(8192);
                alpha = value;
            }
            if ((index = this.getCaptures(side, capArr)) == 0) {
                return value;
            }
            bValue = value;
            testValue = value;
        }
        long oldAlpha = alpha;
        for (int i = index - 1; i >= 0; --i) {
            if (MoveFunctions.getValue(capArr[i]) == 1) continue;
            int to = MoveFunctions.getTo(capArr[i]);
            int from = MoveFunctions.getFrom(capArr[i]);
            if (!isInCheck && Board.piece_in_square[to] != -1 && (long)(Global.values[Board.piece_in_square[to]] - Global.values[Board.piece_in_square[from]]) < Math.max(0L, alpha - testValue) && (long)SEE.getSEE(side, to, from, -1) < Math.max(0L, alpha - testValue)) {
                bValue = alpha;
                continue;
            }
            this.chessBoard.MakeMove(capArr[i], false);
            if (!isInCheck && this.inCheck(side)) {
                this.chessBoard.UnMake(capArr[i], false);
                continue;
            }
            value = -this.Quies(-side, depth + 1, -beta, -alpha);
            --thisDepth;
            this.chessBoard.UnMake(capArr[i], false);
            if (value <= bValue) continue;
            if (value >= beta) {
                return value;
            }
            bValue = value;
            if (value <= alpha) continue;
            alpha = value;
        }
        if (alpha != oldAlpha) {
            Engine.PV[Engine.thisDepth - 1][Engine.thisDepth - 1] = this.chessBoard.GetMoveAtDepth(thisDepth - 1);
            Engine.lengthPV[Engine.thisDepth - 1] = lengthPV[thisDepth];
            System.arraycopy(PV[thisDepth], thisDepth, PV[thisDepth - 1], thisDepth, lengthPV[thisDepth] - thisDepth + 1);
        }
        return bValue;
    }

    public void PerftTest(int depth) {
        this.perft = 0L;
        long temp = System.currentTimeMillis();
        this.Perft(this.chessBoard.getTurn(), depth);
        long temp2 = System.currentTimeMillis();
        long time = temp2 - temp;
        System.out.println("Perft value is " + this.perft);
        System.out.println("millis seconds taken is " + time);
    }

    public void Divide(int depth) {
        int index;
        boolean inCheck = false;
        int side = this.chessBoard.getTurn();
        if (this.inCheck(side)) {
            inCheck = true;
        }
        int[] moveArr = new int[128];
        if (!inCheck) {
            int index2 = this.getCaptures(side, moveArr);
            index = this.getMoves(side, moveArr, index2);
        } else {
            index = this.getCheckEscapes(side, moveArr);
        }
        for (int i = index - 1; i >= 0; --i) {
            this.perft = 0L;
            int reps = this.chessBoard.MakeMove(moveArr[i], false);
            int to = MoveFunctions.getTo(moveArr[i]);
            int from = MoveFunctions.getFrom(moveArr[i]);
            int piece = MoveFunctions.getPiece(moveArr[i]);
            String output = HistoryWriter.getUCIMove(to, from, piece);
            System.out.print(output);
            if (!inCheck && this.inCheck(side)) {
                this.chessBoard.UnMake(moveArr[i], false);
                continue;
            }
            if (reps == 3) {
                return;
            }
            this.Perft(-side, depth - 1);
            this.chessBoard.UnMake(moveArr[i], false);
            System.out.println(" " + this.perft);
        }
    }

    private void Perft(int side, int depth) {
        int index;
        boolean inCheck = false;
        if (this.inCheck(side)) {
            inCheck = true;
        }
        if (depth <= 0) {
            ++this.perft;
            return;
        }
        int[] moveArr = new int[128];
        if (!inCheck) {
            int index2 = this.getCaptures(side, moveArr);
            index = this.getMoves(side, moveArr, index2);
        } else {
            index = this.getCheckEscapes(side, moveArr);
        }
        for (int i = index - 1; i >= 0; --i) {
            int reps = this.chessBoard.MakeMove(moveArr[i], true);
            if (!inCheck && this.inCheck(side)) {
                this.chessBoard.UnMake(moveArr[i], true);
                continue;
            }
            if (reps == 3) {
                return;
            }
            this.Perft(-side, depth - 1);
            this.chessBoard.UnMake(moveArr[i], true);
        }
    }

    static {
        Hist = new int[64][64];
        Hist2 = new int[64][64];
        HashTable = new TransTable(Global.HASHSIZE, 0);
        moveOrder = new int[128];
        killerMoves = new int[100][2];
        infiniteTimeControl = false;
        PV = new int[64][64];
        lengthPV = new int[64];
    }
}

