/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.Random;

public final class Board {
    public int moveCount;
    public static final int[] boardMoves = new int[512];
    public static final int[] piece_in_square = new int[64];
    public static int[] materialValues = new int[236196];
    public static int materialKey = 0;
    public int wPieceNo;
    public int bPieceNo;
    private int materialAdjust;
    private int[][] QueenMaterialAdjustArray = new int[8][8];
    private int numberWhiteQueens;
    private int numberBlackQueens;
    public int totalValue;
    private static final long[] KnightMoveBoard = new long[64];
    private static final long[] WhitePawnMoveBoard = new long[64];
    private static final long[] WhitePawnAttackBoard = new long[64];
    private static final long[] BlackPawnMoveBoard = new long[64];
    private static long[] BlackPawnAttackBoard = new long[64];
    public long bitboard;
    public long whitepieces;
    public long blackpieces;
    public long whitepawns;
    public long blackpawns;
    public long whiteknights;
    public long blackknights;
    public long whitebishops;
    public long blackbishops;
    public long whiterooks;
    public long blackrooks;
    public long whitequeen;
    public long blackqueen;
    public long whiteking;
    public long blackking;
    public long pawnsKings;
    public long slidePieces;
    public int bCastle;
    public int wCastle;
    private static final int[] init = new int[]{0, 1, 2, 3, 4, 2, 1, 0, 5, 5, 5, 5, 5, 5, 5, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 6, 7, 8, 9, 10, 8, 7, 6};
    private static final int[] Convert = new int[]{7, 15, 23, 31, 39, 47, 55, 63, 6, 14, 22, 30, 38, 46, 54, 62, 5, 13, 21, 29, 37, 45, 53, 61, 4, 12, 20, 28, 36, 44, 52, 60, 3, 11, 19, 27, 35, 43, 51, 59, 2, 10, 18, 26, 34, 42, 50, 58, 1, 9, 17, 25, 33, 41, 49, 57, 0, 8, 16, 24, 32, 40, 48, 56};
    private static final int[] L45Convert = new int[]{0, 8, 1, 16, 9, 2, 24, 17, 10, 3, 32, 25, 18, 11, 4, 40, 33, 26, 19, 12, 5, 48, 41, 34, 27, 20, 13, 6, 56, 49, 42, 35, 28, 21, 14, 7, 57, 50, 43, 36, 29, 22, 15, 58, 51, 44, 37, 30, 23, 59, 52, 45, 38, 31, 60, 53, 46, 39, 61, 54, 47, 62, 55, 63};
    private static final int[] R45Convert = new int[]{7, 6, 15, 5, 14, 23, 4, 13, 22, 31, 3, 12, 21, 30, 39, 2, 11, 20, 29, 38, 47, 1, 10, 19, 28, 37, 46, 55, 0, 9, 18, 27, 36, 45, 54, 63, 8, 17, 26, 35, 44, 53, 62, 16, 25, 34, 43, 52, 61, 24, 33, 42, 51, 60, 32, 41, 50, 59, 40, 49, 58, 48, 57, 56};
    private static final int[] L45Update = new int[64];
    private static final int[] R45Update = new int[64];
    private static final int[] R90Update = new int[64];
    private static final int[] ShiftL = new int[]{0, 1, 3, 6, 10, 15, 21, 28, 1, 3, 6, 10, 15, 21, 28, 36, 3, 6, 10, 15, 21, 28, 36, 43, 6, 10, 15, 21, 28, 36, 43, 49, 10, 15, 21, 28, 36, 43, 49, 54, 15, 21, 28, 36, 43, 49, 54, 58, 21, 28, 36, 43, 49, 54, 58, 61, 28, 36, 43, 49, 54, 58, 61, 63};
    private static final int[] ShiftR = new int[]{28, 21, 15, 10, 6, 3, 1, 0, 36, 28, 21, 15, 10, 6, 3, 1, 43, 36, 28, 21, 15, 10, 6, 3, 49, 43, 36, 28, 21, 15, 10, 6, 54, 49, 43, 36, 28, 21, 15, 10, 58, 54, 49, 43, 36, 28, 21, 15, 61, 58, 54, 49, 43, 36, 28, 21, 63, 61, 58, 54, 49, 43, 36, 28};
    private static final int[] ShiftRank = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 8, 8, 8, 8, 16, 16, 16, 16, 16, 16, 16, 16, 24, 24, 24, 24, 24, 24, 24, 24, 32, 32, 32, 32, 32, 32, 32, 32, 40, 40, 40, 40, 40, 40, 40, 40, 48, 48, 48, 48, 48, 48, 48, 48, 56, 56, 56, 56, 56, 56, 56, 56};
    private static final int[] ShiftFile = new int[]{56, 48, 40, 32, 24, 16, 8, 0, 56, 48, 40, 32, 24, 16, 8, 0, 56, 48, 40, 32, 24, 16, 8, 0, 56, 48, 40, 32, 24, 16, 8, 0, 56, 48, 40, 32, 24, 16, 8, 0, 56, 48, 40, 32, 24, 16, 8, 0, 56, 48, 40, 32, 24, 16, 8, 0, 56, 48, 40, 32, 24, 16, 8, 0};
    private long Board45L;
    private long Board45R;
    private long Board90R;
    private static final int[] bishopShift = new int[64];
    private static final int[] rookShift = new int[64];
    private static final long[] bMask = new long[64];
    private static final long[] rMask = new long[64];
    private static final long[] bMagics = new long[64];
    private static final long[] rMagics = new long[64];
    private static final long[][] bishopTable = new long[64][];
    private static final long[][] rookTable = new long[64][];
    private int[] flagHistory = new int[512];
    private int passantW;
    private int passantB;
    private int drawCount;
    private int turn;
    public long hashValue;
    private static final long[][] pHash = new long[64][12];
    private static final long[] wCastleHash = new long[8];
    private static final long[] bCastleHash = new long[8];
    private long bHashMove;
    private static final long[] passantHashW = new long[9];
    private static final long[] passantHashB = new long[9];
    private static final int NO_PASSANT_WHITE = 51;
    private static final int NO_PASSANT_BLACK = 3;
    private long[] hashHistory = new long[512];
    private long pawnHash;
    private HistoryWriter writer;
    private static final int[][] queenDist = new int[64][64];
    private static final int[] index32 = new int[32];
    private static final int debruijn = 125613361;
    private MoveHelper Helper = MoveHelper.getInstance();
    private static final long[] zorbistHistory = new long[202];
    private static final int[] lastReversableMove = new int[202];
    private int zorbistDepth;
    private boolean reversable = true;
    private static final int[] arrCurrentMoves = new int[64];
    private int iCurrentMovesDepth;
    private static final Board INSTANCE = new Board();

    private Board() {
        int j;
        int temp;
        int j2;
        int i;
        for (i = 0; i < 32; ++i) {
            Board.index32[125613361 << i >>> 27] = i;
        }
        this.writer = new HistoryWriter();
        this.initQueenDist();
        this.setHash();
        for (i = 0; i < 15; ++i) {
            Global.diag1Masks[i] = 0L;
        }
        for (j2 = 0; j2 < 64; ++j2) {
            int n = temp = Global.Diag1Groups[j2];
            Global.diag1Masks[n] = Global.diag1Masks[n] | 1L << j2;
        }
        for (i = 0; i < 15; ++i) {
            Global.diag2Masks[i] = 0L;
        }
        for (j2 = 0; j2 < 64; ++j2) {
            int n = temp = Global.Diag2Groups[j2];
            Global.diag2Masks[n] = Global.diag2Masks[n] | 1L << j2;
        }
        for (i = 0; i < 64; ++i) {
            Global.set_Mask[i] = 1L << i;
        }
        for (i = 0; i < 8; ++i) {
            Global.fileMasks[i] = 0L;
            for (j = 0; j < 64; ++j) {
                if (j % 8 != i) continue;
                int n = i;
                Global.fileMasks[n] = Global.fileMasks[n] | 1L << j;
            }
        }
        for (i = 0; i < 8; ++i) {
            Global.rankMasks[i] = 0L;
            for (j = 0; j < 64; ++j) {
                if (j / 8 != i) continue;
                int n = i;
                Global.rankMasks[n] = Global.rankMasks[n] | 1L << j;
            }
        }
        for (i = 0; i < 64; ++i) {
            Global.plus9[i] = 0L;
            for (j = i + 9; j < 64 && j % 8 != 0; j += 9) {
                int n = i;
                Global.plus9[n] = Global.plus9[n] | Global.set_Mask[j];
            }
        }
        for (i = 0; i < 64; ++i) {
            Global.minus9[i] = 0L;
            for (j = i - 9; j >= 0 && j % 8 != 7; j -= 9) {
                int n = i;
                Global.minus9[n] = Global.minus9[n] | Global.set_Mask[j];
            }
        }
        for (i = 0; i < 64; ++i) {
            Global.plus7[i] = 0L;
            for (j = i + 7; j < 64 && j % 8 != 7; j += 7) {
                int n = i;
                Global.plus7[n] = Global.plus7[n] | Global.set_Mask[j];
            }
        }
        for (i = 0; i < 64; ++i) {
            Global.minus7[i] = 0L;
            for (j = i - 7; j >= 0 && j % 8 != 0; j -= 7) {
                int n = i;
                Global.minus7[n] = Global.minus7[n] | Global.set_Mask[j];
            }
        }
        for (i = 0; i < 64; ++i) {
            Global.plus8[i] = 0L;
            for (j = i + 8; j < 64; j += 8) {
                int n = i;
                Global.plus8[n] = Global.plus8[n] | Global.set_Mask[j];
            }
        }
        for (i = 0; i < 64; ++i) {
            Global.minus8[i] = 0L;
            for (j = i - 8; j >= 0; j -= 8) {
                int n = i;
                Global.minus8[n] = Global.minus8[n] | Global.set_Mask[j];
            }
        }
        for (i = 0; i < 64; ++i) {
            Global.plus1[i] = 0L;
            for (j = i + 1; j < 64 && j % 8 != 0; ++j) {
                int n = i;
                Global.plus1[n] = Global.plus1[n] | Global.set_Mask[j];
            }
        }
        for (i = 0; i < 64; ++i) {
            Global.minus1[i] = 0L;
            for (j = i - 1; j >= 0 && j % 8 != 7; --j) {
                int n = i;
                Global.minus1[n] = Global.minus1[n] | Global.set_Mask[j];
            }
        }
        for (i = 8; i < 64; ++i) {
            int file = i % 8;
            Global.whitePassedPawnMasks[i] = file == 0 ? Global.plus8[i] | Global.plus8[i + 1] : (file == 7 ? Global.plus8[i] | Global.plus8[i - 1] : Global.plus8[i] | Global.plus8[i + 1] | Global.plus8[i - 1]);
        }
        for (i = 55; i >= 0; --i) {
            int rank = i % 8;
            Global.blackPassedPawnMasks[i] = rank == 0 ? Global.minus8[i] | Global.minus8[i + 1] : (rank == 7 ? Global.minus8[i] | Global.minus8[i - 1] : Global.minus8[i] | Global.minus8[i + 1] | Global.minus8[i - 1]);
        }
        for (i = 0; i < 64; ++i) {
            for (j = 0; j < 64; ++j) {
                if (L45Convert[j] != i) continue;
                Board.L45Update[i] = j;
            }
        }
        for (i = 0; i < 64; ++i) {
            for (j = 0; j < 64; ++j) {
                if (R45Convert[j] != i) continue;
                Board.R45Update[i] = j;
            }
        }
        for (i = 0; i < 64; ++i) {
            for (j = 0; j < 64; ++j) {
                if (Convert[j] != i) continue;
                Board.R90Update[i] = j;
            }
        }
        for (i = 0; i < 8; ++i) {
            if (i % 8 == 0) {
                Global.wKingMask[i] = Global.set_Mask[i + 8] | Global.set_Mask[i + 9] | Global.set_Mask[i + 10] | Global.set_Mask[i + 16] | Global.set_Mask[i + 17] | Global.set_Mask[i + 18] | Global.set_Mask[i + 1] | Global.set_Mask[i + 2] | Global.set_Mask[i];
                Global.bKingMask[i] = Global.set_Mask[56 + i - 6] | Global.set_Mask[56 + i - 7] | Global.set_Mask[56 + i - 8] | Global.set_Mask[56 + i - 14] | Global.set_Mask[56 + i - 15] | Global.set_Mask[56 + i - 16] | Global.set_Mask[56 + i + 1] | Global.set_Mask[56 + i + 2] | Global.set_Mask[56 + i];
                continue;
            }
            if (i % 8 == 7) {
                Global.wKingMask[i] = Global.set_Mask[i + 6] | Global.set_Mask[i + 7] | Global.set_Mask[i + 8] | Global.set_Mask[i + 14] | Global.set_Mask[i + 15] | Global.set_Mask[i + 16] | Global.set_Mask[i - 1] | Global.set_Mask[i - 2] | Global.set_Mask[i];
                Global.bKingMask[i] = Global.set_Mask[56 + i - 8] | Global.set_Mask[56 + i - 9] | Global.set_Mask[56 + i - 10] | Global.set_Mask[56 + i - 16] | Global.set_Mask[56 + i - 17] | Global.set_Mask[56 + i - 18] | Global.set_Mask[56 + i - 1] | Global.set_Mask[56 + i - 2] | Global.set_Mask[56 + i];
                continue;
            }
            Global.wKingMask[i] = Global.set_Mask[i + 7] | Global.set_Mask[i + 8] | Global.set_Mask[i + 9] | Global.set_Mask[i + 15] | Global.set_Mask[i + 16] | Global.set_Mask[i + 17] | Global.set_Mask[i - 1] | Global.set_Mask[i + 1] | Global.set_Mask[i];
            Global.bKingMask[i] = Global.set_Mask[56 + i - 7] | Global.set_Mask[56 + i - 8] | Global.set_Mask[56 + i - 9] | Global.set_Mask[56 + i - 15] | Global.set_Mask[56 + i - 16] | Global.set_Mask[56 + i - 17] | Global.set_Mask[56 + i + 1] | Global.set_Mask[56 + i - 1] | Global.set_Mask[56 + i];
        }
        this.setBishopMasks();
        this.setBishopMagics();
        this.setRookMasks();
        this.setRookMagics();
        this.populateBishopTables();
        this.populateRookTables();
        this.zorbistDepth = 1;
        Board.lastReversableMove[0] = 1;
        Board.lastReversableMove[1] = 1;
        this.InitKnightMoveBoard(KnightMoveBoard);
        this.InitWhitePawnMoveBoard(WhitePawnMoveBoard);
        this.InitWhitePawnAttackBoard(WhitePawnAttackBoard);
        this.InitBlackPawnMoveBoard(BlackPawnMoveBoard);
        this.InitBlackPawnAttackBoard(BlackPawnAttackBoard);
        this.InitializeMaterialArray();
    }

    public static Board getInstance() {
        return INSTANCE;
    }

    public final void undoAll() {
        int noMoves = this.moveCount;
        for (int i = noMoves - 1; i >= 0; --i) {
            this.UnMake(boardMoves[i], true);
            this.writer.removeLastHistory();
        }
        this.zorbistDepth = 1;
        this.iCurrentMovesDepth = 0;
    }

    public final void newGame() {
        int i;
        materialKey = 0;
        this.materialAdjust = 0;
        this.numberWhiteQueens = 0;
        this.numberBlackQueens = 0;
        this.zorbistDepth = 1;
        this.blackpieces = 0L;
        this.whitepieces = 0L;
        this.moveCount = 0;
        this.drawCount = 0;
        this.bitboard = 0L;
        this.Board45R = 0L;
        this.Board45L = 0L;
        this.Board90R = 0L;
        this.whiteknights = 0L;
        this.blackknights = 0L;
        this.whitebishops = 0L;
        this.blackbishops = 0L;
        this.whiterooks = 0L;
        this.blackrooks = 0L;
        this.whiteking = 0L;
        this.blackking = 0L;
        this.whitequeen = 0L;
        this.blackqueen = 0L;
        this.whitepawns = 0L;
        this.blackpawns = 0L;
        this.slidePieces = 0L;
        this.totalValue = 0;
        this.turn = -1;
        this.pawnsKings = 0L;
        this.wPieceNo = 0;
        this.bPieceNo = 0;
        this.iCurrentMovesDepth = 0;
        for (i = 0; i < 64; ++i) {
            Board.piece_in_square[i] = -1;
        }
        this.bCastle = 6;
        this.wCastle = 6;
        this.passantW = 51;
        this.passantB = 3;
        this.hashValue = 0L;
        this.pawnHash = 0L;
        for (i = 0; i < 64; ++i) {
            if (init[i] == -1) continue;
            this.setBoard(i, init[i]);
            this.hashValue ^= pHash[i][init[i]];
        }
        this.hashValue ^= bCastleHash[this.bCastle];
        this.hashValue ^= wCastleHash[this.wCastle];
        Engine.resetHash();
        Evaluation2.clearEvalHash();
        Evaluation2.clearPawnHash();
        this.writer.reset();
    }

    private final void InitializeMaterialArray() {
        int noReps = 0;
        this.QueenMaterialAdjustArray[2][0] = 2 * -Global.values[3] - Global.values[9];
        this.QueenMaterialAdjustArray[2][1] = -Global.values[3] + Global.values[5];
        this.QueenMaterialAdjustArray[2][2] = -Global.values[9] + Global.values[5];
        this.QueenMaterialAdjustArray[1][2] = 2 * Global.values[9] + Global.values[5];
        this.QueenMaterialAdjustArray[0][2] = 2 * Global.values[9] + Global.values[5];
        for (int wRook = 0; wRook < 3; ++wRook) {
            for (int bRook = 0; bRook < 3; ++bRook) {
                for (int wBishop = 0; wBishop < 3; ++wBishop) {
                    for (int bBishop = 0; bBishop < 3; ++bBishop) {
                        for (int wKnight = 0; wKnight < 3; ++wKnight) {
                            for (int bKnight = 0; bKnight < 3; ++bKnight) {
                                for (int wQueen = 0; wQueen < 2; ++wQueen) {
                                    for (int bQueen = 0; bQueen < 2; ++bQueen) {
                                        for (int wPawn = 0; wPawn < 9; ++wPawn) {
                                            for (int bPawn = 0; bPawn < 9; ++bPawn) {
                                                ++noReps;
                                                int noWhitePieces = wQueen + wRook + wBishop + wKnight + wPawn;
                                                int noBlackPieces = bQueen + bRook + bBishop + bKnight + bPawn;
                                                int noWhiteMinors = wBishop + wKnight;
                                                int noBlackMinors = bBishop + bKnight;
                                                int index = wRook + bRook * 3 + wBishop * 3 * 3 + bBishop * 3 * 3 * 3 + wKnight * 3 * 3 * 3 * 3 + bKnight * 3 * 3 * 3 * 3 * 3 + wQueen * 3 * 3 * 3 * 3 * 3 * 3 + bQueen * 3 * 3 * 3 * 3 * 3 * 3 * 2 + wPawn * 3 * 3 * 3 * 3 * 3 * 3 * 2 * 2 + bPawn * 3 * 3 * 3 * 3 * 3 * 3 * 2 * 2 * 9;
                                                int materialImbalence = 0;
                                                if (noWhitePieces <= 1 && noBlackPieces <= 1 && noWhiteMinors == noWhitePieces && noBlackMinors == noBlackPieces) {
                                                    materialImbalence = 999999;
                                                } else if (noWhitePieces <= 2 && noBlackPieces == 2 && noBlackPieces == bKnight && noWhitePieces == noWhiteMinors && wBishop != 2) {
                                                    materialImbalence = 999999;
                                                } else if (noBlackPieces <= 2 && noWhitePieces == 2 && noWhitePieces == bKnight && noBlackPieces == noBlackMinors && bBishop != 2) {
                                                    materialImbalence = 999999;
                                                } else if (noWhitePieces == 1 && wPawn == 1 && noBlackPieces == 1 && noBlackPieces == noBlackMinors) {
                                                    materialImbalence = 999999;
                                                } else if (noBlackPieces == 1 && bPawn == 1 && noWhitePieces == 1 && noWhitePieces == noWhiteMinors) {
                                                    materialImbalence = 999999;
                                                } else if (noWhiteMinors == 2 && noWhitePieces == 2 && noWhitePieces != wBishop && noBlackPieces == 1 && noBlackMinors == 1) {
                                                    materialImbalence = 999999;
                                                } else if (noBlackMinors == 2 && noBlackPieces == 2 && noBlackPieces != bBishop && noWhitePieces == 1 && noWhiteMinors == 1) {
                                                    materialImbalence = 999999;
                                                } else if (noBlackPieces == 2 && noBlackPieces == noBlackMinors && noBlackPieces != bBishop && noWhitePieces == 1 && wRook == 1) {
                                                    materialImbalence = 999999;
                                                } else if (noWhitePieces == 2 && noWhitePieces == noWhiteMinors && noWhitePieces != wBishop && noBlackPieces == 1 && bRook == 1) {
                                                    materialImbalence = 999999;
                                                } else {
                                                    materialImbalence = -Global.values[3] * wQueen + Global.values[9] * bQueen - Global.values[0] * wRook + Global.values[6] * bRook - Global.values[2] * wBishop + Global.values[8] * bBishop - Global.values[1] * wKnight + Global.values[7] * bKnight - Global.values[5] * wPawn + Global.values[11] * bPawn;
                                                    if (wBishop == 2 && bBishop < 2) {
                                                        materialImbalence -= 50;
                                                    } else if (bBishop == 2 && wBishop < 2) {
                                                        materialImbalence += 50;
                                                    }
                                                    if (wPawn - bPawn >= 3 && noBlackMinors - noWhiteMinors > 0) {
                                                        materialImbalence += 75;
                                                    } else if (bPawn - wPawn >= 3 && noWhiteMinors - noBlackMinors > 0) {
                                                        materialImbalence -= 75;
                                                    }
                                                    if (wPawn - bPawn >= 1 && wRook - bRook == 1 && noBlackMinors - noWhiteMinors == 2) {
                                                        materialImbalence += 25;
                                                    } else if (bPawn - wPawn >= 1 && bRook - wRook == 1 && noWhiteMinors - noBlackMinors == 2) {
                                                        materialImbalence -= 25;
                                                    }
                                                    if (wQueen - bQueen == 1 && bRook - wRook == 1 && noBlackMinors - noWhiteMinors == 1 && bPawn - wPawn == 1) {
                                                        materialImbalence -= 75;
                                                    } else if (bQueen - wQueen == 1 && wRook - bRook == 1 && noWhiteMinors - noBlackMinors == 1 && wPawn - bPawn == 1) {
                                                        materialImbalence += 75;
                                                    }
                                                }
                                                Board.materialValues[index] = materialImbalence;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private final void initQueenDist() {
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                if (i % 8 >= j % 8 && i % 8 != j % 8 && i / 8 != j / 8) continue;
                Board.queenDist[i][j] = this.getQueenDistance(i, j);
                Board.queenDist[j][i] = queenDist[i][j];
            }
        }
    }

    public final int getDistance(int to, int from) {
        return queenDist[to][from];
    }

    private final int getQueenDistance(int qPos, int kPos) {
        int qRank = qPos / 8;
        int kRank = kPos / 8;
        int qFile = qPos % 8;
        int kFile = kPos % 8;
        int fileDiff = Math.abs(qFile - kFile);
        int rankDiff = Math.abs(qRank - kRank);
        int Distance = 0;
        if (qRank == kRank) {
            Distance = fileDiff;
        } else if (qFile == kFile) {
            Distance = rankDiff;
        } else if (kFile > qFile) {
            if (kRank > qRank) {
                if (fileDiff < rankDiff) {
                    int pos = qPos;
                    while (pos % 8 != kFile) {
                        pos += 9;
                        ++Distance;
                    }
                    Distance += Math.abs(pos / 8 - kRank);
                } else {
                    int pos = qPos;
                    while (pos / 8 != kRank) {
                        pos += 9;
                        ++Distance;
                    }
                    Distance += Math.abs(pos - kPos);
                }
            } else if (fileDiff < rankDiff) {
                int pos = qPos;
                while (pos % 8 != kFile) {
                    pos -= 7;
                    ++Distance;
                }
                Distance += Math.abs(pos / 8 - kRank);
            } else {
                int pos = qPos;
                while (pos / 8 != kRank) {
                    pos -= 7;
                    ++Distance;
                }
                Distance += Math.abs(pos - kPos);
            }
        }
        return Distance;
    }

    public final void callFileWrite(File f) {
        this.writer.historyToFile(f);
    }

    public final void callFileRead(File f) {
        this.writer.readHistory(f);
    }

    public void acceptFen(String fen) {
        materialKey = 0;
        this.materialAdjust = 0;
        this.numberWhiteQueens = 0;
        this.numberBlackQueens = 0;
        this.blackpieces = 0L;
        this.whitepieces = 0L;
        this.bitboard = 0L;
        this.whiteknights = 0L;
        this.blackknights = 0L;
        this.whitebishops = 0L;
        this.blackbishops = 0L;
        this.whiterooks = 0L;
        this.blackrooks = 0L;
        this.whiteking = 0L;
        this.blackking = 0L;
        this.whitequeen = 0L;
        this.blackqueen = 0L;
        this.whitepawns = 0L;
        this.blackpawns = 0L;
        this.slidePieces = 0L;
        this.totalValue = 0;
        this.wPieceNo = 0;
        this.bPieceNo = 0;
        for (int i = 0; i < 64; ++i) {
            Board.piece_in_square[i] = -1;
        }
        this.bCastle = 0;
        this.wCastle = 0;
        this.passantW = 51;
        this.passantB = 3;
        this.hashValue = 0L;
        this.pawnHash = 0L;
        int count = 63;
        for (int i = 0; i < 8; ++i) {
            String rank;
            int endOfRank = fen.indexOf("/");
            if (endOfRank == -1) {
                endOfRank = fen.indexOf(" ");
                rank = fen.substring(0, endOfRank);
                fen = fen.substring(endOfRank + 1);
            } else {
                rank = fen.substring(0, endOfRank);
                fen = fen.substring(endOfRank + 1);
            }
            block30: for (int j = 0; j < endOfRank; ++j) {
                char c = rank.charAt(endOfRank - 1 - j);
                switch (c) {
                    case 'r': {
                        this.setBoard(count, 6);
                        this.hashValue ^= pHash[count][6];
                        --count;
                        continue block30;
                    }
                    case 'n': {
                        this.setBoard(count, 7);
                        this.hashValue ^= pHash[count][7];
                        --count;
                        continue block30;
                    }
                    case 'b': {
                        this.setBoard(count, 8);
                        this.hashValue ^= pHash[count][8];
                        --count;
                        continue block30;
                    }
                    case 'q': {
                        this.setBoard(count, 9);
                        this.hashValue ^= pHash[count][9];
                        --count;
                        continue block30;
                    }
                    case 'k': {
                        this.setBoard(count, 10);
                        this.hashValue ^= pHash[count][10];
                        --count;
                        continue block30;
                    }
                    case 'p': {
                        this.setBoard(count, 11);
                        this.hashValue ^= pHash[count][11];
                        --count;
                        continue block30;
                    }
                    case 'R': {
                        this.setBoard(count, 0);
                        this.hashValue ^= pHash[count][0];
                        --count;
                        continue block30;
                    }
                    case 'N': {
                        this.setBoard(count, 1);
                        this.hashValue ^= pHash[count][1];
                        --count;
                        continue block30;
                    }
                    case 'B': {
                        this.setBoard(count, 2);
                        this.hashValue ^= pHash[count][2];
                        --count;
                        continue block30;
                    }
                    case 'Q': {
                        this.setBoard(count, 3);
                        this.hashValue ^= pHash[count][3];
                        --count;
                        continue block30;
                    }
                    case 'K': {
                        this.setBoard(count, 4);
                        this.hashValue ^= pHash[count][4];
                        --count;
                        continue block30;
                    }
                    case 'P': {
                        this.setBoard(count, 5);
                        this.hashValue ^= pHash[count][5];
                        --count;
                        continue block30;
                    }
                    case '1': {
                        --count;
                        continue block30;
                    }
                    case '2': {
                        count -= 2;
                        continue block30;
                    }
                    case '3': {
                        count -= 3;
                        continue block30;
                    }
                    case '4': {
                        count -= 4;
                        continue block30;
                    }
                    case '5': {
                        count -= 5;
                        continue block30;
                    }
                    case '6': {
                        count -= 6;
                        continue block30;
                    }
                    case '7': {
                        count -= 7;
                        continue block30;
                    }
                    case '8': {
                        count -= 8;
                    }
                }
            }
        }
        char c = fen.charAt(0);
        fen = fen.substring(fen.indexOf(" ") + 1);
        this.turn = c == 'w' ? -1 : 1;
        if (this.turn == 1) {
            this.hashValue ^= this.bHashMove;
        }
        String token = fen.substring(0, fen.indexOf(" "));
        fen = fen.substring(fen.indexOf(" ") + 1);
        int tokenSize = token.length();
        block31: for (int i = 0; i < tokenSize; ++i) {
            c = token.charAt(i);
            switch (c) {
                case 'K': {
                    this.wCastle = 2;
                    continue block31;
                }
                case 'Q': {
                    if (this.wCastle == 0) {
                        this.wCastle = 4;
                        continue block31;
                    }
                    this.wCastle = 6;
                    continue block31;
                }
                case 'k': {
                    this.bCastle = 2;
                    continue block31;
                }
                case 'q': {
                    this.bCastle = this.bCastle == 0 ? 4 : 6;
                }
            }
        }
        c = fen.charAt(0);
        if (c != '-') {
            token = fen.substring(0, fen.indexOf(" "));
            int pSq = HistoryWriter.getNumericPosition(token);
            if (this.turn == -1) {
                this.passantB = pSq;
            } else {
                this.passantW = pSq;
            }
        }
        fen = fen.substring(fen.indexOf(" "));
        fen = fen.substring(fen.indexOf(" ") + 1);
        token = fen.substring(0, fen.indexOf(" "));
        Integer noMoves = new Integer(token);
        this.drawCount = noMoves;
        token = fen = fen.substring(fen.indexOf(" ") + 1);
        noMoves = new Integer(token);
        this.moveCount = noMoves - 1;
        this.hashValue ^= bCastleHash[this.bCastle];
        this.hashValue ^= wCastleHash[this.wCastle];
    }

    public final long getPawnHash() {
        return this.pawnHash;
    }

    public final long getHash() {
        return this.hashValue;
    }

    public final long generateHash() {
        long temp = this.bitboard;
        long hash = 0L;
        while (temp != 0L) {
            long temp2 = temp & -temp;
            int pos = Long.numberOfTrailingZeros(temp2);
            temp &= temp2 ^ 0xFFFFFFFFFFFFFFFFL;
            hash ^= pHash[pos][piece_in_square[pos]];
        }
        hash ^= passantHashW[this.passantW % 9];
        hash ^= passantHashB[this.passantB % 9];
        hash ^= bCastleHash[this.bCastle];
        hash ^= wCastleHash[this.wCastle];
        if (this.turn == 1) {
            hash ^= this.bHashMove;
        }
        return hash;
    }

    private final void setHash() {
        int i;
        Random rand = new Random(80392848L);
        for (i = 0; i < 64; ++i) {
            for (int j = 0; j < 12; ++j) {
                Board.pHash[i][j] = rand.nextLong() & Long.MAX_VALUE;
            }
        }
        for (i = 0; i < 9; ++i) {
            Board.passantHashW[i] = rand.nextLong() & Long.MAX_VALUE;
            Board.passantHashB[i] = rand.nextLong() & Long.MAX_VALUE;
        }
        this.bHashMove = rand.nextLong() & Long.MAX_VALUE;
        for (i = 0; i < 8; ++i) {
            Board.bCastleHash[i] = rand.nextLong() & Long.MAX_VALUE;
            Board.wCastleHash[i] = rand.nextLong() & Long.MAX_VALUE;
        }
    }

    private final void setBishopMagics() {
        Board.bMagics[0] = 0x2020202020200L;
        Board.bishopShift[0] = 6;
        Board.bMagics[8] = 0x40404040400L;
        Board.bishopShift[8] = 5;
        Board.bMagics[16] = 0x4000808080800L;
        Board.bishopShift[16] = 5;
        Board.bMagics[24] = 571746315931648L;
        Board.bishopShift[24] = 5;
        Board.bMagics[32] = 285941744803840L;
        Board.bishopShift[32] = 5;
        Board.bMagics[40] = 142971408236544L;
        Board.bishopShift[40] = 5;
        Board.bMagics[48] = 0x410410400000L;
        Board.bishopShift[48] = 5;
        Board.bMagics[56] = 0x104104104000L;
        Board.bishopShift[56] = 6;
        Board.bMagics[1] = 0x2020202020000L;
        Board.bishopShift[1] = 5;
        Board.bMagics[9] = 0x20202020200L;
        Board.bishopShift[9] = 5;
        Board.bMagics[17] = 0x2000404040400L;
        Board.bishopShift[17] = 5;
        Board.bMagics[25] = 285873157965824L;
        Board.bishopShift[25] = 5;
        Board.bMagics[33] = 142970872401920L;
        Board.bishopShift[33] = 5;
        Board.bMagics[41] = 71485704118272L;
        Board.bishopShift[41] = 5;
        Board.bMagics[49] = 0x208208200000L;
        Board.bishopShift[49] = 5;
        Board.bMagics[57] = 0x2082082000L;
        Board.bishopShift[57] = 5;
        Board.bMagics[2] = 1127008041959424L;
        Board.bishopShift[2] = 5;
        Board.bMagics[10] = 4402375163904L;
        Board.bishopShift[10] = 5;
        Board.bMagics[18] = 0x1000202020200L;
        Board.bishopShift[18] = 7;
        Board.bMagics[26] = 35734195078144L;
        Board.bishopShift[26] = 7;
        Board.bMagics[34] = 17884244346880L;
        Board.bishopShift[34] = 7;
        Board.bMagics[42] = 8935813681152L;
        Board.bishopShift[42] = 7;
        Board.bMagics[50] = 139654594560L;
        Board.bishopShift[50] = 5;
        Board.bMagics[58] = 545525760L;
        Board.bishopShift[58] = 5;
        Board.bMagics[3] = 0x4040080000000L;
        Board.bishopShift[3] = 5;
        Board.bMagics[11] = 0x40400800000L;
        Board.bishopShift[11] = 5;
        Board.bMagics[19] = 140771881664512L;
        Board.bishopShift[19] = 7;
        Board.bMagics[27] = 70643689259520L;
        Board.bishopShift[27] = 9;
        Board.bMagics[35] = 0x20080080080L;
        Board.bishopShift[35] = 9;
        Board.bMagics[43] = 137724168192L;
        Board.bishopShift[43] = 7;
        Board.bMagics[51] = 0x20880000L;
        Board.bishopShift[51] = 5;
        Board.bMagics[59] = 0x208800L;
        Board.bishopShift[59] = 5;
        Board.bMagics[4] = 0x1104000000000L;
        Board.bishopShift[4] = 5;
        Board.bMagics[12] = 0x11040000000L;
        Board.bishopShift[12] = 5;
        Board.bMagics[20] = 140754678710272L;
        Board.bishopShift[20] = 7;
        Board.bMagics[28] = 145135543263232L;
        Board.bishopShift[28] = 9;
        Board.bMagics[36] = 0x404040040100L;
        Board.bishopShift[36] = 9;
        Board.bMagics[44] = 8800392184832L;
        Board.bishopShift[44] = 7;
        Board.bMagics[52] = 0x1002020000L;
        Board.bishopShift[52] = 5;
        Board.bMagics[60] = 0x10020200L;
        Board.bishopShift[60] = 5;
        Board.bMagics[5] = 143006304829440L;
        Board.bishopShift[5] = 5;
        Board.bMagics[13] = 558618378240L;
        Board.bishopShift[13] = 5;
        Board.bMagics[21] = 35188675985408L;
        Board.bishopShift[21] = 7;
        Board.bMagics[29] = 70643655708672L;
        Board.bishopShift[29] = 7;
        Board.bMagics[37] = 141291539267840L;
        Board.bishopShift[37] = 7;
        Board.bMagics[45] = 0x1010101000200L;
        Board.bishopShift[45] = 7;
        Board.bMagics[53] = 4415360729088L;
        Board.bishopShift[53] = 5;
        Board.bMagics[61] = 17247502848L;
        Board.bishopShift[61] = 5;
        Board.bMagics[6] = 0x410410400000L;
        Board.bishopShift[6] = 5;
        Board.bMagics[14] = 0x4104104000L;
        Board.bishopShift[14] = 5;
        Board.bMagics[22] = 70370925748224L;
        Board.bishopShift[22] = 5;
        Board.bMagics[30] = 141287261212672L;
        Board.bishopShift[30] = 5;
        Board.bMagics[38] = 282578783438848L;
        Board.bishopShift[38] = 5;
        Board.bMagics[46] = 0x2020202000400L;
        Board.bishopShift[46] = 5;
        Board.bMagics[54] = 0x4040404040000L;
        Board.bishopShift[54] = 5;
        Board.bMagics[62] = 0x40404040400L;
        Board.bishopShift[62] = 5;
        Board.bMagics[7] = 0x104104104000L;
        Board.bishopShift[7] = 6;
        Board.bMagics[15] = 0x2082082000L;
        Board.bishopShift[15] = 5;
        Board.bMagics[23] = 35185462874112L;
        Board.bishopShift[23] = 5;
        Board.bMagics[31] = 70643630606336L;
        Board.bishopShift[31] = 5;
        Board.bMagics[39] = 141289391719424L;
        Board.bishopShift[39] = 5;
        Board.bMagics[47] = 0x1010101000200L;
        Board.bishopShift[47] = 5;
        Board.bMagics[55] = 0x2020202020000L;
        Board.bishopShift[55] = 5;
        Board.bMagics[63] = 0x2020202020200L;
        Board.bishopShift[63] = 6;
        for (int i = 0; i < 64; ++i) {
            Board.bishopTable[i] = new long[1 << bishopShift[i]];
        }
    }

    private final void setRookMagics() {
        Board.rMagics[0] = 36028866279506048L;
        Board.rookShift[0] = 12;
        Board.rMagics[8] = 140738029420672L;
        Board.rookShift[8] = 11;
        Board.rMagics[16] = 35734132097152L;
        Board.rookShift[16] = 11;
        Board.rMagics[24] = 35736275402752L;
        Board.rookShift[24] = 11;
        Board.rMagics[32] = 35459258384512L;
        Board.rookShift[32] = 11;
        Board.rMagics[40] = 35459258417152L;
        Board.rookShift[40] = 11;
        Board.rMagics[48] = 35459258384512L;
        Board.rookShift[48] = 11;
        Board.rMagics[56] = 17730707128577L;
        Board.rookShift[56] = 12;
        Board.rMagics[1] = 18014467231055936L;
        Board.rookShift[1] = 11;
        Board.rMagics[9] = 70369281069056L;
        Board.rookShift[9] = 10;
        Board.rMagics[17] = 70643624185856L;
        Board.rookShift[17] = 10;
        Board.rMagics[25] = 35185445851136L;
        Board.rookShift[25] = 10;
        Board.rMagics[33] = 35185450029056L;
        Board.rookShift[33] = 10;
        Board.rMagics[41] = 35185445863552L;
        Board.rookShift[41] = 10;
        Board.rMagics[49] = 35185445863552L;
        Board.rookShift[49] = 10;
        Board.rMagics[57] = 17730698772737L;
        Board.rookShift[57] = 11;
        Board.rMagics[2] = 36037661833560192L;
        Board.rookShift[2] = 11;
        Board.rMagics[10] = 140806209929344L;
        Board.rookShift[10] = 10;
        Board.rMagics[18] = 141287512612864L;
        Board.rookShift[18] = 10;
        Board.rMagics[26] = 17594335625344L;
        Board.rookShift[26] = 10;
        Board.rMagics[34] = 17594341924864L;
        Board.rookShift[34] = 10;
        Board.rMagics[42] = 17592722948224L;
        Board.rookShift[42] = 10;
        Board.rMagics[50] = 17592722948224L;
        Board.rookShift[50] = 10;
        Board.rMagics[58] = 8865349386497L;
        Board.rookShift[58] = 11;
        Board.rMagics[3] = 36033229426262144L;
        Board.rookShift[3] = 11;
        Board.rMagics[11] = 0x800800100080L;
        Board.rookShift[11] = 10;
        Board.rMagics[19] = 0x808008001000L;
        Board.rookShift[19] = 10;
        Board.rMagics[27] = 0x80080100080L;
        Board.rookShift[27] = 10;
        Board.rMagics[35] = 0x80080801000L;
        Board.rookShift[35] = 10;
        Board.rMagics[43] = 0x80010008080L;
        Board.rookShift[43] = 10;
        Board.rMagics[51] = 0x80010008080L;
        Board.rookShift[51] = 10;
        Board.rMagics[59] = 4432674693377L;
        Board.rookShift[59] = 11;
        Board.rMagics[4] = 36031013222613120L;
        Board.rookShift[4] = 11;
        Board.rMagics[12] = 0x800400080080L;
        Board.rookShift[12] = 10;
        Board.rMagics[20] = 0x808004000800L;
        Board.rookShift[20] = 10;
        Board.rMagics[28] = 0x40080080080L;
        Board.rookShift[28] = 10;
        Board.rMagics[36] = 0x40080800800L;
        Board.rookShift[36] = 10;
        Board.rMagics[44] = 0x40008008080L;
        Board.rookShift[44] = 10;
        Board.rMagics[52] = 0x40008008080L;
        Board.rookShift[52] = 10;
        Board.rMagics[60] = 281483634278417L;
        Board.rookShift[60] = 11;
        Board.rMagics[5] = 36029905120788608L;
        Board.rookShift[5] = 11;
        Board.rMagics[13] = 140746078552192L;
        Board.rookShift[13] = 10;
        Board.rMagics[21] = 141287277724672L;
        Board.rookShift[21] = 10;
        Board.rMagics[29] = 2201171001472L;
        Board.rookShift[29] = 10;
        Board.rMagics[37] = 2201179128832L;
        Board.rookShift[37] = 10;
        Board.rMagics[45] = 2199090397312L;
        Board.rookShift[45] = 10;
        Board.rMagics[53] = 2199090397312L;
        Board.rookShift[53] = 10;
        Board.rMagics[61] = 281483633756161L;
        Board.rookShift[61] = 11;
        Board.rMagics[6] = 36029346791555584L;
        Board.rookShift[6] = 11;
        Board.rMagics[14] = 140741783453824L;
        Board.rookShift[14] = 10;
        Board.rMagics[22] = 1103806726148L;
        Board.rookShift[22] = 10;
        Board.rMagics[30] = 1101667500544L;
        Board.rookShift[30] = 10;
        Board.rMagics[38] = 2199040098308L;
        Board.rookShift[38] = 10;
        Board.rMagics[46] = 1099545215104L;
        Board.rookShift[46] = 10;
        Board.rMagics[54] = 140741783453824L;
        Board.rookShift[54] = 10;
        Board.rMagics[62] = 281477157749761L;
        Board.rookShift[62] = 11;
        Board.rMagics[7] = 36028935540048128L;
        Board.rookShift[7] = 12;
        Board.rMagics[15] = 140738570486016L;
        Board.rookShift[15] = 11;
        Board.rMagics[23] = 2199027482884L;
        Board.rookShift[23] = 11;
        Board.rMagics[31] = 140739635855616L;
        Board.rookShift[31] = 11;
        Board.rMagics[39] = 140738570486016L;
        Board.rookShift[39] = 11;
        Board.rMagics[47] = 277042298884L;
        Board.rookShift[47] = 11;
        Board.rMagics[55] = 140738578874496L;
        Board.rookShift[55] = 11;
        Board.rMagics[63] = 138521150466L;
        Board.rookShift[63] = 12;
        for (int i = 0; i < 64; ++i) {
            Board.rookTable[i] = new long[1 << rookShift[i]];
        }
    }

    private final void setBishopMasks() {
        for (int i = 0; i < 64; ++i) {
            Board.bMask[i] = this.getConventionalBishopMoves(i, 0L) & 0x7E7E7E7E7E7E00L;
        }
    }

    private final void setRookMasks() {
        for (int i = 0; i < 64; ++i) {
            Board.rMask[i] = this.getConventionalRookMoves(i, 0L);
            if (i % 8 < 7) {
                int n = i;
                rMask[n] = rMask[n] & 0x7F7F7F7F7F7F7F7FL;
            }
            if (i % 8 > 0) {
                int n = i;
                rMask[n] = rMask[n] & 0xFEFEFEFEFEFEFEFEL;
            }
            if (i / 8 > 0) {
                int n = i;
                rMask[n] = rMask[n] & 0xFFFFFFFFFFFFFF00L;
            }
            if (i / 8 >= 7) continue;
            int n = i;
            rMask[n] = rMask[n] & 0xFFFFFFFFFFFFFFL;
        }
    }

    private final void populateBishopTables() {
        for (int sq = 0; sq < 64; ++sq) {
            long occ = 0L;
            long oset = this.getConventionalBishopMoves(sq, occ) & 0x7E7E7E7E7E7E00L;
            do {
                long attacks;
                int index = (int)(occ * bMagics[sq] >>> 64 - bishopShift[sq]);
                Board.bishopTable[sq][index] = attacks = this.getConventionalBishopMoves(sq, occ);
            } while ((occ = occ - oset & oset) != 0L);
        }
    }

    public final void populateRookTables() {
        for (int sq = 0; sq < 64; ++sq) {
            long occ = 0L;
            long oset = rMask[sq];
            do {
                long attacks;
                int index = (int)(occ * rMagics[sq] >>> 64 - rookShift[sq]);
                Board.rookTable[sq][index] = attacks = this.getConventionalRookMoves(sq, occ);
            } while ((occ = occ - oset & oset) != 0L);
        }
    }

    public final void setBoard(int i, int piece) {
        this.bitboard |= Global.set_Mask[i];
        Board.piece_in_square[i] = piece;
        switch (piece) {
            case 0: {
                ++this.wPieceNo;
                this.whitepieces |= Global.set_Mask[i];
                this.whiterooks |= Global.set_Mask[i];
                materialKey += Global.materialOffset[piece];
                this.totalValue += Global.values[piece];
                break;
            }
            case 1: {
                ++this.wPieceNo;
                this.whitepieces |= Global.set_Mask[i];
                this.whiteknights |= Global.set_Mask[i];
                materialKey += Global.materialOffset[piece];
                this.totalValue += Global.values[piece];
                break;
            }
            case 2: {
                ++this.wPieceNo;
                this.whitepieces |= Global.set_Mask[i];
                this.whitebishops |= Global.set_Mask[i];
                materialKey += Global.materialOffset[piece];
                this.totalValue += Global.values[piece];
                break;
            }
            case 3: {
                ++this.wPieceNo;
                this.materialAdjust = this.QueenMaterialAdjustArray[++this.numberWhiteQueens][this.numberBlackQueens];
                this.whitepieces |= Global.set_Mask[i];
                this.whitequeen |= Global.set_Mask[i];
                materialKey += Global.materialOffset[piece];
                this.totalValue += Global.values[piece];
                break;
            }
            case 4: {
                ++this.wPieceNo;
                this.whitepieces |= Global.set_Mask[i];
                this.whiteking |= Global.set_Mask[i];
                this.pawnsKings |= Global.set_Mask[i];
                break;
            }
            case 5: {
                ++this.wPieceNo;
                this.whitepieces |= Global.set_Mask[i];
                this.whitepawns |= Global.set_Mask[i];
                this.pawnsKings |= Global.set_Mask[i];
                materialKey += Global.materialOffset[piece];
                this.totalValue += Global.values[piece];
                this.pawnHash ^= pHash[i][piece];
                break;
            }
            case 6: {
                ++this.bPieceNo;
                this.blackpieces |= Global.set_Mask[i];
                this.blackrooks |= Global.set_Mask[i];
                materialKey += Global.materialOffset[piece];
                this.totalValue += Global.values[piece];
                break;
            }
            case 7: {
                ++this.bPieceNo;
                this.blackpieces |= Global.set_Mask[i];
                this.blackknights |= Global.set_Mask[i];
                materialKey += Global.materialOffset[piece];
                this.totalValue += Global.values[piece];
                break;
            }
            case 8: {
                ++this.bPieceNo;
                this.blackpieces |= Global.set_Mask[i];
                this.blackbishops |= Global.set_Mask[i];
                materialKey += Global.materialOffset[piece];
                this.totalValue += Global.values[piece];
                break;
            }
            case 9: {
                ++this.bPieceNo;
                this.materialAdjust = this.QueenMaterialAdjustArray[this.numberWhiteQueens][++this.numberBlackQueens];
                this.blackpieces |= Global.set_Mask[i];
                this.blackqueen |= Global.set_Mask[i];
                materialKey += Global.materialOffset[piece];
                this.totalValue += Global.values[piece];
                break;
            }
            case 10: {
                ++this.bPieceNo;
                this.blackpieces |= Global.set_Mask[i];
                this.blackking |= Global.set_Mask[i];
                this.pawnsKings |= Global.set_Mask[i];
                break;
            }
            case 11: {
                ++this.bPieceNo;
                this.blackpieces |= Global.set_Mask[i];
                this.blackpawns |= Global.set_Mask[i];
                this.pawnsKings |= Global.set_Mask[i];
                materialKey += Global.materialOffset[piece];
                this.totalValue += Global.values[piece];
                this.pawnHash ^= pHash[i][piece];
            }
        }
    }

    private final void updateBoard(int i, int j) {
        int piece;
        long bit = 1L << i | 1L << j;
        this.bitboard ^= bit;
        Board.piece_in_square[i] = piece = piece_in_square[j];
        Board.piece_in_square[j] = -1;
        switch (piece) {
            case 0: {
                this.whitepieces ^= bit;
                this.whiterooks ^= bit;
                break;
            }
            case 1: {
                this.whitepieces ^= bit;
                this.whiteknights ^= bit;
                break;
            }
            case 2: {
                this.whitepieces ^= bit;
                this.whitebishops ^= bit;
                break;
            }
            case 3: {
                this.whitepieces ^= bit;
                this.whitequeen ^= bit;
                break;
            }
            case 4: {
                this.whitepieces ^= bit;
                this.whiteking ^= bit;
                this.pawnsKings ^= bit;
                break;
            }
            case 5: {
                this.whitepieces ^= bit;
                this.whitepawns ^= bit;
                this.pawnHash ^= pHash[i][piece];
                this.pawnHash ^= pHash[j][piece];
                this.pawnsKings ^= bit;
                break;
            }
            case 6: {
                this.blackpieces ^= bit;
                this.blackrooks ^= bit;
                break;
            }
            case 7: {
                this.blackpieces ^= bit;
                this.blackknights ^= bit;
                break;
            }
            case 8: {
                this.blackpieces ^= bit;
                this.blackbishops ^= bit;
                break;
            }
            case 9: {
                this.blackpieces ^= bit;
                this.blackqueen ^= bit;
                break;
            }
            case 10: {
                this.blackpieces ^= bit;
                this.blackking ^= bit;
                this.pawnsKings ^= bit;
                break;
            }
            case 11: {
                this.blackpieces ^= bit;
                this.blackpawns ^= bit;
                this.pawnHash ^= pHash[i][piece];
                this.pawnHash ^= pHash[j][piece];
                this.pawnsKings ^= bit;
            }
        }
    }

    public final void clearBoard(int i) {
        this.bitboard ^= Global.set_Mask[i];
        int piece = piece_in_square[i];
        switch (piece) {
            case 0: {
                --this.wPieceNo;
                this.whitepieces ^= Global.set_Mask[i];
                this.whiterooks ^= Global.set_Mask[i];
                materialKey -= Global.materialOffset[piece];
                this.totalValue -= Global.values[piece];
                break;
            }
            case 1: {
                --this.wPieceNo;
                this.whitepieces ^= Global.set_Mask[i];
                this.whiteknights ^= Global.set_Mask[i];
                materialKey -= Global.materialOffset[piece];
                this.totalValue -= Global.values[piece];
                break;
            }
            case 2: {
                --this.wPieceNo;
                this.whitepieces ^= Global.set_Mask[i];
                this.whitebishops ^= Global.set_Mask[i];
                materialKey -= Global.materialOffset[piece];
                this.totalValue -= Global.values[piece];
                break;
            }
            case 3: {
                --this.wPieceNo;
                this.materialAdjust = this.QueenMaterialAdjustArray[--this.numberWhiteQueens][this.numberBlackQueens];
                this.whitepieces ^= Global.set_Mask[i];
                this.whitequeen ^= Global.set_Mask[i];
                materialKey -= Global.materialOffset[piece];
                this.totalValue -= Global.values[piece];
                break;
            }
            case 4: {
                --this.wPieceNo;
                this.whitepieces ^= Global.set_Mask[i];
                this.whiteking ^= Global.set_Mask[i];
                this.pawnsKings ^= Global.set_Mask[i];
                break;
            }
            case 5: {
                --this.wPieceNo;
                this.whitepieces ^= Global.set_Mask[i];
                this.whitepawns ^= Global.set_Mask[i];
                this.pawnsKings ^= Global.set_Mask[i];
                materialKey -= Global.materialOffset[piece];
                this.totalValue -= Global.values[piece];
                this.pawnHash ^= pHash[i][piece];
                break;
            }
            case 6: {
                --this.bPieceNo;
                this.blackpieces ^= Global.set_Mask[i];
                this.blackrooks ^= Global.set_Mask[i];
                materialKey -= Global.materialOffset[piece];
                this.totalValue -= Global.values[piece];
                break;
            }
            case 7: {
                --this.bPieceNo;
                this.blackpieces ^= Global.set_Mask[i];
                this.blackknights ^= Global.set_Mask[i];
                materialKey -= Global.materialOffset[piece];
                this.totalValue -= Global.values[piece];
                break;
            }
            case 8: {
                --this.bPieceNo;
                this.blackpieces ^= Global.set_Mask[i];
                this.blackbishops ^= Global.set_Mask[i];
                materialKey -= Global.materialOffset[piece];
                this.totalValue -= Global.values[piece];
                break;
            }
            case 9: {
                --this.bPieceNo;
                this.materialAdjust = this.QueenMaterialAdjustArray[this.numberWhiteQueens][--this.numberBlackQueens];
                this.blackpieces ^= Global.set_Mask[i];
                this.blackqueen ^= Global.set_Mask[i];
                materialKey -= Global.materialOffset[piece];
                this.totalValue -= Global.values[piece];
                break;
            }
            case 10: {
                --this.bPieceNo;
                this.blackpieces ^= Global.set_Mask[i];
                this.blackking ^= Global.set_Mask[i];
                this.pawnsKings ^= Global.set_Mask[i];
                break;
            }
            case 11: {
                --this.bPieceNo;
                this.blackpieces ^= Global.set_Mask[i];
                this.blackpawns ^= Global.set_Mask[i];
                this.pawnsKings ^= Global.set_Mask[i];
                materialKey -= Global.materialOffset[piece];
                this.totalValue -= Global.values[piece];
                this.pawnHash ^= pHash[i][piece];
            }
        }
        Board.piece_in_square[i] = -1;
    }

    public final int GetRawMaterialScore() {
        return materialValues[materialKey] + this.materialAdjust;
    }

    public final int GetMaterialScore(int side) {
        if (materialValues[materialKey] == 999999) {
            return 0;
        }
        return side * (materialValues[materialKey] + this.materialAdjust);
    }

    public final int getTotalValue() {
        return this.totalValue;
    }

    public int getPos(long pos) {
        return Long.numberOfTrailingZeros(pos);
    }

    public final long getAttackBoard(int i) {
        switch (piece_in_square[i]) {
            case 0: {
                return this.getMagicRookMoves(i);
            }
            case 1: {
                return KnightMoveBoard[i];
            }
            case 2: {
                return this.getMagicBishopMoves(i);
            }
            case 3: {
                return this.getQueenMoves(i);
            }
            case 4: {
                return this.Helper.getKingPosition(i);
            }
            case 5: {
                return WhitePawnAttackBoard[i];
            }
            case 6: {
                return this.getMagicRookMoves(i);
            }
            case 7: {
                return KnightMoveBoard[i];
            }
            case 8: {
                return this.getMagicBishopMoves(i);
            }
            case 9: {
                return this.getQueenMoves(i);
            }
            case 10: {
                return this.Helper.getKingPosition(i);
            }
            case 11: {
                return BlackPawnAttackBoard[i];
            }
        }
        return 0L;
    }

    public final long getAttack2(int i) {
        long attack = this.getMagicBishopMoves(i) & (this.whitebishops | this.blackbishops | this.whitequeen | this.blackqueen);
        attack |= this.getMagicRookMoves(i) & (this.whiterooks | this.blackrooks | this.whitequeen | this.blackqueen);
        attack |= KnightMoveBoard[i] & (this.whiteknights | this.blackknights);
        attack |= this.Helper.getKingPosition(i) & (this.whiteking | this.blackking);
        attack |= WhitePawnAttackBoard[i] & this.blackpawns;
        return attack |= BlackPawnAttackBoard[i] & this.whitepawns;
    }

    public final long getMovesTo(int i) {
        long temp = this.getMagicBishopMoves(i);
        long movers = temp & (this.whitebishops | this.blackbishops | this.whitequeen | this.blackqueen);
        temp = this.getMagicRookMoves(i);
        movers |= temp & (this.whiterooks | this.blackrooks | this.whitequeen | this.blackqueen);
        temp = KnightMoveBoard[i];
        movers |= temp & (this.whiteknights | this.blackknights);
        if (piece_in_square[i] == -1) {
            if (i / 8 > 0) {
                temp = Global.set_Mask[i - 8];
                movers |= temp & this.whitepawns;
                if (i / 8 == 3 && piece_in_square[i - 8] == -1) {
                    temp = Global.set_Mask[i - 16];
                    movers |= temp & this.whitepawns;
                }
            }
            if (i / 8 < 7) {
                temp = Global.set_Mask[i + 8];
                movers |= temp & this.blackpawns;
                if (i / 8 == 4 && piece_in_square[i + 8] == -1) {
                    temp = Global.set_Mask[i + 16];
                    movers |= temp & this.blackpawns;
                }
            }
        }
        return movers;
    }

    public final boolean isWhiteAttacked(int i) {
        if ((WhitePawnAttackBoard[i] & this.blackpawns) != 0L) {
            return true;
        }
        if ((this.getMagicBishopMoves(i) & (this.blackbishops | this.blackqueen)) != 0L) {
            return true;
        }
        if ((this.getMagicRookMoves(i) & (this.blackrooks | this.blackqueen)) != 0L) {
            return true;
        }
        if ((KnightMoveBoard[i] & this.blackknights) != 0L) {
            return true;
        }
        return (this.Helper.getKingPosition(i) & this.blackking) != 0L;
    }

    public final boolean isBlackAttacked(int i) {
        if ((BlackPawnAttackBoard[i] & this.whitepawns) != 0L) {
            return true;
        }
        if ((this.getMagicBishopMoves(i) & (this.whitebishops | this.whitequeen)) != 0L) {
            return true;
        }
        if ((this.getMagicRookMoves(i) & (this.whiterooks | this.whitequeen)) != 0L) {
            return true;
        }
        if ((KnightMoveBoard[i] & this.whiteknights) != 0L) {
            return true;
        }
        return (this.Helper.getKingPosition(i) & this.whiteking) != 0L;
    }

    public final int[] getPiecesInSquare() {
        return piece_in_square;
    }

    private final long rotate45R(long board) {
        long rotate = 0L;
        for (int i = 0; i < 64; ++i) {
            int index = R45Convert[i];
            long bit = Global.set_Mask[index];
            if (((bit &= board) >> index & 1L) != 1L) continue;
            rotate += Global.set_Mask[i];
        }
        return rotate;
    }

    private final long rotate45L(long board) {
        long rotate = 0L;
        for (int i = 0; i < 64; ++i) {
            int index = L45Convert[i];
            long bit = 1L << index;
            if (((bit &= board) >> index & 1L) != 1L) continue;
            rotate += 1L << i;
        }
        return rotate;
    }

    private final long rotate90R(long board) {
        long rotate = 0L;
        for (int i = 0; i < 64; ++i) {
            long bit = Global.set_Mask[i];
            if (((bit &= board) >> i & 1L) != 1L) continue;
            rotate += Global.set_Mask[R90Update[i]];
        }
        return rotate;
    }

    public final int getPassantW() {
        return this.passantW;
    }

    public final int getPassantB() {
        return this.passantB;
    }

    public final boolean whiteHasCastled() {
        return this.wCastle == 1;
    }

    public final boolean blackHasCastled() {
        return this.bCastle == 1;
    }

    private final void InitBlackPawnAttackBoard(long[] board) {
        for (int square = 63; square > 7; --square) {
            if (square % 8 == 0) {
                board[square] = 1L << square - 7;
                continue;
            }
            if (square % 8 == 7) {
                board[square] = 1L << square - 9;
                continue;
            }
            board[square] = 1L << square - 7;
            int n = square;
            board[n] = board[n] | 1L << square - 9;
        }
    }

    private final void InitBlackPawnMoveBoard(long[] board) {
        for (int square = 55; square > 7; --square) {
            if (square >= 48) {
                int n = square;
                board[n] = board[n] | 1L << square - 16;
            }
            int n = square;
            board[n] = board[n] | 1L << square - 8;
        }
    }

    private final void InitWhitePawnMoveBoard(long[] board) {
        for (int square = 0; square <= 55; ++square) {
            if (square >= 8 && square <= 15) {
                int n = square;
                board[n] = board[n] | 1L << square + 16;
            }
            int n = square;
            board[n] = board[n] | 1L << square + 8;
        }
    }

    private final void InitWhitePawnAttackBoard(long[] board) {
        for (int square = 0; square < 56; ++square) {
            if (square % 8 == 0) {
                board[square] = 1L << square + 9;
                continue;
            }
            if (square % 8 == 7) {
                board[square] = 1L << square + 7;
                continue;
            }
            board[square] = 1L << square + 7;
            int n = square;
            board[n] = board[n] | 1L << square + 9;
        }
    }

    public final long getWPawnAttack(int index) {
        return WhitePawnAttackBoard[index];
    }

    public final long getBPawnAttack(int index) {
        return BlackPawnAttackBoard[index];
    }

    public final long getWPawnMoves(int index) {
        long moves = WhitePawnMoveBoard[index];
        if ((this.bitboard & Global.set_Mask[index + 8]) != 0L) {
            moves = 0L;
        } else if (index < 16 && (moves & this.bitboard) != 0L) {
            moves = Global.set_Mask[index + 8];
        }
        return moves | WhitePawnAttackBoard[index] & (this.blackpieces | Global.set_Mask[this.passantB]);
    }

    public final long getBPawnMoves(int index) {
        long moves = BlackPawnMoveBoard[index];
        if ((this.bitboard & Global.set_Mask[index - 8]) != 0L) {
            moves = 0L;
        } else if (index > 47 && (moves & this.bitboard) != 0L) {
            moves = Global.set_Mask[index - 8];
        }
        return moves | BlackPawnAttackBoard[index] & (this.whitepieces | Global.set_Mask[this.passantW]);
    }

    private final void InitKnightMoveBoard(long[] board) {
        for (int square = 0; square < 64; ++square) {
            if (square - 17 >= 0) {
                board[square] = 1L << square - 17;
            }
            if (square - 15 >= 0) {
                int n = square;
                board[n] = board[n] | 1L << square - 15;
            }
            if (square - 10 >= 0) {
                int n = square;
                board[n] = board[n] | 1L << square - 10;
            }
            if (square - 6 >= 0) {
                int n = square;
                board[n] = board[n] | 1L << square - 6;
            }
            if (square + 6 <= 63) {
                int n = square;
                board[n] = board[n] | 1L << square + 6;
            }
            if (square + 10 <= 63) {
                int n = square;
                board[n] = board[n] | 1L << square + 10;
            }
            if (square + 15 <= 63) {
                int n = square;
                board[n] = board[n] | 1L << square + 15;
            }
            if (square + 17 <= 63) {
                int n = square;
                board[n] = board[n] | 1L << square + 17;
            }
            if (square % 8 <= 1) {
                if (square + 6 <= 63) {
                    int n = square;
                    board[n] = board[n] ^ 1L << square + 6;
                }
                if (square - 10 >= 0) {
                    int n = square;
                    board[n] = board[n] ^ 1L << square - 10;
                }
            }
            if (square % 8 == 0) {
                if (square + 15 <= 63) {
                    int n = square;
                    board[n] = board[n] ^ 1L << square + 15;
                }
                if (square - 17 >= 0) {
                    int n = square;
                    board[n] = board[n] ^ 1L << square - 17;
                }
            }
            if (square % 8 >= 6) {
                if (square - 6 >= 0) {
                    int n = square;
                    board[n] = board[n] ^ 1L << square - 6;
                }
                if (square + 10 <= 63) {
                    int n = square;
                    board[n] = board[n] ^ 1L << square + 10;
                }
            }
            if (square % 8 != 7) continue;
            if (square + 17 <= 63) {
                int n = square;
                board[n] = board[n] ^ 1L << square + 17;
            }
            if (square - 15 < 0) continue;
            int n = square;
            board[n] = board[n] ^ 1L << square - 15;
        }
    }

    public final long getWKnightMoves(int index) {
        return KnightMoveBoard[index] & (this.whitepieces ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final long getBKnightMoves(int index) {
        return KnightMoveBoard[index] & (this.blackpieces ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final long getKnightMoves(int index) {
        return KnightMoveBoard[index];
    }

    public final long getBKingCastle(int index) {
        long Temp = this.Helper.getKingCastle((int)(this.bitboard >>> 56));
        long castle = 0L;
        if ((Temp & Global.set_Mask[2]) != 0L && !this.isBlackAttacked(58) && !this.isBlackAttacked(59)) {
            castle |= Global.set_Mask[58];
        }
        if ((Temp & Global.set_Mask[6]) != 0L && !this.isBlackAttacked(61) && !this.isBlackAttacked(62)) {
            castle |= Global.set_Mask[62];
        }
        return castle;
    }

    public final long getWKingCastle(int index) {
        long Temp = this.Helper.getKingCastle((int)this.bitboard & 0xFF);
        if ((Temp & Global.set_Mask[2]) != 0L && (this.isWhiteAttacked(2) || this.isWhiteAttacked(3))) {
            Temp &= Global.set_Mask[6];
        }
        if ((Temp & Global.set_Mask[6]) != 0L && (this.isWhiteAttacked(5) || this.isWhiteAttacked(6))) {
            Temp &= Global.set_Mask[2];
        }
        return Temp;
    }

    public final long getBKingMoves(int index) {
        long kingPos = this.Helper.getKingPosition(index);
        return kingPos & (this.blackpieces ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final long getWKingMoves(int index) {
        long kingPos = this.Helper.getKingPosition(index);
        return kingPos &= this.whitepieces ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public final long getWRookMoves(int index) {
        long moves = this.getRookMoves(index, 0);
        return moves & (this.whitepieces ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final long getBRookMoves(int index) {
        long moves = this.getRookMoves(index, 0);
        return moves & (this.blackpieces ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final long getWBishopMoves(int index) {
        long moves = this.getBishopMoves(index, 0);
        return moves & (this.whitepieces ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final long getBBishopMoves(int index) {
        long moves = this.getBishopMoves(index, 0);
        return moves & (this.blackpieces ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final long getWQueenMoves(int index) {
        long moves = this.getQueenMoves(index);
        return moves & (this.whitepieces ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final long getBQueenMoves(int index) {
        long moves = this.getQueenMoves(index);
        return moves & (this.blackpieces ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private final long getRookMoves(int index, int relation) {
        int Decimal;
        long sRank;
        long temp = 0L;
        if (relation != 2) {
            sRank = this.bitboard >> ShiftRank[index];
            Decimal = (int)(sRank & 0xFFL);
            temp = this.Helper.getRooksRank2(index, Decimal);
        }
        if (relation != 1) {
            sRank = this.Board90R >> ShiftFile[index];
            Decimal = (int)(sRank & 0xFFL);
            temp |= this.Helper.getRooksFile2(index, Decimal);
        }
        return temp;
    }

    private final long getConventionalRookMoves(int index, long occ) {
        long temp = 0L;
        long sRank = occ >> ShiftRank[index];
        int Decimal = (int)(sRank & 0xFFL);
        temp = this.Helper.getRooksRank2(index, Decimal);
        sRank = this.rotate90R(occ) >> ShiftFile[index];
        Decimal = (int)(sRank & 0xFFL);
        return temp |= this.Helper.getRooksFile2(index, Decimal);
    }

    public final long getMagicRookMoves(int index) {
        long occ = this.bitboard & rMask[index];
        occ *= rMagics[index];
        return rookTable[index][(int)(occ >>>= 64 - rookShift[index])];
    }

    private final long getBishopMoves(int index, int relation) {
        if (relation == 3) {
            int temp45 = (int)(this.Board45L >> ShiftL[index]);
            return this.Helper.getDiag1Attack(index, temp45 & 0xFF);
        }
        if (relation == 4) {
            int temp45 = (int)(this.Board45R >> ShiftR[index]);
            return this.Helper.getDiag2Attack(index, temp45 & 0xFF);
        }
        int temp45 = (int)(this.Board45L >> ShiftL[index]);
        long tempD = this.Helper.getDiag1Attack(index, temp45 & 0xFF);
        temp45 = (int)(this.Board45R >> ShiftR[index]);
        return tempD |= this.Helper.getDiag2Attack(index, temp45 & 0xFF);
    }

    private final long getConventionalBishopMoves(int index, long occ) {
        long right45 = this.rotate45R(occ);
        long left45 = this.rotate45L(occ);
        int temp45 = (int)(left45 >>> ShiftL[index]);
        long tempD = this.Helper.getDiag1Attack(index, temp45 & 0xFF);
        temp45 = (int)(right45 >>> ShiftR[index]);
        return tempD |= this.Helper.getDiag2Attack(index, temp45 & 0xFF);
    }

    public final long getMagicBishopMoves(int index) {
        long occ = this.bitboard & bMask[index];
        occ *= bMagics[index];
        return bishopTable[index][(int)(occ >>>= 64 - bishopShift[index])];
    }

    public final long getQueenMoves(int index) {
        return this.getMagicBishopMoves(index) | this.getMagicRookMoves(index);
    }

    public final void switchTurn() {
        this.hashValue ^= this.bHashMove;
        this.turn = -this.turn;
    }

    public final int getMaxNumberOfPieces() {
        if (this.wPieceNo > this.bPieceNo) {
            return this.wPieceNo;
        }
        return this.bPieceNo;
    }

    public final int getMinNumberOfPieces() {
        if (this.wPieceNo < this.bPieceNo) {
            return this.wPieceNo;
        }
        return this.bPieceNo;
    }

    public final int getNumberOfPieces(int side) {
        if (side == -1) {
            return this.wPieceNo;
        }
        return this.bPieceNo;
    }

    public int AddRepetitionRoot() {
        this.iCurrentMovesDepth = 0;
        if (this.reversable) {
            ++this.zorbistDepth;
            Board.zorbistHistory[this.zorbistDepth] = this.hashValue;
            Board.lastReversableMove[this.zorbistDepth] = lastReversableMove[this.zorbistDepth - 1];
            if (this.zorbistDepth - lastReversableMove[this.zorbistDepth] >= 100) {
                return 3;
            }
            int count = 1;
            for (int i = this.zorbistDepth - 2; i >= lastReversableMove[this.zorbistDepth]; i -= 2) {
                if (zorbistHistory[i] != this.hashValue) continue;
                ++count;
            }
            return count;
        }
        this.zorbistDepth = 1;
        Board.zorbistHistory[this.zorbistDepth] = this.hashValue;
        Board.lastReversableMove[this.zorbistDepth] = lastReversableMove[this.zorbistDepth - 1];
        return 1;
    }

    public int AddRepetition() {
        if (this.reversable) {
            ++this.zorbistDepth;
            Board.zorbistHistory[this.zorbistDepth] = this.hashValue;
            Board.lastReversableMove[this.zorbistDepth] = lastReversableMove[this.zorbistDepth - 1];
            if (this.zorbistDepth - lastReversableMove[this.zorbistDepth] >= 100) {
                return 3;
            }
            int count = 1;
            for (int i = this.zorbistDepth - 2; i >= lastReversableMove[this.zorbistDepth]; i -= 2) {
                if (zorbistHistory[i] != this.hashValue) continue;
                ++count;
            }
            return count;
        }
        ++this.zorbistDepth;
        Board.zorbistHistory[this.zorbistDepth] = this.hashValue;
        Board.lastReversableMove[this.zorbistDepth] = this.zorbistDepth;
        return 1;
    }

    public final void AddMove(int move) {
        int to = move >> 6 & 0x3F;
        int from = move & 0x3F;
        Board.boardMoves[this.moveCount] = move;
        this.writer.addHistory(to, from, this.moveCount);
    }

    public int GetMoveAtDepth(int depth) {
        return arrCurrentMoves[depth];
    }

    public final int MakeMove(int move, boolean board) {
        int to = move >> 6 & 0x3F;
        int from = move & 0x3F;
        int type = move >> 20 & 0xF;
        int thePiece = move >> 12 & 0xF;
        int cP = (move >> 16 & 0xF) - 1;
        Board.arrCurrentMoves[this.iCurrentMovesDepth] = move;
        ++this.iCurrentMovesDepth;
        this.reversable = true;
        this.hashHistory[this.moveCount] = this.hashValue;
        this.flagHistory[this.moveCount] = this.passantW | this.passantB << 6 | this.wCastle << 12 | this.bCastle << 15;
        this.turn = -this.turn;
        this.hashValue ^= this.bHashMove;
        ++this.moveCount;
        int oldPassantW = this.passantW;
        int oldPassantB = this.passantB;
        this.passantW = 51;
        this.passantB = 3;
        switch (type) {
            case 0: {
                if (cP != -1) {
                    if (thePiece == 4) {
                        if (this.wCastle > 1) {
                            this.hashValue ^= wCastleHash[this.wCastle];
                            this.wCastle = 0;
                            this.hashValue ^= wCastleHash[this.wCastle];
                        }
                    } else if (thePiece == 10) {
                        if (this.bCastle > 1) {
                            this.hashValue ^= bCastleHash[this.bCastle];
                            this.bCastle = 0;
                            this.hashValue ^= bCastleHash[this.bCastle];
                        }
                    } else {
                        this.UpdateCastleFlags(thePiece, to, from);
                    }
                    this.reversable = false;
                    this.clearBoard(to);
                    this.hashValue ^= pHash[to][cP];
                    break;
                }
                switch (thePiece) {
                    case 5: {
                        this.reversable = false;
                        break;
                    }
                    case 11: {
                        this.reversable = false;
                        break;
                    }
                    case 0: {
                        if (this.wCastle <= 1) break;
                        if (from == 7) {
                            this.hashValue ^= wCastleHash[this.wCastle];
                            this.wCastle &= 4;
                            this.hashValue ^= wCastleHash[this.wCastle];
                            break;
                        }
                        if (from != 0) break;
                        this.hashValue ^= wCastleHash[this.wCastle];
                        this.wCastle &= 2;
                        this.hashValue ^= wCastleHash[this.wCastle];
                        break;
                    }
                    case 6: {
                        if (this.bCastle <= 1) break;
                        if (from == 63) {
                            this.hashValue ^= bCastleHash[this.bCastle];
                            this.bCastle &= 4;
                            this.hashValue ^= bCastleHash[this.bCastle];
                            break;
                        }
                        if (from != 56) break;
                        this.hashValue ^= bCastleHash[this.bCastle];
                        this.bCastle &= 2;
                        this.hashValue ^= bCastleHash[this.bCastle];
                        break;
                    }
                    case 4: {
                        if (this.wCastle <= 1) break;
                        this.hashValue ^= wCastleHash[this.wCastle];
                        this.wCastle = 0;
                        this.hashValue ^= wCastleHash[this.wCastle];
                        break;
                    }
                    case 10: {
                        if (this.bCastle <= 1) break;
                        this.hashValue ^= bCastleHash[this.bCastle];
                        this.bCastle &= 0;
                        this.hashValue ^= bCastleHash[this.bCastle];
                    }
                }
                break;
            }
            case 1: {
                this.reversable = false;
                if (thePiece == 5) {
                    this.clearBoard(to - 8);
                    this.hashValue ^= pHash[to - 8][11];
                    break;
                }
                this.clearBoard(to + 8);
                this.hashValue ^= pHash[to + 8][5];
                break;
            }
            case 2: {
                this.reversable = false;
                if (thePiece == 4) {
                    this.hashValue ^= wCastleHash[this.wCastle];
                    this.wCastle = 1;
                    this.hashValue ^= wCastleHash[this.wCastle];
                    this.updateBoard(5, 7);
                    this.hashValue ^= pHash[5][0];
                    this.hashValue ^= pHash[7][0];
                    break;
                }
                this.hashValue ^= bCastleHash[this.bCastle];
                this.bCastle = 1;
                this.hashValue ^= bCastleHash[this.bCastle];
                this.updateBoard(61, 63);
                this.hashValue ^= pHash[61][6];
                this.hashValue ^= pHash[63][6];
                break;
            }
            case 3: {
                this.reversable = false;
                this.clearBoard(from);
                this.hashValue ^= pHash[from][thePiece];
                this.setBoard(from, thePiece - 2);
                this.hashValue ^= pHash[from][thePiece - 2];
                if (cP == -1) break;
                this.UpdateCastleFlags(thePiece, to, from);
                this.clearBoard(to);
                this.hashValue ^= pHash[to][cP];
                break;
            }
            case 4: {
                this.reversable = false;
                if (thePiece == 4) {
                    this.hashValue ^= wCastleHash[this.wCastle];
                    this.wCastle = 1;
                    this.hashValue ^= wCastleHash[this.wCastle];
                    this.updateBoard(3, 0);
                    this.hashValue ^= pHash[3][0];
                    this.hashValue ^= pHash[0][0];
                    break;
                }
                this.hashValue ^= bCastleHash[this.bCastle];
                this.bCastle = 1;
                this.hashValue ^= bCastleHash[this.bCastle];
                this.updateBoard(59, 56);
                this.hashValue ^= pHash[56][6];
                this.hashValue ^= pHash[59][6];
                break;
            }
            case 5: {
                this.reversable = false;
                this.clearBoard(from);
                this.hashValue ^= pHash[from][thePiece];
                this.setBoard(from, thePiece - 4);
                this.hashValue ^= pHash[from][thePiece - 4];
                if (cP == -1) break;
                this.UpdateCastleFlags(thePiece, to, from);
                this.clearBoard(to);
                this.hashValue ^= pHash[to][cP];
                break;
            }
            case 6: {
                this.reversable = false;
                this.clearBoard(from);
                this.hashValue ^= pHash[from][thePiece];
                this.setBoard(from, thePiece - 5);
                this.hashValue ^= pHash[from][thePiece - 5];
                if (cP == -1) break;
                this.UpdateCastleFlags(thePiece, to, from);
                this.clearBoard(to);
                this.hashValue ^= pHash[to][cP];
                break;
            }
            case 7: {
                this.reversable = false;
                this.clearBoard(from);
                this.hashValue ^= pHash[from][thePiece];
                this.setBoard(from, thePiece - 3);
                this.hashValue ^= pHash[from][thePiece - 3];
                if (cP == -1) break;
                this.UpdateCastleFlags(thePiece, to, from);
                this.clearBoard(to);
                this.hashValue ^= pHash[to][cP];
                break;
            }
            case 8: {
                this.reversable = false;
                this.passantW = to - 8;
                break;
            }
            case 9: {
                this.reversable = false;
                this.passantB = from - 8;
            }
        }
        this.hashValue ^= pHash[from][piece_in_square[from]];
        this.hashValue ^= pHash[to][piece_in_square[from]];
        this.updateBoard(to, from);
        if (oldPassantW != this.passantW) {
            this.hashValue ^= passantHashW[oldPassantW % 9];
            this.hashValue ^= passantHashW[this.passantW % 9];
        }
        if (oldPassantB != this.passantB) {
            this.hashValue ^= passantHashB[oldPassantB % 9];
            this.hashValue ^= passantHashB[this.passantB % 9];
        }
        if (board) {
            return this.AddRepetition();
        }
        return 1;
    }

    public final void UpdateCastleFlags(int thePiece, int to, int from) {
        if (this.wCastle > 1) {
            if (to == 7 || from == 7) {
                this.hashValue ^= wCastleHash[this.wCastle];
                this.wCastle &= 4;
                this.hashValue ^= wCastleHash[this.wCastle];
            } else if (to == 0 || from == 0) {
                this.hashValue ^= wCastleHash[this.wCastle];
                this.wCastle &= 2;
                this.hashValue ^= wCastleHash[this.wCastle];
            }
        }
        if (this.bCastle > 1) {
            if (to == 63 || from == 63) {
                this.hashValue ^= bCastleHash[this.bCastle];
                this.bCastle &= 4;
                this.hashValue ^= bCastleHash[this.bCastle];
            } else if (to == 56 || from == 56) {
                this.hashValue ^= bCastleHash[this.bCastle];
                this.bCastle &= 2;
                this.hashValue ^= bCastleHash[this.bCastle];
            }
        }
    }

    public final int getDraw() {
        return this.drawCount;
    }

    public final int getCount() {
        return this.moveCount;
    }

    public final int getTurn() {
        return this.turn;
    }

    public final void UnMake(int move, boolean board) {
        if (board) {
            --this.zorbistDepth;
        }
        this.turn = -this.turn;
        --this.moveCount;
        this.wCastle = this.flagHistory[this.moveCount] >> 12 & 7;
        this.bCastle = this.flagHistory[this.moveCount] >> 15 & 7;
        --this.iCurrentMovesDepth;
        int to = move >> 6 & 0x3F;
        int from = move & 0x3F;
        int type = move >> 20 & 0xF;
        int piece = move >> 12 & 0xF;
        int capPiece = (move >> 16 & 0xF) - 1;
        switch (type) {
            case 0: {
                this.updateBoard(from, to);
                if (capPiece == -1) break;
                this.setBoard(to, capPiece);
                break;
            }
            case 1: {
                this.updateBoard(from, to);
                if (piece == 5) {
                    this.setBoard(to - 8, 11);
                    break;
                }
                this.setBoard(to + 8, 5);
                break;
            }
            case 2: {
                this.updateBoard(from, to);
                if (piece == 4) {
                    this.updateBoard(7, 5);
                    break;
                }
                this.updateBoard(63, 61);
                break;
            }
            case 3: {
                this.clearBoard(to);
                this.setBoard(to, piece);
                this.updateBoard(from, to);
                if (capPiece == -1) break;
                this.setBoard(to, capPiece);
                break;
            }
            case 4: {
                this.updateBoard(from, to);
                if (piece == 4) {
                    this.updateBoard(0, 3);
                    break;
                }
                this.updateBoard(56, 59);
                break;
            }
            case 5: {
                this.clearBoard(to);
                this.setBoard(to, piece);
                this.updateBoard(from, to);
                if (capPiece == -1) break;
                this.setBoard(to, capPiece);
                break;
            }
            case 6: {
                this.clearBoard(to);
                this.setBoard(to, piece);
                this.updateBoard(from, to);
                if (capPiece == -1) break;
                this.setBoard(to, capPiece);
                break;
            }
            case 7: {
                this.clearBoard(to);
                this.setBoard(to, piece);
                this.updateBoard(from, to);
                if (capPiece == -1) break;
                this.setBoard(to, capPiece);
                break;
            }
            case 8: {
                this.updateBoard(from, to);
                break;
            }
            case 9: {
                this.updateBoard(from, to);
            }
        }
        this.hashValue = this.hashHistory[this.moveCount];
        this.passantW = this.flagHistory[this.moveCount] & 0x3F;
        this.passantB = this.flagHistory[this.moveCount] >> 6 & 0x3F;
    }
}

