#ifndef SEARCH_H
#define SEARCH_H

#include <math.h>
#include "position.h"

const int MAX_PLY = 64;
const int MAX_BRANCH = 128;

struct MultiPVEntry
{
  vector<Move> m_pv;
  EVAL m_score;
  bool m_seen;
};

struct HashEntry
{
  U8   age;
  I8   depth;
  EVAL eval;
  U32  hashLock;
  Move mv;
  U8   type;
};

enum MODE_T
{
  IDLE = 0, 
  ANALYZE = 1, 
  THINKING = 2, 
  EPDTEST = 3
};
extern MODE_T g_mode;
extern int g_multipv_size;
extern vector<Move> g_rootPV;

struct Limits
{
  int   m_restMillisec;
  int   m_sd;
  int   m_inc;    // milliseconds
  NODES m_sn;
  int   m_stSoft; // milliseconds
  int   m_stHard; // milliseconds
};

extern bool g_limitStrength;
extern int g_npsLimit;

void        Epdtest(FILE* psrc, double time_in_seconds, int reps);
HashEntry*  ProbeHash(const Position* pos);
void        RecordHash(const Position* pos, Move best_mv, I8 depth, EVAL eval, U8 type, int ply);
EVAL        SEE(const Position& pos, Move mv);
void        SetElo(int rating);
void        SetHashMB(double mb);
void        SetLimits(int restMillisec, int sd, NODES sn, int stHard, int stSoft);
void        StartAnalyze(const Position& pos0);
int         StartEpd(const Position& pos, const char* fen, int reps, int* ptotal, int* psolved, double* psec);
void        StartThinking(Position& pos0);
void        StartPerft(const Position& pos0, int depth);

const EVAL SORT_HASH       = 0x40000000;
const EVAL SORT_CAPTURE    = 0x20000000;
const EVAL SORT_MATEKILLER = 0x18000000;
const EVAL SORT_KILLER     = 0x10000000;
const EVAL MAX_HISTORY     = 0x0fffffff;

#endif

