/* GNU Chess 5.0 - solve.c - position solving code
   Copyright (c) 1999-2002 Free Software Foundation, Inc.

   GNU Chess is based on the two research programs 
   Cobalt by Chua Kong-Sian and Gazebo by Stuart Cracraft.

   GNU Chess is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GNU Chess is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Chess; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     bug-gnu-chess@gnu.org
     cracraft@ai.mit.edu, cracraft@stanfordalumni.org, cracraft@earthlink.net
*/
/* 
 *
 */

#include <stdio.h>
#include <string.h>
#include "util.h"
#include "epd.h"
#include "searchparams.h"
#include "searchstats.h"
#include "iterate.h"
#include "move.h"

void Solve (char *file, searchparams_t *searchparams)
/*****************************************************************************
 *
 *
 *
 *****************************************************************************/
{

   int total, correct, found;
   long TotalNodes;
   char *p;
   board_t board[1];
   searchstats_t searchstats[1];
   char bm[MAXSTR];
   char id[MAXSTR];
   char SANmv[SANSZ];
   epd_iter_t epd_iter[1];


   total = correct = 0;
   TotalNodes = 0;
   EPDIterInit(epd_iter);
   EPDIterStart(epd_iter,file);
   if(searchparams->ST==0){
       searchparams->ST=10;
   }
   while (!(Protocol->state_flags & QUIT) && EPDIterNext(epd_iter,board,id,bm)) {
     SearchStatsInit(searchstats);
     total++;
     BoardShow (board); 
     Iterate (board,searchparams,searchstats);
     TotalNodes += searchstats->NodeCnt + searchstats->QuiesCnt;
     MoveToSAN(board,searchstats->RootPV,SANmv);
     p = bm;
     found = false;
     while (*p != '\0'){
       if (!strncmp (p, SANmv, strlen(SANmv))) {
	 correct++;
	 found = true;
	 break;
       }
       while (*p != ' ' && *p != '\0'){ p++; }
       while (*p == ' ' && *p != '\0'){ p++; }
     }
     Output ("%s : ", id);
     Output (found ? "Correct:  " : "Incorrect:  ");
     Output ("%s %s\n", SANmv, bm);
     Output ("Correct=%d Total=%d\n", correct, total);
   }
   Output ("\nTotal nodes = %ld\n", TotalNodes);
}

