/* GNU Chess 5.0 - book.h - book symbolic definitions
   Copyright (c) 1999-2002 Free Software Foundation, Inc.

   GNU Chess is based on the two research programs 
   Cobalt by Chua Kong-Sian and Gazebo by Stuart Cracraft.

   GNU Chess is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GNU Chess is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Chess; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     bug-gnu-chess@gnu.org
     cracraft@ai.mit.edu, cracraft@stanfordalumni.org, cracraft@earthlink.net
*/

// includes

#include "moveseq.h"

// defines

#ifndef SEARCHSTATS_H
#define SEARCHSTATS_H

// types

typedef struct
{
    unsigned long NodeCnt;
    unsigned long QuiesCnt;
    unsigned long EvalCnt;
    unsigned long EvalMatCnt;
    unsigned long EvalLazyCnt;
    unsigned long EvalFullCnt;
    unsigned long OneRepCnt;
    unsigned long ChkExtCnt;
    unsigned long RcpExtCnt;
    unsigned long PawnExtCnt;
    unsigned long PawnConvExtCnt;
    unsigned long HorzExtCnt;
    unsigned long ThrtExtCnt;
    unsigned long KingExtCnt;;
    unsigned long NullCutCnt;
    unsigned long NullFailLowCnt;
    unsigned long TransThreatCnt;
    unsigned long FutlCutCnt;
    unsigned long BetaCutCnt;
    unsigned long BetaCutMoveCnt;
    unsigned long LMRRedCnt;
    unsigned long LMRFailHighCnt;
    unsigned long RazrCutCnt;
    unsigned long GenCnt;
    unsigned long SearchInconsistencyCnt;
    unsigned long PVSFailCnt;
    unsigned long DangerousNodeCnt;
    int RootPV;
    int RootPVScore;
    float ElapsedTime;
    moveseq_t RootPVSeq[1];
} searchstats_t;

// functions

void SearchStatsInit(searchstats_t *searchstats);
void SearchStatsShow(searchstats_t *searchstats);

#endif /* SEARCHSTATS_H */
