#include "searchstats.h"
#include "util.h"
#include "string.h"

void SearchStatsInit(searchstats_t *searchstats){
    memset(searchstats,0,sizeof(searchstats_t));
}

void SearchStatsShow(searchstats_t *searchstats){
    OutputConsole("\
*Nodes=(n=%uk,q=%uk,t=%uk) ET=%.2fs NPS=%dk/s Eval=(m=%uk,l=%uk,f=%uk,t=%uk)\n\
*Ext=(check=%uk onerep=%uk pawn=%uk pawnconv=%uk)\n\
*Cut=(null=%uk, nullfl=%uk transtr=%uk fut=%uk,razor=%uk beta=%uk)\n\
*Red=(LMR=%uk)\n\
*Eff=%.2f Incons=%u Dang=%uk LMRfh=%uk PVSfh=%uk\n\
",
		  searchstats->NodeCnt/1000,
		  searchstats->QuiesCnt/1000,
		  (searchstats->NodeCnt+searchstats->QuiesCnt)/1000,
		  searchstats->ElapsedTime,
		  (int)((searchstats->NodeCnt+searchstats->QuiesCnt)/(1000*searchstats->ElapsedTime)),
		  searchstats->EvalMatCnt/1000,
		  searchstats->EvalLazyCnt/1000,
		  searchstats->EvalFullCnt/1000,
		  (searchstats->EvalMatCnt+searchstats->EvalLazyCnt+searchstats->EvalFullCnt)/1000,
		  searchstats->ChkExtCnt/1000,
		  searchstats->OneRepCnt/1000,
		  searchstats->PawnExtCnt/1000,
		  searchstats->PawnConvExtCnt/1000,
		  searchstats->NullCutCnt/1000,
		  searchstats->NullFailLowCnt/1000,
		  searchstats->TransThreatCnt/1000,
		  searchstats->FutlCutCnt/1000,
		  searchstats->RazrCutCnt/1000,
		  searchstats->BetaCutCnt/1000,
		  searchstats->LMRRedCnt/1000,
		  ((double)searchstats->BetaCutMoveCnt)/((double) searchstats->BetaCutCnt),
		  searchstats->SearchInconsistencyCnt,
		  searchstats->DangerousNodeCnt/1000,
		  searchstats->LMRFailHighCnt/1000,
		  searchstats->PVSFailCnt/1000
		  
	   ); 
}
