#include "searchparams.h"
#include "util.h"
#include "protocol.h"
#include "option.h"
#include "uci.h"

void SearchParamsCreate(searchparams_t *searchparams, 
			protocol_t *protocol){
    board_t board[1];
    BoardFromGame(board,protocol->game,BOARD_LAST);
    searchparams->protocol=PROTOCOL_XBOARD;
    searchparams->TCinc=(float) protocol->TCinc;
    searchparams->SearchDepth=protocol->SearchDepth;
    searchparams->timelimit=protocol->TimeLimit[board->side];
    searchparams->NPS=protocol->NPS;
    searchparams->ST=protocol->ST;
    searchparams->SearchTime=0.0;
    searchparams->maxtime=0.0;
    searchparams->infinite=false;
    searchparams->ponder=false;
    searchparams->post=(protocol->state_flags & POST)?true:false;
    if(protocol->TCMove){
	searchparams->movestogo=(protocol->NextPeriod-board->GameCnt+1)/2;
    }else{
	searchparams->movestogo=0;
    }

}

void SearchParamsCreateUci(searchparams_t *searchparams,
			   uci_t *uci){
    searchparams->protocol=PROTOCOL_UCI;
    searchparams->movestogo=uci->movestogo;
    searchparams->timelimit=((float)(uci->board->side==white?uci->wtime:uci->btime))/1000;
    searchparams->TCinc=((float)(uci->board->side==white?uci->winc:uci->binc))/1000;
    searchparams->ST=((float) uci->movetime)/1000;
    searchparams->SearchDepth=uci->depth;
    // This is not quite right but for the moment we don't ponder!
    searchparams->infinite=uci->infinite;
    searchparams->ponder=uci->ponder;
    if(uci->ponder){
	searchparams->infinite=true;
    }
}
