#ifndef SEARCHDATA_H
#define SEARCHDATA_H

// includes

#include <setjmp.h>
#include "util.h"
#include "board.h"
#include "moveseq.h"
#include "timer.h"
#include "history.h"

// types

typedef struct{

    /* for timeouts */
    jmp_buf rootpointer;
    
    int RootDepth;
    int RootScore;
    int RootAlpha;
    int RootBeta;
    int RootState;
    board_t *RootBoard;

    /* periodic updates */
    int  RootMoves;
    int  RootMovesRemaining;
    char RootMoveCurrent[SANSZ];
    char RootMoveCurrentLAN[SANSZ];
    
    timer__t timer[1];
    history_t history[1];
    int lazydiff[2];
    int posdiff[2];
    
    int killer1[MAXPLYDEPTH];
    int killer2[MAXPLYDEPTH];
    int ChkCnt[MAXPLYDEPTH]; /* counts the number of checks extensions up to now */
    short InChk[MAXPLYDEPTH];
    short KingThrt[2][MAXPLYDEPTH];
    int Hashmv[MAXPLYDEPTH];
    int reduction[MAXPLYDEPTH];
    moveseq_t moveseq[1];
    int DumpId;
} searchdata_t;

// functions

void SearchDataInit(searchdata_t *searchdata, board_t *board);

#endif
