#ifndef SEARCH_H
#define SEARCH_H

// includes

#include "board.h"
#include "searchparams.h"
#include "searchdata.h"
#include "searchstats.h"
#include "option.h"
#include "movelist.h"


// macros

#define SCORE_INIT 0
#define SCORE_FAIL_LOW 1
#define SCORE_FAIL_HIGH 2
#define SCORE_EXACT 3
#define SCORE_PV 4

/*  Node types  */ 
#define PV  0
#define ALL 1
#define CUT 2



// types

typedef struct{
    int UseNull;
    int UseNullVer;
    int UseFut;
    int LateMovePruning;
    int UseLMR;
    int AggressiveLMR;
    int UseAspiration;
    int AspirationWindow;
    int UseMateDistancePruning;
    int UseTT;
    int UseMateScores;
    int UseTTinPV;
    int UseMateScoresinPV;
    int UseHistory;
    int LazyEvalMargin1;
    int LazyEvalMargin2;
    int DeltaMargin;
    int Razoring;
    int PanickTimeFactor;
    int DumpTree;
    int DumpId;
} search_t;

// variables

extern search_t search;

// functions

void SearchInit(option_list_t *options);

void ShowLine (board_t *board, 
	       searchparams_t *searchparams, 
	       searchdata_t *searchdata, 
	       searchstats_t *searchstats,
	       int c);

void ShowBestMove(searchstats_t *searchstats);


void SearchRoot (board_t *board, 
		 searchparams_t *searchparams, 
		 searchdata_t *searchdata,
		 searchstats_t *searchstats,
		 movelist_t *movelist);

void ShowBestMove(searchstats_t *searchstats);

#endif 



