#ifndef PAWN_H
#define PAWN_H

// includes

#include "bitboard.h"
#include "board.h"

// macros

#define PAWNSLOTS 1024
#define KEY(a)	     (a >> 32) 

// types

typedef uint32_t KeyType;

typedef struct{
   KeyType pkey;  
   BitBoard passed;
   BitBoard weaked;
   int score;
   int phase;
} ptable_slot_t;


typedef struct {
    ptable_slot_t *PawnTab[2];
    unsigned long GoodPawnHashCnt;
    unsigned long TotalPawnHashCnt;
    unsigned long PHashMask;
    unsigned int Size;
}ptable_t;  



// variables

extern ptable_t PTable[1];

// functions

void PTableInit(ptable_t *ptable);
void PTableClear(ptable_t *ptable);
void PTableZero (ptable_t *ptable);
void PTableResetStats(ptable_t *ptable);
void PTableSetSize(ptable_t *ptable, unsigned int size);
void PTableSetSizeMb(ptable_t *ptable, unsigned int size);
int PTableGet(ptable_t *ptable, 
	      board_t *board, 
	      int side,
	      BitBoard *passed, 
	      BitBoard *weaked, 
	      int *score, 
	      int *phase);

void PTablePut(ptable_t *ptable,
	       board_t *board,  	      
	       int side,
	       BitBoard passed, 
	       BitBoard weaked, 
	       int score, 
	       int phase);

void PTableStatsShow(ptable_t *ptable);
#endif
