/* GNU Chess 5.0 - null.c - null move code
   Copyright (c) 1999-2002 Free Software Foundation, Inc.

   GNU Chess is based on the two research programs 
   Cobalt by Chua Kong-Sian and Gazebo by Stuart Cracraft.

   GNU Chess is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GNU Chess is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Chess; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     bug-gnu-chess@gnu.org
     cracraft@ai.mit.edu, cracraft@stanfordalumni.org, cracraft@earthlink.net
*/
/*
 *
 */

#include <stdio.h>
#include <string.h>
#include "util.h"
#include "move.h"
#include "null.h"
#include "board.h"

void NullMoveMake(board_t *board){
    undo_t undo[1];
    NullMoveMakeS(board,undo);
}

void NullMoveMakeS(board_t *board, undo_t *undo)
/*****************************************************************************
 *
 *  Makes a null move on the board and update the various game information.
 *
 *****************************************************************************/
{
  int side;
#ifdef DEBUG
   memcpy(&undo->board,board,sizeof(board_t));
   ASSERT(BoardIsEqual(board,&undo->board)==0)
#endif 
   ASSERT(BoardValidate(board)==0);
   ASSERT(!board->xin_check);
   ASSERT(!board->in_check);
   side=board->side;
   undo->epsq = board->ep;
   undo->bflag = board->flag;
   undo->hashkey = board->HashKey;
   undo->stack=board->stack[board->GameCnt-board->Game50];
   board->stack[board->GameCnt-board->Game50]=board->HashKey;
   board->GameCnt++;
   if (board->ep > -1){
      board->HashKey ^= ephash[board->ep];
   }
   board->HashKey ^= Sidehash; 
   board->ep = -1;
   board->side = 1^side;
   ASSERT(BoardValidate(board)==0);
   return;
}

void NullMoveUnMakeS (board_t *board, undo_t *undo)
/****************************************************************************
 *
 *  Undoing a null move.
 *
 ****************************************************************************/
{
  int side;
   ASSERT(BoardValidate(board)==0);
  side=board->side;
   
   side = 1^side;
   board->side = side;

   board->ep = undo->epsq;
   board->flag = undo->bflag;
   board->HashKey = undo->hashkey;

   board->GameCnt--;
   board->stack[board->GameCnt-board->Game50]=undo->stack;
   ASSERT(BoardValidate(board)==0);
   ASSERT(BoardIsEqual(&undo->board,board)==0);
   return;
}

