#ifndef MOVESEQ_H
#define MOVESEQ_H

// includes

#include "board.h"

// macros

#define MOVESEQ_LAST(moveseq) \
          (moveseq->gencnt>0?moveseq->moves[moveseq->gencnt-1]:NOMOVE)
#define MOVESEQ_NEXTTOLAST(moveseq) \
          (moveseq->gencnt>1?moveseq->moves[moveseq->gencnt-2]:NOMOVE)

// types

typedef struct {
    int moves[MAXPLYDEPTH];
    int gencnt;
} moveseq_t;

// functions

void  MoveSeqToSAN(board_t *board, moveseq_t *moveseq, char *SAN);
void  MoveSeqToLAN(moveseq_t *moveseq, char *LAN);
void MoveSeqShow(board_t *board, moveseq_t *moveseq);
void MoveSeqPrependMove(moveseq_t *dst, moveseq_t *src, int move);


#endif
