#ifndef MOVELIST_H
#define MOVELIST_H

// includes

#include "util.h"


// types

typedef struct
{
   int move;   /* the move that produced this particular board */
   int score;  /* the scored value of this leaf */
} leaf;


typedef struct {
  leaf moves[MAXMOVES];
  int gencnt;
} movelist_t;

// includes 

#include "board.h"

// functions

void MoveListFilter(board_t *board, movelist_t *movelist);
void MoveListShow(board_t *board, movelist_t *movelist);
leaf *MoveListPickRandom(movelist_t *movelist);
leaf *MoveListPickBest(movelist_t *movelist);
void MoveListPickSel(movelist_t *movelist, leaf *head);
void MoveListAdd(board_t *board, movelist_t *movelist, leaf *p);

// TODO Rename this function

leaf *IsInMoveList (movelist_t *movelist,  int f, int t, char piece);


#endif
