#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "GCint.h"
#include "bitboard.h"
#include "magic.h"
#include "piece.h"
#include "board.h"
#include "square.h"




// generated by a variant of Tord Romstad's program
// see below

const uint64_t BMagic64[64] ={
  ULL(0x4120011126108200), 
  ULL(0x8800041430023215), 
  ULL(0x00000020200a2088), 
  ULL(0x4001180240328210), 
  ULL(0x2010000801082840), 
  ULL(0x0081901b44c41001), 
  ULL(0x800808109210024a), 
  ULL(0x0420402a0070c021), 
  ULL(0x00050c2c02420084), 
  ULL(0x0010a0420441c000), 
  ULL(0x94408c0810010400), 
  ULL(0x0c20820203044201), 
  ULL(0x0400082620a80405), 
  ULL(0x0000000951440180), 
  ULL(0x2400440208020000), 
  ULL(0x0005080544200100), 
  ULL(0x00090c4410410180), 
  ULL(0x00080224014c1c00), 
  ULL(0x0208101000486081), 
  ULL(0x4000101a10131200), 
  ULL(0x0000034030400200), 
  ULL(0x0200040034008800), 
  ULL(0x1804008230010801), 
  ULL(0x00040202401c1000), 
  ULL(0x3048014282010180), 
  ULL(0x0010850040050400), 
  ULL(0x2104080460821008), 
  ULL(0x0024440400044100), 
  ULL(0x0000200800510050), 
  ULL(0x8200e80410080020), 
  ULL(0x0041100810700100), 
  ULL(0x030220a000100300), 
  ULL(0x0c01820211861080), 
  ULL(0x0021010104108800), 
  ULL(0x00900110a4805000), 
  ULL(0x0251001001024000), 
  ULL(0x1020218008008002), 
  ULL(0x00c0280a040800a0), 
  ULL(0x1408b200c4140800), 
  ULL(0x410c100020200100), 
  ULL(0x0110211082281206), 
  ULL(0x1200c100840c2048), 
  ULL(0x2e82000100720040), 
  ULL(0x2004009180a00200), 
  ULL(0x0028000220809000), 
  ULL(0x0481002884040080), 
  ULL(0x0084040204181200), 
  ULL(0x0020144820470200), 
  ULL(0x080000a20a500408), 
  ULL(0x4020040402080400), 
  ULL(0xe0000104204c0428), 
  ULL(0x6a3a040460420001), 
  ULL(0x2004a10212810000), 
  ULL(0x08902200a1020004), 
  ULL(0x00000a1002008100), 
  ULL(0x000450040802a400), 
  ULL(0x044100c100e01000), 
  ULL(0x0304311808008900), 
  ULL(0x0000901008000002), 
  ULL(0x1804242004004200), 
  ULL(0x00240400842c4800), 
  ULL(0x04100400c0410048), 
  ULL(0x0030040504002016), 
  ULL(0x0820920210330200), 
};
const uint64_t RMagic64[64] ={
  ULL(0x8040040083006242), 
  ULL(0x8100022181081004), 
  ULL(0x0801002806040081), 
  ULL(0x0002000910204482), 
  ULL(0x0060200210000501), 
  ULL(0x08604020000a1101), 
  ULL(0x4002004082a29106), 
  ULL(0x8000302043020486), 
  ULL(0x060054108122c200), 
  ULL(0x0080021859102400), 
  ULL(0x410a001004884a00), 
  ULL(0x0041009004080100), 
  ULL(0x0012040820104200), 
  ULL(0x0030a00041021100), 
  ULL(0xc080a10882005200), 
  ULL(0x0004401420800180), 
  ULL(0x1014004303820004), 
  ULL(0x0800060001008080), 
  ULL(0x0010401410080120), 
  ULL(0x1080880004008080), 
  ULL(0x004200404c220010), 
  ULL(0x0120028810008020), 
  ULL(0x0640081000202000), 
  ULL(0x0628400030888000), 
  ULL(0x0040008452000409), 
  ULL(0x542028900400010a), 
  ULL(0x8080860080800400), 
  ULL(0x0101040080803800), 
  ULL(0x00000a0042002011), 
  ULL(0x9000300882802000), 
  ULL(0x0000200080804000), 
  ULL(0x0084204008800089), 
  ULL(0x020080018000c100), 
  ULL(0x0010110400c21008), 
  ULL(0x04000c0080800200), 
  ULL(0x2210240180080080), 
  ULL(0x01001001000900a0), 
  ULL(0x0c41410900102003), 
  ULL(0x0008400100210080), 
  ULL(0x0080004040082008), 
  ULL(0x0800460000408401), 
  ULL(0x0000040002051008), 
  ULL(0x1024808004000200), 
  ULL(0x5804008008018004), 
  ULL(0x4210008008038250), 
  ULL(0x2222828010012000), 
  ULL(0x0010004020004000), 
  ULL(0x0c0c040042008101), 
  ULL(0x2832000a108a4104), 
  ULL(0x0014001002012804), 
  ULL(0x200e001200104964), 
  ULL(0xa000800c00802800), 
  ULL(0x020b002100300028), 
  ULL(0x0200801000200082), 
  ULL(0x0100401000200040), 
  ULL(0x0011800080a04008), 
  ULL(0x088000628000c300), 
  ULL(0x8300020004409100), 
  ULL(0x0a00030c10880200), 
  ULL(0x010011000800024c), 
  ULL(0x4080100080080046), 
  ULL(0x0080100128802001), 
  ULL(0x2040200040021000), 
  ULL(0x008004400050e280), 
};



const uint64_t BMagic32[64] ={
  ULL(0x2320550000026002), 
  ULL(0x1200e08501041010), 
  ULL(0x0816082044040021), 
  ULL(0x30a2020b00000000), 
  ULL(0x082088001080000d), 
  ULL(0x08a8040001080001), 
  ULL(0x240218010a120424), 
  ULL(0x80a1082980002202), 
  ULL(0x0101000091021801), 
  ULL(0x4104502080201801), 
  ULL(0x3200801400004014), 
  ULL(0x1202000002000014), 
  ULL(0x608242220a020009), 
  ULL(0x00b1010080008029), 
  ULL(0x0908201080005288), 
  ULL(0x02900110404b4110), 
  ULL(0x4080030404110904), 
  ULL(0x405002820c200806), 
  ULL(0x0210040800400421), 
  ULL(0x0400004040200801), 
  ULL(0x9080491280848045), 
  ULL(0x240088c00081002b), 
  ULL(0x0320046040063210), 
  ULL(0x4002060008010412), 
  ULL(0x000b414011008202), 
  ULL(0x000c108800430405), 
  ULL(0x2008090002512c01), 
  ULL(0x0006101808282304), 
  ULL(0x0110450090020104), 
  ULL(0x4101010000060050), 
  ULL(0x2020020000004490), 
  ULL(0x1409201100c10c20), 
  ULL(0x0490580020020042), 
  ULL(0x0202210400350400), 
  ULL(0x0304468004004810), 
  ULL(0x4c00200800804090), 
  ULL(0x0c00400424202822), 
  ULL(0x0224840000408520), 
  ULL(0x04480604a5100200), 
  ULL(0x58520c4044a02000), 
  ULL(0x6082330000402641), 
  ULL(0x090826000c808401), 
  ULL(0x8222b00048206022), 
  ULL(0x1a03801202508001), 
  ULL(0x4104100002008224), 
  ULL(0x08071082000c8228), 
  ULL(0x28010042002c4060), 
  ULL(0x0408808200901048), 
  ULL(0x10880480000000c4), 
  ULL(0x0a48060111004188), 
  ULL(0x2808900005010088), 
  ULL(0x0e04040000000481), 
  ULL(0x1042040060204264), 
  ULL(0x0200241004801005), 
  ULL(0x0174001040011808), 
  ULL(0x1002810080022044), 
  ULL(0x2860240021448061), 
  ULL(0x2214024082022202), 
  ULL(0x123000008c051002), 
  ULL(0x4000040200084840), 
  ULL(0x100040604a240d02), 
  ULL(0x0900804000122084), 
  ULL(0x0440268000108401), 
  ULL(0x5444022202200414), 
};
const uint64_t RMagic32[64] ={
  ULL(0x0040288b0a020041), 
  ULL(0x000400e180050002), 
  ULL(0x28020a0100411804), 
  ULL(0x1028101202040806), 
  ULL(0x0001004700002410), 
  ULL(0x0210190100084820), 
  ULL(0x1102128122002040), 
  ULL(0x0010449280126201), 
  ULL(0x8211402000102081), 
  ULL(0x0100050020000102), 
  ULL(0x2c40808000004492), 
  ULL(0x00900a0000042006), 
  ULL(0x01000808100c00d0), 
  ULL(0x0093004010826008), 
  ULL(0x0487060041082045), 
  ULL(0x208004040c024004), 
  ULL(0x8282010200101401), 
  ULL(0x9004080800401001), 
  ULL(0x040100069a503885), 
  ULL(0x0c84040074002048), 
  ULL(0x04008200201040a8), 
  ULL(0x020208008a040090), 
  ULL(0x0608040001410840), 
  ULL(0x0104004420018204), 
  ULL(0x0010288022001049), 
  ULL(0x1040410000001312), 
  ULL(0x008104010400d022), 
  ULL(0x020004202000100a), 
  ULL(0x0080108101124008), 
  ULL(0x0108200380080241), 
  ULL(0x0040200018001054), 
  ULL(0x6080800080a08240), 
  ULL(0x00c100c44c00014a), 
  ULL(0x0024020010090041), 
  ULL(0x00081244040e0002), 
  ULL(0x0008800400001101), 
  ULL(0x5001201064010009), 
  ULL(0x02a8260202401142), 
  ULL(0x004508840000222a), 
  ULL(0x010040200009a202), 
  ULL(0x0041020804060401), 
  ULL(0x00a4121050080c02), 
  ULL(0x8482004194008041), 
  ULL(0x020862400a000404), 
  ULL(0x40200a8200804202), 
  ULL(0x80a0004860210104), 
  ULL(0x1200280122400020), 
  ULL(0x002040880000a480), 
  ULL(0x0000824208090001), 
  ULL(0x1980020a20008001), 
  ULL(0x000c162080404041), 
  ULL(0x0200108208081018), 
  ULL(0x405004040000404a), 
  ULL(0x00a4010000040820), 
  ULL(0x40805a0008208020), 
  ULL(0x0a20800080108040), 
  ULL(0x040d208080800049), 
  ULL(0x0041860810802882), 
  ULL(0x800b208040210002), 
  ULL(0x0204106112000802), 
  ULL(0x000b088415002010), 
  ULL(0x1800403208200820), 
  ULL(0x0080291001001040), 
  ULL(0x4091814c80400020), 
};

const uint64_t BMask[64] ={
  ULL(0x0040201008040200), 
  ULL(0x0020100804020000), 
  ULL(0x0050080402000000), 
  ULL(0x0028440200000000), 
  ULL(0x0014224000000000), 
  ULL(0x000a102040000000), 
  ULL(0x0004081020400000), 
  ULL(0x0002040810204000), 
  ULL(0x0000402010080400), 
  ULL(0x0000201008040200), 
  ULL(0x0000500804020000), 
  ULL(0x0000284402000000), 
  ULL(0x0000142240000000), 
  ULL(0x00000a1020400000), 
  ULL(0x0000040810204000), 
  ULL(0x0000020408102000), 
  ULL(0x0040004020100800), 
  ULL(0x0020002010080400), 
  ULL(0x0050005008040200), 
  ULL(0x0028002844020000), 
  ULL(0x0014001422400000), 
  ULL(0x000a000a10204000), 
  ULL(0x0004000408102000), 
  ULL(0x0002000204081000), 
  ULL(0x0020400040201000), 
  ULL(0x0010200020100800), 
  ULL(0x0008500050080400), 
  ULL(0x0044280028440200), 
  ULL(0x0022140014224000), 
  ULL(0x00100a000a102000), 
  ULL(0x0008040004081000), 
  ULL(0x0004020002040800), 
  ULL(0x0010204000402000), 
  ULL(0x0008102000201000), 
  ULL(0x0004085000500800), 
  ULL(0x0002442800284400), 
  ULL(0x0040221400142200), 
  ULL(0x0020100a000a1000), 
  ULL(0x0010080400040800), 
  ULL(0x0008040200020400), 
  ULL(0x0008102040004000), 
  ULL(0x0004081020002000), 
  ULL(0x0002040850005000), 
  ULL(0x0000024428002800), 
  ULL(0x0000402214001400), 
  ULL(0x004020100a000a00), 
  ULL(0x0020100804000400), 
  ULL(0x0010080402000200), 
  ULL(0x0004081020400000), 
  ULL(0x0002040810200000), 
  ULL(0x0000020408500000), 
  ULL(0x0000000244280000), 
  ULL(0x0000004022140000), 
  ULL(0x00004020100a0000), 
  ULL(0x0040201008040000), 
  ULL(0x0020100804020000), 
  ULL(0x0002040810204000), 
  ULL(0x0000020408102000), 
  ULL(0x0000000204085000), 
  ULL(0x0000000002442800), 
  ULL(0x0000000040221400), 
  ULL(0x0000004020100a00), 
  ULL(0x0000402010080400), 
  ULL(0x0040201008040200), 
};

const uint64_t RMask[64] ={
  ULL(0x7e80808080808000), 
  ULL(0x3e40404040404000), 
  ULL(0x5e20202020202000), 
  ULL(0x6e10101010101000), 
  ULL(0x7608080808080800), 
  ULL(0x7a04040404040400), 
  ULL(0x7c02020202020200), 
  ULL(0x7e01010101010100), 
  ULL(0x007e808080808000), 
  ULL(0x003e404040404000), 
  ULL(0x005e202020202000), 
  ULL(0x006e101010101000), 
  ULL(0x0076080808080800), 
  ULL(0x007a040404040400), 
  ULL(0x007c020202020200), 
  ULL(0x007e010101010100), 
  ULL(0x00807e8080808000), 
  ULL(0x00403e4040404000), 
  ULL(0x00205e2020202000), 
  ULL(0x00106e1010101000), 
  ULL(0x0008760808080800), 
  ULL(0x00047a0404040400), 
  ULL(0x00027c0202020200), 
  ULL(0x00017e0101010100), 
  ULL(0x0080807e80808000), 
  ULL(0x0040403e40404000), 
  ULL(0x0020205e20202000), 
  ULL(0x0010106e10101000), 
  ULL(0x0008087608080800), 
  ULL(0x0004047a04040400), 
  ULL(0x0002027c02020200), 
  ULL(0x0001017e01010100), 
  ULL(0x008080807e808000), 
  ULL(0x004040403e404000), 
  ULL(0x002020205e202000), 
  ULL(0x001010106e101000), 
  ULL(0x0008080876080800), 
  ULL(0x000404047a040400), 
  ULL(0x000202027c020200), 
  ULL(0x000101017e010100), 
  ULL(0x00808080807e8000), 
  ULL(0x00404040403e4000), 
  ULL(0x00202020205e2000), 
  ULL(0x00101010106e1000), 
  ULL(0x0008080808760800), 
  ULL(0x00040404047a0400), 
  ULL(0x00020202027c0200), 
  ULL(0x00010101017e0100), 
  ULL(0x0080808080807e00), 
  ULL(0x0040404040403e00), 
  ULL(0x0020202020205e00), 
  ULL(0x0010101010106e00), 
  ULL(0x0008080808087600), 
  ULL(0x0004040404047a00), 
  ULL(0x0002020202027c00), 
  ULL(0x0001010101017e00), 
  ULL(0x008080808080807e), 
  ULL(0x004040404040403e), 
  ULL(0x002020202020205e), 
  ULL(0x001010101010106e), 
  ULL(0x0008080808080876), 
  ULL(0x000404040404047a), 
  ULL(0x000202020202027c), 
  ULL(0x000101010101017e), 
};

const int RBits[64] = { 
  12, 11, 11, 11, 11, 11, 11, 12,
  11, 10, 10, 10, 10, 10, 10, 11,
  11, 10, 10, 10, 10, 10, 10, 11,
  11, 10, 10, 10, 10, 10, 10, 11,
  11, 10, 10, 10, 10, 10, 10, 11,
  11, 10, 10, 10, 10, 10, 10, 11,
  11, 10, 10, 10, 10, 10, 10, 11,
  12, 11, 11, 11, 11, 11, 11, 12
};
 
const int BBits[64] = {
  6, 5, 5, 5, 5, 5, 5, 6,
  5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 7, 7, 7, 7, 5, 5,
  5, 5, 7, 9, 9, 7, 5, 5,
  5, 5, 7, 9, 9, 7, 5, 5,
  5, 5, 7, 7, 7, 7, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5,
  6, 5, 5, 5, 5, 5, 5, 6
};

BitBoard MagicBishopTable[64][512];
BitBoard MagicRookTable[64][4096];

BitBoard MagicBishopAttack_(board_t *board, int sq) {
    BitBoard mask, reachable,ret;
    int hash;
    mask=BMask[sq];
    reachable=mask & ~board->blocker;
    hash=MagicHash(reachable,BMagic(sq), BBits[sq]);
    ret=MagicBishopTable[sq][hash];
    ASSERT(ret!=NULLBITBOARD);
    return ret;
}

BitBoard MagicRookAttack_(board_t *board, int sq) {
    BitBoard mask, reachable,ret;
    int hash;
    mask=RMask[sq];
    reachable=mask & ~board->blocker;
    hash=MagicHash(reachable,RMagic(sq), RBits[sq]);
    ret=MagicRookTable[sq][hash];
    ASSERT(ret!=NULLBITBOARD);
    return ret;
}

BitBoard MagicQueenAttack_(board_t *board, int sq){
    return MagicBishopAttack_(board,sq)|MagicRookAttack_(board,sq); 
}


BitBoard MagicAttack(int sq, int piece, BitBoard blocker){
    short dir,blocksq;
    BitBoard b,c;
    b=NULLBITBOARD;
    for (dir = raybeg[piece]; dir < rayend[piece]; dir++){
	c = bitboards.Ray[sq][dir] & blocker;
	if (c == NULLBITBOARD){
	    c = bitboards.Ray[sq][dir]; 
	}else{
	    blocksq = (bitboards.BitPosArray[sq] > c ? leadz (c) : trailz (c));
	    c = bitboards.FromToRay[sq][blocksq];
	}
	b |= c;
    }
    return b;
}


// Tom Romstad

BitBoard MagicBitBoardFromIndex(int index,int bits, BitBoard mask){
    int i,j;
    BitBoard ret=NULLBITBOARD;
#ifdef DEBUG
    BitBoard org_mask=mask;
#endif
    i=0;
    for(i=0;i<bits;i++){
	j=leadz(mask);
	CLEARBIT (mask, j);
	if(index & (1<<i)){
	    ret |= (ULL(1) <<(63-j));
	}

    }
    ASSERT(ret<=org_mask);
    return ret;
}



void MagicPieceInit(int piece){
    int sq,hash,bits,index;
    BitBoard mask,blocker,attack,table_entry,reachable;
    uint64_t magic;
    if(piece==bishop){
	memset(MagicBishopTable,0,sizeof(MagicBishopTable));
    }else{
	memset(MagicRookTable,0,sizeof(MagicRookTable));
    }
    for(sq=0;sq<=63;sq++){
	magic=(piece==bishop?BMagic(sq):RMagic(sq));
	mask=(piece==bishop?BMask[sq]:RMask[sq]);
	bits=(piece==bishop?BBits[sq]:RBits[sq]);
	for(index=0;index<(1<<bits);index++){
	    reachable= MagicBitBoardFromIndex(index,bits,mask);
	    blocker=~reachable & bitboards.MoveArray[piece][sq];
	    attack=MagicAttack(sq, piece, blocker);

            hash=MagicHash(reachable,magic,bits);
	    table_entry=(piece==bishop?MagicBishopTable[sq][hash]:
			 MagicRookTable[sq][hash]);
	    if(table_entry==NULLBITBOARD || table_entry==attack){
		if(piece==bishop){
		    MagicBishopTable[sq][hash]=attack;
		}else{
		    MagicRookTable[sq][hash]=attack;
		}
	    }else{
		// Initialization error
		Output("Error initializig magics\n");
		exit(EXIT_FAILURE);
	    }
	    
	}
    }

}

void MagicInit(){
#ifdef __i386__
    OutputConsole("Initializing 32 bit magics...\n");
#else
    OutputConsole("Initializing 64 bit magics...\n");
#endif    
    MagicPieceInit(bishop);
    MagicPieceInit(rook);
}

// Below we give code to generate magics. This is basically a 
// version of Tord Romstad's program here
// http://chessprogramming.wikispaces.com/Looking+for+Magics 

uint64_t random_uint64() {
  uint64_t u1, u2, u3, u4;
  u1 = (uint64_t)(rand()) & 0xFFFF; u2 = (uint64_t)(rand()) & 0xFFFF;
  u3 = (uint64_t)(rand()) & 0xFFFF; u4 = (uint64_t)(rand()) & 0xFFFF;
  return u1 | (u2 << 16) | (u3 << 32) | (u4 << 48);
}
 
uint64_t random_uint64_fewbits() {
  return random_uint64() & random_uint64() & random_uint64();
}


void MagicFind(){
    uint64_t magic;
    uint64_t magics[64];
    int sq, hash,bits,index,good_magic;
    int piece=bishop;
    BitBoard mask, reachable, blocker, attack, table_entry;
#ifdef __i386__
    char *mode_s="32";
#else
    char *mode_s="64";
#endif
    for(piece=bishop;piece<=rook;piece++){
	for(sq=0;sq<=63;sq++){
	    while(1){
		good_magic=true;
		memset(MagicBishopTable[sq],0,sizeof(MagicBishopTable[sq]));
		memset(MagicRookTable[sq],0,sizeof(MagicRookTable[sq]));
		magic=random_uint64_fewbits();
		mask=(piece==bishop?BMask[sq]:RMask[sq]);
		bits=(piece==bishop?BBits[sq]:RBits[sq]);
		for(index=0;index<(1<<bits);index++){
		    reachable= MagicBitBoardFromIndex(index,bits,mask);
		    blocker=~reachable & bitboards.MoveArray[piece][sq];
		    attack=MagicAttack(sq, piece, blocker);
		    ASSERT(attack!=NULLBITBOARD);
		    hash=MagicHash(reachable,magic,bits);
		    table_entry=(piece==bishop?MagicBishopTable[sq][hash]:
				 MagicRookTable[sq][hash]);
		    if(table_entry==NULLBITBOARD || table_entry==attack){
			if(piece==bishop){
			    MagicBishopTable[sq][hash]=attack;
			}else{
			    MagicRookTable[sq][hash]=attack;
			}
		    }else{
			// collision
			good_magic=false;
			break;
		    }
		}
		if(good_magic){
		    break;
		}
	    }
	    magics[sq]=magic;
	}
	if(piece==bishop){
	    Output("const uint64_t BMagic%s[64] ={\n",mode_s);
	}else{
	    Output("const uint64_t RMagic%s[64] ={\n",mode_s);
	}
	for(sq=0;sq<=63;sq++){
	    Output("  ULL(0x"U64_FORMAT"), \n",magics[sq]);
	}
	Output("};\n");
    }
}

void MagicMakeMasks(){
    BitBoard masks[64];
    BitBoard mask;
    int sq,r,f;
    Output("const uint64_t BMask[64] ={\n");
    for(sq=0;sq<=63;sq++){
	Output("  ULL(0x"U64_FORMAT"), \n",bitboards.MoveArray[bishop][sq] & bitboards.boxes[1]);
    }
    Output("};\n");
    for(sq=0;sq<=63;sq++){
	mask=bitboards.MoveArray[rook][sq];
	r=RANK(sq);
	f=FILE_(sq);
	if(f<7) mask&=~bitboards.FileBit[7];
	if(f>0) mask&=~bitboards.FileBit[0];
	if(r<7) mask&=~bitboards.RankBit[7];
	if(r>0) mask&=~bitboards.RankBit[0];
	masks[sq]=mask;
    }
    Output("const uint64_t RMask[64] ={\n");
    for(sq=0;sq<=63;sq++){
	Output("  ULL(0x"U64_FORMAT"), \n",masks[sq]);
    }
    Output("};\n");
}
