#ifndef EPD_H
#define EPD_H

// includes

#include <stdio.h>
#include "board.h"

// macros

/* Error codes for ParseEPD */
enum {
   EPD_SUCCESS,
   EPD_ERROR
};


// types

typedef struct {
  FILE *fp;
}   epd_iter_t;

// variables

extern epd_iter_t EPDIter[1];

// functions

/*  The EPD routines  */
int ParseEPD (board_t *board, const char *fen, char *bm, char *id);
void SaveEPD (board_t *board, char *file);
void EPDIterInit(epd_iter_t *epd_iter);
int EPDIterStart(epd_iter_t *epd_iter, char *file);
void EPDIterClose(epd_iter_t *epd_iter);
int EPDIterNext(epd_iter_t *epd_iter, board_t *board, char *id, char *bm);



#endif
